#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh version 1.0.0
# NXWvf[^̍쐬
# Y.Hamuro
# 2003/01/07
#*****************************************************************************

#G[bZ[W
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0.0
------------------------
Tv)NXWv\\쐬B
) xtcross.sh -k sɂȂ鍀ږ -f ɂȂ鍀ږ -d Z̒l̍ږ [-it@C] [-oo̓t@C] [-T [NfBNg]

) xtcross.sh -k ڋq -f  -d z -i dat.xt -o rsl.xt
EOF
exit 1
}

#p[^̃`FbNZbg
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":k:f:d:i:o:h" opt; do
    case $opt in
      k  ) row=$OPTARG ;;
      f  ) col=$OPTARG ;;
      d  ) dat=$OPTARG ;;
      i  ) input=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
     tmpD=/tmp
  fi
  if [ "$input" = "" ]; then
     input=/dev/stdin
  fi
  if [ "$output" = "" ]; then
     output=/dev/stdout
  fi
  if [ "$row" = "" ]; then
     help; exit 1
  fi
  if [ "$col" = "" ]; then
     help; exit 1
  fi
  if [ "$dat" = "" ]; then
     help; exit 1
  fi

TD=$tmpD/xxx$$
mkdir -p $TD

#Kvڂ؂oAtmpt@CŕۑB
xtcut -f $row,$col,$dat -i $input -o $TD.a

#j[Nڋq̃Xg쐬
xtcut -f $row -i $TD.a |
xtuniq -k $row -o $TD.cust

#j[NރXg̍쐬 -> XNvg쐬
xtcut -f $col -i $TD.a |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD.sh

#ޖɃt@C𕪊
xtsep -d $TD.sep.'$('$col')' -i $TD.a

#ޖ̃t@CڋqL[join֐
function joinCls {
  xtjoin -n -k $row -m $TD.sep.$1 -f $dat:$1 -i $TD.cust -o $TD.p
  cp $TD.p $TD.cust
}

#ŃXNvgs
. $TD.sh

cat <$TD.cust >$output

rm -rf $tmpD/xxx*
#===============================================================
