/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;

class Lines
extends ArrayList {
    public static final Format annotationFormat = new MessageFormat("{0,,        } ({1} {2,  date,dd-MMM-yyyy}): {3}");

    public Lines() {
    }

    public Lines(String text) {
        this(null, Diff.stringToArray((String)text));
    }

    public Lines(Node release, String text) {
        this(release, Diff.stringToArray((String)text));
    }

    public Lines(Object[] text) {
        this(null, text);
    }

    public Lines(Node release, Object[] text) {
        for (int i = 0; i < text.length; ++i) {
            super.add(new Line(release, text[i]));
        }
    }

    public boolean add(Object o) {
        return super.add((Line)o);
    }

    public Node[] nodesToArray() {
        Node[] result = new Node[this.size()];
        int x = 0;
        for (Object o : this) {
            result[x++] = ((Line)o).revision;
        }
        return result;
    }

    public Object[] textToArray() {
        return this.textToArray(false);
    }

    public Object[] textToArray(boolean annotate) {
        Object[] result = new Object[this.size()];
        Iterator r = this.iterator();
        int i = 0;
        while (r.hasNext()) {
            Line l = (Line)r.next();
            Object o = l.getText();
            if (annotate) {
                Node rev = l.getRevision();
                o = annotationFormat.format(new Object[]{rev.getVersion(), rev.getAuthor(), rev.getDate(), o});
            }
            result[i++] = o;
        }
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean annotate) {
        return Diff.arrayToString((Object[])this.textToArray(annotate));
    }
}

