/*
** libsnmptrap
** $Id: snmptrap.h,v 1.1 2006/03/21 05:39:29 sella Exp $
** Copyright (c) 2005,2006 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_LIBSNMPTRAP_SNMPTRAP_H
#define __DGS_LIBSNMPTRAP_SNMPTRAP_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/types.h>

#ifdef HAVE_NET_SNMP
	#include <net-snmp/net-snmp-config.h>
	#include <net-snmp/net-snmp-includes.h>
#else
	#ifndef SNMP_VERSION_1
		#define SNMP_VERSION_1 0
	#endif
	#ifndef SNMP_VERSION_2c
		#define SNMP_VERSION_2c 2
	#endif
	#ifndef SNMP_VERSION_3
		#define SNMP_VERSION_3 3
	#endif
#endif

typedef struct _snmptrap_peer_t {
	char peername[255];
	char community[64];
	int version; /* SNMP_VERSION_1, SNMP_VERSION_2c or SNMP_VERSION_3 */
	int inform; /* Only used for v2c and v3 */
	char agent[32]; /* Only used for v1 */
	struct _snmptrap_peer_t *next;
} snmptrap_peer_t;

typedef struct _snmptrap_varbind_t {
	char type; /* See type chart below */
	char var[255];
	char val[255];
	struct _snmptrap_varbind_t *next;
} snmptrap_varbind_t;

typedef struct _snmptrap_t {
	long sysUpTime;
	char sysObjectID[255];
	int trap_type; /* Only used for v1 */
	int specific_type; /* Only used for v1 */
	struct _snmptrap_peer_t *peer;
	struct _snmptrap_varbind_t *varbind;
} snmptrap_t;

/* Function definitions. */
int send_snmptrap(snmptrap_t *trap);
#ifdef HAVE_NET_SNMP
int _callback(int operation, netsnmp_session *session, int reqid, netsnmp_pdu *pdu, void *magic);
#endif

/* SNMP Types (snmptrap_varbind_t->type)

	a IP address 
	c Counter 
	d Decimal string 
	i Integer
	n Null
	o Object ID
	s String
	t Time ticks
	u Unsigned integer
	x Hexadecimal string

*/

#endif

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
