#!/bin/sh
set -vx

PROG=`basename $0`

if [ "$#" -ne "2" ]; then
        printf "Usage: $PROG <phrel-cvs> <version>\n"
        printf "Builds a dist tarball from a directory containing a CVS checkout.\n\n"
        printf "NOTE: Please make sure to do a 'cvs checkout -P' and update the\nversion numbers within the README, INSTALL, etc files.\n\n"
        printf "Example: $PROG phrel 1.0.0\n\n"
        printf "Report bugs to <sella@digitalgenesis.com>.\n"
        exit 1
fi

if [ "`id -u`" -ne 0 ]; then
	printf "This script must be run as root.\n\n"
	exit 1
fi

if [ ! -d "`basename $1`" ]; then
	printf "Either $1 isn't a directory or you aren't in its parent directory.\n\n"
	exit 1
fi

ORG="$1"
NEW="phrel-$2"

(cd "$ORG" && make distclean || exit 1)
(cd "$ORG" && rm -rf "autom4te.cache" && rm -rf "src/autom4te.cache")
chown -R root:root "$ORG" || exit 1
mv "$ORG" "$NEW" || exit 1
tar cvzf "$NEW".tar.gz --exclude=CVS $NEW || exit 1
tar cvjf "$NEW".tar.bz2 --exclude=CVS $NEW || exit 1
mv "$NEW" "$ORG" || exit 1
chown $USER:$GROUP "$NEW".tar.gz || exit 1
chown $USER:$GROUP "$NEW".tar.bz2 || exit 1
chown -R $USER:$GROUP "$ORG" || exit 1

echo "Built $NEW.tar.gz and $NEW.tar.bz2 successfully."
