/*
** PHREL
** $Id: trap.c,v 1.4 2006/03/23 06:21:00 sella Exp $
** Copyright (c) 2005,2006 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

static const char rcsid[] = "$Id: trap.c,v 1.4 2006/03/23 06:21:00 sella Exp $";

#include "trap.h"

#include "phrel.h"
#include "prefs.h"

#include <snmptrap.h>

#include <string.h>
#include <stdlib.h>

#include <assert.h>
#include <errno.h>

/* Global variables */
extern struct args_t args;
extern pid_t pid;
extern time_t startup_time;

int snmptrap_process_startup() {
	return snmptrap_pid(TRAP_PROCESS_STARTUP);
}

int snmptrap_process_shutdown() {
	return snmptrap_pid(TRAP_PROCESS_SHUTDOWN);
}

int snmptrap_process_restart() {
	return snmptrap_pid(TRAP_PROCESS_RESTART);
}

int snmptrap_sync_lost() {
	return snmptrap_pid(TRAP_SYNC_LOST);
}

int snmptrap_threshold_increase(struct data_t* data, unsigned int pps, unsigned int prev_threshold) {
	return snmptrap_threshold(TRAP_THRESHOLD_INCREASE, data, pps, prev_threshold);
}

int snmptrap_threshold_decrease(struct data_t* data, unsigned int pps, unsigned int prev_threshold) {
	return snmptrap_threshold(TRAP_THRESHOLD_DECREASE, data, pps, prev_threshold);
}

int init_snmptrap_t(const char *trap_oid, snmptrap_t *trap) {
	int ret_val = 0;

	/* Zero trap struct */
	memset(trap, 0, sizeof(snmptrap_t));

	/* Setup trap structure */
	trap->sysUpTime = (time(NULL) - startup_time) * 100;
	strncpy(trap->sysObjectID, trap_oid, sizeof(trap->sysObjectID));
	trap->trap_type = 6; /* Only used for v1 */
	trap->specific_type = 0; /* Only used for v1 */
	trap->peer = args.peer;

	return ret_val;

}

int snmptrap_pid(const char *trap_oid) {
	int ret_val = 0;
	snmptrap_t trap;
	snmptrap_varbind_t *varbind = NULL;

	/* Any peers? */
	if (args.peer == NULL) {
		return 0;
	}

	/* Init trap struct */
	init_snmptrap_t(trap_oid, &trap);

	/* Setup varbind */
	trap.varbind = malloc(sizeof(snmptrap_varbind_t));

	varbind = trap.varbind;
	varbind->type = 'u';
	strncpy(varbind->var, OID_ID, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", pid);

	varbind->next = NULL;

	/* Send trap */
	ret_val = send_snmptrap(&trap);

	/* Free varbind memory */
   while (trap.varbind) {
      varbind = trap.varbind;
      trap.varbind = varbind->next;
      free(varbind);
   }

	return ret_val;
}

int snmptrap_threshold(const char* trap_oid, struct data_t* data, unsigned int pps, unsigned int prev_threshold) {
	int ret_val = 0;
	snmptrap_t trap;
	snmptrap_varbind_t *varbind = NULL;
	time_t cur = time(NULL);

	/* Any peers? */
	if (args.peer == NULL) {
		return 0;
	}

	/* Init trap struct */
	init_snmptrap_t(trap_oid, &trap);

	/* Setup varbind */
	trap.varbind = malloc(sizeof(snmptrap_varbind_t));

	varbind = trap.varbind;
	varbind->type = 'u';
	strncpy(varbind->var, OID_ID, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", pid);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'a';
	strncpy(varbind->var, OID_HOST, sizeof(varbind->var));
	inet_ntop(AF_INET, &(data->ip), varbind->val, sizeof(varbind->val));

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_PPS, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", pps);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_THRES, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", data->threshold);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_LTHRES, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", prev_threshold);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_RATE, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", data->rate);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_BURST, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%u", data->burst);

	varbind->next = malloc(sizeof(snmptrap_varbind_t));
	varbind = varbind->next;
	varbind->type = 'u';
	strncpy(varbind->var, OID_DECAY, sizeof(varbind->var));
	snprintf(varbind->val, sizeof(varbind->val), "%lu", (data->decay > 0) ? data->decay - cur : 0);

	varbind->next = NULL;

	/* Send trap */
	ret_val = send_snmptrap(&trap);

	/* Free varbind memory */
   while (trap.varbind) {
      varbind = trap.varbind;
      trap.varbind = varbind->next;
      free(varbind);
   }

	return ret_val;
}

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
