/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef TOOLTIP_H
#define TOOLTIP_H

#include <QObject>
#include <QtCore/QPoint>
#include <QTimer>

class QClipboard;

class ToolTip : public QObject
{
    Q_OBJECT
public:
    explicit ToolTip(QObject *parent = 0);

signals:
public slots:
    void showTooltipText(const QString &text);
    void setCursorPositionLocked(bool b);
private  slots:
    void updateCursorPos();
    void slotHideToolTip();
private:
    QPoint m_cursor_pos;
    QClipboard *m_clipboard;
    bool  m_cursor_pos_locked;
    QTimer m_hide_timer;
};

#endif // TOOLTIP_H
