/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#include "trayicon.h"
#include <QtGui/QMenu>


TrayIcon::TrayIcon(QObject *parent) :
    QObject(parent),
    m_menu(new QMenu),
    m_tray_icon(new QSystemTrayIcon(QIcon(":/icons/artwork/icons/eyeworld_icon.png"))),
    m_action_show_or_hide(new QAction(QIcon(":/icons/artwork/icons/eyeworld_icon.png"), tr("Hide"), this)),
    m_action_translate(new QAction(QIcon(":/icons/artwork/icons/go-next.png"), tr("Translate"), this)),
    m_action_swap(new QAction(QIcon(":/icons/artwork/icons/system-switch-user.png"), tr("Swap"), this)),
    #ifdef Q_WS_X11
    m_action_enable_scan_selection_buffer(new QAction(QIcon(":/icons/artwork/icons/select-rectangular.png"),tr("Scan selection buffer"), this)),
    #endif
    m_action_configure(new QAction(QIcon(":/icons/artwork/icons/configure.png"), tr("Settings"), this)),
    m_action_quit(new QAction(QIcon(":/icons/artwork/icons/application-exit.png"), tr("Exit"), this))

{

    // Creating system tray menu
    m_menu->addAction(m_action_show_or_hide);
    m_menu->addSeparator();
    m_menu->addAction(m_action_translate);
    m_menu->addAction(m_action_swap);
#ifdef Q_WS_X11
    m_menu->addAction(m_action_enable_scan_selection_buffer);
#endif
    m_menu->addAction(m_action_configure);
    m_menu->addSeparator();
    m_menu->addAction(m_action_quit);
#ifdef Q_WS_X11
    m_action_enable_scan_selection_buffer->setCheckable(true);
#endif

    m_tray_icon->setContextMenu(m_menu);


    connect(m_action_show_or_hide, SIGNAL(triggered()), this, SIGNAL(showOrHideRequested()));
    connect(m_action_translate, SIGNAL(triggered()), this, SIGNAL(translationRequested()));
    connect(m_action_swap, SIGNAL(triggered()),this,SIGNAL(swapRequested()));
#ifdef Q_WS_X11
    connect(m_action_enable_scan_selection_buffer, SIGNAL(toggled(bool)),this, SIGNAL(scanSelectionChanged(bool)));
#endif
    connect(m_action_configure, SIGNAL(triggered()), this, SIGNAL(configureRequested()));
    connect(m_action_quit, SIGNAL(triggered()), this, SIGNAL(quitRequested()));

    connect(m_tray_icon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(trayActivated(QSystemTrayIcon::ActivationReason)));
}


void TrayIcon::setTranslateActionEnabled(bool b){
    m_action_translate->setEnabled(b);
}

#ifdef Q_WS_X11
void TrayIcon::setScanBufferChecked(bool b){
    m_action_enable_scan_selection_buffer->setChecked(b);
}

bool TrayIcon::scanBufferEnabled() const {
    return m_action_enable_scan_selection_buffer->isChecked();
}
#endif

void TrayIcon::show(){
    m_tray_icon->show();
}

void TrayIcon::hide(){
    m_tray_icon->hide();
}

void TrayIcon::notificate(const QString &title, const QString &text, int msec){
    m_tray_icon->showMessage(title, text, QSystemTrayIcon::NoIcon, msec);
}

void TrayIcon::setMainWindowHidden(bool b){
    if(b)
        m_action_show_or_hide->setText(tr("Show"));
    else
        m_action_show_or_hide->setText(tr("Hide"));
}



void TrayIcon::trayActivated(QSystemTrayIcon::ActivationReason reason){
    if(reason == QSystemTrayIcon::Trigger)
        emit showOrHideRequested();
}


void TrayIcon::retranslateMenu(QWidget* MainWindow) {
    m_action_show_or_hide->setText(MainWindow->isVisible() ? tr("Hide") : tr("Show"));
    m_action_translate->setText(tr("Translate"));
    m_action_swap->setText(tr("Swap"));
#ifdef Q_WS_X11
    m_action_enable_scan_selection_buffer->setText(tr("Scan selection buffer"));
#endif
    m_action_configure->setText(tr("Settings"));
    m_action_quit->setText(tr("Exit"));
}


void TrayIcon::setToolTip(const QString &text) {
    m_tray_icon->setToolTip(text);
}
