/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#include "wordsreservation.h"
#include "ui_wordsreservation.h"

//#include <QtCore/QFile>
#include <QtCore/QDebug>
#include <QtGui/QMessageBox>
#include <QtGui/QInputDialog>
#include "defines.h"

static const QChar space = ' ';
static const QString label = "123_";
static const QString splitter_sequence = "<->";

WordsReservation::WordsReservation(QWidget *parent) :
    QDialog(parent),
    m_flag_case_sensetive(true),
    m_flag_have_changes(false),
//    m_sequences_file(QFile(QGT_RESERVATION_FILE)),
    ui(new Ui::WordsReservation)
{
    ui->setupUi(this);
    m_sequences_file.setFileName(qgt_default_reservation_file);
    loadSequences();


    connect(ui->clear_pushButton, SIGNAL(clicked()), this, SLOT(clearSequences()));
    connect(ui->remove_pushButton, SIGNAL(clicked()), this, SLOT(deleteSequence()));
    connect(ui->add_pushButton, SIGNAL(clicked()),this,SLOT(addSequence()));

    connect(ui->buttonBox, SIGNAL(accepted()),this, SLOT(acceptChanges()));
    connect(ui->buttonBox, SIGNAL(rejected()),this,SLOT(reject()));
}

WordsReservation::~WordsReservation()
{
    delete ui;
}

void WordsReservation::changeEvent(QEvent *e) {
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

//void WordsReservation::setInputData(const QString &source_text, const QString &translated_text){
//    m_source_text = source_text;
//    m_translated_text = translated_text;
//}

QString WordsReservation::getProcessedText(const QString &rawtext){
    QString tmp = rawtext;
    for(int i = 0; i < m_reserved_sequences.size(); i++)
        tmp.replace(m_reserved_sequences.at(i), label + m_reserved_sequences.at(i),
                    m_flag_case_sensetive ? Qt::CaseSensitive : Qt::CaseInsensitive);

    return tmp;
}

QString WordsReservation::getResultText(const QString &res) const {
    QString tmp = res;
    for(int i = 0; i < m_reserved_sequences.size(); i++){
        tmp.replace(label + m_reserved_sequences.at(i), m_reserved_sequences.at(i),
                    m_flag_case_sensetive ? Qt::CaseSensitive : Qt::CaseInsensitive);
    }
    return tmp;
}

void WordsReservation::addWord(const QString &word){
   addReservedSequence(word);
   saveSequences();
}

//void WordsReservation::setStorageFile(const QString &file){
//    m_sequences_file.setFileName(file);
//}

void WordsReservation::setCaseSensetive(bool b){
    m_flag_case_sensetive = b;
}

void WordsReservation::showReservator(){
    loadSequences();
    show();
}
void WordsReservation::addReservedSequence(const QString &word){
    ui->listWidget->addItem(word);
    m_reserved_sequences.append(word);
}


void WordsReservation::loadSequences(){
    if(m_sequences_file.open(QFile::ReadOnly | QFile::Text | QFile::Truncate)){
       const QString tmp = m_sequences_file.readAll().data();
       m_reserved_sequences.clear();
       m_reserved_sequences = tmp/*.simplified()*/.split(splitter_sequence, QString::SkipEmptyParts);
       ui->listWidget->clear();
       ui->listWidget->addItems(m_reserved_sequences);
       updateList();
       m_sequences_file.close();
    }
//    else
//        qWarning() << Q_FUNC_INFO << "Error! Can\'t open sequence file: " << m_sequences_file.errorString();

//    m_sequences_file.close();
}

void WordsReservation::saveSequences(){
    if(m_sequences_file.open(QFile::ReadWrite | QFile::Text | QFile::Truncate/*| QFile::Append*/)){
//        m_sequences_file.write(0);

        QByteArray text;
        if(m_reserved_sequences.size() > 1)
            text.append(m_reserved_sequences.join(splitter_sequence));
        else if(m_reserved_sequences.size() == 1) // /\ \/ - dirty hacks
            text.append(m_reserved_sequences.join("") + splitter_sequence);
//        else if(m_reserved_sequences.isEmpty())

        m_sequences_file.write(text);
    } else {
        qWarning() << "Error! Can\'t write sequences file: "
                   << m_sequences_file.fileName()<< m_sequences_file.errorString();
    }
    m_sequences_file.close();
    m_flag_have_changes = false;
}

void WordsReservation::addSequence(){
    const QString seq = QInputDialog::getText(this, tr("enter sequense"), "");

    if(seq.isEmpty()) return;

    addReservedSequence(seq);
    updateList();
    m_flag_have_changes = true;
}

void WordsReservation::deleteSequence(){
    m_reserved_sequences.removeAt(ui->listWidget->currentRow());
    ui->listWidget->clear();
    ui->listWidget->addItems(m_reserved_sequences);
    updateList();
    m_flag_have_changes = true;
}

void WordsReservation::clearSequences(){
    ui->listWidget->clear();
    m_reserved_sequences.clear();
    m_flag_have_changes = true;
}

void WordsReservation::updateList(){
    ui->listWidget->setCurrentRow(ui->listWidget->count() - 1);
}

void WordsReservation::acceptChanges(){
    if(m_flag_have_changes &&
            QMessageBox::question(0,tr("Save changes?"),tr("Do you wand save changes?"),
             QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes){
        saveSequences();
        accept();
    } else reject();
}



//void WordsReservation::rejectChanges(){
//    reject();
//}
