# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "socket"
require "xmlrpc/client"

require "rast_xmlrpc_client"

require "make-variable"
require "rast/database-generatable"

module Rast
  module XMLRPCServerTestable
    include DatabaseGeneratable

    private

    @@port_start = 8000

    def kick_rast_xmlrpc_server_process(*args)
      for port in @@port_start .. 16000
        begin
          TCPSocket.open("localhost", port).close
        rescue Errno::ECONNREFUSED
          @@port_start = port
          break
        end
      end
      tmp_dir = generate_db_name
      conf_dir = File.join(tmp_dir, "conf")
      FileUtils.mkdir_p(conf_dir)
      pid_filename = File.join(conf_dir, "abyss.pid")
      filters_dir = File.join(tmp_dir, "filters")
      FileUtils.mkdir_p(filters_dir)
      command_line = [
        "env", "--", "RAST_FILTER_MODULEDIR=#{filters_dir}",
        File.join(MakeVariable::TOP_BUILDDIR, "src",
                  "rast-xmlrpc-server-abyss"),
        "--port", port.to_s,
        "--pid-file", pid_filename,
        *args
      ]
      system("#{command_line.join(' ')} > /dev/null")
      begin
        count = 0
        begin
          server = XMLRPC::Client.new("localhost", "/RPC2", port)
          server.call("system.listMethods")
          File.open(pid_filename).close
        rescue
          sleep(0.01)
          if count < 300
            count += 1
            retry
          end
          raise
        end
        yield(port)
      ensure
        pid = File.read(pid_filename).to_i
        Process.kill(:TERM, pid)
        count = 0
        begin
          Process.kill(0, pid)
        rescue Errno::ESRCH
        rescue
          sleep(0.01)
          if count < 300
            count += 1
            retry
          end
          raise
        end
      end
    end

    def kick_xmlrpc_client(*args)
      kick_rast_xmlrpc_server_process(*args) do |port|
        url = "http://localhost:#{port}/RPC2"
        XMLRPCClient.open(url) do |db|
          yield(db)
        end
      end
    end
  end
end
