/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;

public class JarFileIterator
implements ClassFileIterator {
    private ZipInputStream jarStream;

    public JarFileIterator(InputStream inputStream) throws IOException {
        this.jarStream = new ZipInputStream(inputStream);
    }

    private byte[] getEntryBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ClassFile getNextClassFile() {
        ClassFile classFile = null;
        try {
            ZipEntry zipEntry = this.jarStream.getNextEntry();
            while (classFile == null && zipEntry != null) {
                String string = zipEntry.getName();
                if (!zipEntry.isDirectory() && string.endsWith(".class")) {
                    ClassFile classFile2 = new ClassFile();
                    classFile2.read(this.jarStream);
                    classFile = classFile2;
                    continue;
                }
                zipEntry = this.jarStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            String string2 = iOException.getClass().getName();
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            throw new RuntimeException("Problem reading JAR file: " + string2);
        }
        return classFile;
    }
}

