/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AggregateTransformer {
    public static final String ALLPACKAGES = "all-packages";
    public static final String ALLCLASSES = "all-classes";
    public static final String OVERVIEW_PACKAGES = "overview-packages";
    public static final String CLASS_DETAILS = "class-details";
    public static final String CLASSES_LIST = "classes-list";
    public static final String PACKAGE_SUMMARY = "package-summary";
    public static final String OVERVIEW_SUMMARY = "overview-summary";
    public static final String FRAMES = "frames";
    public static final String NOFRAMES = "noframes";
    protected Task task;
    protected Document document;
    protected File styleDir;
    protected File toDir;
    protected String format;
    protected String extension;
    protected static final DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();

    public AggregateTransformer(Task task) {
        this.task = task;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setXmlDocument(Document document) {
        this.document = document;
    }

    void setXmlfile(File file) throws BuildException {
        try {
            this.setXmlDocument(this.readDocument(file));
        }
        catch (Exception exception) {
            throw new BuildException("Error while parsing document: " + file, (Throwable)exception);
        }
    }

    public void setStyledir(File file) {
        this.styleDir = file;
    }

    public void setTodir(File file) {
        this.toDir = file;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    protected String getExtension() {
        if (this.extension == null) {
            this.extension = ".html";
        }
        return this.extension;
    }

    public void transform() throws BuildException {
        this.checkOptions();
        try {
            Element element = this.document.getDocumentElement();
            if (NOFRAMES.equals(this.format)) {
                this.createSinglePageSummary(element);
            } else {
                this.createFrameStructure();
                this.createCascadingStyleSheet();
                this.createPackageList(element);
                this.createClassList(element);
                this.createPackageOverview(element);
                this.createAllTestSuiteDetails(element);
                this.createAllPackageDetails(element);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException("Errors while applying transformations", (Throwable)exception);
        }
    }

    protected void checkOptions() throws BuildException {
        if (!FRAMES.equals(this.format) && !NOFRAMES.equals(this.format)) {
            throw new BuildException("Invalid format. Must be 'frames' or 'noframes' but was: '" + this.format + "'");
        }
        if (this.toDir == null) {
            this.toDir = this.task.getProject().resolveFile(".");
        } else if (!this.toDir.isAbsolute()) {
            this.toDir = this.task.getProject().resolveFile(this.toDir.getPath());
        }
        if (!this.toDir.exists() && !this.toDir.mkdirs()) {
            throw new BuildException("Could not create directory " + this.toDir);
        }
    }

    protected void createSinglePageSummary(Element element) throws IOException, SAXException {
        this.transform(element, "overview-summary.xsl", OVERVIEW_SUMMARY + this.getExtension());
    }

    protected Document readDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        Document document;
        DocumentBuilder documentBuilder = dbfactory.newDocumentBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            document = documentBuilder.parse(fileInputStream);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return document;
    }

    protected void createCascadingStyleSheet() throws IOException, SAXException {
        InputStream inputStream = null;
        inputStream = this.styleDir == null ? this.getResourceAsStream("html/stylesheet.css") : new FileInputStream(new File(this.styleDir, "stylesheet.css"));
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.toDir, "stylesheet.css"));
        AggregateTransformer.copy(inputStream, fileOutputStream);
    }

    protected void createFrameStructure() throws IOException, SAXException {
        InputStream inputStream = null;
        inputStream = this.styleDir == null ? this.getResourceAsStream("html/index.html") : new FileInputStream(new File(this.styleDir, "index.html"));
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.toDir, "index.html"));
        AggregateTransformer.copy(inputStream, fileOutputStream);
    }

    protected void createPackageList(Node node) throws SAXException {
        this.transform(node, "all-packages.xsl", ALLPACKAGES + this.getExtension());
    }

    protected void createClassList(Node node) throws SAXException {
        this.transform(node, "all-classes.xsl", ALLCLASSES + this.getExtension());
    }

    protected void createPackageOverview(Node node) throws SAXException {
        this.transform(node, "overview-packages.xsl", OVERVIEW_PACKAGES + this.getExtension());
    }

    protected Enumeration getPackages(Element element) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NodeList nodeList = element.getElementsByTagName("testsuite");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            String string = element2.getAttribute("package");
            if (string == null) {
                throw new IllegalStateException("Invalid 'testsuite' node: should contains 'package' attribute");
            }
            hashtable.put(string, string);
            ++n2;
        }
        return hashtable.keys();
    }

    protected void createAllTestSuiteDetails(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName("testsuite");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            this.createTestSuiteDetails(element2);
            ++n2;
        }
    }

    protected void createTestSuiteDetails(Element element) throws SAXException {
        String string = element.getAttribute("package");
        String string2 = this.packageToPath(string);
        String string3 = element.getAttribute("name");
        String string4 = string3 + "-details" + this.getExtension();
        String string5 = string2 + string4;
        this.transform(element, "class-details.xsl", string5);
    }

    protected void createAllPackageDetails(Element element) throws SAXException, ParserConfigurationException {
        Enumeration enumeration = this.getPackages(element);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PackageFilter packageFilter = new PackageFilter(string);
            NodeList nodeList = DOMUtil.listChildNodes(element, packageFilter, false);
            Element element2 = this.buildDocument(nodeList);
            if (string.equals("")) continue;
            this.createPackageDetails(element2, string);
        }
    }

    protected String packageToPath(String string) {
        if (!string.equals("")) {
            return string.replace('.', File.separatorChar) + File.separatorChar;
        }
        return "." + File.separatorChar;
    }

    protected void createPackageDetails(Node node, String string) throws SAXException {
        String string2 = this.packageToPath(string);
        this.transform(node, "classes-list.xsl", string2 + CLASSES_LIST + this.getExtension());
        this.transform(node, "package-summary.xsl", string2 + PACKAGE_SUMMARY + this.getExtension());
    }

    protected Element buildDocument(NodeList nodeList) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = dbfactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("testsuites");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            DOMUtil.importNode(element, nodeList.item(n2));
            ++n2;
        }
        return element;
    }

    protected void transform(Node node, String string, String string2) throws SAXException {
        try {
            long l = System.currentTimeMillis();
            XSLTInputSource xSLTInputSource = this.getXSLStreamSource(string);
            XSLTProcessor xSLTProcessor = XSLTProcessorFactory.getProcessor();
            File file = new File(this.toDir, string2);
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            this.task.log("Applying '" + string + "'. Generating '" + file + "'", 3);
            xSLTProcessor.process(new XSLTInputSource(node), xSLTInputSource, new XSLTResultTarget(file.getAbsolutePath()));
            long l2 = System.currentTimeMillis() - l;
            this.task.log("Transform time for " + string + ": " + l2 + "ms");
        }
        catch (IOException iOException) {
            this.task.log(iOException.getMessage(), 0);
            iOException.printStackTrace();
            throw new SAXException(iOException.getMessage());
        }
    }

    protected XSLTInputSource getXSLStreamSource(String string) throws IOException {
        File file;
        String string2;
        InputStream inputStream;
        if (this.styleDir == null) {
            inputStream = this.getResourceAsStream("xsl/" + string);
            string2 = this.getClass().getResource("xsl/" + string).toString();
        } else {
            file = new File(this.styleDir, string);
            inputStream = new FileInputStream(file);
            string2 = file.getAbsolutePath();
        }
        file = new XSLTInputSource(inputStream);
        ((InputSource)((Object)file)).setSystemId(string2);
        return file;
    }

    private InputStream getResourceAsStream(String string) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not find resource '" + string + "'");
        }
        return inputStream;
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = -1;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    protected static class PackageFilter
    implements DOMUtil.NodeFilter {
        private final String pkgName;

        PackageFilter(String string) {
            this.pkgName = string;
        }

        public boolean accept(Node node) {
            String string = DOMUtil.getNodeAttribute(node, "package");
            return this.pkgName.equals(string);
        }
    }
}

