/*****************************************************************************
 *
 * FILE:	kanacodemap.h
 * DESCRIPTION: WKF: Ⱦѥʡ  Ѵơ֥
 * DATE:	Mon, Nov 10 1997
 * UPDATE:	Sun, Jun 11 2000
 * AUTHOR:	Kouichi ABE (WALL) / 
 * E-MAIL:	kouichi@MysticWALL.COM
 * URL:		http://www.MysticWALL.COM/
 * COPYRIGHT:	(c) 1997-2005 졿Kouichi ABE (WALL), All rights reserved.
 * LICENSE:
 *
 *  Copyright (c) 1997-2005 Kouichi ABE (WALL) <kouichi@MysticWALL.COM>,
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 *   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE
 *   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *   INTERRUPTION)  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 *   THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: kanacodemap.h,v 1.3 2005/04/05 08:26:56 kouichi Exp $
 *
 *****************************************************************************/
#ifndef	_kanacodemap_h
#define	_kanacodemap_h	1

typedef struct _kana2CodeMap {
  unsigned char	b1, b2;
} kana2CodeMap;

static kana2CodeMap	kana2code_map[] = {
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x01, 0x03}, {0x01, 0x36}, {0x01, 0x37},
{0x01, 0x02}, {0x01, 0x06}, {0x05, 0x52}, {0x05, 0x01},
{0x05, 0x03}, {0x05, 0x05}, {0x05, 0x07}, {0x05, 0x09},
{0x05, 0x43}, {0x05, 0x45}, {0x05, 0x47}, {0x05, 0x23},

{0x01, 0x1c}, {0x05, 0x02}, {0x05, 0x04}, {0x05, 0x06},
{0x05, 0x08}, {0x05, 0x0a}, {0x05, 0x0b}, {0x05, 0x0d},
{0x05, 0x0f}, {0x05, 0x11}, {0x05, 0x13}, {0x05, 0x15},
{0x05, 0x17}, {0x05, 0x19}, {0x05, 0x1b}, {0x05, 0x1d},

{0x05, 0x1f}, {0x05, 0x21}, {0x05, 0x24}, {0x05, 0x26},
{0x05, 0x28}, {0x05, 0x2a}, {0x05, 0x2b}, {0x05, 0x2c},
{0x05, 0x2d}, {0x05, 0x2e}, {0x05, 0x2f}, {0x05, 0x32},
{0x05, 0x35}, {0x05, 0x38}, {0x05, 0x3b}, {0x05, 0x3e},

{0x05, 0x3f}, {0x05, 0x40}, {0x05, 0x41}, {0x05, 0x42},
{0x05, 0x44}, {0x05, 0x46}, {0x05, 0x48}, {0x05, 0x49},
{0x05, 0x4a}, {0x05, 0x4b}, {0x05, 0x4c}, {0x05, 0x4d},
{0x05, 0x4f}, {0x05, 0x53}, {0x01, 0x0b}, {0x01, 0x0c},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x01, 0x03}, {0x01, 0x36}, {0x01, 0x37},
{0x01, 0x02}, {0x01, 0x06}, {0x05, 0x52}, {0x05, 0x01},
{0x05, 0x03}, {0x05, 0x05}, {0x05, 0x07}, {0x05, 0x09},
{0x05, 0x43}, {0x05, 0x45}, {0x05, 0x47}, {0x05, 0x23},

{0x01, 0x1c}, {0x05, 0x02}, {0x05, 0x04}, {0x05, 0x06},
{0x05, 0x08}, {0x05, 0x0a}, {0x05, 0x0b}, {0x05, 0x0d},
{0x05, 0x0f}, {0x05, 0x11}, {0x05, 0x13}, {0x05, 0x15},
{0x05, 0x17}, {0x05, 0x19}, {0x05, 0x1b}, {0x05, 0x1d},

{0x05, 0x1f}, {0x05, 0x21}, {0x05, 0x24}, {0x05, 0x26},
{0x05, 0x28}, {0x05, 0x2a}, {0x05, 0x2b}, {0x05, 0x2c},
{0x05, 0x2d}, {0x05, 0x2e}, {0x05, 0x2f}, {0x05, 0x32},
{0x05, 0x35}, {0x05, 0x38}, {0x05, 0x3b}, {0x05, 0x3e},

{0x05, 0x3f}, {0x05, 0x40}, {0x05, 0x41}, {0x05, 0x42},
{0x05, 0x44}, {0x05, 0x46}, {0x05, 0x48}, {0x05, 0x49},
{0x05, 0x4a}, {0x05, 0x4b}, {0x05, 0x4c}, {0x05, 0x4d},
{0x05, 0x4f}, {0x05, 0x53}, {0x01, 0x0b}, {0x01, 0x0c},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},

{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
{0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}
};

/*
 * JIS X 0201-1976 ̡ȾĤʤʸˤĤ줿Ƚ
 */
#define	KANA_CHECK(x)	(((((x) >= 0xb6) && ((x) <= 0xc4)) || \
			  (((x) >= 0xca) && ((x) <= 0xce))) || \
			 ((((x) >= 0x36) && ((x) <= 0x44)) || \
			  (((x) >= 0x4a) && ((x) <= 0x4e))) ? 1 : 0)

#endif	/* _kanacodemap_h */
