/*************************************************************************\
*   Copyright (C) 2011 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

#ifndef YAWP_EXTENDED_DESKTOP_PAINTER_H
#define YAWP_EXTENDED_DESKTOP_PAINTER_H

//--- LOCAL CLASSES ---
#include "abstractpainter.h"
#include "desktoppainter.h"
#include "yawpday.h"
#include "yawpdefines.h"

//--- QT4 CLASSES --- 
#include <QGraphicsSceneMouseEvent>
#include <QFrame>
#include <QPointer>

//--- KDE4 CLASSES --- 
#include <Plasma/Applet>

/*  The ExtendedDesktopPainter paints the content almost like the
 *  the extended tooltip used in panel mode.
 */
class ExtendedDesktopPainter : public DesktopPainter
{
public:
	static const qreal EXTENDED_LAYOUT_HEADER_OFFSET;
	static const qreal EXTENDED_LAYOUT_APPLET_WIDTH;
  
	ExtendedDesktopPainter (
		QGraphicsWidget * widget,
		const Yawp::ConfigData * configData,
		StateMachine * stateMachine,
		bool desktopMode = true);
	virtual ~ExtendedDesktopPainter();
	
	virtual Plasma::AspectRatioMode aspectRatioMode() const;
	
	virtual Yawp::PainterType painterType() const;
	
	virtual int heightForWidth(int width) const;
	virtual int widthForHeight(int height) const;
	
	virtual void mousePressEvent (QGraphicsSceneMouseEvent * event);
	
	/** public method to initialize weather icon change animation for given day index. */
	virtual void triggerWeatherIconAnimation(int dayIndex);
	
protected:
	virtual QRect getContentsRect(const QRect & contentsRect) const;
	virtual void handleLayoutChanges();
	virtual void drawPage(QPainter * painter, const QRect & contentsRect) const;
	virtual void drawBackground (QPainter * painter, const QRect & contentsRect) const;
	
	void drawNavigationHeader (QPainter * painter, const QRect & contentsRect) const;
	void drawMiniApplet(QPainter * painter, const QRect & appletContentsRect, bool showDayNames) const;

	void drawForecastText(QPainter * painter, const QRect & forecastContentRect, const qreal fontScale) const;
	
	/**
	 *  Get one of the buttons on the left top page (Preview, Details or Satellite).
	 *  This buttons will change the page.
	 */
	QRect getPageButtonRect (const QRect & headerRect, Yawp::PageType pageType) const;
	
	/**
	 *  This button are on the left and right side of the city name and will change
	 *  the currently shown city.
	 */
	QRect getCityButtonRect(const QRect & headerRect, bool previous) const;
	
	QRect getTodaysWeatherIconRect(const QRect & appletContentsRect) const;
	
	void initMiniAppletPageChange(const QRect & appletContentsRect, int newDayIndex, Yawp::PageType pageType);
	
	/**
	 * This function calculates sizes and positions of the for areas inside the applet
	 * depending of given content Rectangle.
	 * @param contentsRect This is the given rectangle that describes the size and position of the total content area.
	 * @param headerRect This is the calculated area that contains the buttons and the city name.
	 * @param miniAppletRectangle This is the calculated area that contains the mini applet of yaWP.
	 * @param forecastTextRectangle This is the calculated area that contains the forecast text.
	 * @param satelliteImageRectangle This is the calculated area that contains the satellite image of the city.
	 */
	static void calculateLayout(const QRect & contentsRect,
			     QRect & haderRectangle,
			     QRect & miniAppletRectangle,
			     QRect & forecastTextRectangle,
			     QRect & satelliteImageRectangle);
	
	static qreal calculateLayoutScalingFactor(const QRect & contentsRect);

private:
	const bool m_bDesktopMode;
	QString m_sVisualCityName;
	bool m_bShowForecastHeaderDayNames;
	
	QRect m_headerRectangle;
	QRect m_miniAppletRectangle;
	QRect m_forecastTextRectangle;
	QRect m_satelliteImageRectangle;
};

#endif // YAWP_EXTENDED_DESKTOP_PAINTER_H
