/*************************************************************************\
*   Copyright (C) 2011 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

#ifndef YAWP_PANEL_PAINTER_H
#define YAWP_PANEL_PAINTER_H

//--- LOCAL CLASSES ---
#include "abstractpainter.h"
//#include "basedesktoppainter.h"
#include "basepanelpainter.h"
#include "yawpday.h"
#include "yawpdefines.h"

//--- QT4 CLASSES --- 
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsWidget>
#include <QFrame>
#include <QPointer>

//--- KDE4 CLASSES --- 

/*  The PanelPainter is the traditional painter
 *  for the "panel mode" of yaWP.
 *  It is painting the horizontal and the vertical layout.
 *  Furthermore it distinguishs between a normal panel mode
 *  and a compact panel mode. But this is a feature of this
 *  panel painter.
 */
class PanelPainter : public BasePanelPainter
{
	Q_OBJECT

	//--- define pointer type to panels layout functions ---
	typedef void (* PanelLayoutDelegate)(
		const int heightOrWidth,
		const Yawp::ConfigData * configData,
		QSize & contentSize,
		QRect & todaysTempRect,
		QRect & todaysIconRect,
		QList<QRect> * forecastTempRects,
		QList<QRect> * forecastIconRects);

public:
	static const qreal HORIZONTAL_COMPACT_ICON_SIZE;
	static const qreal HORIZONTAL_TODAYS_COMPACT_TEMPERATURE;
	static const qreal HORIZONTAL_FORECAST_COMPACT_TEMPERATURE;
	static const qreal HORIZONTAL_TODAYS_TEMPERATURE;
	static const qreal HORIZONTAL_FORECAST_TEMPERATURE;
	
	static const qreal VERTICAL_COMPACT_ICON_SIZE;
	static const qreal VERTICAL_TODAYS_COMPACT_TEMPERATURE;
	static const qreal VERTICAL_FORECAST_COMPACT_TEMPERATURE;
	static const qreal VERTICAL_TODAYS_TEMPERATURE;
	static const qreal VERTICAL_FORECAST_TEMPERATURE;
	static const qreal VERTICAL_FORECAST_ICON_SPACER;
  
  
	PanelPainter (
		QGraphicsWidget * graphicsWidget,
		const Yawp::ConfigData * configData,
		StateMachine * stateMachine,
		Plasma::FormFactor formFactor);
	virtual ~PanelPainter();
	
	virtual Plasma::FormFactor formFactor() const;
	virtual Yawp::PainterType painterType() const;
	
	virtual int heightForWidth(int width) const;
	virtual int widthForHeight(int height) const;

	virtual void mousePressEvent (QGraphicsSceneMouseEvent * event);
	virtual void slotToggleWeatherIcon(int dayIndex);

protected:
	QRect getContentsRect(const QRect & contentsRect) const;
	void handleLayoutChanges();
	void drawPage(QPainter * painter, const QRect & contentsRect) const;
	
private:
	void drawTemperature(QPainter * painter, const YawpWeather * weather, int alignmentFlag, const QRect & tempRect) const;
	PanelLayoutDelegate getLayoutDelegate() const;
	
	static int getTemperatureWidth (int pixelSize, const QString & text);
	
	static void getHorizontalTemperatureSize(
		const int contentsHeight,
		const bool bUseCompactPanelLayout,
		int & todaysTemperatureWidth,
		int & forecastTemperatureWidth);

	static void getVerticalTemperatureSize(
		const int contentsHeight,
		const bool bUseCompactPanelLayout,
		int & todaysTemperatureWidth,
		int & forecastTemperatureWidth);

	static void calculateHorizontalLayout(
		const int panelHeight,
		const Yawp::ConfigData * configData,
		QSize & contentSize,
		QRect & todaysTempRect,
		QRect & todaysIconRect,
		QList<QRect> * forecastTempRects,
		QList<QRect> * forecastIconRects);

	static void calculateCompactHorizontalLayout(
		const int panelHeight,
		const Yawp::ConfigData * configData,
		QSize & contentSize,
		QRect & todaysTempRect,
		QRect & todaysIconRect,
		QList<QRect> * forecastTempRects,
		QList<QRect> * forecastIconRects);

	static void calculateVerticalLayout(
		const int panelWidth,
		const Yawp::ConfigData * configData,
		QSize & contentSize,
		QRect & todaysTempRect,
		QRect & todaysIconRect,
		QList<QRect> * forecastTempRects,
		QList<QRect> * forecastIconRects);

	static void calculateCompactVerticalLayout(
		const int panelWidth,
		const Yawp::ConfigData * configData,
		QSize & contentSize,
		QRect & todaysTempRect,
		QRect & todaysIconRect,
		QList<QRect> * forecastTempRects,
		QList<QRect> * forecastIconRects);

private:
	const Plasma::FormFactor m_formFactor;
	
	const PanelLayoutDelegate m_pfLayoutDelegate;
	const PanelLayoutDelegate m_pfCompactLayoutDelegate;
	
	QRect m_todaysTempRect;
	QRect m_todaysIconRect;
	QList<QRect> m_vForecastTemperatureRects;
	QList<QRect> m_vForecastIconRects;
};

#endif // YAWP_PANEL_PAINTER_H
