/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "convertor.h"

Segment::Segment(const WideString _kanji,const WideString _yomi) {
    kanji = _kanji;
    yomi = _yomi;
};
Segment::~Segment() {
};

const WideString Segment::getKanji() {
    return kanji;
};

const WideString Segment::getYomi() {
    return yomi;
};


/* 全部ダミーメソッドさぁー♪ */

Convertor::Convertor(ConfigPointer cfg) : HonokaPluginBase(String("Convertor"))
{
    // cfgプロパティを使ってSCIMの設定にアクセス可能です。
    config = cfg;
}


Convertor::~Convertor()
{
    // 正しい終了処理をデストラクタに書きましょう。
}

bool Convertor::isConnected() {
    // サーバに接続できているかどうかをチェックするメソッド。
    // サーバ/クライアント型でない変換エンジンの場合は常にtrueを返すと良いです。
    return false;
}

void Convertor::reset(){
    // resetメソッド。
    // このメソッドが呼ばれるまでを１変換処理と扱います。
    return;
}

void Convertor::setYomiText(WideString yomi) {
    // 読みをセットします。
    return;
}

int Convertor::ren_conversion() {
    // 連文節変換を開始します。
    // 文節数を返します。
    return 0;
}

int Convertor::setPos(int p){
    // 注目する文節位置をセットします。0から開始します。
    return 0;
}

int Convertor::getPos() {
    // 注目文節の番号を返します。0が一番左です。
    return 0;
}

ResultList Convertor::getResultList(int p,ResultType kt){
    // 注目文節pに対してktと言う変換方法で変換し、
    // 変換結果の候補をすべてResultListに入れて返して下さい。
    // 失敗/エラー処理は候補無しのResultListを返すと良いです。
    return ResultList();
}

bool Convertor::select(int p) {
    // 現在の注目文節の候補番号pを選択します。
    return false;
}

bool Convertor::resizeRegion(int w) {
    // 注目文節の選択範囲を指定します。wは相対値を指定します。
    return false;
}

void Convertor::updateFrequency() {
    // 頻度を更新する処理を書いて下さい。
    // selectでは頻度更新をすべきではないと思います。個人的意見。
    return;
}

bool Convertor::connect() {
    // サーバに接続する処理を書きます。
    // 不要ならtrueを返せば良いです。
    return false;
}
void Convertor::disconnect() {
    // サーバから接続を切断する処理を書きます。
    return;
}


String Convertor::getName()
{
    // 名前を返して下さい。
    // 必ずユニークなものを指定しましょう。
    return String("Convertor");
}

String Convertor::getPropertyName()
{
    // 諸々の事情で、ユニークなものを指定しましょう。
    return getName();
}


const vector<Segment> Convertor::getSegmentList()
{
    // getTextにかわるもの。
    return vector<Segment>();
}


void Convertor::unSelected()
{
    return;
}


void Convertor::selected()
{
    return;
}
