/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "honokasetupcore.h"

using namespace Honoka;

HonokaSetupCoreItem::HonokaSetupCoreItem(String _label,String _name,String _tip)
{
    label = _label;
    name = _name;
    tip = _tip;
}


HonokaSetupCoreItem::~HonokaSetupCoreItem()
{
}

const String HonokaSetupCoreItem::getType()
{
    return type;
}

const String HonokaSetupCoreItem::getName()
{
    return name;
}

const String HonokaSetupCoreItem::getLabel()
{
    return label;
}

const String HonokaSetupCoreItem::getTip()
{
    return tip;
}

const String HonokaSetupCoreItem::getStringData()
{
    return stringData;
}

int HonokaSetupCoreItem::getIntData()
{
    return intData;
}

bool HonokaSetupCoreItem::getBoolData()
{
    return boolData;
}

vector<String> HonokaSetupCoreItem::getStringListData()
{
    return stringListData;
}

int HonokaSetupCoreItem::getIntUpper()
{
    return intUpper;
}

int HonokaSetupCoreItem::getIntLower()
{
    return intLower;
}


HonokaSetupCoreContainer::HonokaSetupCoreContainer()
{
}


HonokaSetupCoreContainer::~HonokaSetupCoreContainer()
{
    for(unsigned int i = 0;i < items.size();i ++) {
        delete items[i];
    }
}

void HonokaSetupCoreContainer::append(HonokaSetupCoreItem *item)
{
    items.push_back(item);
}

const vector<HonokaSetupCoreItem *> HonokaSetupCoreContainer::getChildren()
{
    return items;
}


HonokaSetupCoreEntryItem::HonokaSetupCoreEntryItem(String _label,String _name,String _tip,String _default)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_ENTRY;
    stringData = _default;
}

HonokaSetupCoreKeyItem::HonokaSetupCoreKeyItem(String _label,String _name,String _tip,String _default)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_KEY;
    stringData = _default;
}

HonokaSetupCoreFileItem::HonokaSetupCoreFileItem(String _label,String _name,String _tip,String _default)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_FILE;
    stringData = _default;
}

HonokaSetupCoreBoolItem::HonokaSetupCoreBoolItem(String _label,String _name,String _tip,bool _default)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_BOOL;
    boolData = _default;
}

HonokaSetupCoreIntItem::HonokaSetupCoreIntItem(String _label,String _name,String _tip,int _default,int _lower,int _upper)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_INT;
    intData = _default;
    intLower = _lower;
    intUpper = _upper;
}

HonokaSetupCoreSelectItem::HonokaSetupCoreSelectItem(String _label,String _name,String _tip,String _default,vector<String> _list)
: HonokaSetupCoreItem(_label,_name,_tip)
{
    type = HONOKA_SETUP_ITEM_SELECT;
    stringData = _default;
    stringListData = _list;
}

HonokaSetupCorePage::HonokaSetupCorePage(String _label,String _name,String _tip)
: HonokaSetupCoreItem(_label,_name,_tip),HonokaSetupCoreContainer()
{
    type = HONOKA_SETUP_ITEM_PAGE;
}

HonokaSetupCore::HonokaSetupCore(String _label,String _name,String _tip)
: HonokaSetupCoreItem(_label,_name,_tip),HonokaSetupCoreContainer()
{
    type = HONOKA_SETUP_ITEM_SETUP;
}



