/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBIRDGEAGENTSETPREEDITSHOWNEVENT_H_
#define SCIMBIRDGEAGENTSETPREEDITSHOWNEVENT_H_

#include "scim-bridge-agent-event.h"
#include "scim-bridge-imcontext.h"

class ScimBridgeAgentSetPreeditShownEvent: public ScimBridgeAgentEvent
{

    public:

        ScimBridgeAgentSetPreeditShownEvent (scim_bridge_imcontext_id_t new_id, bool new_shown);
        ~ScimBridgeAgentSetPreeditShownEvent ();

        scim_bridge_imcontext_id_t get_imcontext_id () const;

        bool is_shown () const;

    private:

        scim_bridge_imcontext_id_t imcontext_id;

        bool shown;

};
#endif                                            /*SCIMBIRDGEAGENTSETPREEDITSHOWNEVENT_H_*/
