/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <string.h>

#include "scim-bridge-agent-exception.h"

using std::runtime_error;
using std::string;

ScimBridgeAgentException::ScimBridgeAgentException (const string &new_message):
runtime_error (new_message), message (new_message)
{
}


ScimBridgeAgentException::~ScimBridgeAgentException () throw ()
{
}


const string &ScimBridgeAgentException::get_message () const
{
    return message;
}
