/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTPANELLISTENER_H_
#define SCIMBRIDGEAGENTPANELLISTENER_H_

#include <scim.h>

#include "scim-bridge-agent-event-client.h"
#include "scim-bridge-agent-panel-listener-protected.h"
#include "scim-bridge-display.h"
#include "scim-bridge-imcontext.h"

class ScimBridgeAgentProtected;

class ScimBridgeAgentPanelListener: public ScimBridgeAgentEventClient, public ScimBridgeAgentPanelListenerProtected
{

    public:

        static ScimBridgeAgentPanelListener *alloc (const scim::String &config_name, const ScimBridgeDisplay *display, ScimBridgeAgentProtected *new_agent);

        virtual ~ScimBridgeAgentPanelListener () {}

		virtual retval_t launch () = 0;

        virtual void read_and_dispatch () = 0;
        virtual void prepare (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual void send () = 0;

        virtual void focus_in (const scim::String &factory_uuid) = 0;
        virtual void focus_out () = 0;

        virtual void update_screen () = 0;
        virtual void update_cursor_location (int x, int y) = 0;
        virtual void update_factory_info (const scim::PanelFactoryInfo &factory_info) = 0;

        virtual void turn_on () = 0;
        virtual void turn_off () = 0;

        virtual void set_aux_string (const scim::WideString &str, const scim::AttributeList &attrs) = 0;
        virtual void show_aux_string () = 0;
        virtual void hide_aux_string () = 0;

        virtual void set_lookup_table (const scim::LookupTable &table) = 0;
        virtual void show_lookup_table () = 0;
        virtual void hide_lookup_table () = 0;

        virtual void set_preedit_cursor_position (int cursor_pos) = 0;
        virtual void set_preedit_string (const scim::WideString &str, const scim::AttributeList &attrs) = 0;
        virtual void show_preedit () = 0;
        virtual void hide_preedit () = 0;

        virtual void start_helper (const scim::String &helper_uuid) = 0;
        virtual void stop_helper (const scim::String &helper_uuid) = 0;
        virtual void send_helper_event (const scim::String &helper_uuid, const scim::Transaction &trans) = 0;

        virtual void register_properties (const scim::PropertyList &properties) = 0;
        virtual void update_property (const scim::Property &property) = 0;

        virtual void show_factory_menu (const std::vector<scim::PanelFactoryInfo> &menu) = 0;
        virtual void show_help (const scim::String &string) = 0;

    protected:

        ScimBridgeAgentPanelListener () {}

        virtual void do_close_event_client () = 0;

};
#endif                                            /*SCIMBRIDGEAGENTPANELLISTENER_H_*/
