/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

/**
 * @file
 * @author Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 * @brief This header is used for exception handling.
 *
 * These functions are useful in debugging.\n
 * You can get the debug message, or the stacktrace even in C.\n
 * \n
 * Notice, I'll remove this in the next release; It's too exaggerated.
 */
#ifndef SCIMBRIDGEEXCEPTION_H_
#define SCIMBRIDGEEXCEPTION_H_

#include "scim-bridge.h"

enum _scim_bridge_exception_code_t
{
    OUT_OF_BOUNDS_EXCEPTION,
    NULL_POINTER_EXCEPTION,
    ILLEGAL_STATE_EXCEPTION,
    INVALID_ARGUMENT_EXCEPTION,
    IO_EXCEPTION,
    NUMBER_FORMAT_EXCEPTION,
    NO_SUCH_ELEMENT_EXCEPTION,
    INVALID_ESCAPE_EXCEPTION,
    UNEXPECTED_VALUE_EXCEPTION,
    INVALID_UTF8_EXCEPTION,
    INVALID_UCS4_EXCEPTION,
    NO_ENOUGH_BUFFER_EXCEPTION,
    OVER_FLOW_EXCEPTION,
    SYSTEM_EXCEPTION,
    UNKNOWN_EXCEPTION,
    NO_EXCEPTION
};

/**
 * The type for error codes.
 */
typedef enum _scim_bridge_exception_code_t scim_bridge_exception_code_t;

#ifdef __cplusplus
extern "C"
{
#endif
    
    void scim_bridge_exception_clear ();

    void scim_bridge_exception_occured (scim_bridge_exception_code_t code, const char *message,...);
    void scim_bridge_exception_output ();

    void scim_bridge_exception_push_stack (const char *stack);
    const char *scim_bridge_exception_poll_stack ();

    const char *scim_bridge_exception_get_message ();
    scim_bridge_exception_code_t scim_bridge_exception_get_code ();

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEEXCEPTION_H_*/
