/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */


/**
 * @file
 * @author Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 * @brief This header describes abut file pathes.
 */
#ifndef SCIMBRIDGEPATH_H_
#define SCIMBRIDGEPATH_H_

#include "scim-bridge.h"

#ifdef __cplusplus
extern "C"
{
#endif

    /**
     * Get the socket path for messengers.
     *
     * @return The socket path.
     */
    const char *scim_bridge_path_get_socket ();

    /**
     * Get the lockfile path of the agent.
     *
     * @return The lockfile path.
     */
    const char *scim_bridge_path_get_lockfile ();

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEPATH_H_*/
