MACRO(PROCESS_IIFILES _i_FILES)
	# reset the variable
	SET(${_i_FILES})

	FOREACH(_current_FILE ${ARGN})
		GET_FILENAME_COMPONENT(_tmp_FILE ${_current_FILE} ABSOLUTE)
		GET_FILENAME_COMPONENT(_abs_PATH ${_tmp_FILE} PATH)
		GET_FILENAME_COMPONENT(_basename ${_tmp_FILE} NAME_WE)
		SET(_i_FILE ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.i)
		
		ADD_CUSTOM_COMMAND(OUTPUT ${_i_FILE}
			COMMAND ${CMAKE_BINARY_DIR}/tools/install_service 
			ARGS -i ${CMAKE_CURRENT_SOURCE_DIR}/${_current_FILE} -o ${_i_FILE} >& /dev/null
			DEPENDS ${CMAKE_CURRENT_SOURCE_DIR}/${_current_FILE} ${CMAKE_BINARY_DIR}/tools/install_service)
		
		SET(${_i_FILES} ${${_i_FILES}} ${_i_FILE})
			
	ENDFOREACH(_current_FILE)

	ADD_CUSTOM_TARGET(ifiles ALL 
		DEPENDS ${${_i_FILES}})	

ENDMACRO(PROCESS_IIFILES)

MACRO(GENERATE_RUNLEVEL)
	SET(_runlevel_FILES)
	FOREACH(_current_FILE ${ARGN})
		SET(_runlevel_FILE ${CMAKE_CURRENT_BINARY_DIR}/${_current_FILE})
		ADD_CUSTOM_COMMAND(OUTPUT ${_runlevel_FILE}
			COMMAND ${CMAKE_SOURCE_DIR}/gen_system_runlevel 
			ARGS -confdir ${CMAKE_CURRENT_BINARY_DIR} ${_current_FILE} >& /dev/null
			DEPENDS ${CMAKE_SOURCE_DIR}/gen_system_runlevel)
		
		SET(_runlevel_FILES ${_runlevel_FILES} ${_runlevel_FILE})
			
	ENDFOREACH(_current_FILE)

	ADD_CUSTOM_TARGET(runlevel ALL 
		DEPENDS ${_runlevel_FILES})	
		
ENDMACRO(GENERATE_RUNLEVEL)
