#!/usr/bin/perl -w

#  install_service.pl
#  Copyright (C) 2005 Grzegorz Dabrowski <gdx@poczta.fm>
# 
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
# 
#  You should have received a copy of the GNU Lesser General
#  Public License along with this library; if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301, USA.

# full replacement for install_service.c

sub probe_distro
{
    # Give Linspire predence over debian because it also has the
    # /etc/debian_version file.
    if (-f "/etc/linspire-version") {
        return "linspire";
    }
    if (-f "/etc/debian_version") {
        return "debian";
    }
    if (-f "/etc/gentoo-release" || -f "/etc/pardus-release") {
        return "gentoo";
    }
    if (-f "/etc/fedora-release") {
        return "fedora";
    }
    if (-f "/etc/pld-release") {
        return "pld";
    }
    if (-f "/etc/pingwinek-release") {
        return "pingwinek";
    }
    if (-f "/etc/altlinux-release") {
	return "altlinux";
    }
    return "unknown";
}

my $input_file = "";
my $output_file = "";
my $distro = probe_distro();
my $print_row = 0;
my $match_distro_in_block = 0;
my $in_block = 0;
my $in_exec_block = 0;
my @exec_block;

for ($i = 0; $i <= $#ARGV; $i++) {
    if ($ARGV[$i] eq "-i" || $ARGV[$i] eq "--in") {
	$input_file = $ARGV[$i+1];
    }
    if ($ARGV[$i] eq "-o" || $ARGV[$i] eq "--out") {
	$output_file = $ARGV[$i+1];
    }
    if ($ARGV[$i] eq "-d" || $ARGV[$i] eq "--dist") {
	$distro = $ARGV[$i+1];
    }
}

print STDERR "Distribution set: $distro\n";

if ($input_file ne "" && $output_file eq "") {
    if ($input_file =~ /\.ii$/) {
	$output_file = $input_file;
	$output_file =~ s/\.ii/\.i/;
    }
}

open(IN, $input_file);
open(OUT, ">$output_file");
while (<IN>)
{
    my $line = $_;
    if ($print_row == 1 && !/^\#endd/ && !/^\#elsed/) {
	print OUT "$line";
    }
    if (/^\#exec/) {
	$in_exec_block = 1;
    }
    if (/^\#ifd\s+(.+)/ || /^\#elsed\s*(.*)/)
    {
	my $d = $1;
	my @distros = split(/[\s]+/, $d);
	my $ndistros = $#distros + 1;
	$in_block = 1;
	$print_row = 0;
	if ($ndistros != 0) {
	    foreach my $di (@distros)
	    {
		if ($distro eq $di) {
	  	    $match_distro_in_block = 1;
		    $print_row = 1;
		}
	    }
	} else {
	    # unknown distro block
	    if ($match_distro_in_block == 0) {
		$print_row = 1;
	    }
	}
    }
    if (/^\#endexec/) {
	$in_exec_block = 0;
	print OUT join("\n", @exec_block);
    }
    if ($in_exec_block == 1 && !/\#exec/) {
	push @exec_block, $line;
    }
    # print everything outside block
    if ($in_block == 0 && ($in_exec_block == 0 && !/\#endexec/)) {
	print OUT "$line";
    }
    if (/^\#endd/) {
	$in_block = 0;
	$match_distro_in_block = 0;
	$print_row = 0;
    }
}
close(IN);
close(OUT);
