/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "cursor.h"
#include "cursorstr.h"
#include "scrnintstr.h"
#include "servermd.h"
#include "inputstr.h"

#include "Agent.h"
#include "Display.h"
#include "Options.h"
#include "Screen.h"
#include "Cursor.h"
#include "Visual.h"
#include "Keyboard.h"
#include "Args.h"
#include "Window.h"
#include "Events.h"
#include "windowstr.h"
#include "resource.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * Defined in Display.c. There are huge problems
 * using GC definition. This is to be reworked.
 */

extern XlibGC nxagentBitmapGC;

/*
 * Whenever a change in the bitmap of the cursor is needed
 * this function gets called.
 *
 * 1. We still haven't managed to get it called for a box
 *    different tan the agent's root window.
 *
 * 2. Always ungrabs the cursor without grabbing it.
 *
 * It is still unclear if we actually need to "constrain"
 * the cursor, anyway we skip the operations performed by
 * the Xnest server to avoid the XGetGeometry round-trip.
 *
 * It is also unclear why XGetGeometry was used as window
 * geometry is stored in nxagentDefaultWindows[] of screen.
 */

#ifdef NXAGENT_CONSTRAINCURSOR
void nxagentConstrainCursor(pScreen, pBox)
     ScreenPtr pScreen;
     BoxPtr pBox;
{
  int wwidth, wheight;

  #ifdef TEST
  fprintf(stderr, "nxagentConstrainCursor: WARNING! Called with box [%d,%d,%d,%d]. Skipping operation.\n",
              pBox->x1, pBox->y1, pBox->x2, pBox->y2);
  #endif

  wwidth  = nxagentOption(RootWidth);
  wheight = nxagentOption(RootHeight);

  /*
  {
      static int nx_count;
      fprintf(stderr, "nxagentConstrainCursor #: %d\n", nx_count++);
      fprintf(stderr,
              "Arguments: pBox->x1: %d, pBox->x2: %d, pBox->y1: %d, pBox->y2: %d\n",
              pBox->x1, pBox->x2, pBox->y1, pBox->y2);
      fprintf(stderr, "wwidth: %u, wheight; %u\n", wwidth, wheight);
  }
  */

  if (pBox->x1 <= 0 && pBox->y1 <= 0 &&
      pBox->x2 >= wwidth && pBox->y2 >= wheight)
  {
    return;
  }
  else
  { 
    /*
     * This is to understand if and when we
     * can enter this part of the clause.
     */

    fprintf(stderr, "DEBUG: nxagentConstrainCusor called with pBox different from root!\n");
    fprintf(stderr, 
            "Arguments: pBox->x1: %d, pBox->x2: %d, pBox->y1: %d, pBox->y2: %d\n", 
            pBox->x1, pBox->x2, pBox->y1, pBox->y2);
    fprintf(stderr, "wwidth: %u, wheight; %u\n", wwidth, wheight);
    fprintf(stderr, "DEBUG: please report under what situation it happened\n");
  }
}
#else /* NXAGENT_CONSTRAINCURSOR */
void nxagentConstrainCursor(pScreen, pBox)
     ScreenPtr pScreen;
     BoxPtr pBox;
{
#ifdef _XSERVER64
  Window64 wroot;
#else
  Window wroot;
#endif

  int wx, wy;
  unsigned int wwidth, wheight;
  unsigned int wborderwidth;
  unsigned int wdepth;

  XGetGeometry(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &wroot,
               &wx, &wy, &wwidth, &wheight, &wborderwidth, &wdepth);

  if (pBox->x1 <= 0 && pBox->y1 <= 0 &&
      pBox->x2 >= wwidth && pBox->y2 >= wheight)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentConstrainCursor: WARNING! Going to ungrab the pointer in context [C].\n");
    #endif

    XUngrabPointer(nxagentDisplay, CurrentTime);
  }
  else
  {
    Mask eventMask;
    int resource;

    XReparentWindow(nxagentDisplay, nxagentConfineWindow,
                    nxagentDefaultWindows[pScreen->myNum],
                    pBox->x1, pBox->y1);

    XResizeWindow(nxagentDisplay, nxagentConfineWindow,
                  pBox->x2 - pBox->x1, pBox->y2 - pBox->y1);

    /*
     * From the XGrabPointer man page:
     *
     * "event_mask specifies which pointer events are reported
     * to the client. The mask is the bitwise inclusive OR of
     * the valid pointer event mask bits."
     *
     * So all the possibly selected keyboard events are cleared
     * from the mask.
     */

    #ifdef WARNING
    fprintf(stderr, "nxagentConstrainCursor: WARNING! Going to grab the pointer in context [C].\n");
    #endif

    nxagentGetDefaultEventMask(&eventMask);

    /*
     * FIXME: To be reviewed.
     */

    resource = nxagentWaitForResource(NXGetCollectGrabPointerResource,
                                          nxagentCollectGrabPointerPredicate);

    NXCollectGrabPointer(nxagentDisplay, resource,
                             nxagentDefaultWindows[pScreen->myNum], True,
                                 eventMask & (~NXAGENT_KEYBOARD_EVENT_MASK|KeymapStateMask),
                                     GrabModeAsync, GrabModeAsync, nxagentConfineWindow,
                                         None, CurrentTime);
  }
}
#endif /* NXAGENT_CONSTRAINCURSOR */

void nxagentCursorLimits(pScreen, pCursor, pHotBox, pTopLeftBox)
     ScreenPtr pScreen;
     CursorPtr pCursor;
     BoxPtr pHotBox;
     BoxPtr pTopLeftBox;
{
  *pTopLeftBox = *pHotBox;
}

Bool nxagentDisplayCursor(pScreen, pCursor)
     ScreenPtr pScreen;
     CursorPtr pCursor;
{
  if (nxagentOption(Rootless) == False)
  {
    XDefineCursor(nxagentDisplay,
                     nxagentWindow(WindowTable[pScreen -> myNum]),
                        nxagentCursor(pCursor, pScreen));

    #ifdef TEST
    fprintf(stderr, "nxagentDisplayCursor: Called for cursor at [%p] with private [%p].\n",
                (void *) pCursor, pCursor->devPriv[pScreen->myNum]);
    #endif
  }

  return True;
}

Bool nxagentRealizeCursor(pScreen, pCursor)
     ScreenPtr pScreen;
     CursorPtr pCursor;
{
  XImage *ximage;
  Pixmap source, mask;
  XColor fg_color, bg_color;
  unsigned long valuemask;
  XGCValues values;

  #ifdef TEST
  fprintf(stderr, "nxagentRealizeCursor: Called for cursor at [%p].\n", (void *) pCursor);
  #endif
  
  valuemask = GCFunction |
              GCPlaneMask |
              GCForeground |
              GCBackground |
              GCClipMask;

  values.function = GXcopy;
  values.plane_mask = AllPlanes;
  values.foreground = 1L;
  values.background = 0L;
  values.clip_mask = None;

  XChangeGC(nxagentDisplay, nxagentBitmapGC, valuemask, &values);

  source = XCreatePixmap(nxagentDisplay,
                         nxagentDefaultWindows[pScreen->myNum],
                         pCursor->bits->width,
                         pCursor->bits->height,
                         1);

  mask   = XCreatePixmap(nxagentDisplay,
                         nxagentDefaultWindows[pScreen->myNum],
                         pCursor->bits->width,
                         pCursor->bits->height,
                         1);

  ximage = XCreateImage(nxagentDisplay,
                        nxagentDefaultVisual(pScreen),
                        1, XYBitmap, 0,
                        (char *)pCursor->bits->source,
                        pCursor->bits->width,
                        pCursor->bits->height,
                        BitmapPad(nxagentDisplay), 0);

  /*
   * Force Xlib to swap the image if needed.
   */

  nxagentSetImageFormat(ximage);

  XPutImage(nxagentDisplay, source, nxagentBitmapGC, ximage,
            0, 0, 0, 0, pCursor->bits->width, pCursor->bits->height);

  XFree(ximage);

  ximage = XCreateImage(nxagentDisplay,
                        nxagentDefaultVisual(pScreen),
                        1, XYBitmap, 0,
                        (char *)pCursor->bits->mask,
                        pCursor->bits->width,
                        pCursor->bits->height,
                        BitmapPad(nxagentDisplay), 0);

  nxagentSetImageFormat(ximage);

  XPutImage(nxagentDisplay, mask, nxagentBitmapGC, ximage,
            0, 0, 0, 0, pCursor->bits->width, pCursor->bits->height);

  XFree(ximage);

  fg_color.red = pCursor->foreRed;
  fg_color.green = pCursor->foreGreen;
  fg_color.blue = pCursor->foreBlue;

  bg_color.red = pCursor->backRed;
  bg_color.green = pCursor->backGreen;
  bg_color.blue = pCursor->backBlue;

  pCursor->devPriv[pScreen->myNum] = (pointer)xalloc(sizeof(nxagentPrivCursor));
  nxagentCursorPriv(pCursor, pScreen)->cursor =
    XCreatePixmapCursor(nxagentDisplay, source, mask, &fg_color, &bg_color,
                        pCursor->bits->xhot, pCursor->bits->yhot);
  nxagentCursorUsesRender(pCursor, pScreen) = 0;

  #ifdef TEST
  fprintf(stderr, "nxagentRealizeCursor: Set cursor private at [%p] cursor is [%ld].\n",
              (void *) nxagentCursorPriv(pCursor, pScreen), nxagentCursorPriv(pCursor, pScreen) -> cursor);
  #endif
  
  XFreePixmap(nxagentDisplay, source);
  XFreePixmap(nxagentDisplay, mask);

  return True;
}

Bool nxagentUnrealizeCursor(pScreen, pCursor)
     ScreenPtr pScreen;
     CursorPtr pCursor;
{
  if (nxagentCursorUsesRender(pCursor, pScreen))
  {
    PicturePtr pPicture = nxagentCursorPicture(pCursor, pScreen);

    FreePicture(pPicture, pPicture -> id);
  }

  if (nxagentCursor(pCursor, pScreen) != None)
  {
    XFreeCursor(nxagentDisplay, nxagentCursor(pCursor, pScreen));

    nxagentCursor(pCursor, pScreen) = None;
  }

  xfree(nxagentCursorPriv(pCursor, pScreen));

  return True;
}

void nxagentRecolorCursor(pScreen,  pCursor, displayed)
     ScreenPtr pScreen;
     CursorPtr pCursor;
     Bool displayed;
{
  XColor fg_color, bg_color;
  
  fg_color.red = pCursor->foreRed;
  fg_color.green = pCursor->foreGreen;
  fg_color.blue = pCursor->foreBlue;
  
  bg_color.red = pCursor->backRed;
  bg_color.green = pCursor->backGreen;
  bg_color.blue = pCursor->backBlue;
  
  XRecolorCursor(nxagentDisplay, 
                 nxagentCursor(pCursor, pScreen),
                 &fg_color, &bg_color);
}

Bool nxagentSetCursorPosition(pScreen, x, y, generateEvent)
     ScreenPtr pScreen;
     int x, y;
     Bool generateEvent;
{
  int i;

  for (i = 0; i < nxagentNumScreens; i++)
    XWarpPointer(nxagentDisplay, nxagentDefaultWindows[i],
                 nxagentDefaultWindows[pScreen->myNum],
                 0, 0, 0, 0, x, y);
  
  return True;
}

void nxagentReconnectCursor(pointer p0, XID x1, pointer p2)
{
  Bool* pBool = (Bool*)p2;
  CursorPtr pCursor = (CursorPtr)p0;
  extern ScreenPtr nxagentDummyScreen;
  extern Bool nxagentRenderRealizeCursor(ScreenPtr, CursorPtr);

  #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
  fprintf(stderr, "nxagentReconnectCursor: %p\n", pCursor);
  #endif

  if (!*pBool || !pCursor)
  {
    return;
  }

  if (nxagentCursorPriv(pCursor, nxagentDummyScreen))
  {
    if (nxagentCursorUsesRender(pCursor, nxagentDummyScreen))
    {
      PicturePtr pPicture = nxagentCursorPicture(pCursor, nxagentDummyScreen);
      int ret = 1;
      extern void nxagentReconnectPicture(PicturePtr, pointer, pointer);

      nxagentReconnectPicture(pPicture, 0, &ret);

      nxagentRenderRealizeCursor(nxagentDummyScreen, pCursor);
    }
    else
    {
      xfree(nxagentCursorPriv(pCursor, nxagentDummyScreen));
      if (!nxagentRealizeCursor(nxagentDummyScreen, pCursor))
      {
        fprintf(stderr, "nxagentReconnectCursor: nxagentRealizeCursor failed\n");
        *pBool = False;
      }
    }
  }

  #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
  fprintf(stderr, "nxagentReconnectCursor: %p - ID %lx\n", pCursor, nxagentCursor(pCursor, nxagentDummyScreen));
  #endif
}

/*
 * The parameter is ignored at the moment.
 */

void nxagentReDisplayCurrentCursor(void)
{
  extern ScreenPtr nxagentDummyScreen;
  extern CursorPtr GetSpriteCursor(void);
  CursorPtr pCursor = GetSpriteCursor();

  if (pCursor &&
          nxagentCursorPriv(pCursor, nxagentDummyScreen) &&
              nxagentCursor(pCursor, nxagentDummyScreen))
  {
    nxagentDisplayCursor(nxagentDummyScreen, pCursor);
  }
}

Bool nxagentReconnectAllCursor(void *p0)
{
  int i;
  Bool r = True;
  extern InputInfo inputInfo;
  GrabPtr grab = inputInfo.pointer -> grab;

  #if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_CURSOR_DEBUG)
  fprintf(stderr, "nxagentReconnectAllCursor\n");
  #endif

  for (i = 0, r = 1; i < MAXCLIENTS; r = 1, i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], RT_CURSOR, nxagentReconnectCursor, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentReconnectAllCursor: WARNING! Failed to recreate "
                    "cursor for client [%d].\n", i);
      }

      #endif
    }
  }

  if (grab)
  {
    nxagentReconnectCursor(grab -> cursor, 0, &r);
  }

  return r;
}

void nxagentDisconnectCursor(pointer p0, XID x1, pointer p2)
{
  extern ScreenPtr nxagentDummyScreen;

  Bool* pBool = (Bool *) p2;
  CursorPtr pCursor = (CursorPtr) p0;

  /*
   * We get a animated cursor whose pointer to private is NULL.
   */

  if (!*pBool || !pCursor || !nxagentCursorPriv(pCursor, nxagentDummyScreen))
  {
    return;
  }


  #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
  fprintf(stderr, "nxagentDisconnectCursor: %p - ID %lx\n",
          pCursor,
          nxagentCursor(pCursor, nxagentDummyScreen));
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectCursor: Called with bool [%d].\n", *pBool);

  fprintf(stderr, "nxagentDisconnectCursor: Pointer to cursor is [%p] with counter [%d].\n",
              (void *) pCursor, pCursor -> refcnt);

  fprintf(stderr, "nxagentDisconnectCursor: Dummy screen is at [%p].\n",
              (void *) nxagentDummyScreen);

  fprintf(stderr, "nxagentDisconnectCursor: Cursor private is at [%p].\n",
              (void *) nxagentCursorPriv(pCursor, nxagentDummyScreen));
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectCursor: Dummy screen number is [%d].\n",
              nxagentDummyScreen -> myNum);

  fprintf(stderr, "nxagentDisconnectCursor: Cursor is [%ld].\n",
              nxagentCursor(pCursor, nxagentDummyScreen));
  #endif

  nxagentCursor(pCursor, nxagentDummyScreen) = None;

  if (nxagentCursorUsesRender(pCursor, nxagentDummyScreen))
  {
    PicturePtr pPicture = nxagentCursorPicture(pCursor, nxagentDummyScreen);
    int        ret = 1;
    extern void nxagentDisconnectPicture(PicturePtr, pointer, pointer);

    #if defined(NXAGENT_RECONNECT_CURSOR_DEBUG) || defined(NXAGENT_RECONNECT_PICTURE_DEBUG)
    fprintf(stderr, "nxagentDisconnectCursor: disconnecting attached picture %p\n", pPicture);
    #endif

    nxagentDisconnectPicture(pPicture, 0, &ret);
  }
}

Bool nxagentDisconnectAllCursor(void)
{
  int i;
  Bool r = TRUE;
  extern InputInfo inputInfo;
  GrabPtr grab = inputInfo.pointer -> grab;

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectAllCursor: Going to iterate through cursor resources.\n");
  #endif

  for (i = 0, r = 1; i < MAXCLIENTS; r = 1, i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], RT_CURSOR, nxagentDisconnectCursor, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentDisconnectAllCursor: WARNING! Failed to disconnect "
                    "cursor for client [%d].\n", i);
      }

      #endif
    }
  }

  if (grab)
  {
    nxagentDisconnectCursor(grab -> cursor, 0, &r);
  }

  return r;
}


#ifdef NXAGENT_RECONNECT_CURSOR_DEBUG

void nxagentPrintCursorInfo(CursorPtr pCursor, char msg[])
{
   extern ScreenPtr nxagentDummyScreen;

   fprintf(stderr, "%s: %p - ID %lx - ref count %d\n",
           msg, pCursor, nxagentCursor(pCursor, nxagentDummyScreen), pCursor->refcnt);
}

void nxagentListCursor(void *p0, void *p1, void *p2)
{
  CursorPtr pCursor = (CursorPtr)p0;

  nxagentPrintCursorInfo(pCursor, "CursorDebug:");
}

void nxagentListCursors(void)
{
  int i;
  Bool r;

  for (i = 0, r = 1; i < MAXCLIENTS; r = 1, i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], RT_CURSOR, nxagentListCursor, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentListCursors: WARNING! Failed to list "
                    "cursor for client [%d].\n", i);
      }

      #endif
    }
  }

  return True;
}

#endif /* NXAGENT_RECONNECT_CURSOR_DEBUG */
