/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "signal.h"
#include "unistd.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "servermd.h"
#include "mi.h"

#include NXAGENT_NXPROTO_INCLUDE

#include "Agent.h"
#include "Args.h"
#include "Atoms.h"
#include "Color.h"
#include "Display.h"
#include "Screen.h"
#include "Window.h"
#include "Keyboard.h"
#include "Keystroke.h"
#include "Events.h"
#include "Pointer.h"
#include "Rootless.h"
#include "Splash.h"
#include "Trap.h"
#include "Dialog.h"
#include "Control.h"

#ifdef NXAGENT_FIXKEYS
#include "inputstr.h"
#include "input.h"
#endif

#include "XKBlib.h"

#include <X11/cursorfont.h>

/*
 * Set here the required log level. Please note
 * that if you want to enable DEBUG here, then
 * you need to enable DEBUG even in Rootless.c
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

/*
 * Reduce latency by enabling generation
 * of expose events internally to agent.
 */

#ifdef NXAGENT_EXPOSURES
extern Bool nxagentAutoExposures;
#endif

#ifdef NXAGENT_VISIBILITY
#include NXAGENT_NXLIB_INCLUDE
int prov;
#endif

#ifdef NXAGENT_ONEXIT
extern Bool nxagentWMIsRunning;
extern Bool nxagentOnce;
extern int nxagentClients;
#endif

extern WindowPtr nxagentRootTileWindow;
extern int nxagentSplashCount;

#ifdef NXAGENT_FORCEBACK
extern Bool nxagentForceBackingStore;
#endif

extern int nxagentLastClipboardClient;

extern Window nxagentFullscreenWindow;
extern Window nxagentIconWindow;
extern void MaximizeToFullScreen(ScreenPtr pScreen);
extern void MinimizeFromFullScreen(ScreenPtr pScreen);
extern void nxagentSwitchFullscreen(ScreenPtr pScreen, Bool switch_on);
extern void nxagentMoveViewport(ScreenPtr pScreen, int hShift, int vShift);

extern void nxagentRootlessAddTopLevelWindow(WindowPtr pWin, Window w);
extern WindowPtr nxagentRootlessTopLevelWindow(Window w);

extern void nxagentRootlessRestack(Window *toplevel, unsigned int ntoplevel);

extern int nxagentRRSetScreenConfig(ScreenPtr pScreen, int width, int height);

#ifdef DEBUG
extern Bool nxagentRootlessTreesMatch(void);
#endif

Bool   xkbdRunning = False;
pid_t  pidkbd;
extern Bool nxagentIpaq;

WindowPtr nxagentLastEnteredWindow = NULL;

PropertyRequestRec nxagentPropertyRequests[NXNumberOfConnections];

void nxagentHandleCollectPropertyEvent(XEvent*);

/*
 * Finalize the asynchronous handling
 * of the GrabPointer requests.
 */

void nxagentCollectGrabPointerEvent(int resource);

/*
 * Finalize the asynchronous handling
 * of the InputFocus requests.
 */

void nxagentCollectInputFocusEvent(int resource);

/*
 * Viewport navigation.
 */

static int viewportInc = 1;
static enum HandleEventResult viewportLastKeyPressResult;
static int viewportLastX;
static int viewportLastY;
static Cursor viewportCursor;

static Mask defaultEventMask;

#define MAX_INC 200
#define INC_STEP 5
#define nextinc(x)  ((x) < MAX_INC ? (x) += INC_STEP : (x))

/*
 * Used to mask the appropriate bits in
 * the state reported by XkbStateNotify
 * and XkbGetIndicatorState.
 */

#define CAPSFLAG_IN_REPLY     1
#define CAPSFLAG_IN_EVENT     2
#define NUMFLAG_IN_EVENT      16
#define NUMFLAG_IN_REPLY      2

CARD32 nxagentLastEventTime     = 0;
CARD32 nxagentLastKeyPressTime  = 0;
Time   nxagentLastServerTime    = 0;

/*
 * Used for storing windows that have received expose
 * events from the agent.
 */

WindowPtr nxagentPendingExposedWindows[PENDING_EXPOSED_SIZE];
WindowPtr nxagentSentExposedWindows[PENDING_EXPOSED_SIZE];
int nxagentPendingExposedNum = 0;
int nxagentSentExposedNum = 0;

/*
 * We have to check these before launching the terminate
 * dialog in rootless mode.
 */

Bool nxagentLastWindowDestroied = False;
Time nxagentLastWindowDestroiedTime = 0;

void ProcessInputEvents()
{
  mieqProcessInputEvents();
}

int TimeSinceLastInputEvent()
{
    if (nxagentLastEventTime == 0)
    {
      nxagentLastEventTime = GetTimeInMillis();
    }

    return GetTimeInMillis() - nxagentLastEventTime;
}

void SetTimeSinceLastInputEvent()
{
  nxagentLastEventTime = GetTimeInMillis();
}

void nxagentLogoDebug(char *msg)
{
#ifdef NXAGENT_LOGO_DEBUG
    fprintf(stderr, msg);
#endif
}

extern Bool nxagentFastCopyAreaEnable;
extern Bool nxagentFastGetImageEnable;

void nxagentSwitchSlowMode(void)
{
  nxagentFastGetImageEnable = !nxagentFastGetImageEnable;
  nxagentFastCopyAreaEnable = !nxagentFastCopyAreaEnable;

  if (nxagentFastCopyAreaEnable)
  {
    fprintf(stderr, "Info: Using fast copy area mode in agent.\n");

    nxagentLaunchDialog(DIALOG_FASTMODE);
  }
  else
  {
    fprintf(stderr, "Info: Not using fast copy area mode in agent.\n");

    nxagentLaunchDialog(DIALOG_SLOWMODE);
  }

  if (nxagentFastGetImageEnable)
  {
    fprintf(stderr, "Info: Using fast get image mode in agent.\n");
  }
  else
  {
    fprintf(stderr, "Info: Not using fast get image mode in agent.\n");
  }
}

void nxagentSwitchRandRMode(ScreenPtr pScreen)
{
  XSizeHints sizeHints;

  int desktopResize = nxagentOption(DesktopResize);

  nxagentChangeOption(DesktopResize, !desktopResize);

  sizeHints.flags = PMaxSize;

  if (nxagentOption(DesktopResize) == 0)
  {
    fprintf(stderr,"Info: Disabled desktop resize mode in agent.\n");

    nxagentLaunchDialog(DIALOG_DISABLE_DESKTOP_RESIZE_MODE);

    sizeHints.max_width = nxagentOption(RootWidth);
    sizeHints.max_height = nxagentOption(RootHeight);
  }
  else
  {
    fprintf(stderr,"Info: Enabled desktop resize mode in agent.\n");

    nxagentLaunchDialog(DIALOG_ENABLE_DESKTOP_RESIZE_MODE);

    nxagentRRSetScreenConfig(pScreen, nxagentOption(Width), nxagentOption(Height));

    sizeHints.max_width = WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
    sizeHints.max_height = HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
  }

  XSetWMNormalHints(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], 
                       &sizeHints);
}

static void nxagentSwitchLazyMode(void)
{
  int lazyMode = nxagentOption(Lazy) ? 0 : 1;

  nxagentChangeOption(Lazy, lazyMode);

  if (lazyMode)
  {
    nxagentLaunchDialog(DIALOG_ENABLE_LAZY_MODE);
  }
  else
  {
    nxagentLaunchDialog(DIALOG_DISABLE_LAZY_MODE);
  }
}

static Bool nxagentExposurePredicate(Display *display, XEvent *event, char *window)
{
  /*
   *  Handle both Expose and ProcessedExpose events.
   *  The latters are those not filtered by function
   *  nxagentWindowExposures().
   */

  if (window)
  {
    return ((event -> type == Expose || event -> type == ProcessedExpose) &&
                event -> xexpose.window == *((Window *) window));
  }
  else
  {
    return (event -> type == Expose || event -> type == ProcessedExpose);
  }
}

static Bool nxagentAnyEventPredicate(Display *display, XEvent *event, char *parameter)
{
  return True;
}

void nxagentInitDefaultEventMask()
{
  Mask mask = NoEventMask;

  if (nxagentParentWindow != (Window) 0)
  {
    /*
     * Use of nxagentParentWindow is deprecated.
     * We should better identify which events
     * are selected in the diferent operating
     * modes.
     */

    mask |= StructureNotifyMask;
  }
  else
  {
    #ifdef NXAGENT_VISIBILITY
    mask |= (StructureNotifyMask | VisibilityChangeMask);
    #endif
  }

  mask |= ExposureMask;

  #ifdef NXAGENT_STOPBIGREQ_no
  attributes.event_mask |= VisibilityChangeMask;
  #endif

  mask |= NXAGENT_KEYBOARD_EVENT_MASK;
  mask |= NXAGENT_POINTER_EVENT_MASK;
  mask |= FocusChangeMask;

  if (nxagentOption(Rootless))
  {
    mask |= ExposureMask;
  }

  defaultEventMask = mask;
}

void nxagentGetDefaultEventMask(Mask *mask_return)
{
  *mask_return = defaultEventMask;
}

void nxagentSetDefaultEventMask(Mask mask)
{
  defaultEventMask = mask;
}

void nxagentGetEventMask(WindowPtr pWin, Mask *mask_return)
{
  Mask mask = NoEventMask;

  if (nxagentOption(Rootless))
  {
    /*
     * mask = pWin -> eventMask &
     *           ~(NXAGENT_KEYBOARD_EVENT_MASK | NXAGENT_POINTER_EVENT_MASK);
     */

    if (pWin -> drawable.class == InputOutput)
    {
      if (nxagentWindowTopLevel(pWin))
      {
        mask = defaultEventMask;
      }
      else
      {
        mask = ExposureMask;
      }
    }

    mask |= PropertyChangeMask;
  }
  else if (pWin -> drawable.class != InputOnly)
  {
    mask = ExposureMask;

    #ifdef NXAGENT_STOPBIGREQ_no
    mask |= VisibilityChangeMask;
    #endif
  }

  #ifdef NXAGENT_REPARENT
  if (pWin != nxagentRootWindow)
  {
    mask |= StructureNotifyMask;
  }
  #endif

 *mask_return = mask;
}

/*
 * FIXME: To be reviewed.
 */

void nxagentDispatchEvents(PredicateFuncPtr predicate)
{
  XEvent X;
  xEvent x;
  ScreenPtr pScreen = NULL;

  #ifdef  NXAGENT_MOTION
  int nloop = 0;
  int nSent = 0;
  int postForce = 0;
  int lastMotion = 0;
  #endif

  Bool minimize = False;
  Bool startKbd = False;
  Bool closeSession = False;
  Bool switchFullscreen = False;

  /*
   * FIXME: To be reviewed.
   */

  while (XCheckIfEvent(nxagentDisplay, &X, predicate ? predicate :
                           nxagentAnyEventPredicate, (XPointer) NULL))
  {
    #ifdef DEBUG
    fprintf(stderr, "nxagentDispatchEvents: Going to handle new event type [%d].\n",
                X.type);
    #endif

    #ifdef NXAGENT_MOTION

    if (lastMotion > 0 &&
            (X.type != MotionNotify || nSent == 0 ||
                 postForce > 0))
    {
      mieqEnqueue(&x);

      lastMotion = 0;

      nSent++;

      if (X.type != MotionNotify)
      {
        postForce = 1;
      }
      else
      {
        postForce = 0;
      }
    }

    #endif

    /*
     * Handle the incoming event.
     */

    switch (X.type)
    {
      #ifdef NXAGENT_CLIPBOARD

      case SelectionClear:
      {
        extern void nxagentClearSelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionClear event.\n");
        #endif

        nxagentClearSelection(&X);

        break;
      }
      case SelectionRequest:
      {
        extern void nxagentRequestSelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionRequest event.\n");
        #endif

        nxagentRequestSelection(&X);

        break;
      }
      case SelectionNotify:
      {
        extern void nxagentNotifySelection(XEvent *);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new SelectionNotify event.\n");
        #endif

        nxagentNotifySelection(&X);

        break;
      }

      #endif /* NXAGENT_CLIPBOARD */

      case PropertyNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: PropertyNotify on "
                    "prop %d[%s] window %lx state %d\n",
                        (int)X.xproperty.atom, validateString(XGetAtomName(nxagentDisplay, X.xproperty.atom)),
                            X.xproperty.window, X.xproperty.state);
        #endif

        nxagentHandlePropertyNotify(&X);

        break;
      }

      case KeyPress:
      {
        enum HandleEventResult result;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeyPress event.\n");
        #endif

        nxagentHandleKeyPress(&X, &result);

        if (viewportLastKeyPressResult != result)
        {
          viewportInc = 1;
          viewportLastKeyPressResult = result;
        }

        if (result != doNothing && result != doStartKbd)
        {
          pScreen = nxagentScreen(X.xkey.window);
        }

        switch (result)
        {
          case doNothing:
          {
            break;
          }
          case doCloseSession:
          {
            closeSession = TRUE;
            break;
          }
          case doMinimize:
          {
            minimize = TRUE;
            break;
          }
          case doStartKbd:
          {
            startKbd = TRUE;
            break;
          }
          case doSwitchFullscreen:
          {
            switchFullscreen = TRUE;
            break;
          }
          case doViewportUp:
          {
            nxagentMoveViewport(pScreen, 0, -nextinc(viewportInc));
            break;
          }
          case doViewportDown:
          {
            nxagentMoveViewport(pScreen, 0, +nextinc(viewportInc));
            break;
          }
          case doViewportLeft:
          {
            nxagentMoveViewport(pScreen, -nextinc(viewportInc), 0);
            break;
          }
          case doViewportRight:
          {
            nxagentMoveViewport(pScreen, +nextinc(viewportInc), 0);
            break;
          }
          case doSwitchSlowMode:
          {
            if (nxagentNoDialogIsRunning)
            {
              nxagentSwitchSlowMode();
            }
            break;
          }
          case doRandR:
          {
            if (nxagentNoDialogIsRunning)
            {
              nxagentSwitchRandRMode(pScreen);
            }
            break;
          }
          case doSwitchLazyEncoding:
          {
            if (nxagentNoDialogIsRunning)
            {
              nxagentSwitchLazyMode();
            }
            break;
          }
          default:
          {
            FatalError("nxagentDispatchEvent: handleKeyPress returned unknown value\n");
            break;
          }
        }

        break;
      }

      case KeyRelease:
      {
        enum HandleEventResult result;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeyRelease event.\n");
        #endif

        if (nxagentXkbState.Initialized == 0)
        {
          nxagentInitKeyboardState();
        }

        if (X.xkey.keycode == 68 && nxagentWMIsRunning && nxagentOption(Fullscreen)  &&
                   ((X.xkey.state & (ControlMask | Mod1Mask | ShiftMask)) ==
                       (Mod1Mask)))
        {
          break;
        }
        if (X.xkey.keycode == 70 &&
                                 ((X.xkey.state & (ControlMask | Mod1Mask | ShiftMask)) ==
                       (Mod1Mask)))
        {
          break;
        }

        x.u.u.type = KeyRelease;
        x.u.u.detail = X.xkey.keycode;
        x.u.keyButtonPointer.time = nxagentLastKeyPressTime + (X.xkey.time - nxagentLastServerTime);

        nxagentLastServerTime = X.xkey.time;

        nxagentLastEventTime = GetTimeInMillis();

        if (!(nxagentCheckSpecialKeystroke(&X.xkey, &result)))
        {
          mieqEnqueue(&x);
        }

        break;
      }
      case ButtonPress:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ButtonPress event.\n");
        #endif

        if (nxagentOption(Fullscreen))
        {
          extern Bool magicPixelZone(int, int);

          if (magicPixelZone(X.xbutton.x, X.xbutton.y))
          {
            pScreen = nxagentScreen(X.xbutton.window);

            minimize = True;

            break;
          }
        }

        if (nxagentIpaq && nxagentClients <= 0)
        {
          closeSession = TRUE;
        }

        if (nxagentOption(DesktopResize) == False &&
                (X.xbutton.state & (ControlMask | Mod1Mask)) == (ControlMask | Mod1Mask))
        {
          /*
           * Start viewport navigation mode.
           */

          /*
           * FIXME: To be reviewed.
           */

          int resource = nxagentWaitForResource(NXGetCollectGrabPointerResource,
                                                    nxagentCollectGrabPointerPredicate);

          ScreenPtr pScreen = nxagentScreen(X.xbutton.window);
          viewportCursor = XCreateFontCursor(nxagentDisplay, XC_fleur);

          NXCollectGrabPointer(nxagentDisplay, resource,
                                   nxagentDefaultWindows[pScreen -> myNum], True,
                                       NXAGENT_POINTER_EVENT_MASK, GrabModeAsync,
                                           GrabModeAsync, None, viewportCursor,
                                               CurrentTime);
          viewportLastX = X.xbutton.x;
          viewportLastY = X.xbutton.y;

          break;
        }

        if (!(nxagentOption(Fullscreen) &&
                X.xbutton.window == nxagentFullscreenWindow &&
                    X.xbutton.subwindow == None))
        {
          x.u.u.type = ButtonPress;
          x.u.u.detail = X.xbutton.button;
          x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

          if (nxagentOption(Rootless))
          {
            x.u.keyButtonPointer.rootX = X.xmotion.x_root;
            x.u.keyButtonPointer.rootY = X.xmotion.y_root;
          }
          else
          {
            x.u.keyButtonPointer.rootX = X.xmotion.x - nxagentOption(RootX);
            x.u.keyButtonPointer.rootY = X.xmotion.y - nxagentOption(RootY);
          }

          mieqEnqueue(&x);
        }

        break;
      }
      case ButtonRelease:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ButtonRelease event.\n");
        #endif

        if (viewportCursor)
        {
          /*
           * Leave viewport navigation mode.
           */

          XUngrabPointer(nxagentDisplay, CurrentTime);
          XFreeCursor(nxagentDisplay, viewportCursor);
          viewportCursor = None;

          /*
           * FIXME: Should we put a break here?
           *
           * break;
           */
        }

        if (minimize != True)
        {
          x.u.u.type = ButtonRelease;
          x.u.u.detail = X.xbutton.button;
          x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

          if (nxagentOption(Rootless))
          {
            x.u.keyButtonPointer.rootX = X.xmotion.x_root;
            x.u.keyButtonPointer.rootY = X.xmotion.y_root;
          }
          else
          {
            x.u.keyButtonPointer.rootX = X.xmotion.x - nxagentOption(RootX);
            x.u.keyButtonPointer.rootY = X.xmotion.y - nxagentOption(RootY);
          }

          mieqEnqueue(&x);
        }

        break;
      }
      case MotionNotify:
      {
        ScreenPtr pScreen = nxagentScreen(X.xmotion.window);

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new MotionNotify event.\n");
        #endif

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Handling motion notify window [%ld] root [%ld] child [%ld].\n",
                    X.xmotion.window, X.xmotion.root, X.xmotion.subwindow);

        fprintf(stderr, "nxagentDispatchEvents: Pointer at [%d][%d] relative root [%d][%d].\n",
                    X.xmotion.x, X.xmotion.y, X.xmotion.x_root, X.xmotion.y_root);
        #endif

        x.u.u.type = MotionNotify;

        if (nxagentOption(Rootless))
        {
          if (nxagentPulldownDialogPid == 0 && (X.xmotion.y < 4))
          {
            WindowPtr pWin = nxagentWindowPtr(X.xmotion.window);

            if (pWin &&
                    nxagentClientIsNXClientDialog(wClient(pWin)) == 0 &&
                        pWin -> parent == WindowTable[0] &&
                            pWin -> overrideRedirect == False &&
                                X.xmotion.x > ((pWin -> drawable.width >> 1) - 50) &&
                                    X.xmotion.x < ((pWin -> drawable.width >> 1) + 50))
            {
              nxagentPulldownDialog(pWin -> drawable.id);
            }
          }

          x.u.keyButtonPointer.rootX = X.xmotion.x_root;
          x.u.keyButtonPointer.rootY = X.xmotion.y_root;
        }
        else
        {
          x.u.keyButtonPointer.rootX = X.xmotion.x - nxagentOption(RootX);
          x.u.keyButtonPointer.rootY = X.xmotion.y - nxagentOption(RootY);
        }

        x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

        #ifdef NXAGENT_MOTION

        lastMotion = 1;

        nloop++;

        #else

        if (viewportCursor == None &&
                !(nxagentOption(Fullscreen) &&
                    X.xmotion.window == nxagentDefaultWindows[pScreen -> myNum]
                        && X.xmotion.subwindow == None))
        {
          mieqEnqueue(&x);
        }

        #endif

        /*
         * This test is more complicated and probably not necessary, compared
         * to a simple check on viewportCursor.
         *
         * if (!nxagentOption(Fullscreen) &&
         *       (X.xmotion.state & (ControlMask | Mod1Mask | Button1Mask)) ==
         *            (ControlMask | Mod1Mask | Button1Mask))
        */

        if (viewportCursor)
        {
          /*
           * Pointer is in viewport navigation mode.
           */

          nxagentMoveViewport(pScreen, viewportLastX - X.xmotion.x, viewportLastY - X.xmotion.y);

          viewportLastX = X.xmotion.x;
          viewportLastY = X.xmotion.y;
        }

        break;
      }
      case FocusIn:
      {
        WindowPtr pWin;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new FocusIn event.\n");
        #endif

        /*
         * Here we change the focus state in the agent. It seems necessary
         * only for rootless mode at the present moment.
         */

        if (nxagentOption(Rootless) &&
                (pWin = nxagentWindowPtr(X.xfocus.window)))
        {
          SetInputFocus(serverClient, inputInfo.keyboard, pWin -> drawable.id,
                            RevertToPointerRoot, GetTimeInMillis(), False);
        }

        #ifndef NXAGENT_REPARENT
        if (X.xfocus.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xfocus.window);

          if (pScreen)
            nxagentDirectInstallColormaps(pScreen);
        }
        #endif

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)
        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans)
          {
            nxagentFocusKarma = False;
          }
        }
        #endif
/*
FIXME
*/
/*
        {
          extern void nxagentResetSelectionOwner();

          fprintf (stderr, "nxagentDispatchEvents: Resetting clipboard state on focus in.\n");

          nxagentResetSelectionOwner();
        }
*/
        break;
      }
      case FocusOut:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new FocusOut event.\n");
        #endif

        #ifndef NXAGENT_REPARENT

        if (X.xfocus.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xfocus.window);

          if (pScreen)
            nxagentDirectUninstallColormaps(pScreen);
        }

        #endif

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans)
          {
            nxagentFocusKarmaTimeOut = GetTimeInMillis();

            nxagentFocusKarma = True;
          }
        }

        #endif /* defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA) */

        #ifdef NXAGENT_FIXKEYS

        {
          /*
           * Force the keys all up when focus is lost.
           */

          int i, k;
          int mask = 1;
          CARD8 val;

          for (i = 0; i < DOWN_LENGTH; i++) /* input.h */
          {
            val = inputInfo.keyboard->key->down[i];

            if (val != 0)
            {
              for (k = 0; k < 8; k++)
              {
                if (val & (mask << k))
                {
                  #ifdef NXAGENT_FIXKEYS_DEBUG
                  fprintf(stderr, "sending KeyRelease event for keycode: %d\n",
                              i * 8 + k);
                  #endif

                  if (!nxagentOption(Rootless) ||
                          inputInfo.keyboard->key->modifierMap[i * 8 + k])
                  {
                    x.u.u.type = KeyRelease;
                    x.u.u.detail = i * 8 + k;
                    x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

                    mieqEnqueue(&x);
                  }
                }
              }
            }
          }
        }

        #endif /* NXAGENT_FIXKEYS */

        break;
      }
      case KeymapNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new KeymapNotify event.\n");
        #endif

        break;
      }
      case EnterNotify:
      {
        WindowPtr pWin;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new EnterNotify event.\n");
        #endif

        if (nxagentOption(Rootless) && nxagentWMIsRunning &&
                (pWin = nxagentWindowPtr(X.xcrossing.window)) &&
                    nxagentWindowTopLevel(pWin) && !pWin -> overrideRedirect &&
                        (pWin -> drawable.x != X.xcrossing.x_root - X.xcrossing.x - pWin -> borderWidth ||
                            pWin -> drawable.y != X.xcrossing.y_root - X.xcrossing.y - pWin -> borderWidth))
        {
          /*
           * This code is useful for finding the window
           * position. It should be re-implemented by
           * following the ICCCM 4.1.5 recommendations.
           */

          XID values[4];
          register XID *value = values;
          Mask mask = 0;
          ClientPtr pClient = wClient(pWin);

          #ifdef TEST
          fprintf(stderr, "nxagentDispatchEvents: pWin -> drawable.x [%d] pWin -> drawable.y [%d].\n",
                      pWin -> drawable.x, pWin -> drawable.y);
          #endif

          *value++ = (XID) (X.xcrossing.x_root - X.xcrossing.x - pWin -> borderWidth);
          *value++ = (XID) (X.xcrossing.y_root - X.xcrossing.y - pWin -> borderWidth);

          /*
           * nxagentWindowPriv(pWin)->x = (X.xcrossing.x_root - X.xcrossing.x);
           * nxagentWindowPriv(pWin)->y = (X.xcrossing.y_root - X.xcrossing.y);
           */

          mask = CWX | CWY;

          nxagentScreenTrap = 1;
          ConfigureWindow(pWin, mask, (XID *) values, pClient);
          nxagentScreenTrap = 0;

          nxagentSetSynchronizationPending(nxagentDisplay);
        }

        if (nxagentOption(Fullscreen))
        {
          if (X.xcrossing.window == nxagentFullscreenWindow &&
                  X.xcrossing.detail != NotifyInferior)
          {
            nxagentGrabPointerAndKeyboard(&X);
          }
        }

        #ifdef NXAGENT_REPARENT

        /* quick hack */
        pScreen = screenInfo.screens[0];

        #else

        if (X.xcrossing.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xcrossing.window);

          if (pScreen)
          {
            NewCurrentScreen(pScreen, X.xcrossing.x, X.xcrossing.y);

            x.u.u.type = MotionNotify;

            if (nxagentOption(Rootless))
            {
              nxagentLastEnteredWindow = nxagentWindowPtr(X.xcrossing.window);
              x.u.keyButtonPointer.rootX = X.xcrossing.x_root;
              x.u.keyButtonPointer.rootY = X.xcrossing.y_root;
            }
            else
            {
              x.u.keyButtonPointer.rootX = X.xcrossing.x - nxagentOption(RootX);
              x.u.keyButtonPointer.rootY = X.xcrossing.y - nxagentOption(RootY);
            }

            x.u.keyButtonPointer.time = nxagentLastEventTime = GetTimeInMillis();

            mieqEnqueue(&x);

            nxagentDirectInstallColormaps(pScreen);
          }
        }

        #endif

        break;
      }
      case LeaveNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new LeaveNotify event.\n");
        #endif

        if (nxagentOption(Rootless) && X.xcrossing.mode == NotifyNormal &&
                X.xcrossing.detail != NotifyInferior)
        {
          nxagentLastEnteredWindow = NULL;
        }

        #ifdef NXAGENT_FORCEBACK

        {
          if (nxagentForceBackingStore)
          {
            extern nxbsQueuePtr pbsQueue;
            extern void realizebsQueue(nxbsQueuePtr);

            if(pbsQueue)
            {
              realizebsQueue(pbsQueue);
            }
          }
        }

        #endif

        if (nxagentOption(Fullscreen))
        {
          if (X.xcrossing.window == nxagentFullscreenWindow &&
                  X.xcrossing.detail != NotifyInferior &&
                      X.xcrossing.mode == NotifyNormal)
          {
            nxagentUngrabPointerAndKeyboard(&X);

            pScreen = nxagentScreen(X.xcrossing.window);

            minimize = True;
          }
        }

        #ifndef NXAGENT_REPARENT

        if (X.xcrossing.detail != NotifyInferior)
        {
          pScreen = nxagentScreen(X.xcrossing.window);

          if (pScreen)
          {
            nxagentDirectUninstallColormaps(pScreen);
          }
        }

        #endif

        break;
      }
      case DestroyNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new DestroyNotify event.\n");
        #endif

        if (nxagentParentWindow != (Window) 0 &&
                X.xdestroywindow.window == nxagentParentWindow)
        {
          fprintf(stderr, "Warning: Unhandled destroy notify event received in agent.\n");
        }

        break;
      }
      case ClientMessage:
      {
        enum HandleEventResult result;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ClientMessage event.\n");
        #endif

        nxagentHandleClientMessageEvent(&X, &result);

        if (result == doCloseSession)
        {
          closeSession = TRUE;
        }

        break;
      }

      #ifdef NXAGENT_VISIBILITY

      case VisibilityNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new VisibilityNotify event.\n");
        #endif

        if (X.xvisibility.window != nxagentDefaultWindows[0])
        {
          #ifdef TEST
          fprintf(stderr, "nxagentDispatchEvents: Suppressing visibility notify on window %lx\n",
                    X.xvisibility.window);
          #endif

          break;
        }

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: visibility notify state is %d - previous was %d\n",
                        X.xvisibility.state, nxagentVisibility);
        #endif

        nxagentVisibility = X.xvisibility.state;

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

        if (X.xvisibility.state == VisibilityUnobscured)
        {
          nxagentFocusKarma = False;
        }
        else
        {
          extern Bool nxagentUseNXTrans;

          if (nxagentUseNXTrans &&
                  !nxagentOption(Rootless) &&
                      !nxagentOption(Nested) &&
                          (X.xvisibility.state == VisibilityFullyObscured))
          {
            nxagentFocusKarmaTimeOut = GetTimeInMillis();

            nxagentFocusKarma = True;
          }

          nxagentSetSynchronizationPending(nxagentDisplay);
        }

        #endif

        break;
      }

      #endif /* NXAGENT_VISIBILITY */

      #ifdef NXAGENT_MANAGECLIENTS

      case VisibilityNotify:
      {
        ClientPtr client;
        int ret;
        WindowPtr pWin;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new VisibilityNotify event.\n");
        #endif

        if (X.xvisibility.window == nxagentParentWindow)
        {
          break;
        }

        pWin = nxagentWindowPtr(X.xvisibility.window);

        fprintf(stderr, "VisibilityNotify event, state: %d\n", X.xvisibility.state);

        client = wClient(pWin);
        fprintf(stderr, "client ID: %x\n", client);

        if (X.xvisibility.state == VisibilityUnobscured)
          {
            ClientWakeup(client);
          }
        else if (X.xvisibility.state == VisibilityPartiallyObscured)
          {
            ClientSleep(client, (void (*)()) 0, NULL);
          }
        else
          {
            ErrorF("nxagent warning: unhandled VisibilityNotify state\n");
          }

        break;
      }

      #endif /* NXAGENT_MANAGECLIENTS */

      case Expose:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new Expose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received Expose event "
                    "for drawable [%lx] geometry [%d, %d, %d, %d] count [%d].\n",
                        X.xexpose.window, X.xexpose.x, X.xexpose.y, X.xexpose.width,
                            X.xexpose.height, X.xexpose.count);
        #endif

        nxagentHandleExposeEvent(&X);
      }

      #ifdef NXAGENT_NOEXPOSEOPTIMIZE

      case GraphicsExpose:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new GraphicsExpose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received GraphicsExpose event "
                    "for drawable [%lx] geometry [%d, %d, %d, %d] count [%d].\n",
                        X.xgraphicsexpose.drawable, X.xgraphicsexpose.x, X.xgraphicsexpose.y,
                            X.xgraphicsexpose.width, X.xgraphicsexpose.height,
                                X.xgraphicsexpose.count);
        #endif

        /*
         * We are passing graphics exposures to clients only if the
         * agent window is not fully visible as if the agent window
         * is fully visible we can reliably calculate the graphics
         * exposures by ourselves. If we are using NX transport this
         * test is of very little use because we are already block-
         * ing the graphics exposures whenever we are fully visible.
         */

        if (nxagentVisibility != VisibilityUnobscured)
        {
          nxagentHandleGraphicsExposeEvent(&X);
        }
        else
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentDispatchEvents: Graphics exposure was ignored.\n");
          #endif
        }

        break;
      }
      case NoExpose:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new NoExpose event.\n");
        #endif

        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Received NoExpose event for "
                    "drawable [%lx].\n", X.xnoexpose.drawable);
        #endif

        break;
      }

      #endif /* NXAGENT_NOEXPOSEOPTIMIZE */

      #if defined(NXAGENT_VISIBILITY)

      case CirculateNotify:
      {
        /*
         * WindowPtr pWin;
         * WindowPtr pSib;
         * ClientPtr pClient;

         * XID values[2];
         * register XID *value = values;
         * Mask mask = 0;
         */

        #ifdef WARNING
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new CirculateNotify event.\n");
        #endif

        /*
         * FIXME: This code should be tested before enabling it:
         *
         * pWin = nxagentWindowPtr(X.xcirculate.window);
         *
         * if (!pWin)
         * {
         *   pWin = nxagentRootlessTopLevelWindow(X.xcirculate.window);
         * }
         *
         * if (!pWin)
         * {
         *   break;
         * }
         *
         * XQueryTree(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
         *                &root_return, &parent_return, &children_return, &nchildren_return);
         *
         * nxagentRootlessRestack(children_return, nchildren_return);
         */

        break;
      }
      case ConfigureNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ConfigureNotify event.\n");
        #endif

        nxagentHandleConfigureNotify(&X);

        break;
      }
      case GravityNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new GravityNotify event.\n");
        #endif

        break;
      }
      case ReparentNotify:
      {
        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new ReparentNotify event.\n");
        #endif

        nxagentHandleReparentNotify(&X);

        break;
      }
      case UnmapNotify:
      {
        extern Bool nxagentUseNXTrans;

        WindowPtr pWin;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new UnmapNotify event.\n");
        #endif

        if (nxagentOption(Rootless) &&
                (pWin = nxagentRootlessTopLevelWindow(X.xunmap.window)) != NULL)
        {
          nxagentScreenTrap = 1;
          UnmapWindow(pWin, False);
          nxagentScreenTrap = 0;

          nxagentSetSynchronizationPending(nxagentDisplay);
        }

        if (nxagentUseNXTrans &&
                !nxagentOption(Rootless) &&
                    !nxagentOption(Nested) &&
                        X.xmap.window != nxagentIconWindow)
        {
          nxagentVisibility = VisibilityFullyObscured;

          #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

          nxagentFocusKarmaTimeOut = GetTimeInMillis();
          nxagentFocusKarma = True;

          #endif
        }

        if (X.xunmap.window == nxagentDefaultWindows[0])
        {
          nxagentResetExpose();
        }

        break;
      }
      case MapNotify:
      {
        WindowPtr pWin;
        ClientPtr pClient;

        #ifdef TEST
        fprintf(stderr, "nxagentDispatchEvents: Going to handle new MapNotify event.\n");
        #endif

        if (nxagentOption(Rootless) &&
                (pWin = nxagentRootlessTopLevelWindow(X.xmap.window)) != NULL)
        {
          pClient = wClient(pWin);
          nxagentScreenTrap = 1;
          MapWindow(pWin, pClient);
          nxagentScreenTrap = 0;

          nxagentSetSynchronizationPending(nxagentDisplay);
        }

        if (nxagentOption(Fullscreen))
        {
          if (X.xmap.window == nxagentIconWindow)
          {
            pScreen = nxagentScreen(X.xmap.window);
            MaximizeToFullScreen(pScreen);
          }

          nxagentVisibility = VisibilityUnobscured;
          nxagentVisibilityStop = False;
          nxagentVisibilityTimeout = GetTimeInMillis() + 2000;
        }

        #if defined(NXAGENT_KARMA) && defined(NXAGENT_FOCUS_KARMA)

        nxagentFocusKarma = False;

        #endif

        break;
      }

      #endif /* defined(NXAGENT_VISIBILITY) */

      case MappingNotify:
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentDispatchEvents: WARNING! Going to handle new MappingNotify event.\n");
        #endif

        break;
      }
      default:
      {
        /*
         * Let's check if this is a XKB
         * state modification event.
         */

        if (nxagentHandleKeyboardEvent(&X) == 0)
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentDispatchEvents: WARNING! Unhandled event code [%d].\n",
                      X.type);
          #endif
        }

        break;
      }

    } /* End of switch (X.type) */

  } /* End of while (XCheckIfEvent(...) */

  if (closeSession)
  {
    if (nxagentOption(Persistent))
    {
      if (nxagentNoDialogIsRunning)
      {
        nxagentLaunchDialog(DIALOG_SUSPEND_SESSION);
      }
    }
    else
    {
      if (nxagentNoDialogIsRunning)
      {
        nxagentLaunchDialog(DIALOG_KILL_SESSION);
      }
    }
  }

  if (minimize)
  {
    extern void nxagentWMDetect();

    nxagentWMDetect();

    if (nxagentWMIsRunning)
    {
      if (nxagentOption(Fullscreen))
      {
        MinimizeFromFullScreen(pScreen);
      }
      else
      {
        XIconifyWindow(nxagentDisplay, nxagentDefaultWindows[0], DefaultScreen(nxagentDisplay));
      }
    }
  }

  if (switchFullscreen)
  {
    nxagentSwitchFullscreen(pScreen, !nxagentOption(Fullscreen));
  }

  if (startKbd)
  {
    if (xkbdRunning)
    {
      #ifdef NXAGENT_XKBD_DEBUG
      fprintf(stderr, "Events: nxkbd now is NOT running: %d, %d\n",
                  X.xkey.keycode, escapecode);
      #endif

      xkbdRunning = False;

      kill(pidkbd, 9);
    }
    else
    {
      char kbddisplay[6];
      char *kbdargs[6];

      strcpy(kbddisplay,":");
      strncat(kbddisplay, display, 4);

      kbdargs[0] = "nxkbd";
      kbdargs[1] = "-geometry";
      kbdargs[2] = "240x70+0+250";
      kbdargs[3] = "-display";
      kbdargs[4] = kbddisplay;
      kbdargs[5] = NULL;

      switch (pidkbd = fork())
      {
        case 0:
        {
          execvp(kbdargs[0], kbdargs);

          #ifdef NXAGENT_XKBD_DEBUG
          fprintf(stderr, "Events: execvp of nxkbd failed\n");
          #endif

          exit(1);

          break;
        }
        case -1:
        {
          #ifdef NXAGENT_XKBD_DEBUG
          fprintf(stderr, "Events: can't fork to run nxkbd\n");
          #endif

          break;
        }
        default:
        {
          break;
        }
      }

      #ifdef NXAGENT_XKBD_DEBUG
      fprintf(stderr, "Events: nxkbd now is running: %d, %d\n",
                  X.xkey.keycode, escapecode);
      #endif

      xkbdRunning = True;
    }
  }

  #ifdef NXAGENT_MOTION

  if (lastMotion > 0)
  {
    mieqEnqueue(&x);

    nSent++;
  }

  #ifdef NXAGENT_MOTION_DEBUG

  if (nloop)
  {
    fprintf(stderr, "MotionNotify received=%d sent=%d\n", nloop, nSent);
  }

  #endif /* NXAGENT_MOTION_DEBUG */

  #endif /* NXAGENT_MOTION */
}

/*
 * Functions providing the ad-hoc handling
 * of the remote X events.
 */

int nxagentHandleKeyPress(XEvent *X, enum HandleEventResult *result)
{
  xEvent x;

  if (nxagentXkbState.Initialized == 0)
  {
    nxagentInitKeyboardState();
  }

  if (nxagentCheckSpecialKeystroke(&X -> xkey, result))
  {
    return 1;
  }

  nxagentLastEventTime = nxagentLastKeyPressTime = GetTimeInMillis();

  x.u.u.type = KeyPress;
  x.u.u.detail = X -> xkey.keycode;
  x.u.keyButtonPointer.time = nxagentLastKeyPressTime;

  nxagentLastServerTime = X -> xkey.time;

  mieqEnqueue(&x);

  return 1;
}

int nxagentHandlePropertyNotify(XEvent *X)
{
  int resource;

  if (nxagentOption(Rootless) && !nxagentNotifyMatchChangeProperty((XPropertyEvent *) X))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentHandlePropertyNotify: Property %ld on window %lx.\n",
                X -> xproperty.atom, X -> xproperty.window);
    #endif

    if (nxagentWindowPtr(X -> xproperty.window) != NULL)
    {
      resource = NXGetCollectPropertyResource(nxagentDisplay);

      if (resource == -1)
      {
        #ifdef WARNING
        fprintf(stderr, "nxagentHandlePropertyNotify: WARNING! Asyncronous get property queue is full.\n");
        #endif

        return 0;
      }

      NXCollectProperty(nxagentDisplay, resource,
                            X -> xproperty.window, X -> xproperty.atom, 0,
                                MAX_RETRIEVED_PROPERTY_SIZE, False, AnyPropertyType);

      nxagentPropertyRequests[resource].window = X -> xproperty.window;
      nxagentPropertyRequests[resource].property = X -> xproperty.atom;
    }
    #ifdef TEST
    else
    {
      fprintf(stderr, "nxagentHandlePropertyNotify: Failed to look up remote window property.\n");
    }
    #endif
  }

  #if 0

  if (X -> xproperty.window == nxagentWindow(WindowTable[0]) &&
      X -> xproperty.atom == nxagentAtoms[10] &&
      X -> xproperty.atom != None &&
      X -> xproperty.state == PropertyNewValue)
  {
    unsigned char *buffer;
    Atom xa_string = XInternAtom(nxagentDisplay, "STRING", FALSE);
    Atom type = xa_string;
    int  format;
    int  result;
    unsigned long nitems, bytes_after;

    result = XGetWindowProperty(nxagentDisplay,
                                X -> xproperty.window,
                                X -> xproperty.atom,
                                0, 255, TRUE, type, &type, &format,
                                &nitems, &bytes_after, &buffer);

    /* We are waiting for "terminate" or "suspend". */
    if (type == xa_string && format == 8 && bytes_after == 0)
    {
      fprintf(stderr, "Got property %s\n", validateString(buffer));
    }
  }
  #endif

  return 1;
}

int nxagentHandleExposeEvent(XEvent *X)
{
  WindowPtr pWin = NULL;
  Window window = None;

  RegionRec sum;
  RegionRec add;
  BoxRec box;
  RegionPtr receivedRegion;

  #ifdef DEBUG
  fprintf(stderr, "nxagentHandleExposeEvent: Checking remote expose events.\n");
  #endif

    #ifdef DEBUG
    fprintf(stderr, "nxagentHandleExposeEvent: Looking for window id [%ld].\n",
                X -> xexpose.window);
    #endif

    window = X -> xexpose.window;

    pWin = nxagentWindowPtr(window);

    if (pWin)
    {
      receivedRegion = nxagentWindowPriv(pWin)->received_expose_region;

      REGION_INIT(pWin -> drawable.pScreen, &sum, (BoxRec *) NULL, 1);

      /*
       * It's worth noting that XCheckIfEvent() won't try
       * to read more events if the first event read from
       * the network doesn't match the predicate, so, we
       * should never assume that more events are not in
       * the display buffer until no more data is readable
       * from the socket.
       */

      do
      {
        #ifdef DEBUG
        fprintf(stderr, "nxagentHandleExposeEvent: Adding event for window id [%ld].\n",
                    X -> xexpose.window);
        #endif

        box.x1 = pWin -> drawable.x + wBorderWidth(pWin) + X -> xexpose.x;
        box.y1 = pWin -> drawable.y + wBorderWidth(pWin) + X -> xexpose.y;

        box.x2 = box.x1 + X -> xexpose.width;
        box.y2 = box.y1 + X -> xexpose.height;

        REGION_INIT(pWin -> drawable.pScreen, &add, &box, 1);

        REGION_UNION(pWin -> drawable.pScreen, &sum, &sum, &add);

        REGION_UNINIT(pWin -> drawable.pScreen, &add);

        if (X -> xexpose.count == 0)
        {
          break;
        }
      }
      while (XCheckIfEvent(nxagentDisplay, X, nxagentExposurePredicate, (char *) &window));

      REGION_INTERSECT(pWin->drawable.pScreen, &sum, &sum,
                           &WindowTable[pWin->drawable.pScreen->myNum]->winSize);

      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleExposeEvent: Sending events for window id [%ld].\n",
                  X -> xexpose.window);
      #endif

      /*
       * If the agent has already sent auto-generated expose,
       * save received exposes for later processing.
       */

      if (nxagentSentExposuresIndex(pWin) >= 0)
      {
        REGION_TRANSLATE(pWin -> drawable.pScreen, &sum, -pWin -> drawable.x, -pWin -> drawable.y);

        REGION_UNION(pWin->drawable.pScreen, receivedRegion, receivedRegion, &sum);
      }
      else
      {
        miWindowExposures(pWin, &sum, NullRegion);
      }

      if (nxagentRootTileWindow)
      {
        if (nxagentWindowPriv(nxagentRootTileWindow) -> window == nxagentWindowPriv(pWin) -> window &&
                nxagentSplashCount == 1 && X -> xexpose.count == 0)
        {
          #ifdef DEBUG
          fprintf(stderr, "nxagentHandleExposeEvent: Clearing root tile window id [%ld].\n",
                      nxagentWindowPriv(nxagentRootTileWindow) -> window);
          #endif

          XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow) -> window);
        }
      }

      REGION_UNINIT(pWin -> drawable.pScreen, &sum);
    }

  return 1;
}

int nxagentHandleGraphicsExposeEvent(XEvent *X)
{
  xEvent x;

  WindowPtr pWin = nxagentGetWindowFromID(X -> xgraphicsexpose.drawable);

  if (pWin)
  {
    /*
     * Can handle both GraphicsExpose and NoExpose
     * in the same function, anyway there is no
     * need to call it if event is NoExpose.
     */

    x.u.u.type = X -> type;

    x.u.graphicsExposure.drawable = pWin -> drawable.id;
    x.u.graphicsExposure.x = X -> xgraphicsexpose.x;
    x.u.graphicsExposure.y = X -> xgraphicsexpose.y;
    x.u.graphicsExposure.width = X -> xgraphicsexpose.width;
    x.u.graphicsExposure.height = X -> xgraphicsexpose.height;
    x.u.graphicsExposure.majorEvent = X -> xgraphicsexpose.major_code;
    x.u.graphicsExposure.minorEvent = X -> xgraphicsexpose.minor_code;
    x.u.graphicsExposure.count = X -> xgraphicsexpose.count;

    TryClientEvents(wClient(pWin), &x, 1, 1, 1, 0);
  }

  return 1;
}

int nxagentHandleClientMessageEvent(XEvent *X, enum HandleEventResult *result)
{
  ScreenPtr pScreen;
  WindowPtr pWin;
  xEvent x;

  *result = doNothing;

  #ifdef TEST
  fprintf(stderr, "nxagentHandleClientMessageEvent: ClientMessage event window [%ld] with "
              "type [%ld] format [%d].\n", X -> xclient.window, X -> xclient.message_type,
                  X -> xclient.format);
  #endif

  /*
   * If window is 0, message_type is 0 and format is
   * 32 then we assume event is coming from proxy.
   */

  if (X -> xclient.window == 0 &&
          X -> xclient.message_type == 0 &&
              X -> xclient.format == 32)
  {
    if (nxagentHandleProxyEvent(X) > 0)
    {
      return 1;
    }
  }

  if (nxagentOption(Rootless))
  {
    Atom message_type = nxagentRemoteToLocalAtom(X -> xclient.message_type);

    if (!ValidAtom(message_type))
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentHandleClientMessageEvent: WARNING Invalid type in client message.\n");
      #endif

      return 0;
    }

    pWin = nxagentWindowPtr(X -> xclient.window);

    if (pWin == NULL)
    {
      #ifdef WARNING
      fprintf(stderr, "WARNING: Invalid window in ClientMessage.\n");
      #endif

      return 0;
    }

    if (message_type == MakeAtom("WM_PROTOCOLS", strlen("WM_PROTOCOLS"), False))
    {
      x.u.u.type = ClientMessage;
      x.u.u.detail = X -> xclient.format;

      x.u.clientMessage.window = pWin -> drawable.id;
      x.u.clientMessage.u.l.type = message_type;
      x.u.clientMessage.u.l.longs0 = nxagentRemoteToLocalAtom(X -> xclient.data.l[0]);

      if (!ValidAtom(x.u.clientMessage.u.l.longs0))
      {
        #ifdef WARNING
        fprintf(stderr, "nxagentHandleClientMessageEvent: WARNING Invalid value in client message of type WM_PROTOCOLS.\n");
        #endif

        return 0;
      }

      #ifdef TEST
      fprintf(stderr, "nxagentHandleClientMessageEvent: INFO Sent client message of type WM_PROTOCOLS and value %s.\n",
                  validateString(NameForAtom(x.u.clientMessage.u.l.longs0)));
      #endif

      TryClientEvents(wClient(pWin), &x, 1, 1, 1, 0);
    }
    else
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentHandleClientMessageEvent: Ignored message type %ld [%s].\n",
                  message_type, validateString(NameForAtom(message_type)));
      #endif

      return 0;
    }

    return 1;
  }

  if (X -> xclient.message_type == nxagentAtoms[1]) /* WM_PROTOCOLS */
  {
    Atom deleteWMatom, wmAtom;

    wmAtom = (Atom) X -> xclient.data.l[0];

    deleteWMatom = nxagentAtoms[2]; /* WM_DELETE_WINDOW */

    if (wmAtom == deleteWMatom)
    {
      if (nxagentOnce && (nxagentClients == 0))
      {
        GiveUp(0);
      }
      else
      {
        #ifdef TEST
        fprintf(stderr, "Events: WM_DELETE_WINDOW arrived Atom = %ld.\n", wmAtom);
        #endif

        if (X -> xclient.window == nxagentIconWindow)
        {
          pScreen = nxagentScreen(X -> xmap.window);

          MaximizeToFullScreen(pScreen);
        }

        if (X -> xclient.window == (nxagentOption(Fullscreen) ?
              nxagentIconWindow : nxagentDefaultWindows[0]))
        {
          *result = doCloseSession;
        }
      }
    }
  }

  return 1;
}

int nxagentHandleKeyboardEvent(XEvent *X)
{
  XkbEvent *xkbev = (XkbEvent *) X;

  #ifdef TEST
  fprintf(stderr, "nxagentHandleKeyboardEvent: Handling event with caps [%d] num [%d] locked [%d].\n",
              nxagentXkbState.Caps, nxagentXkbState.Num, nxagentXkbState.Locked);
  #endif

  if (xkbev -> type == nxagentXkbInfo.EventBase + XkbEventCode &&
          xkbev -> any.xkb_type == XkbStateNotify)
  {
    nxagentXkbState.Locked = xkbev -> state.locked_mods;

    #ifdef TEST
    fprintf(stderr, "nxagentHandleKeyboardEvent: Updated XKB locked modifier bits to [%x].\n",
                nxagentXkbState.Locked);
    #endif

    nxagentXkbState.Initialized = 1;

    if (nxagentXkbState.Caps == 0 &&
            (nxagentXkbState.Locked & CAPSFLAG_IN_EVENT))
    {
      nxagentXkbState.Caps = 1;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [66] to engage capslock.\n");
      #endif

      nxagentSendFakeKey(66);
    }

    if (nxagentXkbState.Caps == 1 &&
          !(nxagentXkbState.Locked & CAPSFLAG_IN_EVENT))
    {
      nxagentXkbState.Caps = 0;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [66] to release capslock.\n");
      #endif

      nxagentSendFakeKey(66);
    }

    if (nxagentXkbState.Num == 0 &&
            (nxagentXkbState.Locked & NUMFLAG_IN_EVENT))
    {
      nxagentXkbState.Num = 1;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [77] to engage numlock.\n");
      #endif

      nxagentSendFakeKey(77);
    }

    if (nxagentXkbState.Num == 1 &&
            !(nxagentXkbState.Locked & NUMFLAG_IN_EVENT))
    {
      nxagentXkbState.Num = 0;

      #ifdef TEST
      fprintf(stderr, "nxagentHandleKeyboardEvent: Sending fake key [77] to release numlock.\n");
      #endif

      nxagentSendFakeKey(77);
    }

    return 1;
  }

  return 0;
}

/*
 * FIXME: To be reviewed.
 */

Bool nxagentCollectGrabPointerPredicate(Display *display, XEvent *X, XPointer ptr)
{
  return (X -> xclient.window == 0 &&
             X -> xclient.message_type == 0 &&
                 X -> xclient.format == 32 &&
                     X -> xclient.data.l[0] == NXCollectGrabPointerNotify);
}

/*
 * FIXME: To be reviewed.
 */

Bool nxagentGetCollectInputFocusPredicate(Display *display, XEvent *X, XPointer ptr)
{
  return (X -> xclient.window == 0 &&
             X -> xclient.message_type == 0 &&
                 X -> xclient.format == 32 &&
                     X -> xclient.data.l[0] == NXCollectInputFocusNotify);
}

int nxagentHandleProxyEvent(XEvent *X)
{
  switch (X -> xclient.data.l[0])
  {
    case NXNoSplitNotify:
    case NXStartSplitNotify:
    {
      /*
       * We should never receive such events
       * in the event loop, as they should
       * be caught at the time the split is
       * initiated.
       */

      #ifdef PANIC

      int client = (int) X -> xclient.data.l[1];

      if (X -> xclient.data.l[0] == NXNoSplitNotify)
      {
        fprintf(stderr, "nxagentHandleProxyEvent: PANIC! NXNoSplitNotify received "
                    "with client [%d].\n", client);
      }
      else
      {
        fprintf(stderr, "nxagentHandleProxyEvent: PANIC! NXStartSplitNotify received "
                    "with client [%d].\n", client);
      }

      #endif

      return 1;
    }
    case NXCommitSplitNotify:
    {
      /*
       * We need to commit an image. Image can be the
       * result of a PutSubImage() generated by Xlib,
       * so there can be more than a single image to
       * commit, even if only one PutImage was perfor-
       * med by the agent.
       */

      int client   = (int) X -> xclient.data.l[1];
      int request  = (int) X -> xclient.data.l[2];
      int position = (int) X -> xclient.data.l[3];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCommitSplitNotify received with "
                  "client [%d] request [%d] and position [%d].\n",
                      client, request, position);
      #endif

      nxagentHandleCommitSplitEvent(client, request, position);

      return 1;
    }
    case NXEndSplitNotify:
    {
      /*
       * All images for the split were transferred and
       * we need to restart the client.
       */

      int client = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXEndSplitNotify received with "
                  "client [%d].\n", client);
      #endif

      nxagentHandleEndSplitEvent(client);

      return 1;
    }
    case NXEmptySplitNotify:
    {
      /*
       * All splits where completed and no more are
       * remaining.
       */

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXEmptySplitNotify received.\n");
      #endif

      nxagentHandleEmptySplitEvent();

      return 1;
    }
    case NXCongestionNotify:
    {
      int state = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCongestionNotify received with state [%d].\n",
                  state);
      #endif

      nxagentCongestion = state;

      nxagentAdjustKarma();

      return 1;
    }
    case NXResetNotify:
    {
      int state = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXResetNotify received with state [%d].\n",
                  state);
      #endif

      nxagentReset = state;

      return 1;
    }
    case NXCollectPropertyNotify:
    {
      #ifdef TEST
      int resource = (int) X -> xclient.data.l[1];

      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectPropertyNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentHandleCollectPropertyEvent(X);

      return 1;
    }
    case NXCollectImageNotify:
    {
      int resource = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectImageNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentCollectImageEvent(resource);

      return 1;
    }
    case NXCollectGrabPointerNotify:
    {
      int resource = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectGrabPointerNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentCollectGrabPointerEvent(resource);

      return 1;
    }
    case NXCollectInputFocusNotify:
    {
      int resource = (int) X -> xclient.data.l[1];

      #ifdef TEST
      fprintf(stderr, "nxagentHandleProxyEvent: NXCollectInputFocusNotify received with resource [%d].\n",
                  resource);
      #endif

      nxagentSynchronizationPending = False;

      nxagentSynchronizeExpose();

      nxagentCollectInputFocusEvent(resource);

      return 1;
    }
    default:
    {
      /*
       *  Not a recognized ClientMessage event.
       */

      #ifdef WARNING
      fprintf(stderr, "nxagentHandleProxyEvent: WARNING! Not a recognized ClientMessage proxy event [%d].\n",
                  (int) X -> xclient.data.l[0]);
      #endif

      return 0;
    }
  }
}

int nxagentHandleConfigureNotify(XEvent* X)
{
  if (nxagentOption(Rootless) == True)
  {
    ClientPtr pClient;
    WindowPtr pWinWindow;
    WindowPtr pWin;
    

    extern WindowPtr nxagentRootlessNextSibling(WindowPtr pWin);

    pWinWindow = nxagentWindowPtr(X -> xconfigure.window);

    #ifdef TEST
    {
      WindowPtr pWinEvent  = nxagentWindowPtr(X -> xconfigure.event);

      fprintf(stderr, "nxagentHandleConfigureNotify: Generating window is [%p][%ld] target [%p][%ld].\n",
                  (void *) pWinEvent, X -> xconfigure.event, (void *) pWinWindow, X -> xconfigure.window);
    }
    #endif

    #ifdef TEST
    fprintf(stderr, "nxagentHandleConfigureNotify: New configuration for window [%p][%ld] is [%d][%d][%d][%d] "
                "send_event [%i].\n", (void *) pWinWindow, X -> xconfigure.window,
                    X -> xconfigure.x, X -> xconfigure.y, X -> xconfigure.width,
                        X -> xconfigure.height, X -> xconfigure.send_event);
    #endif

    if ((pWin = nxagentRootlessTopLevelWindow(X -> xconfigure.window)) != NULL)
    {
      static int x = 0;
      static int y = 0;
      static int width = 0;
      static int height = 0;
      static Window win = None;
      Bool geometryChanged = False;
      
      Window root_return;
      Window parent_return;
      Window *children_return;
      unsigned int nchildren_return;

      if (!pWin)
      {
        pWin = nxagentWindowPtr(X -> xconfigure.window);
      }

      /*
       * This is an optimization based on
       * the assumption that we never get
       * a configure with both stacking
       * order and geometry changed, this
       * way we can ignore stacking changes
       * if the geometry has changed.
       */

      if (win == X -> xconfigure.window)
      {
        if (x != X -> xconfigure.x ||
                y != X -> xconfigure.y ||
                    width != X -> xconfigure.width ||
                        height != X -> xconfigure.height)
        {
          geometryChanged = True;
        }
      }

      win = X -> xconfigure.window;

      x = X -> xconfigure.x;
      y = X -> xconfigure.y;
      width = X -> xconfigure.width;
      height = X -> xconfigure.height;

      if (geometryChanged)
      {
        #ifdef TEST
        fprintf(stderr, "nxagentHandleConfigureNotify: Configure frame. No restack.\n");
        #endif

        return 1;
      }

      #ifdef DEBUG
      {
        WindowPtr pSib;

        fprintf(stderr, "nxagentHandleConfigureNotify: Before restacking top level window [%p]\n", (void *) pWin);

        for (pSib = WindowTable[0] -> firstChild; pSib; pSib = pSib -> nextSib)
        {
          fprintf(stderr, "nxagentHandleConfigureNotify: Top level window: [%p].\n", (void *) pSib);
        }
      }
      #endif

      XQueryTree(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                     &root_return, &parent_return, &children_return, &nchildren_return);

      nxagentRootlessRestack(children_return, nchildren_return);

      if (nchildren_return)
      {
        XFree(children_return);
      }

      #ifdef DEBUG
      fprintf(stderr, "nxagentHandleConfigureNotify: Trees match: %s\n",
                  nxagentRootlessTreesMatch() ? "Yes" : "No");
      #endif

      return 1;
    }

    if (nxagentWindowTopLevel(pWinWindow) && !X -> xconfigure.override_redirect)
    {
      XID values[5];
      register XID *value = values;
      Mask mask = 0;

      pClient = wClient(pWinWindow);

      if (X -> xconfigure.send_event || !nxagentWMIsRunning ||
                X -> xconfigure.override_redirect)
      {
        *value++ = (XID)X -> xconfigure.x;
        *value++ = (XID)X -> xconfigure.y;

        /*
         * nxagentWindowPriv(pWinWindow)->x = X -> xconfigure.x;
         * nxagentWindowPriv(pWinWindow)->y = X -> xconfigure.y;
         */

        mask |= CWX | CWY;
      }

      *value++ = (XID)X -> xconfigure.width;
      *value++ = (XID)X -> xconfigure.height;
      *value++ = (XID)X -> xconfigure.border_width;

      /*
       * nxagentWindowPriv(pWinWindow)->width = X -> xconfigure.width;
       * nxagentWindowPriv(pWinWindow)->height = X -> xconfigure.height;
       */

      mask |= CWHeight | CWWidth | CWBorderWidth;

      nxagentScreenTrap = 1;
      ConfigureWindow(pWinWindow, mask, (XID *) values, pClient);
      nxagentScreenTrap = 0;

      nxagentSetSynchronizationPending(nxagentDisplay);

      return 1;
    }
  }
  else
  {
    /*
     * Save the position of the agent default window. Don't
     * save the values if the agent is in fullscreen mode.
     *
     * If we use these values to restore the position of a
     * window after that we have dynamically changed the
     * fullscreen attribute, depending on the behaviour of
     * window manager, we could be not able to place the
     * window exactly in the requested position, so let the
     * window manager do the job for us.
     */

    ScreenPtr pScreen = nxagentScreen(X -> xconfigure.window);

    Bool doRandR = False;    

    if (X -> xconfigure.window == nxagentDefaultWindows[pScreen -> myNum])
    {
      if (!nxagentOption(Fullscreen))
      {
        if (nxagentOption(DesktopResize) == 1)
        {
          if (nxagentOption(Width) != X -> xconfigure.width ||
                nxagentOption(Height) != X -> xconfigure.height)
          {
            Bool newEvents = False;

            doRandR = True;

            do
            {
              newEvents = False;

              usleep(500 * 1000);

              XSync(nxagentDisplay, False);

              while (XCheckTypedWindowEvent(nxagentDisplay, nxagentDefaultWindows[pScreen -> myNum],
                                              ConfigureNotify, X))
              {
                newEvents = True;
              }
            } while (newEvents);
          }
        }

        nxagentChangeOption(X, X -> xconfigure.x);
        nxagentChangeOption(Y, X -> xconfigure.y);
        nxagentChangeOption(Width, X -> xconfigure.width);
        nxagentChangeOption(Height, X -> xconfigure.height);

        nxagentChangeOption(ViewportXSpan, (int) X -> xconfigure.width -
                                (int) nxagentOption(RootWidth));
        nxagentChangeOption(ViewportYSpan, (int) X -> xconfigure.height -
                                (int) nxagentOption(RootHeight));

        nxagentMoveViewport(pScreen, 0, 0);
        
        if (doRandR)
        {
          #ifdef TEST 
          fprintf(stderr,"nxagentHandleConfigureNotify: Width %d Height %d.\n",
                      nxagentOption(Width), nxagentOption(Height));
          #endif

          nxagentRRSetScreenConfig(screenInfo.screens[DefaultScreen(nxagentDisplay)],
                                     nxagentOption(Width), nxagentOption(Height));
        }

      }

      return 1;
    }
  }

  return 0;
}

int nxagentHandleReparentNotify(XEvent* X)
{
  ScreenPtr pScreen = nxagentScreen(X -> xreparent.window);

  #ifdef TEST
  fprintf(stderr, "nxagentHandleReparentNotify: Going to handle a new reparent event.\n");
  #endif

  if (nxagentOption(Rootless))
  {
    WindowPtr pWin;

    Window w;
    Window root_return;
    Window parent_return;
    Window *children_return;
    unsigned int nchildren_return;

    pWin = nxagentWindowPtr(X -> xreparent.window);

    #ifdef TEST

    {
      WindowPtr pParent = nxagentWindowPtr(X -> xreparent.parent);
      WindowPtr pEvent = nxagentWindowPtr(X -> xreparent.event);

      fprintf(stderr, "nxagentHandleReparentNotify: event %p[%lx] window %p[%lx] parent %p[%lx] at (%d, %d)\n",
                  (void*)pEvent, X -> xreparent.event, (void*)pWin, X -> xreparent.window,
                          (void*)pParent, X -> xreparent.parent, X -> xreparent.x, X -> xreparent.y);
    }

    #endif

    if (nxagentWindowTopLevel(pWin))
    {
      /*
       * If window manager reparents our top level window, we require
       * ConfigureNotify events relying with the new top level ancestor.
       * This window is a top level window for window manager. We do
       * this in order to know the stacking order.
       */

      w = None;
      parent_return = X -> xreparent.parent;

      while (parent_return != RootWindow(nxagentDisplay, 0))
      {
        w = parent_return;
        XQueryTree(nxagentDisplay, w, &root_return,
                       &parent_return, &children_return, &nchildren_return);

        if (children_return)
        {
          XFree(children_return);
        }
      }

      if (w && !nxagentWindowPtr(w))
      {
        XSelectInput(nxagentDisplay, w, StructureNotifyMask);

        nxagentRootlessAddTopLevelWindow(pWin, w);

        #ifdef TEST
        fprintf(stderr, "nxagentHandleReparentNotify: new top level window [%ld].\n", w);
        fprintf(stderr, "nxagentHandleReparentNotify: reparented window [%ld].\n",
                    X -> xreparent.window);
        #endif

        XQueryTree(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                       &root_return, &parent_return, &children_return, &nchildren_return);

        nxagentRootlessRestack(children_return, nchildren_return);

        if (nchildren_return)
        {
          XFree(children_return);
        }
      }
    }

    return 1;
  }
  else
  {
    /*
     * This code is supposed to detect if a window manager
     * is running but in some cases it may be unreliable.
     * Each window manager behaves differently so the check
     * can fail for some less common WMs.
     */

    if (!nxagentWMIsRunning && nxagentOption(Fullscreen) &&
            X -> xreparent.window == nxagentDefaultWindows[pScreen -> myNum])
    {
      #ifdef WARNING
      fprintf(stderr, "Warning: The agent window was reparented. Is a "
                  "window manager running?\n");
      #endif

      /*
       * If no window manager is running and we are supposed to
       * be in fullscreen mode then don't wait for the reparent
       * event. We can assume that there is an undetected window
       * manager and, as switching to fullscreen could have fail-
       * ed, we try it again.
       */

      nxagentSwitchFullscreen(pScreen, True);

      nxagentWMIsRunning = True;
    }
    else if (nxagentWMIsRunning && X -> xreparent.window ==
                 nxagentDefaultWindows[pScreen -> myNum] && X -> xreparent.parent ==
                     RootWindow(nxagentDisplay, (pScreen -> myNum)))
    {
      #ifdef WARNING

      fprintf(stderr, "Warning: The agent window has been reparented to the root.\n");

      fprintf(stderr, "Warning: No window manager seems to be running.\n");

      #endif

      /*
       * The agent window was unexpectedly reparented
       * to the root window. We assume that the window
       * manager was terminated.
       */

      nxagentWMIsRunning = False;
    }
  }

  return 1;
}

void nxagentEnableKeyboardEvents()
{
  int i;
  Mask mask;

  nxagentGetDefaultEventMask(&mask);
  mask |= NXAGENT_KEYBOARD_EVENT_MASK;
  nxagentSetDefaultEventMask(mask);

  for (i = 0; i < nxagentNumScreens; i++)
  {
     XSelectInput(nxagentDisplay, nxagentDefaultWindows[i], mask);
  }

  XkbSelectEvents(nxagentDisplay, XkbUseCoreKbd,
                      NXAGENT_KEYBOARD_EXTENSION_EVENT_MASK,
                          NXAGENT_KEYBOARD_EXTENSION_EVENT_MASK);
}

void nxagentDisableKeyboardEvents()
{
  int i;
  Mask mask;

  nxagentGetDefaultEventMask(&mask);
  mask &= ~NXAGENT_KEYBOARD_EVENT_MASK;
  nxagentSetDefaultEventMask(mask);

  for (i = 0; i < nxagentNumScreens; i++)
  {
     XSelectInput(nxagentDisplay, nxagentDefaultWindows[i], mask);
  }

  XkbSelectEvents(nxagentDisplay, XkbUseCoreKbd, 0x0, 0x0);
}

void nxagentEnablePointerEvents()
{
  int i;
  Mask mask;

  nxagentGetDefaultEventMask(&mask);
  mask |= NXAGENT_POINTER_EVENT_MASK;
  nxagentSetDefaultEventMask(mask);

  for (i = 0; i < nxagentNumScreens; i++)
  {
     XSelectInput(nxagentDisplay, nxagentDefaultWindows[i], mask);
  }
}

void nxagentDisablePointerEvents()
{
  int i;
  Mask mask;

  nxagentGetDefaultEventMask(&mask);
  mask &= ~NXAGENT_POINTER_EVENT_MASK;
  nxagentSetDefaultEventMask(mask);

  for (i = 0; i < nxagentNumScreens; i++)
  {
     XSelectInput(nxagentDisplay, nxagentDefaultWindows[i], mask);
  }
}

void nxagentSendFakeKey(int key)
{
  xEvent fake;
  Time   now;

  now = GetTimeInMillis();

  fake.u.u.type = KeyPress;
  fake.u.u.detail = key;
  fake.u.keyButtonPointer.time = now;

  mieqEnqueue(&fake);

  fake.u.u.type = KeyRelease;
  fake.u.u.detail = key;
  fake.u.keyButtonPointer.time = now;

  mieqEnqueue(&fake);
}

int nxagentInitKeyboardState()
{
  XEvent X;

  unsigned int modifiers;

  XkbEvent *xkbev = (XkbEvent *) &X;

  #ifdef TEST
  fprintf(stderr, "nxagentInitKeyboardState: Initializing XKB state.\n");
  #endif

  XkbGetIndicatorState(nxagentDisplay, XkbUseCoreKbd, &modifiers);

  xkbev -> state.locked_mods = 0x0;

  if (modifiers & CAPSFLAG_IN_REPLY)
  {
    xkbev -> state.locked_mods |= CAPSFLAG_IN_EVENT;
  }

  if (modifiers & NUMFLAG_IN_REPLY)
  {
    xkbev -> state.locked_mods |= NUMFLAG_IN_EVENT;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentInitKeyboardState: Assuming XKB locked modifier bits [%x].\n",
              xkbev -> state.locked_mods);
  #endif

  xkbev -> type         = nxagentXkbInfo.EventBase + XkbEventCode;
  xkbev -> any.xkb_type = XkbStateNotify;

  nxagentHandleKeyboardEvent(&X);

  return 1;
}

/*
 * FIXME: To be reviewed.
 */

int nxagentWaitForResource(GetResourceFuncPtr pGetResource, PredicateFuncPtr pPredicate)
{
  int resource;
  struct timeval t;

  while ((resource = (*pGetResource)(nxagentDisplay)) == -1)
  {
    if (NXTransRunning())
    {
      t.tv_sec = 0;
      t.tv_usec = 1000;

      NXTransContinue(&t);
    }

    nxagentDispatchEvents(pPredicate);
  }

  return resource;
}

void nxagentGrabPointerAndKeyboard(XEvent *X)
{
  unsigned long now;

  int resource;

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Grabbing pointer and keyboard with event at [%p].\n",
              (void *) X);
  #endif

  if (X != NULL)
  {
    now = X -> xcrossing.time;
  }
  else
  {
    now = CurrentTime;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to grab the keyboard in context [B1].\n");
  #endif

  XGrabKeyboard(nxagentDisplay, nxagentFullscreenWindow,
                    True, GrabModeAsync, GrabModeAsync, now);

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to grab the pointer in context [B2].\n");
  #endif

  /*
   * FIXME: To be reviewed.
   */

  resource = nxagentWaitForResource(NXGetCollectGrabPointerResource,
                                        nxagentCollectGrabPointerPredicate);

  NXCollectGrabPointer(nxagentDisplay, resource,
                           nxagentFullscreenWindow, True, NXAGENT_POINTER_EVENT_MASK,
                               GrabModeAsync, GrabModeAsync, None, None, now);

  /*
   * This should not be needed.
   *
   * XGrabKey(nxagentDisplay, AnyKey, AnyModifier, nxagentFullscreenWindow,
   *              True, GrabModeAsync, GrabModeAsync);
   */

  if (X != NULL)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to force focus in context [B4].\n");
    #endif

    XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                       RevertToParent, now);
  }
}

void nxagentUngrabPointerAndKeyboard(XEvent *X)
{
  unsigned long now;

  #ifdef TEST
  fprintf(stderr, "nxagentUngrabPointerAndKeyboard: Ungrabbing pointer and keyboard with event at [%p].\n",
              (void *) X);
  #endif

  if (X != NULL)
  {
    now = X -> xcrossing.time;
  }
  else
  {
    now = CurrentTime;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentUngrabPointerAndKeyboard: Going to ungrab the keyboard in context [B5].\n");
  #endif

  XUngrabKeyboard(nxagentDisplay, now);

  #ifdef TEST
  fprintf(stderr, "nxagentGrabPointerAndKeyboard: Going to ungrab the pointer in context [B6].\n");
  #endif

  XUngrabPointer(nxagentDisplay, now);
}

void nxagentDeactivatePointerGrab()
{
  GrabPtr grab = inputInfo.pointer -> grab;
  XButtonEvent X;

  if (grab)
  {
    X.type = ButtonRelease;
    X.serial = 0;
    X.send_event = FALSE;
    X.time = currentTime.milliseconds;
    X.display = nxagentDisplay;
    X.window = nxagentWindow(grab -> window);
    X.root = RootWindow(nxagentDisplay, 0);
    X.subwindow = 0;
    X.x = X.y = X.x_root = X.y_root = 0;
    X.state = 0x100;
    X.button = 1;
    X.same_screen = TRUE;

    XPutBackEvent(nxagentDisplay, (XEvent*)&X);
  }
}

void nxagentCollectGrabPointerEvent(int resource)
{
  int status;

  if (!NXGetCollectedGrabPointer(nxagentDisplay, resource, &status))
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentCollectImageEvent: PANIC! Failed to get GrabPointer reply for resource [%d].\n",
                resource);
    #endif
  }
}

void nxagentHandleCollectPropertyEvent(XEvent *X)
{
  Window window;
  Atom property;
  Atom atomReturnType;
  int resultFormat;
  unsigned long ulReturnItems;
  unsigned long ulReturnBytesLeft;
  unsigned char *pszReturnData = NULL;
  int result;
  int resource;

  resource = X -> xclient.data.l[1];

  if (X -> xclient.data.l[2] == False)
  {
    #ifdef DEBUG
    fprintf (stderr, "nxagentHandleCollectPropertyEvent: Failed to get reply data for client [%d].\n",
                 resource);
    #endif

    return;
  }

  if (resource == nxagentLastClipboardClient)
  {
    nxagentCollectPropertyEvent(resource);
  }
  else
  {
    result = NXGetCollectedProperty(nxagentDisplay,
                                    resource,
                                    &atomReturnType,
                                    &resultFormat,
                                    &ulReturnItems,
                                    &ulReturnBytesLeft,
                                    &pszReturnData);

    if (result == True)
    {
      window = nxagentPropertyRequests[resource].window;
      property = nxagentPropertyRequests[resource].property;

      nxagentImportProperty(window, property, atomReturnType, resultFormat,
                                ulReturnItems, ulReturnBytesLeft, pszReturnData);
    }

    if (result == 0)
    {
      #ifdef DEBUG
      fprintf (stderr, "nxagentHandleCollectPropertyEvent: Failed to get reply data for client [%d].\n",
                   resource);
      #endif
    }

    if (pszReturnData != NULL)
    {
      XFree(pszReturnData);
    }

    return;
  }
}

void nxagentCollectInputFocusEvent(int resource)
{
  Window window;
  int revert_to;

  if (!NXGetCollectedInputFocus(nxagentDisplay, resource, &window, &revert_to))
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentCollectInputFocusEvent: PANIC! Failed to get InputFocus reply for resource [%d].\n",
                resource);
    #endif
  }
}

void nxagentSynchronizeExpose(void)
{
  int i, j;
  WindowPtr pWin;
  RegionPtr receivedRegion, sentRegion, pendingRegion;

  for (i = 0; i < nxagentSentExposedNum; i++)
  {
    pWin = nxagentSentExposedWindows[i];

    if (pWin)
    {
      receivedRegion = nxagentWindowPriv(pWin) -> received_expose_region;
      sentRegion = nxagentWindowPriv(pWin) -> sent_expose_region;

      REGION_TRANSLATE(pWin -> drawable.pScreen, receivedRegion,
                           pWin -> drawable.x, pWin -> drawable.y);
      REGION_TRANSLATE(pWin -> drawable.pScreen, sentRegion,
                           pWin -> drawable.x, pWin -> drawable.y);

      REGION_SUBTRACT(pWin -> drawable.pScreen, receivedRegion,
                         receivedRegion, sentRegion);

      miWindowExposures(pWin, receivedRegion, NullRegion);

      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> received_expose_region);
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> sent_expose_region);
    }
  }

  nxagentSentExposedNum = 0;

  j = 0;

  for (i = 0; i < nxagentPendingExposedNum; i++)
  {
    pWin = nxagentPendingExposedWindows[i];

    if (pWin)
    {
      pendingRegion = nxagentWindowPriv(pWin) -> pending_expose_region;

      REGION_COPY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> sent_expose_region,
                         pendingRegion);

      REGION_EMPTY(pWin -> drawable.pScreen,
                       nxagentWindowPriv(pWin) -> pending_expose_region);

      nxagentSentExposedWindows[j++] = pWin;
    }
  }

  nxagentSentExposedNum = j;
  nxagentPendingExposedNum = 0;

  if (nxagentSynchronizationPending == False && nxagentSentExposedNum > 0)
  {
    /*
     * FIXME: To be reviewed.
     */

    int resource = nxagentWaitForResource(NXGetCollectInputFocusResource, nxagentGetCollectInputFocusPredicate);

    NXCollectInputFocus(nxagentDisplay, resource);
    nxagentSynchronizationPending = True;
  }

  return;
}

void nxagentResetExpose(void)
{
  int i;
  WindowPtr pWin;

  for (i = 0; i < nxagentSentExposedNum; i++)
  {
    pWin = nxagentSentExposedWindows[i];

    if (pWin)
    {
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> received_expose_region);
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> sent_expose_region);
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> pending_expose_region);
    }
  }

  nxagentSentExposedNum = 0;

  for (i = 0; i < nxagentPendingExposedNum; i++)
  {
    pWin = nxagentPendingExposedWindows[i];

    if (pWin)
    {
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> received_expose_region);
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> sent_expose_region);
      REGION_EMPTY(pWin -> drawable.pScreen,
                      nxagentWindowPriv(pWin) -> pending_expose_region);
    }
  }

  nxagentPendingExposedNum = 0;

  nxagentSynchronizationPending = False;

  return;
}

int nxagentPendingExposuresIndex(WindowPtr pWin)
{
  int i;

  for (i = 0; i < nxagentPendingExposedNum; i++)
  {
    if (nxagentPendingExposedWindows[i] == pWin)
    {
      return i;
    }
  }

  return -1;
}

int nxagentSentExposuresIndex(WindowPtr pWin)
{
  int i;

  for (i = 0; i < nxagentSentExposedNum; i++)
  {
    if (nxagentSentExposedWindows[i] == pWin)
    {
      return i;
    }
  }

  return -1;
}

static Bool nxagentWaitSplitPredicate(Display *display, XEvent *event, XPointer ptr)
{
  return (event -> type == ClientMessage &&
              (event -> xclient.data.l[0] == NXNoSplitNotify ||
                  event -> xclient.data.l[0] == NXStartSplitNotify) &&
                      event -> xclient.window == 0 && event -> xclient.message_type == 0 &&
                          event -> xclient.format == 32);
}

int nxagentWaitSplitEvent(int client)
{
  XEvent event;

  /*
   * This will let the proxy write the
   * event immediately.
   */

  XFlush(nxagentDisplay);

  for (;;)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentWaitSplitEvent: Going to wait for the next split event.\n");
    #endif

    if (NXDisplayError(nxagentDisplay) == 1)
    {
      nxagentHandleNoSplitEvent(client);

      return 0;
    }
    else
    {
      if (XCheckIfEvent(nxagentDisplay, &event, nxagentWaitSplitPredicate, NULL) == 1)
      {
        if (client != (int) event.xclient.data.l[1])
        {
          #ifdef WARNING
          fprintf(stderr, "nxagentWaitSplitEvent: WARNING! Got event for client [%d] "
                      "while waiting for [%d].\n", (int) event.xclient.data.l[1], client);
          #endif

          continue;
        }

        if (event.xclient.data.l[0] == NXNoSplitNotify)
        {
          nxagentHandleNoSplitEvent(client);

          return 0;
        }
        else
        {
          nxagentHandleStartSplitEvent(client);

          return 1;
        }
      }
    }
  }
}

void nxagentHandleNoSplitEvent(int client)
{
  if ((client >= 0 && client < MAX_CONNECTIONS &&
          clients[client] != NULL) == 0)
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentHandleNoSplitEvent: PANIC! Invalid client identifier [%d] "
                " received in event.\n", client);
    #endif
  }
  #ifdef TEST
  else
  {
    fprintf(stderr, "nxagentHandleNoSplitEvent: No split was required for client [%d].\n",
                client);
  }
  #endif
}

void nxagentHandleStartSplitEvent(int client)
{
  if (client >= 0 && client < MAX_CONNECTIONS &&
          clients[client] != NULL)
  {
    if (nxagentOption(Lazy) == 0)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentHandleStartSplitEvent: Suspending client [%d] due to a split.\n",
                  client);
      #endif

      nxSleepByBigReq(clients[client]);
    }
  }
  #ifdef PANIC
  else
  {
    fprintf(stderr, "nxagentHandleStartSplitEvent: PANIC! Invalid client identifier [%d] "
                " received in event.\n", client);
  }
  #endif
}

void nxagentHandleCommitSplitEvent(int client, int request, int position)
{
  if (client >= 0 && request >= 0 && position >= 0)
  {
    if (nxagentOption(Lazy) == 0)
    {
      /*
       * Always commit the split, even if the client which
       * issued the PutImage has closed the connection and
       * the pointer in clients[] is null:
       *
       * - The proxy needs to free all resources that were
       *   associated with the recomposed image.
       *
       * - The target of PutImage can be a pixmap used by
       *   by another client.
       */

      #ifdef TEST
      fprintf(stderr, "nxagentHandleCommitSplitEvent: Committing request [%d] with "
                  "position [%d].\n", request, position);
      #endif

      NXCommitSplit(nxagentDisplay, client, True, request, position);
    }
    else
    {
      /*
       * Need anyway to free the proxy resources.
       */

      #ifdef TEST
      fprintf(stderr, "nxagentHandleCommitSplitEvent: Discarding request [%d] with "
                  "position [%d].\n", request, position);
      #endif

      NXCommitSplit(nxagentDisplay, client, False, request, position);
    }
  }
  #ifdef WARNING
  else
  {
    fprintf(stderr, "nxagentHandleCommitSplitEvent: WARNING! Invalid commit event with "
                "request [%d] and position [%d].\n", request, position);
  }
  #endif
}

void nxagentHandleEndSplitEvent(int client)
{
  if (client >= 0 && client < MAX_CONNECTIONS &&
          clients[client] != NULL)
  {
    if (nxagentOption(Lazy) == 0)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentHandleEndSplitEvent: Restarting client [%d].\n",
                  client);
      #endif

      nxWakeByBigRequest(clients[client]);
    }
  }
  #ifdef TEST
  else
  {
    fprintf(stderr, "nxagentHandleEndSplitEvent: WARNING! Ignoring split event "
                "for client [%d].\n", client);
  }
  #endif
}

void nxagentHandleEmptySplitEvent()
{
  #ifdef TEST
  fprintf(stderr, "nxagentHandleEmptySplitEvent: WARNING! Should synchronize the drawables.\n");
  #endif
}
