/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __GCOps_H__
#define __GCOps_H__

#ifdef NXAGENT_PACKEDIMAGES

#include NXAGENT_NXPACK_INCLUDE

#endif

void nxagentFillSpans();
void nxagentSetSpans();
void nxagentGetSpans();
void nxagentPutImage();
void nxagentPutSubImage();
void nxagentGetImage();
RegionPtr nxagentCopyArea();
RegionPtr nxagentCopyPlane();
void nxagentQueryBestSize();
void nxagentPolyPoint();
void nxagentPolylines();
void nxagentPolySegment();
void nxagentPolyRectangle();
void nxagentPolyArc();
void nxagentFillPolygon();
void nxagentPolyFillRect();
void nxagentPolyFillArc();
int nxagentPolyText8();
int nxagentPolyText16();
void nxagentImageText8();
void nxagentImageText16();
void nxagentImageGlyphBlt();
void nxagentPolyGlyphBlt();
void nxagentPushPixels();

/*
 * Reset the visual and alpha cache before
 * closing the screen or connecting to
 * another display.
 */

void nxagentResetVisualCache();
void nxagentResetAlphaCache();

/*
 * If enabled just set drawables to its
 * background on copy area.
 */

extern int nxagentFastCopyAreaEnable;

/*
 * If enabled collect images from windows
 * asynchrounously and match the last one
 * collected from real server.
 */

extern int nxagentFastGetImageEnable;

/*
 * Store data of the last image got from the
 * real X server. Used to guess content of
 * remote window and avoid a round trip.
 */

extern XImage *nxagentLastGetImage;

/*
 * True if we are already waiting for a
 * former GetImage reply.
 */

extern int nxagentLastGetImagePending;

#endif /* __GCOps_H__ */

