/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include <unistd.h>

#include "X.h"
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "servermd.h"

#include "Agent.h"
#include "Handlers.h"
#include "Display.h"
#include "Events.h"
#include "Control.h"
#include "Reconnect.h"
#include "Options.h"
#include "Dialog.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

void nxagentBlockHandler(pointer data, struct timeval **timeout, pointer mask)
{
  if (nxagentNeedConnectionChange())
  {
    nxagentHandleConnectionChanges();
  }

  if (nxagentOption(Rootless) && nxagentLastWindowDestroied && nxagentRootlessDialogPid == 0 &&
              GetTimeInMillis() > nxagentLastWindowDestroiedTime + 15 * 1000)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentBlockHandler: No application running. Closing the session.\n");
    #endif
    
    nxagentSetGiveUp();
  }

  if (nxagentSessionState == SESSION_DOWN)
  {
    usleep(50 * 1000);
  }

  /*
   * Restart all clients. If any of the restarted
   * clients had requests in input we'll need to
   * enter the select with a null timeout, or we
   * will block until any other client becomes
   * available.
   */

  nxagentWakeupByDecongestion(timeout);

  /*
   * We are entering WaitForSomething() so it is
   * required to have written all our data to the
   * display connection and have sent all events
   * to our clients.
   */

  XFlush(nxagentDisplay);

  /*
   * Finally dispatch to the clients all the
   * events that have become available.
   */

  if (XEventsQueued(nxagentDisplay, QueuedAlready))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentBlockHandler: Reading X events queued.\n");
    #endif

    nxagentDispatchEvents(NULL);
  }
}

void nxagentWakeupHandler(pointer data, int count, pointer mask)
{
  if (nxagentNeedConnectionChange())
  {
    nxagentHandleConnectionChanges();
  }

  /*
   * Try to read more events from the display
   * connection only when WaitForSomething()
   * reported that the descriptor is ready.
   */

  if (count > 0 &&
          FD_ISSET(XConnectionNumber(nxagentDisplay),
              (fd_set *) mask))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentWakeupHandler: Reading X events with count [%d].\n",
                count);
    #endif

    nxagentDispatchEvents(NULL);
  }
  #ifdef TEST
  else
  {
    fprintf(stderr, "nxagentWakeupHandler: Not reading X events with count [%d].\n",
                count);
  }
  #endif
}
