/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "X.h"
#include "keysym.h"

#include "screenint.h"
#include "scrnintstr.h"

#include "Agent.h"
#include "Display.h"
#include "Events.h"
#include "Options.h"

extern Bool nxagentWMIsRunning;
extern Bool nxagentIpaq;

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

int nxagentCheckSpecialKeystroke(XKeyEvent *X, enum HandleEventResult *result)
{
  KeySym sym;
  int    index = 0;

  *result = doNothing;

  /*
   * I don't know how much hard work is doing this operation.
   * Do we need a cache ?
   */

  sym = XKeycodeToKeysym(nxagentDisplay, X -> keycode, index);

  if (sym == XK_VoidSymbol || sym == NoSymbol)
  {
    return 0;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentCheckSpecialKeystroke: got code %x - state %x - sym %lx\n",
              X -> keycode, X -> state, sym);
  #endif

  /*
   * Check special keys.
   */

  /*
   * FIXME: We should use the keysym instead that the keycode
   *        here.
   */

  if (X -> keycode == 130 && nxagentIpaq)
  {
    *result = doStartKbd;

    return 1;
  }

  /*
   * Removed Alt + F4 and Ctrl + Alt + Shift + Tab. The same action is performed
   * by Ctrl + Alt + T.
   *
   * if (X -> state & (Mod1Mask | Mod2Mask))
   * {
   *   if ((sym == XK_F4  && (X -> state & (ControlMask | ShiftMask)) == (0)) ||
   *           (sym == XK_Tab && (X -> state & (ControlMask | ShiftMask)) == (ControlMask | ShiftMask)))
   *   {
   *     *result = doCloseSession;
   *
   *     return 1;
   *   }
   * }
   */

  /*
   * Removed Ctrl + Alt + Esc and Alt + F2. The same action is performed by
   * Ctrl + Alt + M.
   *
   *
   * if (nxagentOption(Fullscreen) && nxagentWMIsRunning)
   * {
   *   if ((sym == XK_Escape && ((X -> state & (ControlMask | Mod1Mask | ShiftMask)) ==
   *       (ControlMask|Mod1Mask))) ||
   *     (sym == XK_F2 && ((X -> state & (ControlMask | Mod1Mask | ShiftMask)) ==
   *       (Mod1Mask))))
   *   {
   *     *result = doMinimize;
   *
   *     return 1;
   *   }
   * }
   */

  /*
   * It seems that Apple X server, unlike the others, sets the 1 << 0xd bit
   * of state, instead of Mod1Mask bit. So we have to check 1 << 0xd too.
   */

  if ((X -> state & (Mod1Mask | 1 << 0xd)) &&
          ((X -> state & (ControlMask | ShiftMask)) == ControlMask))
  {
    switch (sym)
    {
      case XK_t:
      case XK_T:
      {
        *result = doCloseSession;

        break;
      }
      case XK_f:
      case XK_F:
      {
        if (nxagentOption(Rootless) == False)
        {
          *result = doSwitchFullscreen;
        }

        break;
      }
      case XK_m:
      case XK_M:
      {
        if (nxagentOption(Rootless) == False)
        {
          *result = doMinimize;
        }

        break;
      }
      case XK_Left:
      case XK_KP_Left:
      {
        if (nxagentOption(Rootless) == False &&
                nxagentOption(DesktopResize) == False)
        {
          *result = doViewportLeft;
        }

        break;
      }
      case XK_Up:
      case XK_KP_Up:
      {
        if (nxagentOption(Rootless) == False &&
                nxagentOption(DesktopResize) == False)
        {
          *result = doViewportUp;
        }

        break;
      }
      case XK_Right:
      case XK_KP_Right:
      {
        if (nxagentOption(Rootless) == False &&
                nxagentOption(DesktopResize) == False)
        {
          *result = doViewportRight;
        }

        break;
      }
      case XK_Down:
      case XK_KP_Down:
      {
        if (nxagentOption(Rootless) == False &&
                nxagentOption(DesktopResize) == False)
        {
          *result = doViewportDown;
        }

        break;
      }
      case XK_S:
      case XK_s:
      {
        *result = doSwitchSlowMode;

        break;
      }
      case XK_R:
      case XK_r:
      {
        if (nxagentOption(Rootless) == False)
        {
          *result = doRandR;
        }

        break;
      }
      case XK_E:
      case XK_e:
      {
        *result = doSwitchLazyEncoding;

        break;
      }
    }
  }

  return (*result == doNothing) ? 0 : 1;
}
