/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>

#include "Options.h"

/*
 * Instead of having a single options' repository
 * data could be attached to the display or the
 * screen. The macro nxagentOption() should make
 * the transition simple.
 */

AgentOptionsRec nxagentOptions;

AgentOptionsPtr nxagentOptionsPtr = &nxagentOptions;

/*
 * This must be called at startup to initialize
 * the options' repository to the default values.
 */

void nxagentResetOptions()
{
  nxagentOptions.LinkType = 0;

  nxagentOptions.Desktop    = 1;
  nxagentOptions.Persistent = 1;
  nxagentOptions.Rootless   = 0;
  nxagentOptions.Fullscreen = 0;

  nxagentOptions.X           = 0;
  nxagentOptions.Y           = 0;
  nxagentOptions.Width       = 0;
  nxagentOptions.Height      = 0;
  nxagentOptions.BorderWidth = 0;

  nxagentOptions.SavedX      = 0;
  nxagentOptions.SavedY      = 0;
  nxagentOptions.SavedWidth  = 0;
  nxagentOptions.SavedHeight = 0;

  nxagentOptions.Timeout = 0;

  nxagentOptions.Nested = 0;

  nxagentOptions.BackingStore = BackingStoreUndefined;

  nxagentOptions.SharedMemory = 1;

  nxagentOptions.DeviceControl = 0;

  nxagentOptions.Reset = 0;

  nxagentOptions.RootX = 0;
  nxagentOptions.RootY = 0;
  nxagentOptions.RootWidth = 0;
  nxagentOptions.RootHeight = 0;

  nxagentOptions.ViewportXSpan = 0;
  nxagentOptions.ViewportYSpan = 0;

  nxagentOptions.DesktopResize = 1;

  nxagentOptions.Binder = 0;
  nxagentOptions.BinderOptions = NULL;

  nxagentOptions.Xdmcp = 0;

  nxagentOptions.DisplayLatency = 0;

  nxagentOptions.Lazy = 0;
}
