/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Options_H__
#define __Options_H__

#ifndef True
#define True   1
#endif

#ifndef False
#define False  0
#endif

typedef enum _BackingStoreMode
{
  BackingStoreUndefined = -1,
  BackingStoreNever,
  BackingStoreWhenRequested,
  BackingStoreForce

} BackingStoreMode;

/*
 * Set of options affecting agent operations.
 */

typedef struct _AgentOptions
{
  /*
   * Link type of the NX connection or none,
   * if this is a direct X11 connection.
   */

  int LinkType;

  /*
   * Is agent running in desktop mode? This
   * is presently the default.
   */

  int Desktop;

  /*
   * True if user activated rootless mode.
   */

  int Rootless;

  /*
   * True if user activated persistent mode.
   */

  int Persistent;

  /*
   * True if user activated fullscreen mode.
   */

  int Fullscreen;

  /*
   * Set to the auto-disconnect timeout, if
   * the user activated this feature.
   */

  int Timeout;

  /*
   * Geometry of the agent's window.
   */

  int X;
  int Y;
  int Width;
  int Height;
  int BorderWidth;

  /*
   * Geometry of the agent's window in window
   * mode. Used to restore window size when
   * switching back to window mode from full-
   * screen.
   */

  int SavedX;
  int SavedY;
  int SavedWidth;
  int SavedHeight;

  int SavedRootWidth;
  int SavedRootHeight;

  /*
   * Set if agent is running nested in another
   * agent X server.
   */

  int Nested;

  /*
   * Selected backing-store mode.
   */

  BackingStoreMode BackingStore;

  /*
   * Enable agent to use the MITSHM extension in
   * path from remote proxy to the real X server.
   */

  int SharedMemory;

  /*
   * Enable agent to propagate keyboard and pointer
   * device configuration to the remote X server.
   */

  int DeviceControl;

  /*
   * Reset server when the last client disconnects.
   */

  int Reset;

  /* 
   * Geometry of the agent root window, relative to
   * the agent default window.
   */

  int RootX;
  int RootY;
  int RootWidth;
  int RootHeight;

  /*
   * Horizontal and vertical span of the
   * agent viewport.
   */

  int ViewportXSpan;
  int ViewportYSpan;

  /*
   * True if the user can resize the desktop
   * by dragging the window border.
   */

  int DesktopResize;

  /*
   * Was the agent run with the -B option?
   */

  int Binder;

  char *BinderOptions;

  /*
   * Set if the agent has to connect to a
   * desktop manager to start the session.
   */

  int Xdmcp;

  /*
   * Latency of the link. It is simply set
   * to a reference value, calculated based
   * on the time required to complete the
   * query of the agent's atoms at session
   * startup.
   */

  int DisplayLatency;

  /*
   * Policy used to update the display.
   */

  int Lazy;

} AgentOptionsRec;

typedef AgentOptionsRec *AgentOptionsPtr;

extern AgentOptionsPtr nxagentOptionsPtr;

/*
 * Macros and functions giving access to options.
 */

#define nxagentOption(option) \
    (nxagentOptionsPtr -> option)

#define nxagentChangeOption(option, value) \
    (nxagentOptionsPtr -> option = (value))

#define nxagentOptions() \
    (nxagentOptionsPtr)

/*
 * Initialize the options to the default values.
 */

extern void nxagentResetOptions();

#endif /* __Options_H__ */
