/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Pixmap_H__
#define __Pixmap_H__

#include "Lazy.h"

extern int nxagentPixmapPrivateIndex;

/*
 * Pixmap privates structure.
 */

typedef struct
{
  Pixmap id;
  XID    mid;

  Bool isVirtual;

  nxagentDrawableLazyRec drawableLazy;

  PixmapPtr pVirtualPixmap;
  PixmapPtr pRealPixmap;

  void *pPicture;

} nxagentPrivPixmapRec;

typedef nxagentPrivPixmapRec *nxagentPrivPixmapPtr;

/*
 * Pixmap privates macro.
 */

#define nxagentPixmapPriv(pPixmap) \
    ((nxagentPrivPixmapPtr) ((pPixmap) -> devPrivates[nxagentPixmapPrivateIndex].ptr))

#define nxagentPixmap(pPixmap) (nxagentPixmapPriv(pPixmap) -> id)

#define nxagentPixmapIsVirtual(pPixmap) \
    (nxagentPixmapPriv(pPixmap) -> isVirtual)

#define nxagentRealPixmap(pPixmap) \
    (nxagentPixmapPriv(pPixmap) -> pRealPixmap)

#define nxagentVirtualPixmap(pPixmap) \
    (nxagentPixmapPriv(pPixmap) -> isVirtual ? pPixmap : \
         nxagentPixmapPriv(pPixmap) -> pVirtualPixmap)

#define nxagentPixmapStatus(pPixmap) \
    (nxagentPixmapPriv(nxagentRealPixmap(pPixmap)) -> drawableLazy.status)

#define nxagentPixmapPlaceholderDrawn(pPixmap) \
    (nxagentPixmapPriv(nxagentRealPixmap(pPixmap)) -> drawableLazy.placeholderDrawn)

PixmapPtr nxagentPixmapPtr();

PixmapPtr nxagentCreatePixmap();
Bool nxagentDestroyPixmap();
RegionPtr nxagentPixmapToRegion();
Bool nxagentModifyPixmapHeader();
Bool nxagentReconnectPixmapData();
int nxagentRealizePixmap();

#endif /* __Pixmap_H__ */
