/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Reconnect_H__
#define __Reconnect_H__

extern Display *nxagentDisplayState;
extern void    nxagentSetReconnectError(int, char*, ...);

extern void nxagentInitReconnector(void);
extern Bool nxagentReconnect(void);
extern void nxagentHandleConnectionChanges(void);

enum SESSION_STATE
{
  SESSION_STARTING,
  SESSION_UP,
  SESSION_DOWN,
  SESSION_GOING_DOWN,
  SESSION_GOING_UP
};

extern enum SESSION_STATE nxagentSessionState;

/*
 * Use this macro in the block and wakeup
 * handlers to save a function call.
 */

#define nxagentNeedConnectionChange() \
    (nxagentSessionState == SESSION_GOING_DOWN || \
         nxagentSessionState == SESSION_GOING_UP)

#endif /* __Reconnect_H__ */
