/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Render_H__
#define __Render_H__

#include "screenint.h"
#include "picture.h"
#include "renderproto.h"

extern Bool nxagentAlphaEnabled;
extern Bool nxagentRenderEnable;
extern int nxagentRenderVersionMajor;
extern int nxagentRenderVersionMinor;

extern void nxagentRenderExtensionInit();
extern Bool nxagentPictureInit(ScreenPtr, PictFormatPtr, int);

extern int nxagentPicturePrivateIndex;

typedef struct
{
  Picture picture;

} nxagentPrivPictureRec;

typedef nxagentPrivPictureRec *nxagentPrivPicturePtr;

#define nxagentPicturePriv(pPicture) \
  ((nxagentPrivPicturePtr) ((pPicture) -> devPrivates[nxagentPicturePrivateIndex].ptr))

#define nxagentPicture(pPicture) (nxagentPicturePriv(pPicture) -> picture)

#endif /* __Render_H__ */
