/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

/*
 * Used by the auto-disconnect feature.
 */

#include <signal.h>

#include "scrnintstr.h"
#include "dix.h"
#include "dixstruct.h"
#include "mi.h"
#include "micmap.h"
#include "mibstore.h"
#include "colormapst.h"
#include "resource.h"
#include "mipointer.h"
#include "../../randr/randrstr.h"

#include "Agent.h"
#include "Display.h"
#include "Screen.h"
#include "Extensions.h"
#include "Atoms.h"
#include "GC.h"
#include "GCOps.h"
#include "Drawable.h"
#include "Font.h"
#include "Color.h"
#include "Cursor.h"
#include "Visual.h"
#include "Events.h"
#include "Init.h"
#include "Args.h"
#include "Control.h"
#include "Options.h"
#include "Splash.h"
#include "Render.h"
#include "Lazy.h"
#include "Trap.h"

#ifdef NXAGENT_MVFB
#include "../../fb/fb.h"
#endif

#include "Xatom.h"
#include "Xproto.h"

#include "Keyboard.h"
#include "Pointer.h"
#include "Reconnect.h"

#ifdef NXAGENT_PACKEDIMAGES

#include NXAGENT_NXLIB_INCLUDE

extern int nxagentPackMethod;

#endif

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  WATCH

#ifdef WATCH
#include "unistd.h"
#endif

extern Bool nxagentIpaq;
extern Pixmap nxagentIconPixmap;
extern Pixmap nxagentIconShape;
extern Bool useXpmIcon;

extern void nxagentMoveViewport(ScreenPtr pScreen, int hShift, int vShift);
extern Bool RRGetInfo (ScreenPtr pScreen);
extern void RRSendConfigNotify (ScreenPtr pScreen);
extern void RREditConnectionInfo (ScreenPtr pScreen);

Window nxagentDefaultWindows[MAXSCREENS];
Window nxagentScreenSaverWindows[MAXSCREENS];

#ifdef NXAGENT_FORCEBACK
extern Bool nxagentForceBackingStore;
#endif

#ifdef NXAGENT_ONEXIT
Bool  nxagentWMIsRunning;
#endif

#ifdef NXAGENT_ONSTART
Atom nxagent_WM_START;
Window nxagentSplashWindow = None;
Pixmap nxagentPixmapLogo;
#endif

ScreenPtr nxagentDummyScreen = NULL;
int  nxagentArgc        = 0;
char**   nxagentArgv    = NULL;
extern int nxagentReconnectTrap;

#ifdef NXAGENT_ARTSD

char mcop_atom[] = "MCOPGLOBALS";
Atom mcop_local_atom = None;
unsigned char fromHexNibble(char c);
void nxagentPropagateArtsdProperties(ScreenPtr pScreen, char *port);

#endif

#ifdef NXAGENT_FAKEBS
extern BSFuncRec nxBSFuncRec;
/*
extern void nxSaveDoomedAreas (WindowPtr pWin,
                        RegionPtr pObscured,
                               int dx, int dy);
extern RegionPtr nxRestoreDoomedAreas (WindowPtr pWin,
RegionPtr prgnExposed);
*/
#endif

Window nxagentIconWindow = None;
Window nxagentFullscreenWindow = None;

WindowPtr nxagentViewportFrameLeft;
WindowPtr nxagentViewportFrameRight;
WindowPtr nxagentViewportFrameAbove;
WindowPtr nxagentViewportFrameBelow;

void MinimizeFromFullScreen(ScreenPtr pScreen)
{
    XUnmapWindow(nxagentDisplay, nxagentFullscreenWindow);
    if(nxagentIpaq)
    {
        XMapWindow(nxagentDisplay, nxagentIconWindow);
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));
    }
    else
    {
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));

    }
}

void MaximizeToFullScreen(ScreenPtr pScreen)
{
    if(nxagentIpaq)
    {
        XUnmapWindow(nxagentDisplay, nxagentIconWindow);
        XMapWindow(nxagentDisplay, nxagentFullscreenWindow);
    }
    else
    {
/*
        XUnmapWindow(nxagentDisplay, nxagentIconWindow);
*/
        XMapRaised(nxagentDisplay, nxagentFullscreenWindow);
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));
/*
        XMapWindow(nxagentDisplay, nxagentIconWindow);
*/

    }

}

Window nxagentCreateIconWindow(void)
{
  XSetWindowAttributes attributes;
  unsigned long valuemask;
  char* window_name;
  XTextProperty windowName;
  XSizeHints sizeHints;
  XWMHints wmHints;
  Window w;
  Mask mask;

  /*
   * Create icon window.
   */

  attributes.override_redirect = False;
  attributes.colormap = DefaultColormap(nxagentDisplay, DefaultScreen(nxagentDisplay));
  attributes.background_pixmap = nxagentScreenSaverPixmap;
  valuemask = CWOverrideRedirect | CWBackPixmap | CWColormap;

  #ifdef TEST
  fprintf(stderr, "nxagentCreateIconWindow: Going to create new icon window.\n");
  #endif

  w = XCreateWindow(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                        0, 0, 1, 1, 0,
                            DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                                InputOutput,
                                    DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                                        valuemask, &attributes);

  #ifdef TEST
  fprintf(stderr, "nxagentCreateIconWindow: Created new icon window with id [%ld].\n",
              nxagentIconWindow);
  #endif

  /*
   *  Set hints to the window manager for the icon window.
   */

  window_name = nxagentWindowName;
  XStringListToTextProperty(&window_name, 1, &windowName);
  sizeHints.flags = PMinSize | PMaxSize;
  sizeHints.min_width = sizeHints.max_width = 1;
  sizeHints.min_height = sizeHints.max_height = 1;
  wmHints.flags = IconPixmapHint | IconMaskHint;
  wmHints.initial_state = IconicState;
  wmHints.icon_pixmap = nxagentIconPixmap;

  if (useXpmIcon)
  {
    wmHints.icon_mask = nxagentIconShape;
    wmHints.flags = IconPixmapHint | IconMaskHint;
  }
  else
  {
    wmHints.flags = StateHint | IconPixmapHint;
  }

  XSetWMProperties(nxagentDisplay, w,
                      &windowName, &windowName,
                          NULL , 0 , &sizeHints, &wmHints, NULL);

  /*
   * Enable events from icon window.
   */

  nxagentGetDefaultEventMask(&mask);
  XSelectInput(nxagentDisplay, w,
                   (mask & ~(KeyPressMask | KeyReleaseMask)) | StructureNotifyMask);

  /*
   * Notify to client if user closes icon window.
   */

  if (nxagentWMIsRunning && !nxagentOption(Rootless))
  {
    Atom deleteWMatom = nxagentAtoms[2]; /* WM_DELETE_WINDOW */

    XSetWMProtocols(nxagentDisplay, w, &deleteWMatom, 1);
  }

  return w;
}

Bool magicPixelZone(int x, int y)
{
  return (x >= nxagentOption(Width) - 1 && y < 1);
}

ScreenPtr nxagentScreen(window)
     Window window;
{
  /*
   * At the moment we use a single screen. Searching for a window
   * matching is useless, so we simply return the known single
   * screen.
   *
   * int i;
   * WindowPtr pWin;
   *
   * #ifdef TEST
   * fprintf(stderr, "nxagentScreen: detecting Screen from window [%lx]\n", window);
   * #endif
   *
   * for (i = 0; i < nxagentNumScreens; i++)
   * {
   *   if (nxagentDefaultWindows[i] == window)
   *     return screenInfo.screens[i];
   * }
   *
   * for (i = 0; i < nxagentNumScreens; i++)
   * {
   *   if (RootWindow(nxagentDisplay, i) == window)
   *     return screenInfo.screens[i];
   * }
   *
   * pWin = nxagentWindowPtr(window);
   *
   * return pWin ? pWin -> drawable.pScreen : NULL;
   */

   return nxagentDummyScreen;
}

static int offset(mask)
     unsigned long mask;
{
  int count;

  for (count = 0; !(mask & 1) && count < 32; count++)
    mask >>= 1;

  return count;
}

static Bool nxagentSaveScreen(pScreen, what)
     ScreenPtr pScreen;
     int what;
{
  /*
   * If there is any client attached then leave the
   * session running, else terminate it. It should
   * use something less brutal, though raising a
   * signal should ensure that the code follows the
   * usual execution path.
   */

  extern int nxagentClients;

  #ifdef TEST
  fprintf(stderr, "nxagentSaveScreen: Called for screen at [%p] with parameter [%d].\n",
              (void *) pScreen, what);

  fprintf(stderr, "nxagentSaveScreen: SCREEN_SAVER_ON is [%d] SCREEN_SAVER_OFF is [%d] "
              "SCREEN_SAVER_FORCER is [%d] SCREEN_SAVER_CYCLE is [%d].\n",
                  SCREEN_SAVER_ON, SCREEN_SAVER_OFF, SCREEN_SAVER_FORCER,
                      SCREEN_SAVER_CYCLE);
  #endif

  if (nxagentSessionState == SESSION_UP &&
          what == SCREEN_SAVER_ON && nxagentOption(Timeout) > 0)
  {
    if (nxagentClients == 0)
    {
      fprintf(stderr, "Info: Terminating the session with no client running.\n");

      raise(SIGTERM);
    }
    else
    {
      fprintf(stderr, "Info: Suspending the session with %d clients running.\n",
                  nxagentClients);

      raise(SIGHUP);
    }
  }

#ifdef NXAGENT_NEVERSS
    return True;
#endif
  if (nxagentSoftwareScreenSaver)
    return False;
  else {
    switch (what) {
    case SCREEN_SAVER_ON:
      XMapRaised(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetScreenSaverColormapWindow(pScreen);
      break;
      
    case SCREEN_SAVER_OFF:
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
      
    case SCREEN_SAVER_FORCER:
      nxagentLastEventTime = GetTimeInMillis();
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
      
    case SCREEN_SAVER_CYCLE:
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
    }
    return True;
  }
}

Bool nxagentCreateScreenResources(ScreenPtr pScreen)
{
  Bool ret;

  CreatePixmapProcPtr savedCreatePixmap = pScreen->CreatePixmap;
  ModifyPixmapHeaderProcPtr savedModifyPixmapHeader = pScreen->ModifyPixmapHeader;

  pScreen->CreatePixmap = fbCreatePixmap;
  pScreen->ModifyPixmapHeader = miModifyPixmapHeader;
  ret = miCreateScreenResources(pScreen);

  pScreen->CreatePixmap = savedCreatePixmap;
  pScreen->ModifyPixmapHeader = savedModifyPixmapHeader;

  return ret;
}

static Bool
nxagentCursorOffScreen (ppScreen, x, y)
    ScreenPtr   *ppScreen;
    int         *x, *y;
{
    return FALSE;
}

static void
nxagentCrossScreen (pScreen, entering)
    ScreenPtr   pScreen;
    Bool        entering;
{
}

static miPointerScreenFuncRec nxagentPointerCursorFuncs =
{
    nxagentCursorOffScreen,
    nxagentCrossScreen,
    miPointerWarpCursor
};

void nxagentInitViewportFrame(ScreenPtr pScreen, WindowPtr pRootWin)
{
  int error = Success;
  VisualID visual = 0;
  int i;
  XID xid;

  if (nxagentOption(Rootless))
  {
    return;
  }

  for (i = 0; i < pScreen -> numDepths; i++)
  {
    if (pScreen -> allowedDepths[i].depth == pRootWin -> drawable.depth)
    {
      visual = pScreen -> allowedDepths[i].vids[0];
      break;
    }
  }

  /*
   * It is not necessary create the windows on the real X server. But this
   * windows are not visible. Create them it is not a great effort, and avoids
   * many errors.
   *
   *  nxagentScreenTrap = True;
   */

  xid = FakeClientID(serverClient -> index);

  #ifdef TEST
  fprintf(stderr, "nxagentInitViewportFrame: XID = [%lx]\n", xid);
  #endif

  nxagentViewportFrameLeft = CreateWindow(xid, pRootWin, -NXAGENT_FRAME_WIDTH, 0, NXAGENT_FRAME_WIDTH,
                                              pRootWin -> drawable.height,
                                                  0, InputOutput, 0, NULL,
                                                      pRootWin -> drawable.depth,
                                                          serverClient, visual, &error);

  AddResource(xid, RT_WINDOW, (pointer) nxagentViewportFrameLeft);

  if (error != Success)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentInitViewportFrame: Error creating nxagentViewportFrameLeft.\n");
    #endif

    error = Success;
  }

  xid = FakeClientID(serverClient -> index);

  #ifdef TEST
  fprintf(stderr, "nxagentInitViewportFrame: XID = [%lx]\n", xid);
  #endif

  nxagentViewportFrameRight = CreateWindow(xid, pRootWin, pRootWin -> drawable.width, 0,
                                               NXAGENT_FRAME_WIDTH,
                                                   pRootWin -> drawable.height,
                                                       0, InputOutput, 0, NULL,
                                                           pRootWin -> drawable.depth,
                                                               serverClient, visual,
                                                                   &error);

  AddResource(xid, RT_WINDOW, (pointer) nxagentViewportFrameRight);

  if (error != Success)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentInitViewportFrame: Error creating nxagentViewportFrameRight.\n");
    #endif

    error = Success;
  }

  xid = FakeClientID(serverClient -> index);

  #ifdef TEST
  fprintf(stderr, "nxagentInitViewportFrame: XID = [%lx]\n", xid);
  #endif

  nxagentViewportFrameAbove = CreateWindow(xid, pRootWin, 0, -NXAGENT_FRAME_WIDTH,
                                               pRootWin -> drawable.width,
                                                   NXAGENT_FRAME_WIDTH, 0,
                                                       InputOutput, 0, NULL,
                                                           pRootWin -> drawable.depth,
                                                               serverClient, visual,
                                                                   &error);

  AddResource(xid, RT_WINDOW, (pointer) nxagentViewportFrameAbove);

  if (error != Success)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentInitViewportFrame: Error creating nxagentViewportFrameAbove.\n");
    #endif

    error = Success;
  }

  xid = FakeClientID(serverClient -> index);

  #ifdef TEST
  fprintf(stderr, "nxagentInitViewportFrame: XID = [%lx]\n", xid);
  #endif

  nxagentViewportFrameBelow = CreateWindow(xid, pRootWin, 0,
                                               pRootWin -> drawable.height,
                                                   pRootWin -> drawable.width,
                                                       NXAGENT_FRAME_WIDTH, 0,
                                                           InputOutput, 0, NULL,
                                                               pRootWin -> drawable.depth,
                                                                   serverClient, visual, &error);

  AddResource(xid, RT_WINDOW, (pointer) nxagentViewportFrameBelow);

  if (error != Success)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentInitViewportFrame: Error creating nxagentViewportFrameBelow.\n");
    #endif
  }

  nxagentViewportFrameLeft -> overrideRedirect = 1;
  nxagentViewportFrameRight -> overrideRedirect = 1;
  nxagentViewportFrameAbove -> overrideRedirect = 1;
  nxagentViewportFrameBelow -> overrideRedirect = 1;

  MapWindow(nxagentViewportFrameLeft, serverClient);
  MapWindow(nxagentViewportFrameRight, serverClient);
  MapWindow(nxagentViewportFrameAbove, serverClient);
  MapWindow(nxagentViewportFrameBelow, serverClient);

  /*
   * We left this code here for debug purpose only. This should be removed when no more
   * useful.
   *
   * XSetWindowBackground(nxagentDisplay, nxagentWindow(nxagentViewportFrameLeft), 0xff0000);
   * XSetWindowBackground(nxagentDisplay, nxagentWindow(nxagentViewportFrameRight), 0xff0000);
   * XSetWindowBackground(nxagentDisplay, nxagentWindow(nxagentViewportFrameAbove), 0xff0000);
   * XSetWindowBackground(nxagentDisplay, nxagentWindow(nxagentViewportFrameBelow), 0xff0000);
   */

  /*
   * nxagentScreenTrap = False;
   */
}

void nxagentPrintAgentGeometry(char *hdrMessage, char *prefix)
{
  #ifdef WARNING

  if (prefix == NULL)
  {
    prefix = "";
  }

  if (hdrMessage)
  {
    fprintf(stderr, "--------------- %s -----------------.\n", hdrMessage);
  }

  fprintf(stderr, "%s Root window at offset (%d,%d) size (%d,%d).\n", prefix,
              nxagentOption(RootX), nxagentOption(RootY),
                  nxagentOption(RootWidth), nxagentOption(RootHeight));

  fprintf(stderr, "%s Default window at offset (%d,%d) size (%d,%d) border size %d.\n", prefix,
              nxagentOption(X), nxagentOption(Y), nxagentOption(Width), nxagentOption(Height),
                  nxagentOption(BorderWidth));

  fprintf(stderr, "%s Span between root window and default window is (%d,%d).\n", prefix,
              nxagentOption(ViewportXSpan), nxagentOption(ViewportYSpan));

  fprintf(stderr, "%s Default window in window mode has offset (%d,%d) and size (%d,%d).\n", prefix,
              nxagentOption(SavedX), nxagentOption(SavedY), nxagentOption(SavedWidth), nxagentOption(SavedHeight));

  fprintf(stderr, "%s Fullscreen is %s.\n", prefix,
              nxagentOption(Fullscreen) ? "ON" : "OFF");

  fprintf(stderr, "%s Desktop resize mode is %s.\n", prefix,
              nxagentOption(DesktopResize) ? "ON" : "OFF");

  fprintf(stderr, "%s Resize desktop at startup is %s.\n", prefix,
              nxagentResizeDesktopAtStartup ? "ON" : "OFF");

  #endif
}

Bool nxagentOpenScreen(index, pScreen, argc, argv)
     int index;
     register ScreenPtr pScreen;
     int argc;
     char *argv[];
{
  VisualPtr visuals;
  DepthPtr depths;
  int numVisuals, numDepths;
  int i, j, depthIndex;
  unsigned long valuemask;
  XSetWindowAttributes attributes;
  XWindowAttributes gattributes;
  XSizeHints sizeHints;
  XWMHints wmHints;
  Mask mask;
  Bool resetAgentPosition = False;

  VisualID defaultVisual;
  int rootDepth;

  pointer pFrameBufferBits;
  int bitsPerPixel;
  int sizeInBytes;

  #if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)
  extern int nxagentClientPrivateIndex;
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentOpenScreen: Called for screen index [%d].\n",
              index);
  #endif

  if (nxagentRenderEnable && nxagentReconnectTrap == False)
  {
    PictureScreenPrivateIndex = -1;
  }

  nxagentDummyScreen = pScreen;

  nxagentQueryAtoms(pScreen);

  #ifdef NXAGENT_ONSTART
  nxagent_WM_START = nxagentAtoms[3];  /* WM_NX_READY */
  #endif

  /*
   * Forced geometry parameter
   * to user geometry.
   */

  if (nxagentResizeDesktopAtStartup)
  {
    if (nxagentUserGeometry.flag & XValue)
    {
      nxagentChangeOption(X, nxagentUserGeometry.X);
    }

    if (nxagentUserGeometry.flag & YValue)
    {
      nxagentChangeOption(Y, nxagentUserGeometry.Y);
    }

    if (nxagentUserGeometry.flag & WidthValue)
    {
      nxagentChangeOption(Width, nxagentUserGeometry.Width);
      nxagentChangeOption(RootWidth, nxagentUserGeometry.Width);

      if (nxagentOption(SavedWidth) > nxagentUserGeometry.Width)
      {
        nxagentChangeOption(SavedWidth, nxagentUserGeometry.Width);
      }
    }

    if (nxagentUserGeometry.flag & HeightValue)
    {
      nxagentChangeOption(Height, nxagentUserGeometry.Height);
      nxagentChangeOption(RootHeight, nxagentUserGeometry.Height);

      if (nxagentOption(SavedHeight) > nxagentUserGeometry.Height)
      {
        nxagentChangeOption(SavedHeight, nxagentUserGeometry.Height);
      }
    }
  }

  /*
   * This is first time the
   * screen is initialized.
   * Filling the geometry parameter
   * from user geometry.
   */

  if (nxagentReconnectTrap == False)
  {
    if (nxagentUserGeometry.flag & XValue)
    {
      nxagentChangeOption(X, nxagentUserGeometry.X);
    }

    if (nxagentUserGeometry.flag & YValue)
    {
      nxagentChangeOption(Y, nxagentUserGeometry.Y);
    }

    if (nxagentUserGeometry.flag & WidthValue)
    {
      nxagentChangeOption(RootWidth, nxagentUserGeometry.Width);
    }

    if (nxagentUserGeometry.flag & HeightValue)
    {
      nxagentChangeOption(RootHeight, nxagentUserGeometry.Height);
    }
  }

  /*
   * Determine the size of the root window.
   * It is the maximum size of the screen
   * if we are either in rootless or in
   * fullscreen mode.
   */

  if (nxagentOption(Rootless) == False && nxagentWMIsRunning == False)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentOpenScreen: No window manager is running, forcing fullscreen mode.\n");
    #endif

    nxagentChangeOption(Fullscreen, True);
  }

  if (nxagentOption(Fullscreen) &&
          nxagentWMIsRunning &&
              nxagentReconnectTrap &&
                  nxagentResizeDesktopAtStartup == False &&
                      nxagentXServerGeometryChanged())
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentOpenScreen: X Server geometry is changed, forcing window mode.\n");
    #endif

    nxagentChangeOption(Fullscreen, False);
    resetAgentPosition = True;
  }

  if (nxagentOption(Fullscreen))
  {
    nxagentChangeOption(X, 0);
    nxagentChangeOption(Y, 0);

    nxagentChangeOption(Width, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
    nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));

    nxagentChangeOption(BorderWidth, 0);

    if (nxagentReconnectTrap == False || nxagentResizeDesktopAtStartup)
    {
      nxagentChangeOption(RootWidth, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
      nxagentChangeOption(RootHeight, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));

      if (nxagentOption(RootWidth) > WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)))
      {
        nxagentChangeOption(SavedWidth, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) * 3 / 4);
      }
      else
      {
        nxagentChangeOption(SavedWidth, nxagentOption(RootWidth));
      }

      if (nxagentOption(RootHeight) > HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)))
      {
        nxagentChangeOption(SavedHeight, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) * 3 / 4);
      }
      else
      {
        nxagentChangeOption(SavedHeight, nxagentOption(RootHeight));
      }
    }

    nxagentChangeOption(RootX, ((WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) -
                            nxagentOption(RootWidth)) / 2));
    nxagentChangeOption(RootY, ((HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) -
                            nxagentOption(RootHeight)) / 2));
  }
  else
  {
    nxagentChangeOption(BorderWidth, 0);

    if (nxagentReconnectTrap == False)
    {
      nxagentChangeOption(RootX, 0);
      nxagentChangeOption(RootY, 0);

      nxagentChangeOption(Width, nxagentOption(RootWidth));
      nxagentChangeOption(Height, nxagentOption(RootHeight));
    }

    /*
     * Be sure that the agent window won't be bigger
     * than the root window.
     */

    if (nxagentOption(Width) > nxagentOption(RootWidth))
    {
      nxagentChangeOption(Width, nxagentOption(RootWidth));
    }

    if (nxagentOption(Height) > nxagentOption(RootHeight))
    {
      nxagentChangeOption(Height, nxagentOption(RootHeight));
    }

    /*
     * Be sure that the agent window won't be bigger
     * than the X server root window.
     */

    if (nxagentOption(Width) > WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)))
    {
      nxagentChangeOption(Width, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) * 3 / 4);
    }

    if (nxagentOption(Height) > HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)))
    {
      nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) * 3 / 4);
    }

    /*
     * Forcing the agent window geometry to be equal to
     * the root window geometry the first time the
     * screen is initialized if the geometry hasn't been
     * esplicitly set in the option file and if
     * the root window isn't bigger than the X server
     * root window..
     */

    if (nxagentReconnectTrap == False)
    {
      if ((nxagentOption(RootWidth) < WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay))) &&
              !(nxagentUserGeometry.flag & WidthValue))
      {
        nxagentChangeOption(Width, nxagentOption(RootWidth));
      }

      if ((nxagentOption(RootHeight) < HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay))) &&
              !(nxagentUserGeometry.flag & HeightValue))
      {
        nxagentChangeOption(Height, nxagentOption(RootHeight));
      }
    }

    if (resetAgentPosition)
    {
      nxagentChangeOption(X, ((WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) -
                              nxagentOption(Width)) / 2));

      nxagentChangeOption(Y, ((HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)) -
                              nxagentOption(Height)) / 2));
    }

    nxagentChangeOption(SavedWidth, nxagentOption(RootWidth));
    nxagentChangeOption(SavedHeight, nxagentOption(RootHeight));
  }

  if (nxagentOption(Rootless))
  {
    nxagentChangeOption(RootWidth, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
    nxagentChangeOption(RootHeight, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
  }

  nxagentChangeOption(SavedRootWidth, nxagentOption(RootWidth));
  nxagentChangeOption(SavedRootHeight, nxagentOption(RootHeight));

  nxagentChangeOption(ViewportXSpan, nxagentOption(Width) - nxagentOption(RootWidth));
  nxagentChangeOption(ViewportYSpan, nxagentOption(Height) - nxagentOption(RootHeight));

  if (nxagentReconnectTrap == FALSE)
  {
    if (nxagentOption(Persistent))
    {
      nxagentArgc   = argc;
      nxagentArgv   = argv;
    }

    #ifdef NXAGENT_TIMESTAMP
    {
      extern unsigned long startTime;
      fprintf(stderr, "Screen: going to open screen, time is [%d] milliseconds.\n",
              GetTimeInMillis() - startTime);
    }
    #endif

    if (!(AllocateWindowPrivate(pScreen, nxagentWindowPrivateIndex, sizeof(nxagentPrivWin))  &&
          AllocateGCPrivate(pScreen, nxagentGCPrivateIndex, sizeof(nxagentPrivGC)) &&
        #if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)
        /* allocate only the pointer */
        AllocateClientPrivate(nxagentClientPrivateIndex, sizeof(nxagentPrivClient)))
        #endif
        )
      return False;

    #ifdef NXAGENT_MVFB
    {
/*
FIXME
*/

    if (!AllocatePixmapPrivate(pScreen, nxagentPixmapPrivateIndex, sizeof(nxagentPrivPixmapRec)))
       return False;  
#if 0
      extern Bool fbAllocatePrivates(ScreenPtr, int *);
      if (!fbAllocatePrivates(pScreen, &i) ||
          !AllocatePixmapPrivate(pScreen, nxagentPixmapPrivateIndex, sizeof(nxagentPrivPixmapRec)) ||
          !AllocateGCPrivate(pScreen, fbGCPrivateIndex, sizeof(FbGCPrivRec)))
        return False;
#endif
    }
    #else
    if (!AllocatePixmapPrivate(pScreen, nxagentPixmapPrivateIndex, sizeof(nxagentPrivPixmapRec)))
       return False;  
    #endif

    /*
     * Initialize the depths.
     */

    depths = (DepthPtr) xalloc(nxagentNumDepths * sizeof(DepthRec));

    for (i = 0; i < nxagentNumDepths; i++)
    {
      depths[i].depth = nxagentDepths[i];
      depths[i].numVids = 0;
      depths[i].vids = (VisualID *) xalloc(MAXVISUALSPERDEPTH * sizeof(VisualID));
    }

    /*
     * Initialize the visuals.
     */

    numVisuals = 0;
    numDepths = nxagentNumDepths;

    visuals = (VisualPtr) xalloc(nxagentNumVisuals * sizeof(VisualRec));

    for (i = 0; i < nxagentNumVisuals; i++)
    {
      visuals[numVisuals].vid = FakeClientID(0);
      visuals[numVisuals].class = nxagentVisuals[i].class;
      visuals[numVisuals].bitsPerRGBValue = nxagentVisuals[i].bits_per_rgb;
      visuals[numVisuals].ColormapEntries = nxagentVisuals[i].colormap_size;
      visuals[numVisuals].nplanes = nxagentVisuals[i].depth;
      visuals[numVisuals].redMask = nxagentVisuals[i].red_mask;
      visuals[numVisuals].greenMask = nxagentVisuals[i].green_mask;
      visuals[numVisuals].blueMask = nxagentVisuals[i].blue_mask;
      visuals[numVisuals].offsetRed = offset(nxagentVisuals[i].red_mask);
      visuals[numVisuals].offsetGreen = offset(nxagentVisuals[i].green_mask);
      visuals[numVisuals].offsetBlue = offset(nxagentVisuals[i].blue_mask);

      /*
       * Check for and remove duplicates.
       */

      for (j = 0; j < numVisuals; j++) {
        if (visuals[numVisuals].class           == visuals[j].class           &&
            visuals[numVisuals].bitsPerRGBValue == visuals[j].bitsPerRGBValue &&
            visuals[numVisuals].ColormapEntries == visuals[j].ColormapEntries &&
            visuals[numVisuals].nplanes         == visuals[j].nplanes         &&
            visuals[numVisuals].redMask         == visuals[j].redMask         &&
            visuals[numVisuals].greenMask       == visuals[j].greenMask       &&
            visuals[numVisuals].blueMask        == visuals[j].blueMask        &&
            visuals[numVisuals].offsetRed       == visuals[j].offsetRed       &&
            visuals[numVisuals].offsetGreen     == visuals[j].offsetGreen     &&
            visuals[numVisuals].offsetBlue      == visuals[j].offsetBlue)
          break;
      }
      if (j < numVisuals)
        continue;

      depthIndex = UNDEFINED;

      for (j = 0; j < numDepths; j++)
      {
        if (depths[j].depth == nxagentVisuals[i].depth)
        {
          depthIndex = j;
          break;
        }
      }

      if (depthIndex == UNDEFINED)
      {
        #ifdef WARNING
        fprintf(stderr, "nxagentOpenScreen: WARNING! Can't find a matching depth for visual depth [%d].\n",
                nxagentVisuals[i].depth);
        #endif

        depthIndex = numDepths;

        depths[depthIndex].depth = nxagentVisuals[i].depth;
        depths[depthIndex].numVids = 0;
        depths[depthIndex].vids = (VisualID *) xalloc(MAXVISUALSPERDEPTH * sizeof(VisualID));

        numDepths++;
      }

      if (depths[depthIndex].numVids >= MAXVISUALSPERDEPTH)
      {
        FatalError("Visual table overflow");
      }

      depths[depthIndex].vids[depths[depthIndex].numVids] = visuals[numVisuals].vid;

      depths[depthIndex].numVids++;

      numVisuals++;
    }

    defaultVisual = visuals[nxagentDefaultVisualIndex].vid;
    rootDepth = visuals[nxagentDefaultVisualIndex].nplanes;

    if (rootDepth == 1)
    {
      bitsPerPixel = 1;
    }
    else if (rootDepth <= 8)
    {
      bitsPerPixel = 8;
    }
    else if (rootDepth <= 16)
    {
      bitsPerPixel = 16;
    }
    else
    {
      bitsPerPixel = 32;
    }

    if (bitsPerPixel == 1)
    {
      sizeInBytes = PixmapBytePad(nxagentOption(RootWidth), rootDepth) * nxagentOption(RootHeight);
    }
    else
    {
      sizeInBytes = PixmapBytePad(nxagentOption(RootWidth), rootDepth) * nxagentOption(RootHeight) * bitsPerPixel/8;
    }

    #ifdef WARNING
    fprintf(stderr, "nxagentOpenScreen: Frame buffer allocated. rootDepth "
                "[%d] bitsPerPixel [%d] sizeInBytes [%d]\n", rootDepth, bitsPerPixel, sizeInBytes);
    #endif

    pFrameBufferBits = (char *) Xalloc(sizeInBytes);

    if (!pFrameBufferBits)
    {
      return FALSE;
    }

    #ifdef WARNING
    fprintf(stderr, "nxagentOpenScreen: Before fbScreenInit numVisuals [%d] numDepths [%d] "
              "rootDepth [%d] defaultVisual [%ld].\n", numVisuals, numDepths,
                  rootDepth, defaultVisual);
    #endif

    if (!fbScreenInit(pScreen, pFrameBufferBits, nxagentOption(RootWidth), nxagentOption(RootHeight),
           1, 1, PixmapBytePad(nxagentOption(RootWidth), rootDepth), bitsPerPixel))
    {
      return FALSE;
    }

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: After fbScreenInit numVisuals [%d] numDepths [%d] "
              "rootDepth [%d] defaultVisual [%ld].\n", numVisuals, numDepths,
                  rootDepth, defaultVisual);
    #endif

    /*
     * Complete the initialization of the GLX
     * extension. This will add the GLX visuals
     * and will modify numVisuals and numDepths.
     */

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Before GLX numVisuals [%d] numDepths [%d] "
              "rootDepth [%d] defaultVisual [%ld].\n", numVisuals, numDepths,
                  rootDepth, defaultVisual);
    #endif

    nxagentInitGlxExtension(&visuals, &depths, &numVisuals, &numDepths,
                                &rootDepth, &defaultVisual);

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: After GLX numVisuals [%d] numDepths [%d] "
              "rootDepth [%d] defaultVisual [%ld].\n", numVisuals, numDepths,
                  rootDepth, defaultVisual);
    #endif

    /*
     * FIXME: Replace visuals and depth initialized by fbScreenInit with ours.
     */

    xfree(pScreen -> visuals);
    xfree(pScreen -> allowedDepths);

    pScreen -> visuals = visuals;
    pScreen -> allowedDepths = depths;
    pScreen -> numVisuals = numVisuals;
    pScreen -> numDepths = numDepths;
    pScreen -> rootVisual = defaultVisual;
    pScreen -> rootDepth = rootDepth;

    /*
     * Complete the initialization
     * of the RANDR extension.
     */

    nxagentInitRandRExtension(pScreen);

    /*
     * Initializing the pixmaps that will serve as
     * "placeholders" in lazy encoding. We need one 
     * pixmap for each depth.
     */

    for (i = 0; i < numDepths; i++)
    {
      nxagentMarkPlaceholderNotLoaded(i);
    }

    #ifdef WATCH

    fprintf(stderr, "nxagentOpenScreen: Watchpoint 7.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

    sleep(30);

    #endif

    if (nxagentParentWindow != 0)
    {
      /*
       * This would cause a GetWindowAttributes
       * and a GetGeometry (asynchronous) reply.
       */

      XGetWindowAttributes(nxagentDisplay, nxagentParentWindow, &gattributes);

      nxagentChangeOption(Width, gattributes.width);
      nxagentChangeOption(Height, gattributes.height);
    }

    #ifdef NXAGENT_PACKEDIMAGES

    /*
     * Inform nxproxy about how to unpack
     * images for a given depth.
     */

    if (nxagentPackMethod != -1)
    {
      /*
       * FIXME: Must carry the agent's client.
       */

      NXSetUnpackGeometry(nxagentDisplay, 0, DefaultScreenOfDisplay(nxagentDisplay), NULL);
    }

    #endif

    if (nxagentOption(Fullscreen))
    {
      attributes.override_redirect = True;

      /*
       * We need to disable the host's screensaver or
       * it will otherwise grab the screen even if it
       *  is under agent's control.
       */

      XSetScreenSaver(nxagentDisplay, 0, 0, DefaultExposures, DefaultBlanking);
    }

    #ifdef NXAGENT_MVFB

    {
      extern Bool nxagentTrue24;

      if (nxagentTrue24)
      {
          fbGetScreenPrivate(pScreen)->win32bpp = visuals[nxagentDefaultVisualIndex].nplanes;
          fbGetScreenPrivate(pScreen)->pix32bpp = visuals[nxagentDefaultVisualIndex].nplanes;
      }
      else
      {
          fbGetScreenPrivate(pScreen)->win32bpp = 32;
          fbGetScreenPrivate(pScreen)->pix32bpp = 32;
      }
    }

    #endif

    /* myNum */
    /* id */

    /*
     * We call miScreenInit with NULL in place of the screen area if we
     * don't want to initialize the frame buffer.
     *
     * if (!miScreenInit(pScreen, NULL, nxagentOption(RootWidth),
     *              nxagentOption(RootHeight), 1, 1, nxagentOption(RootWidth),
     *              visuals[nxagentDefaultVisualIndex].nplanes, / * Root depth. * / 
     *              numDepths, depths,
     *              visuals[nxagentDefaultVisualIndex].vid,* Root visual. * /
     *              numVisuals, visuals))
     *   return FALSE;
     */

    #ifndef NXAGENT_FAKEBS
    /*miInitializeBackingStore(pScreen);*/
    #endif

    /*
     * From misprite.c: called from device-dependent screen
     * initialization proc after all of the function pointers
     * have been stored in the screen structure.
     */

    miDCInitialize(pScreen, &nxagentPointerCursorFuncs);

    pScreen->mmWidth = nxagentOption(RootWidth) * DisplayWidthMM(nxagentDisplay,
                           DefaultScreen(nxagentDisplay)) / DisplayWidth(nxagentDisplay,
                               DefaultScreen(nxagentDisplay));

    pScreen->mmHeight = nxagentOption(RootHeight) * DisplayHeightMM(nxagentDisplay,
                            DefaultScreen(nxagentDisplay)) / DisplayHeight(nxagentDisplay,
                                DefaultScreen(nxagentDisplay));

    pScreen->defColormap = (Colormap) FakeClientID(0);
    pScreen->minInstalledCmaps = MINCMAPS;
    pScreen->maxInstalledCmaps = MAXCMAPS;
    #ifdef NXAGENT_BAKSTR
    pScreen->backingStoreSupport = nxagentBackingStore;
    pScreen->saveUnderSupport = nxagentSaveUnder;
    #else
    pScreen->backingStoreSupport = NotUseful;
    pScreen->saveUnderSupport = NotUseful;
    #endif
    pScreen->whitePixel = nxagentWhitePixel;
    pScreen->blackPixel = nxagentBlackPixel;
    /* rgf */
    /* GCperDepth */
    /* PixmapPerDepth */
    /* WindowPrivateLen */
    /* WindowPrivateSizes */
    /* totalWindowSize */
    /* GCPrivateLen */
    /* GCPrivateSizes */
    /* totalGCSize */

    /*
     * Random screen procedures.
     */

    pScreen->CloseScreen = nxagentCloseScreen;
    pScreen->QueryBestSize = nxagentQueryBestSize;
    pScreen->SaveScreen = nxagentSaveScreen;
    pScreen->GetImage = nxagentGetImage;
    pScreen->GetSpans = nxagentGetSpans;
    pScreen->PointerNonInterestBox = (void (*)()) 0;
    pScreen->SourceValidate = (void (*)()) 0;

    pScreen->CreateScreenResources = nxagentCreateScreenResources;

    /*
     * Window Procedures.
     * 
     * Note that the following functions are not
     * replaced with nxagent counterparts:
     *
     * ValidateTreeProcPtr       ValidateTree;
     * ClearToBackgroundProcPtr  ClearToBackground;
     *
     * Note also that the ConfigureWindow procedure
     * has not a pointer in the screen structure.
     */

    pScreen->CreateWindow = nxagentCreateWindow;
    pScreen->DestroyWindow = nxagentDestroyWindow;
    pScreen->PositionWindow = nxagentPositionWindow;
    pScreen->ChangeWindowAttributes = nxagentChangeWindowAttributes;
    pScreen->RealizeWindow = nxagentRealizeWindow;
    pScreen->UnrealizeWindow = nxagentUnrealizeWindow;
    pScreen->PostValidateTree = (void (*)()) 0;
    pScreen->WindowExposures = nxagentWindowExposures;
    pScreen->PaintWindowBackground = nxagentPaintWindowBackground;
    pScreen->PaintWindowBorder = nxagentPaintWindowBorder;
    pScreen->CopyWindow = nxagentCopyWindow;
    pScreen->ClipNotify = nxagentClipNotify;
    pScreen->RestackWindow = nxagentRestackWindow;
    pScreen->ReparentWindow = nxagentReparentWindow;

    /*
     * Pixmap procedures.
     */

    pScreen->CreatePixmap = nxagentCreatePixmap;
    pScreen->DestroyPixmap = nxagentDestroyPixmap;

    /*
     * Backing store procedures.
     */

    #ifdef NXAGENT_FAKEBS

    pScreen->BackingStoreFuncs = nxBSFuncRec;
    miInitializeBackingStore(pScreen);

    #else

    pScreen->SaveDoomedAreas = (void (*)()) 0;
    pScreen->RestoreAreas = (RegionPtr (*)()) 0;
    pScreen->ExposeCopy = (void (*)()) 0;
    pScreen->TranslateBackingStore = (RegionPtr (*)()) 0;
    pScreen->ClearBackingStore = (RegionPtr (*)()) 0;
    pScreen->DrawGuarantee = (void (*)()) 0;

    #endif

    /*
     * Font procedures.
     */

    pScreen->RealizeFont = nxagentRealizeFont;
    pScreen->UnrealizeFont = nxagentUnrealizeFont;

    /*
     * Cursor Procedures.
     */

    pScreen->ConstrainCursor = nxagentConstrainCursor;
    pScreen->CursorLimits = nxagentCursorLimits;
    pScreen->DisplayCursor = nxagentDisplayCursor;
    pScreen->RealizeCursor = nxagentRealizeCursor;
    pScreen->UnrealizeCursor = nxagentUnrealizeCursor;
    pScreen->RecolorCursor = nxagentRecolorCursor;
    pScreen->SetCursorPosition = nxagentSetCursorPosition;

    /*
     * GC procedures.
     */

    pScreen->CreateGC = nxagentCreateGC;

    /*
     * Colormap procedures.
     */

    pScreen->CreateColormap = nxagentCreateColormap;
    pScreen->DestroyColormap = nxagentDestroyColormap;
    pScreen->InstallColormap = nxagentInstallColormap;
    pScreen->UninstallColormap = nxagentUninstallColormap;
    pScreen->ListInstalledColormaps = nxagentListInstalledColormaps;
    pScreen->StoreColors = nxagentStoreColors;
    pScreen->ResolveColor = nxagentResolveColor;

    pScreen->BitmapToRegion = nxagentPixmapToRegion;

    /*
     * OS layer procedures.
     */

    pScreen->BlockHandler = (void (*)())NoopDDA;
    pScreen->WakeupHandler = (void (*)())NoopDDA;
    pScreen->blockData = (pointer)0;
    pScreen->wakeupData = (pointer)0;

    #define POSITION_OFFSET (pScreen->myNum * (nxagentOption(Width) + \
                               nxagentOption(Height)) / 32)

    #ifdef NXAGENT_FORCEBACK
    {
      int i = XDoesBackingStore(DefaultScreenOfDisplay(nxagentDisplay));
      
      switch(i)
      {
        case Always:
          #ifdef NXAGENT_FORCEBACK_DEBUG
          fprintf(stderr, "DOES BACKING STORE: Always\n");
          #endif
          if (nxagentOption(Fullscreen))
          {
            nxagentForceBackingStore = False;
          }
          break;
        case NotUseful:
          #ifdef NXAGENT_FORCEBACK_DEBUG
          fprintf(stderr, "DOES BACKING STORE: NotUseful\n");
          #endif
          nxagentForceBackingStore = False;
          break;
        case WhenMapped:
          #ifdef NXAGENT_FORCEBACK_DEBUG
          fprintf(stderr, "DOES BACKING STORE: WhenMapped\n");
          #endif
          break;
      }
    }
    #endif
  }

  #ifdef WARNING
  nxagentPrintAgentGeometry(NULL, "nxagentOpenScreen:");
  #endif

  if (nxagentDoFullGeneration || nxagentReconnectTrap)
  {
    valuemask = CWBackPixel | CWEventMask | CWColormap | (nxagentOption(Fullscreen)?CWOverrideRedirect:0);
    attributes.background_pixel = nxagentBlackPixel;

    nxagentGetDefaultEventMask((Mask*)&attributes.event_mask);

    attributes.colormap = nxagentDefaultVisualColormap(nxagentDefaultVisual(pScreen));
    if(nxagentOption(Fullscreen)){
        attributes.override_redirect = True;

      if (nxagentReconnectTrap)
      {
        /*
         * We need to disable the host's screensaver or
         * it will otherwise grab the screen even if it
         * is under agent's control.
         */
                                                                                                   
        XSetScreenSaver(nxagentDisplay, 0, 0, DefaultExposures, DefaultBlanking);
      }
    }

    /*
     * This would be used when running agent
     * embedded into another X window.
     */

    if (nxagentParentWindow != 0)
    {
      nxagentDefaultWindows[pScreen->myNum] = nxagentParentWindow;

      nxagentGetDefaultEventMask(&mask);

      XSelectInput(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum],
                       mask);

    }
    else
    {
      /*
       * Create any top-level window as a child of the
       * real root of the remote display. See also the
       * InitRootWindow() procedure and the function
       * handling the splash screen.
       */

      if (nxagentOption(Rootless) == True)
      {
        nxagentDefaultWindows[pScreen->myNum] = DefaultRootWindow(nxagentDisplay);

        #ifdef TEST
        fprintf(stderr, "nxagentOpenScreen: Using root window id [%ld].\n",
                    nxagentDefaultWindows[pScreen->myNum]);
        #endif
      }

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Going to create new default window.\n");
      #endif

      nxagentDefaultWindows[pScreen->myNum] =
          XCreateWindow(nxagentDisplay,
                        DefaultRootWindow(nxagentDisplay),
                        nxagentOption(X) + POSITION_OFFSET,
                        nxagentOption(Y) + POSITION_OFFSET,
                        nxagentOption(Width),
                        nxagentOption(Height),
                        nxagentOption(BorderWidth),
                        pScreen->rootDepth,
                        InputOutput,
                        nxagentDefaultVisual(pScreen),
                        valuemask, &attributes);

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Created new default window with id [%ld].\n",
                  nxagentDefaultWindows[pScreen->myNum]);
      #endif

      /*
       * The purpose is to use a single round-trip
       * to get all the intern atoms.
       */

      if (nxagentReconnectTrap && !nxagentOption(Rootless))
      {
        /*
         * During reconnection we cannot draw splash
         * over the root window, because it would be
         * hidden by other windows.
         * So we have to draw it over the default window.
         */

        nxagentShowSplashWindow(nxagentDefaultWindows[pScreen->myNum]);

        XMapWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);
      }

      if (nxagentOption(Fullscreen))
      {
        nxagentFullscreenWindow = nxagentDefaultWindows[pScreen->myNum];
      }

      if (nxagentIpaq)
      {
        XWindowChanges ch;
        unsigned int ch_mask;

        ch.stack_mode = Below;
        ch_mask = CWStackMode;

        XConfigureWindow(nxagentDisplay, nxagentFullscreenWindow, ch_mask, &ch);
      }
    }

    if (nxagentOption(Fullscreen))
    {
      /*
       * FIXME: Do we still need to set this property?
       */

      if (nxagentAtoms[8] != 0)
      {
        XChangeProperty(nxagentDisplay,
                        nxagentDefaultWindows[pScreen->myNum],
                        nxagentAtoms[8], /* NX_AGENT_SIGNATURE */
                        XA_STRING,
                        8, 
                        PropModeReplace, 
                        (unsigned char*) "X-AGENT",
                        strlen("X-AGENT"));
      }

      nxagentGetDefaultEventMask(&mask);
      XSelectInput(nxagentDisplay, nxagentFullscreenWindow, mask);
    }

#ifdef NXAGENT_REPARENT_DEBUG
    fprintf(stderr, "root window ID: %X\n",
            nxagentDefaultWindows[pScreen->myNum]);
#endif

#ifdef NXAGENT_REPARENT
    /* we want to know where the pointer is */
    XSelectInput (nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                  PointerMotionMask | KeyPressMask | KeyReleaseMask | KeymapStateMask);
/*                   ButtonPressMask | ButtonReleaseMask | PointerMotionMask */
/*                   KeyPressMask | KeyReleaseMask | KeymapStateMask */
/*                   PointerMotionMask */
#endif

    sizeHints.flags = PPosition | PMinSize | PMaxSize;
    sizeHints.x = nxagentOption(X) + POSITION_OFFSET;
    sizeHints.y = nxagentOption(Y) + POSITION_OFFSET;
    sizeHints.min_width = MIN_NXAGENT_WIDTH;
    sizeHints.min_height = MIN_NXAGENT_HEIGHT;

    sizeHints.width = nxagentOption(RootWidth);
    sizeHints.height = nxagentOption(RootHeight);

    if (nxagentOption(DesktopResize) == 1)
    {
      sizeHints.max_width = WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
      sizeHints.max_height = HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
    }
    else
    {
      sizeHints.max_width = nxagentOption(RootWidth);
      sizeHints.max_height = nxagentOption(RootHeight);
    }

    if (nxagentUserGeometry.flag & XValue || nxagentUserGeometry.flag & YValue)
      sizeHints.flags |= USPosition;
    if (nxagentUserGeometry.flag & WidthValue || nxagentUserGeometry.flag & HeightValue)
      sizeHints.flags |= USSize;

    XSetStandardProperties(nxagentDisplay,
                           nxagentDefaultWindows[pScreen->myNum],
                           nxagentWindowName,
                           nxagentWindowName,
                           nxagentIconPixmap,
                           argv, argc, &sizeHints);

    wmHints.icon_pixmap = nxagentIconPixmap;

    if (useXpmIcon)
    {
      wmHints.icon_mask = nxagentIconShape;
      wmHints.flags = IconPixmapHint | IconMaskHint;
    }
    else
    {
      wmHints.flags = IconPixmapHint;
    }

    XSetWMHints(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &wmHints);

    /*
     * Clear the window but let it unmapped. We'll map it
     * at the time the we'll initialize our screen root
     * and only if we are not running in rootless mode.
     */

    XClearWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);

    if (nxagentOption(Fullscreen))
    {
      valuemask = CWBackPixmap | CWColormap | CWOverrideRedirect;
    }
    else
    {
      valuemask = CWBackPixmap | CWColormap;
    }

    attributes.background_pixmap = nxagentScreenSaverPixmap;
    attributes.colormap = DefaultColormap(nxagentDisplay, DefaultScreen(nxagentDisplay));

    if (nxagentOption(Fullscreen))
    {
      attributes.override_redirect = False;
      if (nxagentReconnectTrap)
      {
        XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                       RevertToParent, CurrentTime);
        XGrabKeyboard(nxagentDisplay, nxagentFullscreenWindow, True, GrabModeAsync,
                      GrabModeAsync, CurrentTime);
      }
    }

    if (nxagentOption(Fullscreen))
    {
      nxagentIconWindow = nxagentCreateIconWindow();
    }
    else
    {
      nxagentIconWindow = 0;
    }

    /*
     * When we don't have window manager we grab keyboard
     * to let nxagent get keyboard events.
     */

    if (!nxagentWMIsRunning && !nxagentOption(Fullscreen))
    {
      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: No window manager, we call XGrabKeyboard.\n");
      #endif

      XGrabKeyboard(nxagentDisplay, RootWindow (nxagentDisplay, 0), True, GrabModeAsync,
                    GrabModeAsync, CurrentTime);
    }

#ifndef NXAGENT_NEVERSS

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Going to create new screen saver window.\n");
    #endif

    nxagentScreenSaverWindows[pScreen->myNum] =
        XCreateWindow(nxagentDisplay,
                      nxagentDefaultWindows[pScreen->myNum],
                      0, 0, nxagentOption(Width), nxagentOption(Height), 0,
                      DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      InputOutput,
                      DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      valuemask, &attributes);

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Created new screen saver window with id [%ld].\n",
                nxagentScreenSaverWindows[pScreen->myNum]);
    #endif

#endif
  }

  if (!nxagentCreateDefaultColormap(pScreen))
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentOpenScreen: Failed to create default colormap for screen.\n");
    #endif

    return False;
  }

  /*
   * The purpose of this check is to verify if there
   * is a window manager running. Unfortunately due
   * to the way we manage the intern atoms call, the
   * atom will always exist.
   */

  if (nxagentWMIsRunning)
  {
    Atom deleteWMatom = nxagentAtoms[2];  /* WM_DELETE_WINDOW */

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Found WM, delete window atom [%ld].\n",
                deleteWMatom);
    #endif

    if (nxagentOption(Rootless) == False)
    {
      /*
       * Set the WM_DELETE_WINDOW protocol for the main agent
       * window and, if we are in fullscreen mode, include the
       * icon window.
       */

      XSetWMProtocols(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &deleteWMatom, 1);

      /*
      if (nxagentOption(Fullscreen))
      {
        XSetWMProtocols(nxagentDisplay, nxagentIconWindow, &deleteWMatom, 1);
      }
      */
    }
    else
    {
      /*
       * We need to register the ICCCM WM_DELETE_WINDOW protocol
       * for any top-level window or the agent will be killed if
       * any window is closed.
       */

      XSetWMProtocols(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &deleteWMatom, 1);
      fprintf(stderr, "Warning: Not setting the WM_DELETE_WINDOW protocol.\n");
    }
  }
  else
  {
    /*
     * We should always enable configuration of the remote
     * X server's devices if we are running fullscreen and
     * there is no WM running.
     */

    if (nxagentOption(Fullscreen))
    {
      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: WARNING! Forcing propagation of device control changes.\n");
      #endif

      nxagentChangeOption(DeviceControl, True);
    }
  }

  /*
   * Inform user if agent's clients will be able to
   * change the real X server's keyboard and pointer
   * settings.
   */

  if (nxagentOption(DeviceControl) == False)
  {
    fprintf(stderr, "Info: Not using local device configuration changes.\n");
  }
  else
  {
    fprintf(stderr, "Info: Using local device configuration changes.\n");
  }

#ifdef RENDER

  if (nxagentRenderEnable && !nxagentReconnectTrap)
  {
    if (!nxagentPictureInit(pScreen, 0, 0))
    {
      nxagentRenderEnable = False;              

      return FALSE;
    }

    if (nxagentAlphaEnabled)
    {
      fprintf(stderr, "Info: Using alpha channel in render extension.\n");
    }
  }

#endif /* RENDER */

#ifdef NXAGENT_TIMESTAMP
{
  extern unsigned long startTime;

  fprintf(stderr, "Screen: open screen finished, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
}
#endif

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenScreen: Watchpoint 8.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
#1   U  2	1	5344 bits (1 KB) ->	2344 bits (0 KB) ->	2672/1 -> 1172/1	= 2.280:1
#16     11		2816 bits (0 KB) ->	197 bits (0 KB) ->	256/1 -> 18/1	= 14.294:1
#91     1		16640 bits (2 KB) ->	12314 bits (2 KB) ->	16640/1 -> 12314/1	= 1.351:1
#98     2		512 bits (0 KB) ->	57 bits (0 KB) ->	256/1 -> 28/1	= 8.982:1
*/

  sleep(30);

  #endif

  return True;
}

Bool nxagentCloseScreen(index, pScreen)
     int index;
     ScreenPtr pScreen;
{
  int i;

  for (i = 0; i < pScreen->numDepths; i++)
  {
    xfree(pScreen->allowedDepths[i].vids);
  }

  /*
   * Free the frame buffer.
   */

  xfree(((PixmapPtr)pScreen -> devPrivate) -> devPrivate.ptr);

  xfree(pScreen->allowedDepths);
  xfree(pScreen->visuals);
  xfree(pScreen->devPrivate);

  if (nxagentLastGetImage)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentGetImage: Deleting last image collected from real server.\n");
    #endif

    XDestroyImage(nxagentLastGetImage);

    nxagentLastGetImage = NULL;
  }

  /*
   * Reset the geometry and alpha information
   * used by proxy to unpack the packed images.
   */

  nxagentResetVisualCache();

  nxagentResetAlphaCache();

  /*
   * The assumption is that all X resources will be
   * destroyed upon closing the display connection.
   * There is no need to generate extra protocol.
   */

  return True;
}

Bool nxagentResizeScreen(ScreenPtr pScreen, int width, int height, int mmWidth, int mmHeight)
{
  BoxRec box;
  XSizeHints sizeHints;
  PixmapPtr pPixmap;
  char *fbBits;
  
  int oldWidth;
  int oldHeight;
  int oldMmWidth;
  int oldMmHeight;

  #ifdef TEST
  nxagentPrintAgentGeometry("Before Resize Screen", "nxagentResizeScreen:");
  #endif
  
  /*
   * Change screen properties.
   */

  oldWidth = pScreen -> width;
  oldHeight = pScreen -> height;
  oldMmWidth = pScreen -> mmWidth;
  oldMmHeight = pScreen -> mmHeight;

  pScreen -> width = width;
  pScreen -> height = height;

  /*
   * Compute screen dimensions if they aren't given.
   */

  if (mmWidth == 0)
  {
    mmWidth  = width * DisplayWidthMM(nxagentDisplay, DefaultScreen(nxagentDisplay)) /
                  DisplayWidth(nxagentDisplay, DefaultScreen(nxagentDisplay));
  }

  if (mmHeight == 0)
  {  
    mmHeight = height * DisplayHeightMM(nxagentDisplay, DefaultScreen(nxagentDisplay)) /
                   DisplayHeight(nxagentDisplay, DefaultScreen(nxagentDisplay));
  }

  pScreen -> mmWidth = mmWidth;
  pScreen -> mmHeight = mmHeight;

  pPixmap = fbGetScreenPixmap(pScreen);

  if ((fbBits = realloc(pPixmap -> devPrivate.ptr, PixmapBytePad(width, pScreen->rootDepth) *
                            height * BitsPerPixel(pScreen->rootDepth) / 8)) == NULL)
  {
    pScreen -> width = oldWidth;
    pScreen -> height = oldHeight;
    pScreen -> mmWidth = oldMmWidth;
    pScreen -> mmHeight = oldMmHeight;

    return False;
  }

  if (!miModifyPixmapHeader(pPixmap, width, height,
                                pScreen->rootDepth, BitsPerPixel(pScreen->rootDepth),
                                    PixmapBytePad(width,
                                        pScreen->rootDepth), fbBits))
  {
    /*
     * FIXME: We should try to restore the previously
     *        reallocated frame buffer pixmap.
     */

    pScreen -> width = oldWidth;
    pScreen -> height = oldHeight;
    pScreen -> mmWidth = oldMmWidth;
    pScreen -> mmHeight = oldMmHeight;

    return False;
  }

  nxagentChangeOption(RootWidth, width);
  nxagentChangeOption(RootHeight, height);

  if (nxagentOption(Fullscreen))
  {
    nxagentChangeOption(Width, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
    nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));

    nxagentChangeOption(RootX, (WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay))
                            - nxagentOption(RootWidth)) / 2);
    nxagentChangeOption(RootY,  (HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay))
                            - nxagentOption(RootHeight)) / 2);
  }
  else
  {
    nxagentChangeOption(RootX, 0);
    nxagentChangeOption(RootY, 0);
  }

  nxagentChangeOption(ViewportXSpan, nxagentOption(Width) - nxagentOption(RootWidth));
  nxagentChangeOption(ViewportYSpan, nxagentOption(Height) - nxagentOption(RootHeight));

  /*
   * Change agent window size and size hints.
   */

  sizeHints.flags = PPosition | PMinSize | PMaxSize;
  sizeHints.x = nxagentOption(X);
  sizeHints.y = nxagentOption(Y);

  sizeHints.min_width = MIN_NXAGENT_WIDTH;
  sizeHints.min_height = MIN_NXAGENT_HEIGHT;
  sizeHints.width = width;
  sizeHints.height = height;

  if (nxagentOption(DesktopResize) == 1)
  {
    sizeHints.max_width = WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
    sizeHints.max_height = HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay));
  }
  else
  {
    sizeHints.max_width = nxagentOption(RootWidth);
    sizeHints.max_height = nxagentOption(RootHeight);
  }

  if (nxagentUserGeometry.flag & XValue || nxagentUserGeometry.flag & YValue)
  {
    sizeHints.flags |= USPosition;
  }

  if (nxagentUserGeometry.flag & WidthValue || nxagentUserGeometry.flag & HeightValue)
  {
    sizeHints.flags |= USSize;
  }

  XSetWMNormalHints(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &sizeHints);

  if (nxagentOption(Fullscreen))
  {
    XResizeWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum],
                      WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)),
                          HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
  }
  else
  {
    XResizeWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], width, height);
  }

  /*
   * Set properties for the agent root window.
   */

  box.x1 = 0;
  box.y1 = 0;
  box.x2 = width;
  box.y2 = height;

  WindowTable[pScreen -> myNum] -> drawable.width = width;
  WindowTable[pScreen -> myNum] -> drawable.height = height;
  WindowTable[pScreen -> myNum] -> drawable.x = 0;
  WindowTable[pScreen -> myNum] -> drawable.y = 0;

  REGION_INIT(pScreen, &WindowTable[pScreen -> myNum] -> borderSize, &box, 1);
  REGION_INIT(pScreen, &WindowTable[pScreen -> myNum] -> winSize, &box, 1);
  REGION_INIT(pScreen, &WindowTable[pScreen -> myNum] -> clipList, &box, 1);
  REGION_INIT(pScreen, &WindowTable[pScreen -> myNum] -> borderClip, &box, 1);

  (*pScreen -> PositionWindow)(WindowTable[pScreen -> myNum], 0, 0);

/*
FIXME
  if (nxagentOption(Fullscreen))
*/
    XMoveWindow(nxagentDisplay, nxagentWindow(WindowTable[0]), nxagentOption(RootX), nxagentOption(RootY));
    nxagentMoveViewport(pScreen, 0, 0);

  #ifdef TEST
  nxagentPrintAgentGeometry("After Resize Screen", "nxagentResizeScreen:");
  #endif

  return True;
}

void nxagentMapDefaultWindows(ScreenPtr pScreen, WindowPtr pWin, ClientPtr pClient)
{
  if (!nxagentOption(Rootless))
  {
    /*
     * Show the NX splash screen.
     */

    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Showing the splash window.\n");
    #endif

    nxagentShowSplashWindow(nxagentWindow(pWin));
  }

  /*
   * Map the default window.
   */

  if (!nxagentOption(Rootless))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Mapping default window id [%ld].\n",
                nxagentDefaultWindows[pScreen->myNum]);
    #endif

    XMapWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);
  }

  /*
   * Map the root window.
   */
 
  #ifdef TEST
  fprintf(stderr, "nxagentMapDefaultWindows: Mapping root window id [%ld].\n",
              nxagentWindow(pWin));
  #endif

  XMoveWindow(nxagentDisplay, nxagentWindow(pWin),
                  nxagentOption(RootX), nxagentOption(RootY));

  MapWindow(pWin, pClient);

  /*
   * Map the icon window.
   */

  if (nxagentIconWindow != 0)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Mapping icon window id [%ld].\n",
                nxagentIconWindow);
    #endif

    XMapWindow(nxagentDisplay, nxagentIconWindow);

    if(nxagentIpaq)
    {
      XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                         DefaultScreen(nxagentDisplay));
    }
  }

  /*
   * Ensure that the fullscreen window gets the focus.
   */

  if (nxagentFullscreenWindow)
  {
    XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                       RevertToParent, CurrentTime);
  }

  #ifdef TEST
  fprintf(stderr, "nxagentMapDefaultWindows: Completed mapping of default windows.\n");
  #endif
}

#ifdef NXAGENT_ARTSD

unsigned char fromHexNibble(char c)
{
  int uc = (unsigned char)c;

  if(uc >= '0' && uc <= '9') return uc - (unsigned char)'0';
  if(uc >= 'a' && uc <= 'f') return uc + 10 - (unsigned char)'a';
  if(uc >= 'A' && uc <= 'F') return uc + 10 - (unsigned char)'A';

  return 16; /*error*/
}

void nxagentPropagateArtsdProperties(ScreenPtr pScreen, char *port)
{
  Window                rootWin;
  Atom                  atomReturnType;
  Atom                  prop_atom;
  int                   iReturnFormat;
  unsigned long         ulReturnItems;
  unsigned long         ulReturnBytesLeft;
  unsigned char         *pszReturnData = NULL;
  int                   iReturn;

  int i,in;
  char tchar[] = "    ";
  char *chport;
  char hex[] = "0123456789abcdef";

  rootWin = DefaultRootWindow(nxagentDisplay);
  prop_atom = nxagentAtoms[4];  /* MCOPGLOBALS */

  /*
   * Get at most 64KB of data.
   */

  iReturn = XGetWindowProperty(nxagentDisplay,
                               rootWin,
                               prop_atom,
                               0,
                               65536 / 4,
                               False,
                               XA_STRING,
                               &atomReturnType,
                               &iReturnFormat,
                               &ulReturnItems,
                               &ulReturnBytesLeft,
                               &pszReturnData);

  if (iReturn == Success && atomReturnType != None &&
          ulReturnItems > 0 && pszReturnData != NULL)
  {
    char *local_buf;

    #ifdef TEST
    fprintf(stderr, "nxagentPropagateArtsdProperties: Got [%ld] elements of format [%d] with [%ld] bytes left.\n",
                ulReturnItems, iReturnFormat, ulReturnBytesLeft);
    #endif

    #ifdef WARNING

    if (ulReturnBytesLeft > 0)
    {
      fprintf(stderr, "nxagentPropagateArtsdProperties: WARNING! Could not get the whole ARTSD property data.\n");
    }

    #endif

    local_buf = (char *) xalloc(strlen((char*)pszReturnData) + 100);

    if (local_buf)
    {
      memset(local_buf, 0, strlen((char *) pszReturnData));

      for (i = 0, in = 0; pszReturnData[i] != '\0'; i++)
      {
        local_buf[in]=pszReturnData[i];

        if(pszReturnData[i]==':')
        {
          i++;

          while(pszReturnData[i]!='\n')
          {
             unsigned char h;
             unsigned char l;

             h = fromHexNibble(pszReturnData[i]);
             i++;
             if(pszReturnData[i]=='\0') continue;
             l = fromHexNibble(pszReturnData[i]);
             i++;

             if(h >= 16 || l >= 16) continue;

             /*
              * FIXME: The array tchar[] was used uninitialized.
              * It's not clear to me the original purpose of the
              * piece of code using it. To be removed in future
              * versions.
              */

             tchar[0]=tchar[1];
             tchar[1]=tchar[2];
             tchar[2]=tchar[3];
             tchar[3] = (h << 4) + l;
             tchar[4]='\0';

             if (strncmp(tchar, "tcp:", 4) == 0)
             {
               local_buf[in-7]='1';
               local_buf[in-6]=strlen(port)+47;

               in++;
               local_buf[in]=pszReturnData[i-2];
               in++;
               local_buf[in]=pszReturnData[i-1];

               strcat(local_buf,"6c6f63616c686f73743a");
               in+=20;

               chport=&port[0];

               while(*chport!='\0')
               {
                 in++;
                 local_buf[in]=hex[(*chport >> 4) & 0xf];
                 in++;
                 local_buf[in]=hex[*chport & 0xf];
                 *chport++;
               }

               strcat(local_buf,"00");
               in+=2;

               while(pszReturnData[i]!='\n')
               {
                 i++;
               }
             }
             else
             {
               in++;
               local_buf[in]=pszReturnData[i-2];
               in++;
               local_buf[in]=pszReturnData[i-1];
             }
           }

           in++;
           local_buf[in]=pszReturnData[i];
        }

        in++;
      }

      local_buf[in]=0;

      if (strlen(local_buf))
      {
        extern int ChangeWindowProperty(WindowPtr pWin, Atom property, Atom type,
                                        int format, int mode, unsigned long len,
                                        pointer value, Bool sendevent);

        mcop_local_atom = MakeAtom(mcop_atom, strlen(mcop_atom), 1);
        ChangeWindowProperty(WindowTable[pScreen->myNum],
                             mcop_local_atom,
                             XA_STRING,
                             iReturnFormat, PropModeReplace,
                             strlen(local_buf), local_buf, 1);
      }

      xfree(local_buf);
    }
  }
}

#endif

Bool nxagentReconnectScreen(void*p0)
{
  CARD16 w, h;
  extern Drawable nxagentDefaultDrawables[];
  PixmapPtr pPixmap = (PixmapPtr)nxagentDummyScreen->devPrivate;
  int flexibility;
  Mask mask;

  flexibility = *(int*)p0;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_SCREEN_DEBUG)
  fprintf(stderr, "nxagentReconnectScreen\n");
#endif

  if (!nxagentOpenScreen(0, nxagentDummyScreen, nxagentArgc, nxagentArgv))
  {
    return False;
  }

  nxagentPixmap(pPixmap) = XCreatePixmap(nxagentDisplay, 
                                         nxagentDefaultWindows[ nxagentDummyScreen->myNum ],
                                         pPixmap -> drawable.width,
                                         pPixmap -> drawable.height,
                                         pPixmap -> drawable.depth);
#ifdef NXAGENT_RECONNECT_SCREEN_DEBUG
  fprintf(stderr, "nxagentReconnectScreen: recreated %p - ID %lx\n",
                   pPixmap,
                   nxagentPixmap( pPixmap ));
#endif
  w = 16;
  h = 16;
  (* nxagentDummyScreen->QueryBestSize)(StippleShape, &w, &h, nxagentDummyScreen);
  if (!(nxagentPixmap(nxagentDummyScreen->PixmapPerDepth[0]) =
       XCreatePixmap(nxagentDisplay, 
                     nxagentDefaultDrawables[1],
                     w, 
                     h, 
                     1)));

  nxagentGetDefaultEventMask(&mask);
  mask |= NXAGENT_KEYBOARD_EVENT_MASK | NXAGENT_POINTER_EVENT_MASK;
  nxagentSetDefaultEventMask(mask);
  XSelectInput(nxagentDisplay, nxagentDefaultWindows[0], mask);

  /*
   * Turn off the screen-saver and reset the
   * time to the next auto-disconnection.
   */

  SaveScreens(SCREEN_SAVER_OFF, ScreenSaverActive);

  lastDeviceEventTime.milliseconds = GetTimeInMillis();

  return True;  
}

int nxagentRRSetScreenConfig(ScreenPtr pScreen, int width, int height)
{
    rrScrPrivPtr pScrPriv;
    RRScreenSizePtr pSize;
    Rotation rotation;
    int rate;
    short oldWidth, oldHeight;
    int  mmWidth, mmHeight;
    int oldSize;
    RRScreenSizePtr oldSizes;

    extern int TellChanged (WindowPtr pWin, pointer value);

    pScrPriv = rrGetScrPriv(pScreen);
   
    oldWidth = pScreen->width;
    oldHeight = pScreen->height;
    
    if (!pScrPriv)
    {
      return 1;
    }

    if (!RRGetInfo (pScreen))
    {
      return 1;
    }

    rotation = RR_Rotate_0;

    rate = 0;

    mmWidth  = width * DisplayWidthMM(nxagentDisplay, DefaultScreen(nxagentDisplay)) /
                  DisplayWidth(nxagentDisplay, DefaultScreen(nxagentDisplay));

    mmHeight = height * DisplayHeightMM(nxagentDisplay, DefaultScreen(nxagentDisplay)) /
                   DisplayHeight(nxagentDisplay, DefaultScreen(nxagentDisplay));

    pSize = xalloc(sizeof(RRScreenSize));

    pSize -> width = width;
    pSize -> height = height;
    pSize -> mmWidth = mmWidth;
    pSize -> mmHeight = mmHeight;

    /*
     * call out to ddx routine to effect the change
     */

    if (!(*pScrPriv->rrSetConfig) (pScreen, rotation, rate,
                                       pSize))
    {
      /*
       * unknown DDX failure.
       */

      xfree(pSize);

      return 1;
    }

    /*
     * TellChanged uses this privates.
     */

    oldSize = pScrPriv->size;
    oldSizes = pScrPriv->pSizes;

    pScrPriv->size = 0;
    pScrPriv->pSizes = pSize;

    /*
     * Deliver ScreenChangeNotify events whenever
     * the configuration is updated
     */

    WalkTree (pScreen, TellChanged, (pointer) pScreen);

    /*
     * Deliver ConfigureNotify events when root changes
     * pixel size
     */

    if (oldWidth != pScreen->width || oldHeight != pScreen->height)
    {
      RRSendConfigNotify (pScreen);
    }

    RREditConnectionInfo (pScreen);
    
    /*
     * Fix pointer bounds and location
     */

    ScreenRestructured (pScreen);

    /*
     * Restore old privates.
     */

    pScrPriv->pSizes = oldSizes;
    pScrPriv->size = oldSize;

    xfree(pSize);

    return 0;
}
