/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include <unistd.h>

#include "X.h"
#include "Xproto.h"
#include "gcstruct.h"
#include "window.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "region.h"
#include "dixstruct.h"

#include "mi.h"

#include "Agent.h"
#include "Display.h"
#include "Screen.h"
#include "GC.h"
#include "Drawable.h"
#include "Color.h"
#include "Cursor.h"
#include "Visual.h"
#include "Events.h"
#include "Clipboard.h"
#include "Args.h"
#include "Trap.h"
#include "Rootless.h"
#include "Atoms.h"
#include "Control.h"
#include "Reconnect.h"
#include "Dialog.h"
#include "Splash.h"

#ifdef NXAGENT_BAKSTR
#include "Init.h"
#endif

#ifdef NXAGENT_VISIBILITY
#include NXAGENT_NXLIB_INCLUDE
#endif

#ifdef NXAGENT_SAFEMODE
extern int nxagentSafeMode;
#endif

int nxagentWindowPrivateIndex;

#ifdef NXAGENT_EXPOSURES
extern Bool nxagentAutoExposures;
#endif

#ifdef NXAGENT_REPARENT
WindowPtr nxagentRootWindow;
#endif

#ifdef NXAGENT_FORCEBACK
#include "Xatom.h"
#include "Window.h"
#endif

/*
 * Used to track nxagent window's visibility.
 */

int nxagentVisibility = VisibilityUnobscured;
unsigned long nxagentVisibilityTimeout = 0;
Bool nxagentVisibilityStop = False;

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

extern Window nxagentFullscreenWindow;
extern Window nxagentIconWindow;
extern Bool nxagentWMIsRunning;
extern Window nxagentCreateIconWindow(void);

extern void nxagentRootlessDelTopLevelWindow(WindowPtr pWin);

extern WindowPtr nxagentViewportFrameLeft;
extern WindowPtr nxagentViewportFrameRight;
extern WindowPtr nxagentViewportFrameAbove;
extern WindowPtr nxagentViewportFrameBelow;

extern Bool fbCreateWindow(WindowPtr);

extern void fbGetImage(DrawablePtr pDrawable, int x, int y, int w, int h,
                         unsigned int format, unsigned long planeMask, char *data);

extern int nxagentRRSetScreenConfig(ScreenPtr pScreen, int width, int height);

static void nxagentUpdateViewportFrame(int x, int y, int w, int h);

#define RECTLIMIT 25
Bool nxagentSynchronizationPending = False;

/*
 * Used to walk through the window hierarchy
 * to find a window
*/

typedef struct _WindowMatch
{
  WindowPtr pWin;
  Window    id;

} WindowMatchRec;

#ifdef NXAGENT_FORCEBACK

static char *blacklist[]=
{
    "mozilla",
    "Mozilla",
    NULL
};

extern Bool nxagentForceBackingStore;
extern unsigned long nxagentMaxAreaBackS;
extern unsigned long nxagentMinAreaBackS;
extern unsigned long nxagentMaxAreaBackS;
extern void nxagentSetBackingStore(WindowPtr, int);
extern void delbsQueue(WindowPtr pWin, nxbsQueuePtr pbsQueue);
extern nxbsQueuePtr pbsQueue;

#endif

extern char isItTimeToYield;
extern WindowPtr nxagentRootTileWindow;
extern void nxagentClearSplash(WindowPtr pWin);

/*
 * Also referenced in Events.c.
 */

int nxagentSplashCount = 0;

#ifdef NXAGENT_FORCEBACK

void nxagentSetBackingStore(WindowPtr pWin, int BackingStore)
{
    XSetWindowAttributes att;
    unsigned long mask = 0;

    att.backing_store = BackingStore;
    if(nxagentWindowPriv(pWin)->is_blacklisted)
    {
        BackingStore = NotUseful;
    }
    mask |= CWBackingStore;
    XChangeWindowAttributes(
                            nxagentDisplay,
                            nxagentWindow(pWin),
                            mask,
                            &att
                           );
    nxagentWindowPriv(pWin)->b_stored = BackingStore;
    nxagentWindowPriv(pWin)->bs_time = BackingStore?GetTimeInMillis()+2000:0;
    /*
    pWin->backingStore = BackingStore;
    pWin->drawable.pScreen->ChangeWindowAttributes(pWin, mask);
    */
#ifdef NXAGENT_FORCEBACK_DEBUG
    fprintf(stderr,
            "nxagentSetBackingStore: %x %i\n",
            nxagentWindow(pWin),
            pWin->backingStore
           );
    /*
    if(pWin->backingStore != NotUseful){
        pWin->borderWidth = 2;
    }
    else
    {
        pWin->borderWidth = 0;
    }
    nxagentConfigureWindow(pWin, CWBorderWidth);
    */
#endif
}


void blacklistChild(WindowPtr pWin)
{
    register WindowPtr pChild, pHead;

    pHead = RealChildHead(pWin);

    for (pChild = pWin->lastChild; pChild != pHead; pChild = pChild->prevSib)
    {
        blacklistChild(pChild);
    }
    nxagentWindowPriv(pWin)->is_blacklisted = True;
}


void nxagentIsBlacklistedforBS(WindowPtr pWin)
{
    if (pWin)
    {
        int           iReturn;
        unsigned long ulReturnItems;
        unsigned long ulReturnBytesLeft;
        Atom          atomReturnType;
        int           iReturnFormat;
        unsigned char *pszReturnData = NULL;
        char          *name;

        if(!(nxagentWindowPriv(pWin)->is_blacklisted))
        {
#ifdef NXAGENT_FORCEBACK_DEBUG
            fprintf(stderr,
                    "nxagentIsBlacklistedforBS: startfrom here for %x\n",
                    nxagentWindow(pWin),
                   );
#endif
            if(!(nxagentWindowPriv(pWin->parent)->is_blacklisted))
            {
                extern int GetWindowProperty(WindowPtr, Atom, long, long, Bool, Atom, Atom*, int*,
                                             unsigned long*, unsigned long*, unsigned char**);

                iReturn = GetWindowProperty(pWin, XA_WM_NAME,0,0, False,
                                            AnyPropertyType, &atomReturnType, &iReturnFormat,
                                            &ulReturnItems, &ulReturnBytesLeft, &pszReturnData);

                if(!iReturn && ulReturnBytesLeft>0)
                {
                    iReturn = GetWindowProperty(pWin, XA_WM_NAME, 0, ulReturnBytesLeft, False,
                                                AnyPropertyType, &atomReturnType, &iReturnFormat,
                                                &ulReturnItems, &ulReturnBytesLeft, &pszReturnData);
                    if(pszReturnData)
                    {
                        name = (char*)xalloc(ulReturnItems+1);
                        if(name)
                        {
                            int i=0;

                            strncpy(name, (char *) pszReturnData, ulReturnItems);
                            name[ulReturnItems] = 0;
                            for(i = 0; blacklist[i]; i++)
                            {
                                if(strstr(name ,blacklist[i]))
                                {
#ifdef NXAGENT_FORCEBACK_DEBUG
                                    fprintf(stderr,
                                            "nxagentIsBlacklistedforBS: disabling for %x coz called mozilla\n",
                                            nxagentWindow(pWin)
                                           );
#endif
                                    blacklistChild(pWin);
                                    nxagentWindowPriv(pWin)->is_blacklisted = True;
                                    break;
                                }
                            }
                            xfree(name);
                        }
                    }
                }
            }
            else
            {
#ifdef NXAGENT_FORCEBACK_DEBUG
                fprintf(stderr, "nxagentIsBlacklistedforBS: disabling for %x coz moz is parent\n",
                        nxagentWindow(pWin)
                       );
#endif
                nxagentWindowPriv(pWin)->is_blacklisted = True;
            }
        }
    }
}
#endif

WindowPtr nxagentGetWindowFromID(Window id)
{
  WindowPtr pWin = WindowTable[0];

  while (pWin && nxagentWindowPriv(pWin))
  {
    if (nxagentWindow(pWin) == id)
    {
      return pWin;
    }

    if (pWin -> nextSib)
    {
      pWin = pWin -> nextSib;
    }
    else
    {
      pWin = pWin -> firstChild;
    }
  }

  return NULL;
}

static int nxagentFindWindowMatch(WindowPtr pWin, pointer ptr)
{
  WindowMatchRec *match = (WindowMatchRec *) ptr;

  if (match -> id == nxagentWindow(pWin))
  {
    match -> pWin = pWin;

    return WT_STOPWALKING;
  }
  else
  {
    return WT_WALKCHILDREN;
  }
}

WindowPtr nxagentWindowPtr(Window window)
{
  int i;

  WindowMatchRec match;

  match.pWin = NullWindow;
  match.id   = window;

  for (i = 0; i < nxagentNumScreens; i++)
  {
    WalkTree(screenInfo.screens[i], nxagentFindWindowMatch, (pointer) &match);

    if (match.pWin) break;
  }

  return match.pWin;
}

Bool nxagentCreateWindow(pWin)
     WindowPtr pWin;
{
  unsigned long mask;
  XSetWindowAttributes attributes;
  Visual *visual;
  ColormapPtr pCmap;

  if (nxagentScreenTrap)
  {
    return True;
  }

  nxagentSplashCount++;

  if (nxagentSplashCount == 2)
  {
      nxagentClearSplash(nxagentRootTileWindow);
  }
#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "nxagentSplashCount: %d\n", nxagentSplashCount);
#endif

  if (pWin->drawable.class == InputOnly) {
    mask = CWEventMask;
    visual = CopyFromParent;
  }
  else {
    mask = CWEventMask | CWBackingStore;

#ifdef NXAGENT_BAKSTR
    mask |= CWBackingPlanes | CWBackingPixel;
    if (nxagentBackingStore != NotUseful)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->backingStore != NotUseful)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     backingstore on window: xu is: %u\n",
                    nxagentWindow(pWin), pWin->backingStore);
          }
#endif
        attributes.backing_store = pWin->backingStore;
        if (pWin->optional)
          {
            mask |= CWBackingPlanes | CWBackingPixel;
            attributes.backing_planes = pWin->optional->backingBitPlanes;
            attributes.backing_pixel = pWin->optional->backingPixel;
          }
      }
    else
      {
        attributes.backing_store = NotUseful;
      }

    if (nxagentSaveUnder == True)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->saveUnder == True)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     saveunder on window: %x is: %u\n", nxagentWindow(pWin), pWin->saveUnder);
          }
#endif
        mask |= CWSaveUnder;
        attributes.save_under = pWin->saveUnder;
      }
#else /* NXAGENT_BAKSTR */
    attributes.backing_store = NotUseful;
#endif
#if defined(NXAGENT_FORCEBACK) || defined(NXAGENT_INTERNALBS)
    nxagentWindowPriv(pWin)->visible = 0;
    nxagentWindowPriv(pWin)->b_stored = 0;
    nxagentWindowPriv(pWin)->bs_time = 0;
    nxagentWindowPriv(pWin)->unexposed = 1;
    nxagentWindowPriv(pWin)->drawableLazy.status = DRAWABLE_SYNCHRONIZED;
    nxagentWindowPriv(pWin)->drawableLazy.placeholderDrawn = False;
#endif
#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {
        if(attributes.backing_store != NotUseful){
            nxagentWindowPriv(pWin)->native_bs = True;
        }
        else{
            nxagentWindowPriv(pWin)->native_bs = False;
        }
        /*XXX*/
        if(!(nxagentWindowPriv(pWin)->native_bs))
        {
            nxagentWindowPriv(pWin)->area = pWin->drawable.width *
                pWin->drawable.height;
            if(nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
            {
                nxagentWindowPriv(pWin)->is_bscandidate = True;
            }
            else
            {
                nxagentWindowPriv(pWin)->is_bscandidate = False;
            }
        }
    }
#endif
    if (pWin->parent) {
      if (pWin->optional && pWin->optional->visual != wVisual(pWin->parent)) {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        if (pWin->optional->colormap) {
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          attributes.colormap = nxagentColormap(pCmap);
        }
        else
          attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
      else if (pWin->optional)
       visual = CopyFromParent;
      else {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
    }
    else { /* root windows have their own colormaps at creation time */
      visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
      pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
      mask |= CWColormap;
      attributes.colormap = nxagentColormap(pCmap);
#ifdef NXAGENT_REPARENT
      /* beware of moultiple roots (screens) */
      nxagentRootWindow = pWin;
      nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
      nxagentWindowPriv(pWin)->window = (int)NULL;
      return;
#endif
    }
  }

#ifdef NXAGENT_REPARENT
  if ((pWin)->parent == nxagentRootWindow)
    {
      /* visual CopyFromParent does not work if parent is root */
      if (visual == CopyFromParent)
        {
          visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          mask |= CWColormap;
          attributes.colormap = nxagentColormap(pCmap);
        }
      mask &= ~CWEventMask;
      mask |= CWColormap;
    }

  if (pWin != nxagentRootWindow)
    {
      mask |= CWEventMask;
    }

#endif

  if (mask & CWEventMask)
  {
    nxagentGetEventMask(pWin, (Mask*)&attributes.event_mask);
  }
  #ifdef WARNING
  else
  {
    attributes.event_mask = NoEventMask;
  }
  #endif

#ifdef NXAGENT_FORCEBACK
  if(nxagentForceBackingStore){
      nxagentWindowPriv(pWin)->event_mask = attributes.event_mask;
      nxagentWindowPriv(pWin)->is_blacklisted = False;
      nxagentWindowPriv(pWin)->enqueued = 0;
  }
#endif

  /*
   * Select the event mask if window is a top level
   * window. This at least makes the keyboard barely
   * work.
   */

  #ifdef TEST
  fprintf(stderr, "nxagentCreateWindow: Going to create new window.\n");
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentCreateWindow: Creating %swindow at %p current event mask = %lX mask & CWEventMask = %ld "
              "event_mask = %lX\n",
                  nxagentWindowTopLevel(pWin) ? "toplevel " : "", (void*)pWin, pWin -> eventMask,
                      mask & CWEventMask, attributes.event_mask);
  #endif

  nxagentWindowPriv(pWin)->window = XCreateWindow(nxagentDisplay,
                                                  nxagentWindowParent(pWin),
                                                  pWin->origin.x -
                                                  wBorderWidth(pWin),
                                                  pWin->origin.y -
                                                  wBorderWidth(pWin),
                                                  pWin->drawable.width,
                                                  pWin->drawable.height,
                                                  pWin->borderWidth,
                                                  pWin->drawable.depth,
                                                  pWin->drawable.class,
                                                  visual,
                                                  mask, &attributes);

  nxagentWindowPriv(pWin) -> received_expose_region =
      REGION_CREATE(pwin -> drawable.pScreen, NULL, 1);

  nxagentWindowPriv(pWin) -> sent_expose_region =
      REGION_CREATE(pwin -> drawable.pScreen, NULL, 1);

  nxagentWindowPriv(pWin) -> pending_expose_region =
      REGION_CREATE(pwin -> drawable.pScreen, NULL, 1);

  #ifdef TEST
  fprintf(stderr, "nxagentCreateWindow: Created new window with id [%ld].\n",
              nxagentWindowPriv(pWin)->window);
  #endif

  /*
   * We have to set the WM_DELETE_WINDOW protocols
   * on every top level window, because we don't know
   * if a client handles this.
   */

  if (nxagentOption(Rootless) && nxagentWindowTopLevel(pWin))
  {
    Atom prop = nxagentMakeAtom("WM_PROTOCOLS", strlen("WM_PROTOCOLS"), True);
    Atom atom = nxagentMakeAtom("WM_DELETE_WINDOW", strlen("WM_DELETE_WINDOW"), True);

    XSetWMProtocols(nxagentDisplay,
                        nxagentWindowPriv(pWin)->window,
                            &atom,
                                1);

    nxagentAddPropertyToList(prop, pWin);
  }

  nxagentWindowPriv(pWin)->x = pWin->origin.x - wBorderWidth(pWin);
  nxagentWindowPriv(pWin)->y = pWin->origin.y - wBorderWidth(pWin);
  nxagentWindowPriv(pWin)->width = pWin->drawable.width;
  nxagentWindowPriv(pWin)->height = pWin->drawable.height;
  nxagentWindowPriv(pWin)->border_width = pWin->borderWidth;
  nxagentWindowPriv(pWin)->sibling_above = None;
  nxagentWindowPriv(pWin)->pPicture = NULL;

#ifdef NXAGENT_FORCEBACK

  if (nxagentForceBackingStore)
  {
      if (nxagentRootTileWindow)
      {
          if (pWin)
          {
              nxagentIsBlacklistedforBS(pWin);
              if(nxagentWindowPriv(pWin)->native_bs){
                  if(!(nxagentWindowPriv(pWin)->is_blacklisted &&
                       nxagentWindowPriv(pWin)->area < nxagentMinAreaBackS) &&
                     nxagentWindowPriv(pWin)->area > nxagentMaxAreaBackS)
                  {
                      nxagentWindowPriv(pWin)->is_bscandidate = True;
                  }
                  else
                  {
                      nxagentWindowPriv(pWin)->is_bscandidate = False;
                  }
              }
          }
      }
  }
#endif

  if (nxagentRootTileWindow)
  {
      if (nxagentWindowPriv(pWin)->window != nxagentWindowPriv(nxagentRootTileWindow)->window)
      {
          XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
      }
  }
  if (pWin->nextSib)
  {
    nxagentWindowPriv(pWin->nextSib)->sibling_above = nxagentWindow(pWin);
  }

#ifdef NXAGENT_SHAPE2
#ifdef SHAPE
  nxagentWindowPriv(pWin)->bounding_shape = NULL;
  nxagentWindowPriv(pWin)->clip_shape = NULL;
#endif /* SHAPE */
#else
#ifdef SHAPE
  nxagentWindowPriv(pWin)->bounding_shape =
    REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
  nxagentWindowPriv(pWin)->clip_shape =
    REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
#endif /* SHAPE */
#endif

  fbCreateWindow(pWin);

  if (!pWin->parent) /* only the root window will have the right colormap */
    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);

  return True;
}

Bool nxagentSomeWindowsAreMapped()
{
  WindowPtr pWin = WindowTable[0] -> firstChild;

  while (pWin)
  {
    if (pWin -> mapped &&
            pWin -> drawable.class == InputOutput) 
    {
      return True;
    }

    pWin = pWin -> nextSib;
  }

  return False;
}

Bool nxagentDestroyWindow(pWin)
     WindowPtr pWin;
{
  int i;
  int j;

  i = nxagentSentExposuresIndex(pWin);

  if (i >= 0)
  {
    nxagentSentExposedWindows[i] = NULL;
  }

  j = nxagentPendingExposuresIndex(pWin);

  if (j >= 0)
  {
    nxagentPendingExposedWindows[j] = NULL;
  }
 
  if (nxagentScreenTrap)
  {
    return True;
  }

  nxagentClearClipboard(NULL, pWin);

#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {
        delbsQueue(pWin, pbsQueue);
    }
#endif
#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif
  if (pWin->nextSib)
  {
    nxagentWindowPriv(pWin->nextSib)->sibling_above =
      nxagentWindowPriv(pWin)->sibling_above;
  }
#ifdef NXAGENT_SHAPE2
#ifdef SHAPE
  if (nxagentWindowPriv(pWin)->bounding_shape)
    {
      REGION_DESTROY(pWin->drawable.pScreen,
                     nxagentWindowPriv(pWin)->bounding_shape);
    }

  if (nxagentWindowPriv(pWin)->clip_shape)
    {
      REGION_DESTROY(pWin->drawable.pScreen,
                     nxagentWindowPriv(pWin)->clip_shape);
    }
#endif
#else
  REGION_DESTROY(pWin->drawable.pScreen,
                 nxagentWindowPriv(pWin)->bounding_shape);
  REGION_DESTROY(pWin->drawable.pScreen,
                 nxagentWindowPriv(pWin)->clip_shape);
#endif

  if (nxagentWindowPriv(pWin)->received_expose_region)
  {
    REGION_DESTROY(pWin->drawable.pScreen,
                   nxagentWindowPriv(pWin)->received_expose_region);

    nxagentWindowPriv(pWin)->received_expose_region = NULL;
  }

  if (nxagentWindowPriv(pWin)->sent_expose_region)
  {
    REGION_DESTROY(pWin->drawable.pScreen,
                   nxagentWindowPriv(pWin)->sent_expose_region);

    nxagentWindowPriv(pWin)->sent_expose_region = NULL;
  }

  if (nxagentWindowPriv(pWin)->pending_expose_region)
  {
    REGION_DESTROY(pWin->drawable.pScreen,
                   nxagentWindowPriv(pWin)->pending_expose_region);

    nxagentWindowPriv(pWin)->pending_expose_region = NULL;
  }

  XDestroyWindow(nxagentDisplay, nxagentWindow(pWin));

  if (nxagentOption(Rootless))
  {
    nxagentRootlessDelTopLevelWindow(pWin);
  }

  nxagentSplashCount--;
#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "nxagentDestroyWindow: nxagentSplashCount: %d\n", nxagentSplashCount);
#endif

  if(nxagentSplashCount == 1 && !isItTimeToYield)
  {
      XClearWindow(nxagentDisplay, nxagentWindowPriv(nxagentRootTileWindow)->window);
  }

  if (pWin == nxagentRootTileWindow)
  {
      nxagentWindowPriv(nxagentRootTileWindow)->window = None;
      nxagentRootTileWindow = None;
  }

  nxagentWindowPriv(pWin)->window = None;

  if (pWin->optional && pWin->optional->colormap && pWin->parent)
    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);

  if (nxagentOption(Rootless) && nxagentRootlessDialogPid == 0 &&
          nxagentLastWindowDestroied == False && nxagentSomeWindowsAreMapped() == False)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentDestroyWindow: Last mapped window as been destroied.\n");
    #endif

    nxagentLastWindowDestroied = True;
    nxagentLastWindowDestroiedTime = GetTimeInMillis();
  }

  return True;
}

/*
 * Need this to test the configure-window
 * failure in rootless mode. Remove when
 * done.
 */

#ifdef TEST
#define MAKE_SYNC_CONFIGURE_WINDOW  XSync(nxagentDisplay, False)
#else
#define MAKE_SYNC_CONFIGURE_WINDOW
#endif

Bool nxagentPositionWindow(pWin, x, y)
     WindowPtr pWin;
     int x, y;
{
  if (nxagentScreenTrap)
  {
    return True;
  }

  /*
   * This is not only very inefficient (why don't we
   * just change the requested attributes?) but it
   * also seems to assume that the x and y coordina-
   * tes have been already written somewhere else.
   */

  #ifdef TEST 
  fprintf(stderr, "nxagentPositionWindow: Changing position of window [%p][%ld].\n",
              (void *) pWin, nxagentWindow(pWin));
  #endif

  nxagentConfigureWindow(pWin,
                         CWParent |
                         CWX | CWY |
                         CWWidth | CWHeight |
                         CWBorderWidth);

  return True;
}

void nxagentRestackWindow(pWin, pOldNextSib)
     WindowPtr pWin;
     WindowPtr pOldNextSib;
{
  if (nxagentScreenTrap)
  {
    return;
  }

  if (!pWin -> prevSib)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Raising window [%p][%ld].\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    XRaiseWindow(nxagentDisplay, nxagentWindow(pWin));
  }
  else if (!pWin -> nextSib)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Lowering window [%p][%ld].\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    XLowerWindow(nxagentDisplay, nxagentWindow(pWin));
  }
  else
  {
    Window windowList[2];

    #ifdef TEST
    fprintf(stderr, "nxagentRestackWindow: Putting window [%p][%ld] in the middle.\n",
                (void *) pWin, nxagentWindow(pWin));
    #endif

    windowList[0] = nxagentWindow(pWin->prevSib);
    windowList[1] = nxagentWindow(pWin);

    XRestackWindows(nxagentDisplay, windowList, 2);
  }

  return;
}

void nxagentSwitchFullscreen(ScreenPtr pScreen, Bool switch_on)
{
  Window w;
  XSetWindowAttributes attributes;
  unsigned long valuemask;
  extern void nxagentWMDetect();

  if (nxagentOption(Rootless))
  {
    return;
  }

  if (!switch_on)
  {
    nxagentWMDetect();

    if (!nxagentWMIsRunning)
    {
      #ifdef WARNING
      fprintf(stderr, "Warning: Can't switch to window mode, no window manager has been detected.\n");
      #endif

      return;
    }
  }

  w = nxagentDefaultWindows[pScreen -> myNum];
  attributes.override_redirect = switch_on;
  valuemask = CWOverrideRedirect;
  XUnmapWindow(nxagentDisplay, w);
  XChangeWindowAttributes(nxagentDisplay, w, valuemask, &attributes);

  if (switch_on)
  {
    /*
     * Change to fullscreen mode.
     */

    int i;
    XEvent e;

    /*
     * Wait for window manager reparenting the default window.
     */

    for (i = 0; i < 100 && nxagentWMIsRunning; i++)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentSwitchFullscreen: WARNING! Going to wait for the ReparentNotify event.\n");
      #endif

      if (XCheckTypedWindowEvent(nxagentDisplay, w, ReparentNotify, &e))
      {
        break;
      }

      XSync(nxagentDisplay, False);

      usleep(50000);
    }

    if (i < 100)
    {
      /*
       * The window manager has done with the reparent
       * operation. We can resize and map the window.
       */

      nxagentChangeOption(Fullscreen, True);

      /*
       * Save the window-mode configuration.
       */

      nxagentChangeOption(SavedX, nxagentOption(X));
      nxagentChangeOption(SavedY, nxagentOption(Y));
      nxagentChangeOption(SavedWidth, nxagentOption(Width));
      nxagentChangeOption(SavedHeight, nxagentOption(Height));
      nxagentChangeOption(SavedRootWidth, nxagentOption(RootWidth));
      nxagentChangeOption(SavedRootHeight, nxagentOption(RootHeight));

      /*
       * Reconf the Default window.
       */

      nxagentChangeOption(X, 0);
      nxagentChangeOption(Y, 0);
      nxagentChangeOption(Width, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
      nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));

      /*
       * Move the root window.
       */

      nxagentChangeOption(RootX, (nxagentOption(Width) - nxagentOption(RootWidth)) / 2);
      nxagentChangeOption(RootY, (nxagentOption(Height) - nxagentOption(RootHeight)) / 2);
      nxagentChangeOption(ViewportXSpan, nxagentOption(Width) - nxagentOption(RootWidth));
      nxagentChangeOption(ViewportYSpan, nxagentOption(Height) - nxagentOption(RootHeight));

      XMoveResizeWindow(nxagentDisplay, w, nxagentOption(X), nxagentOption(Y),
                            nxagentOption(Width), nxagentOption(Height));
      nxagentUpdateViewportFrame(0, 0, nxagentOption(RootWidth), nxagentOption(RootHeight));
      XMoveWindow(nxagentDisplay, nxagentWindow(WindowTable[pScreen -> myNum]),
                      nxagentOption(RootX), nxagentOption(RootY));

      /*
       * FIXME: We disable the screensaver when changing
       * mode to fullscreen. Is it really needed?
       */

      XSetScreenSaver(nxagentDisplay, 0, 0, DefaultExposures, DefaultBlanking);

      if (nxagentIconWindow == None)
      {
        nxagentIconWindow = nxagentCreateIconWindow();

        XMapWindow(nxagentDisplay, nxagentIconWindow);
      }

      XMapRaised(nxagentDisplay, w);
      XSetInputFocus(nxagentDisplay, w, RevertToParent, CurrentTime);
      XCheckTypedWindowEvent(nxagentDisplay, w, LeaveNotify, &e);
      nxagentFullscreenWindow = w;

      if (nxagentOption(DesktopResize))
      {
        nxagentRRSetScreenConfig(pScreen, WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)),
                                     HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
      }
    }
    else
    {
      /*
       * We have waited for a reparent event unsuccessfully.
       * Something happened to the window manager.
       */

      #ifdef WARNING
      fprintf(stderr, "nxagentSwitchFullscreen: WARNING! Expected ReparentNotify event missing.\n");
      #endif

      nxagentWMIsRunning = False;
      attributes.override_redirect = False;
      XChangeWindowAttributes(nxagentDisplay, w, valuemask, &attributes);
      XMapWindow(nxagentDisplay, w);
    }
  }
  else
  {
    /*
     * FIXME:
     * It could be necessary:
     * - To restore screensaver.
     * - To set or reset nxagentForceBackingStore flag.
     * - To grab keyboard.
     * - To propagate device settings to the X server if no WM is running.
     */

    /*
     * Change to windowed mode.
     */

    nxagentChangeOption(Fullscreen, False);
    XDestroyWindow(nxagentDisplay, nxagentIconWindow);
    nxagentIconWindow = nxagentFullscreenWindow = None;

    if (nxagentOption(DesktopResize) == 1)
    {
      nxagentChangeOption(RootWidth, nxagentOption(SavedRootWidth));
      nxagentChangeOption(RootHeight, nxagentOption(SavedRootHeight));
      nxagentRRSetScreenConfig(pScreen, nxagentOption(RootWidth), nxagentOption(RootHeight));
    }

    nxagentChangeOption(X, nxagentOption(SavedX));
    nxagentChangeOption(Y, nxagentOption(SavedY));
    nxagentChangeOption(Width, nxagentOption(SavedWidth));
    nxagentChangeOption(Height, nxagentOption(SavedHeight));

    XMoveResizeWindow(nxagentDisplay, w, nxagentOption(X), nxagentOption(Y),
                          nxagentOption(Width), nxagentOption(Height));
    nxagentUpdateViewportFrame(0, 0,
                                   nxagentOption(Width), nxagentOption(Height));
    XMoveWindow(nxagentDisplay, nxagentWindow(WindowTable[pScreen -> myNum]), 0, 0);
    XMapWindow(nxagentDisplay, w);

    nxagentChangeOption(RootX, 0);
    nxagentChangeOption(RootY, 0);
  }
}

void nxagentUpdateViewportFrame(int x, int y, int w, int h)
{
  /*
   * Four virtual windows make a frame around the viewport. We move the frame
   * with the viewport together. The areas going into the viewport were covered by
   * the frame and become exposed. This make the agent send expose events to his
   * clients.
   */

  XID values[3];
  Mask mask;

  /*
   * nxagentScreenTrap = True;
   */

  values[2] = Above;

  values[1] = nxagentOption(RootHeight);

  mask = CWX | CWHeight | CWStackMode;
  values[0] = x - NXAGENT_FRAME_WIDTH;
  ConfigureWindow(nxagentViewportFrameLeft, mask, (XID *) &values, serverClient);

  values[0] = x + w;
  ConfigureWindow(nxagentViewportFrameRight, mask, (XID *) &values, serverClient);

  values[1] = nxagentOption(RootWidth);

  mask = CWY | CWWidth | CWStackMode;
  values[0] = y - NXAGENT_FRAME_WIDTH;
  ConfigureWindow(nxagentViewportFrameAbove, mask, (XID *) &values, serverClient);

  values[0] = y + h;
  ConfigureWindow(nxagentViewportFrameBelow, mask, (XID *) &values, serverClient);

  /*
   * nxagentScreenTrap = False;
   */
}

void nxagentMoveViewport(ScreenPtr pScreen, int hShift, int vShift)
{
  int newX;
  int newY;

  Bool doMove = False;

  if (nxagentOption(Rootless))
  {
    return;
  }

  /*
   * We must keep x coordinate between viewportXSpan and zero, if viewportXSpan
   * is less then zero. If viewportXSpan is greater or equal to zero, it means
   * the agent root window has a size smaller than the agent default window.
   * In this case we keep the old coordinate.
   */

  if (nxagentOption(ViewportXSpan) < 0)
  {
    newX = nxagentOption(RootX) - hShift;

    if (newX > 0)
    {
      newX = 0;
    }
    else if (newX < nxagentOption(ViewportXSpan))
    {
      newX = nxagentOption(ViewportXSpan);
    }
  }
  else if (nxagentOption(ViewportXSpan) == 0)
  {
    newX = 0;
  }
  else
  {
    newX = nxagentOption(RootX);
  }

  if (nxagentOption(ViewportYSpan) < 0)
  {
    newY = nxagentOption(RootY) - vShift;

    if (newY > 0)
    {
      newY = 0;
    }
    else if (newY < nxagentOption(ViewportYSpan))
    {
      newY = nxagentOption(ViewportYSpan);
    }
  }
  else if (nxagentOption(ViewportYSpan) == 0)
  {
    newY = 0;
  }
  else
  {
    newY = nxagentOption(RootY);
  }

  if (newX != nxagentOption(RootX))
  {
    nxagentChangeOption(RootX, newX);

    doMove = True;
  }

  if (newY != nxagentOption(RootY))
  {
    nxagentChangeOption(RootY, newY);

    doMove = True;
  }

  if (doMove)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentMoveViewport: New viewport geometry: (%d, %d)-"
                "(%d, %d)\n", -nxagentOption(RootX), -nxagentOption(RootY),
                    -nxagentOption(RootX) + nxagentOption(Width),
                        -nxagentOption(RootY) + nxagentOption(Height));

    fprintf(stderr, "nxagentMoveViewport: Root geometry x=[%d] y=[%d]\n",
                WindowTable[0] -> drawable.x, WindowTable[0] -> drawable.y );
    #endif

    XMoveWindow(nxagentDisplay, nxagentWindow(WindowTable[pScreen -> myNum]),
                    nxagentOption(RootX), nxagentOption(RootY));
  }

  nxagentUpdateViewportFrame(-nxagentOption(RootX), -nxagentOption(RootY),
                                 nxagentOption(Width), nxagentOption(Height));

  nxagentSetSynchronizationPending(nxagentDisplay);
}

void nxagentConfigureWindow(pWin, mask)
     WindowPtr pWin;
     unsigned int mask;
{
  unsigned int valuemask;
  XWindowChanges values;

  if (nxagentScreenTrap)
  {
    return;
  }

  if (nxagentOption(Rootless) && nxagentWindowTopLevel(pWin))
  {
    mask &= ~(CWSibling | CWStackMode);
  }

  #ifdef TEST
  fprintf(stderr, "nxagentConfigureWindow: Called with window [%ld] and mask [%x].\n",
              nxagentWindow(pWin), mask);
  #endif

  #ifdef TEST
  if (nxagentScreenTrap)
  {
    fprintf(stderr, "nxagentConfigureWindow: WARNING: Called with nxagentScreenTrap = True.\n");
  }
  #endif

  #ifdef NXAGENT_REPARENT

  if (nxagentWindowPriv(pWin)->window == NULL)
  {
    return;
  }

  #endif

  valuemask = 0;

  if (mask & CWX &&
          nxagentWindowPriv(pWin)->x !=
              pWin->origin.x - wBorderWidth(pWin))
  {
    valuemask |= CWX;

    values.x = nxagentWindowPriv(pWin)->x = pWin->origin.x - wBorderWidth(pWin);
  }

  if (mask & CWY &&
          nxagentWindowPriv(pWin)->y !=
              pWin->origin.y - wBorderWidth(pWin))
  {
    valuemask |= CWY;

    values.y = nxagentWindowPriv(pWin)->y = pWin->origin.y - wBorderWidth(pWin);
  }

  if (mask & CWWidth &&
          nxagentWindowPriv(pWin)->width !=
              pWin->drawable.width)
  {
    valuemask |= CWWidth;

    #ifdef NXAGENT_FORCEBACK

    if (nxagentForceBackingStore)
    {
      nxagentIsBlacklistedforBS(pWin);
      nxagentWindowPriv(pWin)->area = pWin->drawable.width * pWin->drawable.height;

      if (!(nxagentWindowPriv(pWin)->is_blacklisted &&
              nxagentWindowPriv(pWin)->area > nxagentMinAreaBackS ) &&
                  nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
      {
        nxagentWindowPriv(pWin)->is_bscandidate = True;
      }
      else
      {
        nxagentWindowPriv(pWin)->is_bscandidate = False;
        nxagentSetBackingStore(pWin, NotUseful);
      }
    }

    #endif
    values.width = nxagentWindowPriv(pWin)->width = pWin->drawable.width;
  }

  if (mask & CWHeight &&
          nxagentWindowPriv(pWin)->height !=
              pWin->drawable.height)
  {
    valuemask |= CWHeight;

    #ifdef NXAGENT_FORCEBACK

    if (nxagentForceBackingStore)
    {
      nxagentIsBlacklistedforBS(pWin);
      nxagentWindowPriv(pWin)->area = pWin->drawable.width * pWin->drawable.height;

      if (!(nxagentWindowPriv(pWin)->is_blacklisted &&
               nxagentWindowPriv(pWin)->area > nxagentMinAreaBackS ) &&
                   nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
      {
        nxagentWindowPriv(pWin)->is_bscandidate = True;
      }
      else
      {
        nxagentWindowPriv(pWin)->is_bscandidate = False;
        nxagentSetBackingStore(pWin, NotUseful);
      }
    }

    #endif

    values.height = nxagentWindowPriv(pWin)->height = pWin->drawable.height;
  }

  if (mask & CWBorderWidth &&
          nxagentWindowPriv(pWin)->border_width !=
              pWin->borderWidth)
  {
    valuemask |= CWBorderWidth;

    values.border_width = nxagentWindowPriv(pWin)->border_width = pWin->borderWidth;
  }

  if (valuemask)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentConfigureWindow: Going to configure window [%ld] with mask [%x].\n",
                nxagentWindow(pWin), valuemask);
    #endif

    XConfigureWindow(nxagentDisplay, nxagentWindow(pWin), valuemask, &values);

    MAKE_SYNC_CONFIGURE_WINDOW;
  }

  if (mask & CWStackingOrder &&
          nxagentWindowPriv(pWin)->sibling_above !=
              nxagentWindowSiblingAbove(pWin))
  {
    WindowPtr pSib;

    /*
     * Find the top sibling.
     */

    for (pSib = pWin; pSib->prevSib != NullWindow; pSib = pSib->prevSib);

    /*
     * Configure the top sibling.
     */

    valuemask = CWStackMode;

    values.stack_mode = Above;

    if (nxagentSplashWindow)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentConfigureWindow: Going to remove the splash window.\n");
      #endif

      nxagentRemoveSplashWindow(NULL);

      MAKE_SYNC_CONFIGURE_WINDOW;
    }

    #ifdef TEST
    fprintf(stderr, "nxagentConfigureWindow: Going to configure top sibling [%ld] "
                "with mask [%x] and parent [%ld].\n", nxagentWindow(pSib),
                    valuemask, nxagentWindowParent(pWin));
    #endif

    XConfigureWindow(nxagentDisplay, nxagentWindow(pSib), valuemask, &values);

    MAKE_SYNC_CONFIGURE_WINDOW;

    nxagentWindowPriv(pSib)->sibling_above = None;

    /*
     * Configure the rest of siblings.
     */

    valuemask = CWSibling | CWStackMode;

    values.stack_mode = Below;

    for (pSib = pSib->nextSib; pSib != NullWindow; pSib = pSib->nextSib)
    {
      values.sibling = nxagentWindowSiblingAbove(pSib);

      #ifdef TEST
      fprintf(stderr, "nxagentConfigureWindow: Going to configure other sibling [%ld] "
                  "with mask [%x] and parent [%ld] below [%ld].\n", nxagentWindow(pSib),
                      valuemask, nxagentWindowParent(pWin), nxagentWindowSiblingAbove(pSib));
      #endif

      XConfigureWindow(nxagentDisplay, nxagentWindow(pSib), valuemask, &values);

      MAKE_SYNC_CONFIGURE_WINDOW;

      nxagentWindowPriv(pSib)->sibling_above = nxagentWindowSiblingAbove(pSib);
    }

    #ifdef TEST
    {
      Window root_return;
      Window parent_return;
      Window *children_return;
      unsigned int nchildren_return;
      Window *pw;

      XQueryTree(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                     &root_return, &parent_return, &children_return, &nchildren_return);

      pw = children_return;

      fprintf(stderr, "nxagentConfigureWindow: Children of the root: ");
      while(nchildren_return > 0)
      {
        pSib = nxagentWindowPtr(children_return[--nchildren_return]);
        if (pSib)
        {
          fprintf(stderr, "%lu  ", children_return[nchildren_return]);
        }
      }
      fprintf(stderr, "\n");

      if (children_return)
      {
        XFree(children_return);
      }
    }
    #endif
  }

  #ifdef NXAGENT_SPLASH

  /*
   * This should bring again the splash window
   * on top, so why the else clause? Is this
   * really needed?
   */

  else if (mask & CWStackingOrder)
  {
    extern Window nxagentSplashWindow;

    if (nxagentSplashWindow)
    {
      valuemask = CWStackMode;

      values.stack_mode = Above;

      #ifdef TEST
      fprintf(stderr, "nxagentConfigureWindow: Going to configure splash window [%ld].\n",
                  nxagentSplashWindow);
      #endif

      XConfigureWindow(nxagentDisplay, nxagentSplashWindow, valuemask, &values);

      MAKE_SYNC_CONFIGURE_WINDOW;
    }
  }

  #endif
}

void nxagentReparentWindow(pWin, pOldParent)
     WindowPtr pWin;
     WindowPtr pOldParent;
{
  if (nxagentScreenTrap)
  {
    return;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentReparentWindow:  window at %p [%lx] previous parent at %p [%lx].\n",
              (void*)pWin, nxagentWindow(pWin),
                  (void*)pOldParent, nxagentWindow(pOldParent));
  #endif

  XReparentWindow(nxagentDisplay, nxagentWindow(pWin),
                      nxagentWindowParent(pWin),
                          pWin->origin.x - wBorderWidth(pWin),
                              pWin->origin.y - wBorderWidth(pWin));
}

Bool nxagentChangeWindowAttributes(pWin, mask)
     WindowPtr pWin;
     unsigned long mask;
{
  XSetWindowAttributes attributes;

  if (nxagentScreenTrap)
  {
    return True;
  }

#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  if (mask & CWBackPixmap)
    switch (pWin->backgroundState) {
    case None:
        attributes.background_pixmap = None;
        attributes.background_pixel = nxagentWhitePixel;
      break;

    case ParentRelative:
      attributes.background_pixmap = ParentRelative;
      break;

    case BackgroundPixmap:
      attributes.background_pixmap = nxagentPixmap(pWin->background.pixmap);
      break;

    case BackgroundPixel:
      mask &= ~CWBackPixmap;
      break;
    }

  if (mask & CWBackPixel) {
    if (pWin->backgroundState == BackgroundPixel)
      attributes.background_pixel = nxagentPixel(pWin->background.pixel);
    else
      mask &= ~CWBackPixel;
  }

  if (mask & CWBorderPixmap) {
    if (pWin->borderIsPixel)
      mask &= ~CWBorderPixmap;
    else
      attributes.border_pixmap = nxagentPixmap(pWin->border.pixmap);
  }

  if (mask & CWBorderPixel) {
    if (pWin->borderIsPixel)
      attributes.border_pixel = nxagentPixel(pWin->border.pixel);
    else
      mask &= ~CWBorderPixel;
  }

  if (mask & CWBitGravity)
    attributes.bit_gravity = pWin->bitGravity;

  if (mask & CWWinGravity) /* dix does this for us */
    mask &= ~CWWinGravity;

#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingStore)
    {  /*
        if ((nxagentBackingStore == NotUseful))
        mask &= ~CWBackingStore;
      else
        { */
          attributes.backing_store = pWin->backingStore;
          /* this is really useful */
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingstore for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

       /* }*/
    }
#else
  if (mask & CWBackingStore) /* this is really not useful */
    mask &= ~CWBackingStore;
#endif
#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingPlanes)
    {
      if ((nxagentBackingStore == NotUseful) || (!pWin->optional))
        mask &= ~CWBackingPlanes;
      else
        {
          attributes.backing_planes = pWin->optional->backingBitPlanes;
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingplanes for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

        }
    }
#else
  if (mask & CWBackingPlanes) /* this is really not useful */
    mask &= ~CWBackingPlanes;
#endif

#ifdef NXAGENT_BAKSTR
  if (mask & CWBackingPixel)
    {
      if ((nxagentBackingStore == NotUseful) || (!pWin->optional))
        mask &= ~CWBackingPixel;
      else
        {
          attributes.backing_pixel = pWin->optional->backingPixel;
#ifdef NXAGENT_BAKSTR_DEBUG
          fprintf(stderr, "Configuring backingpixel for window: %X, value: %d\n",
                  nxagentWindow(pWin), pWin->backingStore);
#endif

        }
    }
#else /* NXAGENT_BAKSTR */
  if (mask & CWBackingPixel) /* this is really not useful */
    mask &= ~CWBackingPixel;
#endif /* NXAGENT_BAKSTR */

  if (mask & CWOverrideRedirect)
    attributes.override_redirect = pWin->overrideRedirect;

#ifdef NXAGENT_BAKSTR
  if (mask & CWSaveUnder)
  { /*
    if(nxagentSaveUnder == False)
      mask &= ~CWSaveUnder;
    else
      {*/
        attributes.save_under = pWin->saveUnder;
#ifdef NXAGENT_BAKSTR_DEBUG
        fprintf(stderr, "Configuring saveunder for window: %X, value: %d\n",
                nxagentWindow(pWin), pWin->saveUnder);
#endif
    /*  }*/
  }
#else
  if (mask & CWSaveUnder) /* this is really not useful */
    mask &= ~CWSaveUnder;
#endif

#ifdef NXAGENT_REPARENT
  if (mask & CWEventMask)
    {
      /* We always need some events */

      nxagentGetEventMask(pWin, &attributes.event_mask);

/*       mask &= ~CWEventMask; */
    }
#else
  if (mask & CWEventMask) /* events are handled elsewhere */
    mask &= ~CWEventMask;
#endif

  if (mask & CWDontPropagate) /* events are handled elsewhere */
    mask &= ~CWDontPropagate;

  if (mask & CWColormap) {
    ColormapPtr pCmap;

    pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);

    attributes.colormap = nxagentColormap(pCmap);

    nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
  }

  if (mask & CWCursor)
  {
    if (nxagentOption(Rootless))
    {
      if (pWin->cursorIsNone == False &&
             pWin->optional &&
                 pWin->optional->cursor &&
                     nxagentCursorPriv(pWin->optional->cursor, pWin->drawable.pScreen))
      {
        attributes.cursor = nxagentCursor(pWin->optional->cursor, pWin->drawable.pScreen);
      }
      else
      {
        attributes.cursor = None;
      }
    }
    else /* this is handled in cursor code */
    {
      mask &= ~CWCursor;
    }
  }

  if (mask)
  {
    XChangeWindowAttributes(nxagentDisplay, nxagentWindow(pWin),
                            mask, &attributes);
 }

  return True;
}

Bool nxagentRealizeWindow(pWin)
     WindowPtr pWin;
{
  if (nxagentScreenTrap)
  {
    return True;
  }

#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  nxagentConfigureWindow(pWin, CWStackingOrder);

#ifdef SHAPE
  nxagentShapeWindow(pWin);
#endif /* SHAPE */

  /*
   * Mapping of the root window is called by
   * InitRootWindow in DIX. Skip the operation
   * if we are in rootless mode.
   */

  if (!nxagentOption(Rootless) ||
          nxagentRootlessWindow != pWin)
  {
    XMapWindow(nxagentDisplay, nxagentWindow(pWin));
  }

  #ifdef WARNING
  if (nxagentOption(Rootless) && nxagentLastWindowDestroied)
  {
    fprintf(stderr, "nxagentRealizeWindow: Window realized. Stopped termination for rootless session.\n");
  }
  #endif

  nxagentLastWindowDestroied = False;

  return True;
}

Bool nxagentUnrealizeWindow(pWin)
    WindowPtr pWin;
{
  if (nxagentScreenTrap)
  {
    return True;
  }

#ifdef NXAGENT_REPARENT
  if (nxagentWindowPriv(pWin)->window == NULL)
    return;
#endif

  XUnmapWindow(nxagentDisplay, nxagentWindow(pWin));

#ifdef NXAGENT_INTERNALBS
  /*nxagentWindowPriv(pWin)->unexposed = 1;*/
#endif

  return True;
}

void nxagentFrameBufferPaintWindow(WindowPtr pWin, RegionPtr pRegion, int what)
{
  extern void fbPaintWindow(WindowPtr, RegionPtr, int);

  if (pWin->backgroundState == BackgroundPixmap)
  {
    pWin->background.pixmap = nxagentVirtualPixmap(pWin->background.pixmap);
  }

  if (pWin->borderIsPixel == False)
  {
    pWin->background.pixmap = nxagentVirtualPixmap(pWin->background.pixmap);
  }

  pWin->drawable.pScreen -> PaintWindowBackground = nxagentFrameBufferPaintWindow;
  fbPaintWindow(pWin, pRegion, what);
  pWin->drawable.pScreen -> PaintWindowBackground = nxagentPaintWindowBackground;

  if (pWin->backgroundState == BackgroundPixmap)
  {
    pWin->background.pixmap = nxagentRealPixmap(pWin->background.pixmap);
  }

  if (pWin->borderIsPixel == False)
  {
    pWin->background.pixmap = nxagentRealPixmap(pWin->background.pixmap);
  }
}

void nxagentPaintWindowBackground(pWin, pRegion, what)
     WindowPtr pWin;
     RegionPtr pRegion;
     int what;
{
  int i;
  BoxPtr pBox;

#ifdef NXAGENT_CONFWINOPTIMIZE
  if (nxagentSafeMode == True)
  {
    nxagentConfigureWindow(pWin, CWWidth | CWHeight);
  }
#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
  else
  {
    fprintf(stderr, "nxagentPaintWindowBackground: Suppressing nxagentConfigureWindow() for window [%ld].\n",
                nxagentWindow(pWin));
  }
#endif
#else
  nxagentConfigureWindow(pWin, CWWidth | CWHeight);
#endif

  pBox = REGION_RECTS(pRegion);
  for (i = 0; i < REGION_NUM_RECTS(pRegion); i++)
  {
    XClearArea(nxagentDisplay, nxagentWindow(pWin),
               pBox[i].x1 - pWin->drawable.x,
               pBox[i].y1 - pWin->drawable.y,
               pBox[i].x2 - pBox[i].x1,
               pBox[i].y2 - pBox[i].y1,
               False);
  }

  if (nxagentUsesFrameBuffer(wClient(pWin)))
  {
    nxagentFrameBufferPaintWindow(pWin, pRegion, what);
  }
}

void nxagentPaintWindowBorder(pWin, pRegion, what)
     WindowPtr pWin;
     RegionPtr pRegion;
     int what;
{
#ifdef NXAGENT_CONFWINOPTIMIZE
  if (nxagentSafeMode == True)
  {
    nxagentConfigureWindow(pWin, CWBorderWidth);
  }
#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
  else
  {
    fprintf(stderr, "nxagentPaintWindowBorder: Suppressing nxagentConfigureWindow() for window [%ld].\n",
                nxagentWindow(pWin));
  }
#endif
#else
  nxagentConfigureWindow(pWin, CWBorderWidth);
#endif
}

void nxagentCopyWindow(pWin, oldOrigin, oldRegion)
     WindowPtr pWin;
     xPoint oldOrigin;
     RegionPtr oldRegion;
{
    /*miWindowExposures(pWin, oldRegion, NullRegion);*/
}

void nxagentClipNotify(pWin, dx, dy)
     WindowPtr pWin;
     int dx, dy;
{
  nxagentConfigureWindow(pWin, CWStackingOrder);
#if defined(NXAGENT_INTERNALBS) && defined(NXAGENT_FORCEBACK)
  nxagentWindowPriv(pWin)->unexposed = 1;
#endif
#ifdef NXAGENT_SHAPE
  return;
#else

#ifdef SHAPE
  nxagentShapeWindow(pWin);
#endif /* SHAPE */

#endif /* NXAGENT_SHAPE */
}

void nxagentWindowExposures(pWin, pRgn, other_exposed)
     WindowPtr pWin;
     RegionPtr pRgn, other_exposed;
{
/*
 * The problem: we want to synthetize expose events internally, so that
 * we reduce the latency, but at the same time we need the remote expo-
 * sures, as we need to handle those cases where our windows are covered
 * by other windows on the real display. In order to avoid the annoying
 * "double refreshes", we must be able to identify which events have been
 * already sent to our clients.
 * 
 * Here is how the algorithm is working:
 * 
 * - We collect the exposures that the agent sent to its clients in a
 *   region (the "front-region") and attach the region to the privates
 *   of each window.
 * 
 * - Another region collects the expose that were received from the real
 *   X server (the "remote-region").
 * 
 * - We send a GetInputFocus request to the real X server after each
 *   operation that is going to generate an exposure (e.g. a Configure-
 *   Window or an UnmapWindow).
 * 
 * - Just after having sent the GetInputFocus request, we initialize a
 *   new region (the "back-region"), where we collect the new exposures
 *   which will be synchronized at later time.
 * 
 * - When the GetInputFocus reply is received, we calculate the diffe-
 *   rence between the "remote-region" and the "front-region" for each
 *   window that had collected exposures, and send the exposures for the
 *   resulting region to our clients.
 * 
 * - The other region (the "back-region) now becomes the "front-region".
 * 
 * As you might have guessed, the GetInputFocus request is needed to
 * ensure that all the exposures generated between our internal exposure
 * and the exposures generated by the real X server end up in the same
 * set of regions, so that the union is only comprised of the events that
 * were generated remotely. This GetInputFocus request is sent asynchro-
 * nously, using the nxcompext interfaces, so it doesn't affect in any
 * way the agent's performance.
 */

  RegionRec temp;
  RegionPtr sentRegion, pendingRegion;
  BoxRec box;

  if (nxagentSessionState != SESSION_DOWN)
  {
    if (REGION_NUM_RECTS(pRgn) > RECTLIMIT)
    {
      box = *REGION_EXTENTS(pWin -> drawable.pScreen, pRgn);

      REGION_EMPTY(pWin -> drawable.pScreen, pRgn);
      REGION_INIT(pWin->drawable.pScreen, pRgn, &box, 1);
    }

    REGION_INIT(pWin -> drawable.pScreen, &temp, (BoxRec *) NULL, 1);

    if (pRgn)
    {
      REGION_UNION(pWin -> drawable.pScreen, &temp, &temp, pRgn);
    }

    if (other_exposed)
    {
      REGION_UNION(pWin -> drawable.pScreen, &temp, &temp, other_exposed);
    }

    if (!REGION_NIL(&temp))
    {
      REGION_TRANSLATE(pWin -> drawable.pScreen, &temp,
                           -(pWin -> drawable.x), -(pWin -> drawable.y));

      if (nxagentSynchronizationPending == True)
      {
        pendingRegion = nxagentWindowPriv(pWin) -> pending_expose_region;

        if (nxagentPendingExposedNum == 0 || nxagentPendingExposuresIndex(pWin) < 0)
        {
          nxagentPendingExposedWindows[nxagentPendingExposedNum++] = pWin;
        }

        REGION_UNION(pWin -> drawable.pScreen, pendingRegion, pendingRegion, &temp);

        if (nxagentPendingExposedNum >= PENDING_EXPOSED_SIZE)
        {
          #ifdef WARNING
          fprintf(stderr, "nxagentWindowExposures: WARNING! Reached maximum size "
                      "of pending exposures vector.\n");
          #endif

          nxagentSynchronizeExpose();
        }
      }
      else
      {
        sentRegion = nxagentWindowPriv(pWin) -> sent_expose_region;

        if (nxagentSentExposedNum == 0 || nxagentSentExposuresIndex(pWin) < 0)
        {
          nxagentSentExposedWindows[nxagentSentExposedNum++] = pWin;
        }

        REGION_UNION(pWin -> drawable.pScreen, sentRegion, sentRegion, &temp);

        if (nxagentSentExposedNum >= PENDING_EXPOSED_SIZE - 1)
        {
          #ifdef WARNING
          fprintf(stderr, "nxagentWindowExposures: WARNING! Reached maximum size of sent exposures vector.\n");
          #endif

          nxagentSynchronizeExpose();
        }
      }
    }

    REGION_UNINIT(pWin -> drawable.pScreen, &temp);
  }

  miWindowExposures(pWin, pRgn, other_exposed);

  return;
}

#ifdef SHAPE
static Bool nxagentRegionEqual(pReg1, pReg2)
     RegionPtr pReg1, pReg2;
{
  BoxPtr pBox1, pBox2;
  unsigned int n1, n2;

  if (pReg1 == pReg2) return True;

  if (pReg1 == NullRegion || pReg2 == NullRegion) return False;

  pBox1 = REGION_RECTS(pReg1);
  n1 = REGION_NUM_RECTS(pReg1);

  pBox2 = REGION_RECTS(pReg2);
  n2 = REGION_NUM_RECTS(pReg2);

  if (n1 != n2) return False;

  if (pBox1 == pBox2) return True;

  if (memcmp(pBox1, pBox2, n1 * sizeof(BoxRec))) return False;

  return True;
}

void nxagentShapeWindow(pWin)
     WindowPtr pWin;
{
  Region reg;
  BoxPtr pBox;
  XRectangle rect;
  int i;

  if (NXDisplayError(nxagentDisplay)) return;

#ifdef NXAGENT_SHAPE2_DEBUG
      fprintf(stderr, "nxagentShapeWindow, win: %d\n", nxagentWindow(pWin));
#endif

  if (!nxagentRegionEqual(nxagentWindowPriv(pWin)->bounding_shape,
                        wBoundingShape(pWin)))
    {
#ifdef NXAGENT_SHAPE2_DEBUG
      fprintf(stderr, "Bounding shapes differ\n", nxagentWindow(pWin));
#endif
      if (wBoundingShape(pWin))
        {
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "wBounding shape exists\n", nxagentWindow(pWin));
#endif

#ifdef NXAGENT_SHAPE2
          if (!nxagentWindowPriv(pWin)->bounding_shape)
            {
              nxagentWindowPriv(pWin)->bounding_shape =
                REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
            }
#endif
          REGION_COPY(pWin->drawable.pScreen,
                      nxagentWindowPriv(pWin)->bounding_shape, wBoundingShape(pWin));

          reg = XCreateRegion();
          pBox = REGION_RECTS(nxagentWindowPriv(pWin)->bounding_shape);
          for (i = 0;
               i < REGION_NUM_RECTS(nxagentWindowPriv(pWin)->bounding_shape);
               i++)
            {
              rect.x = pBox[i].x1;
              rect.y = pBox[i].y1;
              rect.width = pBox[i].x2 - pBox[i].x1;
              rect.height = pBox[i].y2 - pBox[i].y1;
              XUnionRectWithRegion(&rect, reg, reg);
            }
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "nxagentShapeWindow, first loop called: %d times\n", i);
#endif


#ifndef NXAGENT_SHAPE
          XShapeCombineRegion(nxagentDisplay, nxagentWindow(pWin),
                              ShapeBounding, 0, 0, reg, ShapeSet);
#endif
          XDestroyRegion(reg);
        }
      else
        {
          REGION_EMPTY(pWin->drawable.pScreen,
                       nxagentWindowPriv(pWin)->bounding_shape);
#ifndef NXAGENT_SHAPE
          XShapeCombineMask(nxagentDisplay, nxagentWindow(pWin),
                            ShapeBounding, 0, 0, None, ShapeSet);
#endif
        }
    }

  if (!nxagentRegionEqual(nxagentWindowPriv(pWin)->clip_shape,
                        wClipShape(pWin)))
    {

      if (wClipShape(pWin))
        {
#ifdef NXAGENT_SHAPE2
          if (!nxagentWindowPriv(pWin)->clip_shape)
            {
              nxagentWindowPriv(pWin)->clip_shape =
                REGION_CREATE(pWin->drawable.pScreen, NULL, 1);
            }
#endif
          REGION_COPY(pWin->drawable.pScreen,
                      nxagentWindowPriv(pWin)->clip_shape, wClipShape(pWin));

          reg = XCreateRegion();
          pBox = REGION_RECTS(nxagentWindowPriv(pWin)->clip_shape);
          for (i = 0;
               i < REGION_NUM_RECTS(nxagentWindowPriv(pWin)->clip_shape);
               i++)
            {
              rect.x = pBox[i].x1;
              rect.y = pBox[i].y1;
              rect.width = pBox[i].x2 - pBox[i].x1;
              rect.height = pBox[i].y2 - pBox[i].y1;
              XUnionRectWithRegion(&rect, reg, reg);
            }
#ifdef NXAGENT_SHAPE2_DEBUG
          fprintf(stderr, "nxagentShapeWindow, first loop called: %d times\n", i);
#endif

#ifndef NXAGENT_SHAPE
          XShapeCombineRegion(nxagentDisplay, nxagentWindow(pWin),
                              ShapeClip, 0, 0, reg, ShapeSet);
#endif
          XDestroyRegion(reg);
        }
      else
        {
          REGION_EMPTY(pWin->drawable.pScreen,
                       nxagentWindowPriv(pWin)->clip_shape);
#ifndef NXAGENT_SHAPE
          XShapeCombineMask(nxagentDisplay, nxagentWindow(pWin),
                            ShapeClip, 0, 0, None, ShapeSet);
#endif
        }
    }
}
#endif /* SHAPE */

static int nxagentForceExposure(pWin, ptr)
WindowPtr pWin;
     pointer ptr;
{
    RegionPtr exposedRgn;
    BoxRec Box;
    WindowPtr pRoot = WindowTable[pWin->drawable.pScreen->myNum];

    if (pWin -> drawable.class != InputOnly)
    {
      Box.x1 = pWin->drawable.x;
      Box.y1 = pWin->drawable.y;
      Box.x2 = Box.x1 + pWin->drawable.width;
      Box.y2 = Box.y1 + pWin->drawable.height;

      exposedRgn = REGION_CREATE(pWin->drawable.pScreen, &Box, 1);
      REGION_INTERSECT(pWin->drawable.pScreen, exposedRgn, exposedRgn, &pRoot->winSize);
      miWindowExposures(pWin, exposedRgn, NullRegion);
      REGION_DESTROY(pWin->drawable.pScreen, exposedRgn);
/*
    miMarkWindow(pWin);
*/  }

    return WT_WALKCHILDREN;
}



void nxagentRefreshWindows(WindowPtr pWin)
{
   int action = 1;
   TraverseTree(pWin, nxagentForceExposure, &action);
/*   miHandleValidateExposures(pWin);*/
}

Bool nxagentReconnectAllWindow(void*);
Bool nxagentDisconnectAllWindow(void);
static void nxagentTraverseWindow(WindowPtr, void(*)(pointer, XID, pointer), pointer);
static void nxagentDisconnectWindow(pointer, XID, pointer);
static Bool nxagentLoopOverWindows(void(*)(pointer, XID, pointer));
static void nxagentReconfigureWindowCursor(pointer, XID, pointer);
static void nxagentReconnectWindow(pointer, XID, pointer);
static void nxagentReconfigureWindow(pointer, XID, pointer);

void nxagentUnmapWindows(void)
{
  int i;

  if (nxagentOption(Fullscreen))
  {
    for (i = 0; i < screenInfo.numScreens; i++)
    {
      if (nxagentDefaultWindows[i])
      {
        XUnmapWindow(nxagentDisplay, nxagentDefaultWindows[i]);
      }
    }
  }

  XFlush(nxagentDisplay);
}

void nxagentMapRootWindow(void)
{
  int i;
  extern Window nxagentIconWindow;

  if (nxagentOption(Rootless) == False)
  {
    for (i = 0; i < screenInfo.numScreens; i++)
    {
      XMoveWindow(nxagentDisplay, nxagentWindow(WindowTable[i]),
                      nxagentOption(RootX), nxagentOption(RootY));

      XMapWindow(nxagentDisplay, nxagentWindow(WindowTable[i]));
    }

    if (nxagentIconWindow)
    {
      XMapWindow(nxagentDisplay, nxagentIconWindow);
    }
  }
}

Bool nxagentDisconnectAllWindow(void)
{
  Bool succeded = True;
  int i;
  WindowPtr pWin;

  #if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_WINDOW_DEBUG)
  fprintf(stderr, "nxagentDisconnectAllWindow\n");
  #endif

  for (i = 0; i < screenInfo.numScreens; i++)
  {
    pWin = WindowTable[i];
    nxagentTraverseWindow( pWin, nxagentDisconnectWindow, &succeded);
    nxagentDefaultWindows[i] = None;
  }

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentDisconnectAllWindow: all windows disconnected\n");
  #endif

  return succeded;
}

/*
 * FIXME: We are giving up reconnecting those pointer
 * that are not resource, and we are just disconnecting them.
 * perhaps we could do better and reconnect them.
 */

void nxagentDisconnectWindow(pointer p0, XID x1, pointer p2)
{
  WindowPtr pWin = (WindowPtr)p0;
  Bool*     pBool = (Bool*)p2;
  CursorPtr pCursor = wCursor(pWin);
  ScreenPtr pScreen = pWin -> drawable.pScreen;
  extern void nxagentDisconnectCursor(pointer, XID, pointer);

  if ((pCursor = wCursor(pWin)) &&
         nxagentCursorPriv(pCursor, pScreen) &&
           nxagentCursor(pCursor, pScreen))
  {
    #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG_disabled
    char msg[] = "nxagentDisconnectWindow:";

    nxagentPrintCursorInfo(pCursor, msg);
    #endif

    #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
    fprintf(stderr, "nxagentDisconnectWindow: window %p - disconnecting cursor %p ID %lx\n",
                pWin, pCursor, nxagentCursor(pCursor, pScreen));
    #endif

    nxagentDisconnectCursor(pCursor, (XID)0, pBool);

    if (*pBool == False)
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentDisconnectWindow: WARNING failed disconnection of cursor at [%p]"
                  " for window at [%p]: ignoring it.\n", (void*)pCursor, (void*)pWin);
      #endif

      *pBool = True;
    }
  }
  #ifdef NXAGENT_RECONNECT_CURSOR_DEBUG
  else if (pCursor)
  {
    fprintf(stderr, "nxagentDisconnectWindow: window %p - cursor %p already disconnected\n",
                pWin, pCursor);
  }
  #endif

  nxagentWindow(pWin) = None;
}

Bool nxagentReconnectAllWindow(void*p0)
{
  int flexibility = *(int*)p0;

  flexibility = flexibility;

  #if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_WINDOW_DEBUG)
  fprintf(stderr, "nxagentReconnectAllWindow\n");
  #endif

  if (WindowTable[0] -> backgroundState == BackgroundPixmap &&
          WindowTable[0] -> background.pixmap == NULL)
  {
    FatalError("nxagentReconnectAllWindow: correct the FIXME\n");
  }

  if (nxagentOption(Fullscreen))
  {
    WindowTable[0] -> origin.x = nxagentOption(RootX);
    WindowTable[0] -> origin.y = nxagentOption(RootY);
  }

  if (!nxagentLoopOverWindows(nxagentReconnectWindow))
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentReconnectAllWindow: couldn't recreate windows\n");
    #endif

    return FALSE;
  }

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  XSync(nxagentDisplay, FALSE);
  fprintf(stderr, "nxagentReconnectAllWindow: all windows recreated\n");
  #endif

  if (!nxagentLoopOverWindows(nxagentReconfigureWindow))
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentReconnectAllWindow: couldn't reconfigure windows\n");
    #endif

    return FALSE;
  }

  if (nxagentOption(Fullscreen))
  {
    WindowTable[0] -> origin.x = 0;
    WindowTable[0] -> origin.y = 0;
  }

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  XSync(nxagentDisplay, FALSE);
  fprintf(stderr, "nxagentReconnectAllWindow: all windows reconfigured\n");
  #endif

  if (nxagentInitClipboard(WindowTable[0]) == -1)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentReconnectAllWindow: couldn't init clipboard\n");
    #endif

    return FALSE;
  }

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  XSync(nxagentDisplay, FALSE);
  fprintf(stderr, "nxagentReconnectAllWindow: clipboard initialized\n");
  #endif

  /*
   * We move the viewport frames out of the way on the X server side.
   */

  if (nxagentViewportFrameLeft &&
          nxagentViewportFrameRight &&
              nxagentViewportFrameAbove &&
                  nxagentViewportFrameBelow)
  {
    XMoveWindow(nxagentDisplay, nxagentWindow(nxagentViewportFrameLeft),
                    -NXAGENT_FRAME_WIDTH, 0);
    XMoveWindow(nxagentDisplay, nxagentWindow(nxagentViewportFrameRight),
                    nxagentOption(RootWidth), 0);
    XMoveWindow(nxagentDisplay, nxagentWindow(nxagentViewportFrameAbove),
                    0, -NXAGENT_FRAME_WIDTH);
    XMoveWindow(nxagentDisplay, nxagentWindow(nxagentViewportFrameBelow),
                    0, nxagentOption(RootHeight));
  }

  nxagentResetExpose();

  return TRUE;
}

Bool nxagentSetWindowsCursors(void*p0)
{
  int flexibility = *(int*)p0;
  extern void nxagentReDisplayCurrentCursor(void);

  flexibility = flexibility;

  #if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_WINDOW_DEBUG)
  fprintf(stderr, "nxagentSetWindowsCursors\n");
  #endif

  if (!nxagentLoopOverWindows(nxagentReconfigureWindowCursor))
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentSetWindowsCursors: couldn't configure all window's cursor\n");
    #endif

    return FALSE;
  }

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentLoopOverWindows: all cursors configured\n");
  #endif

  nxagentReDisplayCurrentCursor();

  return TRUE;
}

static void nxagentTraverseWindow(
  WindowPtr pWin,
  void (*pF)(pointer, XID, pointer),
  pointer p)
{
  pF(pWin, 0, p);

  if (pWin -> nextSib)
  {
    nxagentTraverseWindow(pWin -> nextSib, pF, p);
  }

  if (pWin -> firstChild)
  {
    nxagentTraverseWindow(pWin -> firstChild, pF, p);
  }
}

static Bool nxagentLoopOverWindows(void (*pF)(pointer, XID, pointer))
{
  int i;
  Bool windowSuccess = True;
  WindowPtr pWin;

  for (i = 0; i < screenInfo.numScreens; i++)
  {
    pWin = WindowTable[i];
    nxagentTraverseWindow(pWin, pF, &windowSuccess);
  }

  return windowSuccess;
}

static void nxagentReconnectWindow(pointer param0, XID param1, pointer data_buffer)
{
  WindowPtr pWin = (WindowPtr)param0;
  Bool *pBool = (Bool*)data_buffer;
  Visual *visual;
  unsigned long mask;
  XSetWindowAttributes attributes;
  ColormapPtr pCmap;

  if (!pWin || !*pBool)
    return;

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentReconnectWindow: %p - ID %lx\n", pWin, nxagentWindow(pWin));
  #endif

  if (pWin->drawable.class == InputOnly) {
    mask = CWEventMask;
    visual = CopyFromParent;
  }
  else {
    mask = CWEventMask | CWBackingStore;

#ifdef NXAGENT_BAKSTR
    mask |= CWBackingPlanes | CWBackingPixel;
    if (nxagentBackingStore != NotUseful)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->backingStore != NotUseful)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     backingstore on window: xu is: %u\n",
                    nxagentWindow(pWin), pWin->backingStore);
          }
#endif
        attributes.backing_store = pWin->backingStore;
        if (pWin->optional)
          {
            mask |= CWBackingPlanes | CWBackingPixel;
            attributes.backing_planes = pWin->optional->backingBitPlanes;
            attributes.backing_pixel = pWin->optional->backingPixel;
          }
      }
    else
      {
        attributes.backing_store = NotUseful;
      }

    if (nxagentSaveUnder == True)
      {
#ifdef NXAGENT_BAKSTR_DEBUG
        if (pWin->saveUnder == True)
          {
            fprintf(stderr, "nxagentCreateWindow\n");
            fprintf(stderr, "     saveunder on window: %x is: %u\n", nxagentWindow(pWin), pWin->saveUnder);
          }
#endif
        mask |= CWSaveUnder;
        attributes.save_under = pWin->saveUnder;
      }
#else /* NXAGENT_BAKSTR */
    attributes.backing_store = NotUseful;
#endif

#if 0 /* FIXME: Do i have to set these parameters. */
#if defined(NXAGENT_FORCEBACK) || defined(NXAGENT_INTERNALBS)
    nxagentWindowPriv(pWin)->visible = 0;
    nxagentWindowPriv(pWin)->b_stored = 0;
    nxagentWindowPriv(pWin)->bs_time = 0;
    nxagentWindowPriv(pWin)->unexposed = 1;
#endif
#endif

#ifdef NXAGENT_FORCEBACK
    if(nxagentForceBackingStore)
    {

#if 0  /* FIXME: Do i have to set these parameters. */
        if(attributes.backing_store != NotUseful){
            nxagentWindowPriv(pWin)->native_bs = True;
        }
        else{
            nxagentWindowPriv(pWin)->native_bs = False;
        }
        /*XXX*/
        if(!(nxagentWindowPriv(pWin)->native_bs))
        {
            nxagentWindowPriv(pWin)->area = pWin->drawable.width *
                pWin->drawable.height;
            if(nxagentWindowPriv(pWin)->area < nxagentMaxAreaBackS)
            {
                nxagentWindowPriv(pWin)->is_bscandidate = True;
            }
            else
            {
                nxagentWindowPriv(pWin)->is_bscandidate = False;
            }
        }
#endif

    }
#endif
    if (pWin->parent) {
        if (pWin->optional && pWin->optional->visual != wVisual(pWin->parent)) {
        visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
        mask |= CWColormap;
        if (pWin->optional->colormap) {
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          attributes.colormap = nxagentColormap(pCmap);
        }
        else
          attributes.colormap = nxagentDefaultVisualColormap(visual);
      }
      else
        visual = CopyFromParent;
    }
    else { /* root windows have their own colormaps at creation time */
      visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
      pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
      mask |= CWColormap;
      attributes.colormap = nxagentColormap(pCmap);
#ifdef NXAGENT_REPARENT
      /* beware of moultiple roots (screens) */
      nxagentRootWindow = pWin;
      nxagentSetInstalledColormapWindows(pWin->drawable.pScreen);
      nxagentWindowPriv(pWin)->window = (int)NULL;
      return;
#endif
    }
  }

#ifdef NXAGENT_REPARENT
  if ((pWin)->parent == nxagentRootWindow)
    {
      /* visual CopyFromParent does not work if parent is root */
      if (visual == CopyFromParent)
        {
          visual = nxagentVisualFromID(pWin->drawable.pScreen, wVisual(pWin));
          pCmap = (ColormapPtr)LookupIDByType(wColormap(pWin), RT_COLORMAP);
          mask |= CWColormap;
          attributes.colormap = nxagentColormap(pCmap);
        }
      mask &= ~CWEventMask;
      mask |= CWColormap;
    }

  if (pWin != nxagentRootWindow)
    {
      mask |= CWEventMask;
/*       attributes.event_mask |= PointerMotionMask; */
    }
#endif

  if (mask & CWEventMask)
  {
    nxagentGetEventMask(pWin, (Mask*)&attributes.event_mask);
  }
  #ifdef WARNING
  else
  {
    attributes.event_mask = NoEventMask;
  }
  #endif

#if 0 /* FIXME: Do i have to set these parameters. */
#ifdef NXAGENT_FORCEBACK
  if(nxagentForceBackingStore){
      nxagentWindowPriv(pWin)->event_mask = attributes.event_mask;
      nxagentWindowPriv(pWin)->is_blacklisted = False;
      nxagentWindowPriv(pWin)->enqueued = 0;
  }
#endif
#endif

  #ifdef TEST
  fprintf(stderr, "nxagentReconnectWindow: Going to create new window.\n");
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentReconnectWindow: Recreating %swindow at %p current event mask = %lX mask & CWEventMask = %ld "
              "event_mask = %lX\n",
                  nxagentWindowTopLevel(pWin) ? "toplevel " : "", (void*)pWin, pWin -> eventMask,
                      mask & CWEventMask, attributes.event_mask);
  #endif

  nxagentWindow(pWin) = XCreateWindow(nxagentDisplay,
                                      nxagentWindowParent(pWin),
                                      pWin->origin.x -
                                      wBorderWidth(pWin),
                                      pWin->origin.y -
                                      wBorderWidth(pWin),
                                      pWin->drawable.width,
                                      pWin->drawable.height,
                                      pWin->borderWidth,
                                      pWin->drawable.depth,
                                      pWin->drawable.class,
                                      visual,
                                      mask,
                                      &attributes);

  #ifdef TEST
  fprintf(stderr, "nxagentReconnectWindow: Created new window with id [%ld].\n",
              nxagentWindowPriv(pWin)->window);
  #endif

  /*
   * We have to set the WM_DELETE_WINDOW protocols
   * on every top level window, because we don't know
   * if a client handles this.
   */

  if (nxagentOption(Rootless) && (pWin != WindowTable[0]))
  {
    if (nxagentWindowTopLevel(pWin))
    {
      Atom prop = nxagentMakeAtom("WM_PROTOCOLS", strlen("WM_PROTOCOLS"), True);
      Atom atom = nxagentMakeAtom("WM_DELETE_WINDOW", strlen("WM_DELETE_WINDOW"), True);

      XSetWMProtocols(nxagentDisplay, nxagentWindow(pWin), &atom, 1);

      nxagentAddPropertyToList(prop, pWin);
    }

    nxagentExportAllProperty(pWin);

    if (nxagentWindowTopLevel(pWin))
    {
      int ret;
      Atom type;
      int format;
      unsigned long nItems, bytesLeft;
      XSizeHints *props, hints;
      unsigned char *data = NULL;

      extern int GetWindowProperty(WindowPtr, Atom, long, long, Bool, Atom, Atom*, int*,
                                       unsigned long*, unsigned long*, unsigned char**);

      hints.flags = 0;

      ret = GetWindowProperty(pWin,
                                  XA_WM_NORMAL_HINTS,
                                      0, sizeof(XSizeHints),
                                          False, XA_WM_SIZE_HINTS,
                                              &type, &format, &nItems, &bytesLeft, &data);

      props = (XSizeHints*) data;

      if (ret == Success &&
              ((format >> 3) * nItems) == sizeof(XSizeHints) &&
                  bytesLeft == 0 &&
                      type == XA_WM_SIZE_HINTS)
      {
        #ifdef WARNING
        fprintf(stderr, "nxagentReconnectWindow: setting WMSizeHints on window %p [%lx - %lx].\n",
                    (void*)pWin, pWin -> drawable.id, nxagentWindow(pWin));
        #endif

        hints = *props;
      }
      else
      {
        #ifdef WARNING
        fprintf(stderr, "nxagentReconnectWindow: Failed to get property WM_NORMAL_HINTS on window %p\n",
                    (void*)pWin);
        #endif
      }

      hints.flags |= (USPosition | PWinGravity);
      hints.x = pWin -> drawable.x;
      hints.y = pWin -> drawable.y;
      hints.win_gravity = StaticGravity;

      XSetWMNormalHints(nxagentDisplay,
                           nxagentWindow(pWin),
                              &hints);
    }
  }
}

static void nxagentReconfigureWindowCursor(pointer param0, XID param1, pointer data_buffer)
{
  WindowPtr pWin = (WindowPtr)param0;
  Bool *pBool = (Bool*)data_buffer;
  CursorPtr   pCursor;
  ScreenPtr   pScreen = pWin -> drawable.pScreen;
  extern void nxagentReconnectCursor(void*, XID, void*);

  if (!pWin || !*pBool || !(pCursor = wCursor(pWin)) || !(nxagentCursorPriv(pCursor, pScreen)))
    return;

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentReconfigureWindowCursor: %p - ID %lx geometry (%d,%d,%d,%d) "
                  "cursor %p - ID %lx\n",
                  pWin, nxagentWindow(pWin),
                  pWin -> drawable.x,
                  pWin -> drawable.y,
                  pWin -> drawable.width,
                  pWin -> drawable.height,
                  pCursor, nxagentCursor(pCursor, pScreen));
  #endif

  if (nxagentCursor(pCursor, pScreen) == None)
  {
    #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
    fprintf(stderr, "nxagentReconfigureWindowCursor: reconnecting valid cursor %lx\n",
                (void*)pCursor);
    #endif

    nxagentReconnectCursor(pCursor, 0, pBool);

    if (!*pBool)
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentReconfigureWindowCursor: WARNING "
                  "failed reconnection of cursor at [%p] for window at [%p]: ignoring it.\n",
                      (void*)pCursor, (void*)pWin);
      #endif

      *pBool = True;
    }
  }
}

Bool nxagentIsIconic(WindowPtr);

static void nxagentReconfigureWindow(pointer param0, XID param1, pointer data_buffer)
{
  WindowPtr pWin = (WindowPtr)param0;
  unsigned long mask = 0;

  #ifdef NXAGENT_RECONNECT_WINDOW_DEBUG
  fprintf(stderr, "nxagentReconfigureWindow: pWin %p - ID %lx\n", pWin, nxagentWindow(pWin));
  #endif

  if (pWin -> drawable.class == InputOnly)
    mask = CWWinGravity | CWEventMask | CWDontPropagate | CWOverrideRedirect | CWCursor;
  else
    mask = CWBackPixmap | CWBackPixel | CWBorderPixmap | CWBorderPixel |
         CWBitGravity | CWWinGravity | CWBackingStore | CWBackingPlanes |
         CWBackingPixel | CWOverrideRedirect | CWSaveUnder | CWEventMask |
         CWDontPropagate | CWColormap | CWCursor;

  nxagentChangeWindowAttributes(pWin, mask);

#ifdef SHAPE
  if (nxagentWindowPriv(pWin) -> bounding_shape)
  {
    REGION_DESTROY(pWin -> drawable.pScreen,
                   nxagentWindowPriv(pWin) -> bounding_shape);
    nxagentWindowPriv(pWin) -> bounding_shape = NULL;
  }

  if (nxagentWindowPriv(pWin) -> clip_shape)
  {
    REGION_DESTROY(pWin -> drawable.pScreen,
                   nxagentWindowPriv(pWin) -> clip_shape);
    nxagentWindowPriv(pWin) -> clip_shape = NULL;
  }
  nxagentShapeWindow(pWin);
#endif

  if (pWin != WindowTable[0])
  {
    if (pWin->realized)
    {
        nxagentRealizeWindow (pWin);
    }
    else if (pWin->mapped)
    {
      XMapWindow(nxagentDisplay, nxagentWindow(pWin));
    }
    else if (nxagentOption(Rootless) && pWin -> overrideRedirect == 0 &&
                 nxagentWindowTopLevel(pWin) && nxagentIsIconic(pWin))
    {
      MapWindow(pWin, serverClient);
      XIconifyWindow(nxagentDisplay, nxagentWindow(pWin), pWin -> drawable.pScreen -> myNum);
    }
  }
}

Bool nxagentCheckIllegalRootMonitoring(WindowPtr pWin, Mask mask)
{
  Mask invalidMask = SubstructureRedirectMask | ResizeRedirectMask | ButtonPressMask;

  if (nxagentOption(Rootless) &&
        pWin == WindowTable[0] &&
          (mask & invalidMask))
  {
    return True;
  }

  return False;
}

Bool nxagentCheckWindowIntegrity(WindowPtr pWin)
{
  Bool integrity = True;
  XImage *image;
  char *data;
  int format;
  unsigned long plane_mask = AllPlanes;
  unsigned int width, height, length, depth;
  extern int nxagentImageLength(int, int, int, int, int);
  extern int nxagentImagePad(int, int, int, int);

  width = pWin -> drawable.width;
  height = pWin -> drawable.height;
  depth = pWin -> drawable.depth;
  format = (depth == 1) ? XYPixmap : ZPixmap;

  if (width && height)
  {
     length = nxagentImageLength(width, height, format, 0, depth);
     data = malloc(length);

     if (data == NULL)
     {
       FatalError("nxagentCheckWindowIntegrity: Failed to allocate a buffer of size %d.\n", length);
     }

     memset(data, 0, length);

     image = XGetImage(nxagentDisplay, nxagentWindow(pWin), 0, 0,
                                   width, height, plane_mask, format);
     if (image == NULL)
     {
       fprintf(stderr, "XGetImage: Failed.\n");
       return False;
     }

     NXCleanInPlaceImage(image);

     fbGetImage((DrawablePtr)pWin, 0, 0, width, height, format, plane_mask, data);

     if (image && memcmp(image->data, data, length) != 0)
     {
       #ifdef TEST
       int i;
       char *p, *q;
       #endif

       integrity = False;

       #ifdef TEST
       for (i = 0, p = image->data, q = data; i < length; i++)
       {
         if (p[i] != q[i])
         {
           fprintf(stderr, "[%d] %d - %d !!!!!!!!!!!!!!!!!!! **************** !!!!!!!!!!!!!!!!!\n", i, p[i], q[i]);
         }
         else
         {
           fprintf(stderr, "[%d] %d - %d\n", i, p[i], q[i]);
         }
       }
       #endif

       NXCleanInPlaceImage(image);

       #ifdef WARNING
       fprintf(stderr, "nxagentCheckWindowIntegrity: Window %p width %d, height %d, has been realized "
                 "but the data buffer still differs.\n", (void*) pWin, width, height);
       fprintf(stderr, "nxagentCheckWindowIntegrity: bytes_per_line = %d byte pad %d format %d.\n",
                 image -> bytes_per_line, nxagentImagePad(width, height, 0, depth), image->format);

       fprintf(stderr, "nxagentCheckWindowIntegrity: image is corrupted!!\n");
       #endif
     }
     else
     {
       #ifdef WARNING
       fprintf(stderr, "nxagentCheckWindowIntegrity: Window %p has been realized "
                   "now remote and frambuffer data are synchronized.\n", (void*) pWin);
       #endif
     }

     if (image)
     {
       XDestroyImage(image);
     }

     if (data)
     {
       free(data);
     }
  }
  else
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentCheckWindowIntegrity: ignored window %p with geometry (%d,%d).\n",
                (void*) pWin, width, height);
    #endif
  }

  return integrity;
}

void nxagentSendExposeToDirtyWindows(void *p0, XID x1, void *p2)
{
  WindowPtr pWin = (WindowPtr) p0;

  if (pWin && pWin -> mapped && pWin->viewable &&
          nxagentWindowStatus(pWin) == DRAWABLE_NOT_SYNCHRONIZED)
  {
    nxagentForceExposure(pWin, NULL);

    nxagentWindowStatus(pWin) = DRAWABLE_SYNCHRONIZED;

    #ifdef WARNING
    fprintf(stderr, "nxagentSendExposeToDirtyWindow: Sending an expose event to window %p.\n",
                (void *) pWin);
    #endif
  }
}

Bool nxagentIsIconic(WindowPtr pWin)
{
  int           iReturn;
  unsigned long ulReturnItems;
  unsigned long ulReturnBytesLeft;
  Atom          atomReturnType;
  int           iReturnFormat;
  unsigned char *pszReturnData = NULL;

  extern int GetWindowProperty(WindowPtr, Atom, long, long, Bool, Atom, Atom*, int*,
                               unsigned long*, unsigned long*, unsigned char**);

  iReturn = GetWindowProperty(pWin, MakeAtom("WM_STATE", 8, False), 0, sizeof(CARD32), False,
                              AnyPropertyType, &atomReturnType, &iReturnFormat,
                              &ulReturnItems, &ulReturnBytesLeft, &pszReturnData);

  if (iReturn == Success)
  {
    return (((CARD32 *)pszReturnData)[0] == IconicState);
  }
  else
  {
    return 0;
  }
}
