/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Window_H__
#define __Window_H__

#include "Options.h"
#include "Rootless.h"
#include "Lazy.h"

typedef struct {
  Window window;
  int x;
  int y;
  unsigned int width;
  unsigned int height;
  unsigned int border_width;
  Window sibling_above;
  char bstored;
  nxagentDrawableLazyRec drawableLazy;
#ifdef NXAGENT_FORCEBACK
  Mask event_mask;
  Bool is_blacklisted;
  Bool is_bscandidate;
  Bool native_bs;
  unsigned long area;
  char visible;
  int b_stored;
  unsigned long bs_time;
  char unexposed;
  char enqueued;
  /*
   * 0 not enqueued
   * 1 enqueued to get bs
   * 2 enqueued to lose bs
   */
#endif
#ifdef SHAPE
  RegionPtr bounding_shape;
  RegionPtr clip_shape;
#endif /* SHAPE */

  void *pPicture;

  RegionPtr received_expose_region;
  RegionPtr sent_expose_region;
  RegionPtr pending_expose_region;

} nxagentPrivWin;

extern int nxagentWindowPrivateIndex;

#define nxagentWindowPriv(pWin) \
  ((nxagentPrivWin *)((pWin)->devPrivates[nxagentWindowPrivateIndex].ptr))

#define nxagentWindow(pWin) (nxagentWindowPriv(pWin)->window)

/*
 * Window is either a child of our root
 * or a child of the root of the real X
 * server.
 */

#define nxagentWindowParent(pWin) \
    (nxagentOption(Rootless) ? \
         nxagentRootlessWindowParent(pWin) : \
             ((pWin)->parent ? \
                 nxagentWindow((pWin)->parent) : \
                     nxagentDefaultWindows[pWin->drawable.pScreen->myNum]))

/*
 * True if this is a top level window.
 */

#define nxagentWindowTopLevel(pWin) \
    (pWin && (pWin -> parent == NULL || \
         pWin->parent == nxagentRootlessWindow))

#define nxagentWindowSiblingAbove(pWin) \
  ((pWin)->prevSib ? nxagentWindow((pWin)->prevSib) : None)

#define nxagentWindowSiblingBelow(pWin) \
  ((pWin)->nextSib ? nxagentWindow((pWin)->nextSib) : None)

#define nxagentWindowStatus(pWin) \
  (nxagentWindowPriv(pWin) -> drawableLazy.status)

#define nxagentWindowPlaceholderDrawn(pWin) \
   (nxagentWindowPriv(pWin) -> drawableLazy.placeholderDrawn) 

#define CWParent CWSibling
#define CWStackingOrder CWStackMode

extern WindowPtr *WindowTable;

WindowPtr nxagentWindowPtr();

/*
 * Agent's nested window procedures. Look also
 * at Rootless.h for the rootless counterparts.
 */

Bool nxagentCreateWindow(WindowPtr pWin);
Bool nxagentDestroyWindow(WindowPtr pWin);
Bool nxagentPositionWindow(WindowPtr pWin, int x, int y);
Bool nxagentChangeWindowAttributes(WindowPtr pWin, unsigned long mask);
Bool nxagentRealizeWindow(WindowPtr pWin);
Bool nxagentUnrealizeWindow(WindowPtr pWin);
Bool nxagentCheckIllegalRootMonitoring(WindowPtr pWin, Mask mask);
void nxagentWindowExposures(WindowPtr pWin, RegionPtr pRgn, RegionPtr other_exposed);
void nxagentPaintWindowBackground(WindowPtr pWin, RegionPtr pRegion, int what);
void nxagentPaintWindowBorder(WindowPtr pWin, RegionPtr pRegion, int what);
void nxagentCopyWindow(WindowPtr pWin, xPoint oldOrigin, RegionPtr oldRegion);
void nxagentClipNotify(WindowPtr pWin, int dx, int dy);
void nxagentRestackWindow(WindowPtr pWin, WindowPtr pOldNextSib);
void nxagentReparentWindow(WindowPtr pWin, WindowPtr pOldParent);

/*
 * The ConfigureWindow procedure has not
 * a pointer in the screen structure.
 */

void nxagentConfigureWindow();

/*
 * Used to track nxagent window's visibility.
 */

extern int nxagentVisibility;
extern unsigned long nxagentVisibilityTimeout;
extern Bool nxagentVisibilityStop;

/*
 * Return the pointer to the window given the
 * remote id. It tries to match the id from
 * the last matched window before iterating
 * through the hierarchy.
 */

WindowPtr nxagentGetWindowFromID(Window id);

/*
 * Handle the shape bitmap for windows.
 */

#ifdef SHAPE
void nxagentShapeWindow();
#endif /* SHAPE */

#ifdef NXAGENT_FORCEBACK
typedef struct{
    WindowPtr *queue;
    int last;
    int max;
    unsigned long lastAccess;
} nxbsQueue;

#define NOT_IN_QUEUE 0
#define ADD_BS 1
#define DEL_BS 2

typedef nxbsQueue* nxbsQueuePtr;
#endif

extern Bool nxagentSynchronizationPending;

#define nxagentSetSynchronizationPending(dpy) \
\
  do\
  {\
    if (nxagentSynchronizationPending == False)\
    {\
      NXCollectInputFocus(dpy, NXGetCollectInputFocusResource(dpy));\
\
      nxagentSynchronizationPending = True;\
    }\
  }\
  while(0)

#endif /* __Window_H__ */
