/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef ClientCache_H
#define ClientCache_H

#include "Misc.h"

#include "IntCache.h"
#include "CharCache.h"
#include "OpcodeCache.h"
#include "XidCache.h"
#include "TextCompressor.h"

#include "ChannelCache.h"

class ClientCache : public ChannelCache
{
  public:

  ClientCache();

  ~ClientCache();

  //
  // Opcode prediction caches.
  //

  OpcodeCache opcodeCache;

  //
  // GC and drawables caches.
  //

  XidCache gcCache;
  XidCache drawableCache;
  XidCache windowCache;

  //
  // General-purpose caches.
  //

  CharCache textCache[CLIENT_TEXT_CACHE_SIZE];
  IntCache cursorCache;
  IntCache colormapCache;
  IntCache visualCache;
  CharCache depthCache;
  unsigned int lastFont;

  //
  // AllocColor request.
  //

  IntCache *allocColorRGBCache[3];

  //
  // ChangeProperty request.
  //

  CharCache changePropertyFormatCache;
  IntCache changePropertyPropertyCache;
  IntCache changePropertyTypeCache;
  IntCache changePropertyData32Cache;
  TextCompressor changePropertyTextCompressor;

  //
  // ClearArea request.
  //

  IntCache *clearAreaGeomCache[4];

  //
  // ConfigureWindow request.
  //

  IntCache configureWindowBitmaskCache;
  IntCache *configureWindowAttrCache[7];

  //
  // ConvertSelection request.
  //

  IntCache convertSelectionRequestorCache;
  IntCache* convertSelectionAtomCache[3];
  unsigned int convertSelectionLastTimestamp;

  //
  // CopyArea request.
  //

  IntCache *copyAreaGeomCache[6];

  //
  // CopyPlane request.
  //

  IntCache *copyPlaneGeomCache[6];
  IntCache copyPlaneBitPlaneCache;

  //
  // CreateGC request.
  //

  IntCache createGCBitmaskCache;
  IntCache *createGCAttrCache[23];

  //
  // CreatePixmap request.
  //

  IntCache createPixmapIdCache;
  unsigned int createPixmapLastId;
  IntCache createPixmapXCache;
  IntCache createPixmapYCache;

  //
  // CreateWindow request.
  //

  IntCache *createWindowGeomCache[6];
  IntCache createWindowBitmaskCache;
  IntCache *createWindowAttrCache[15];

  //
  // FillPoly request.
  //

  IntCache fillPolyNumPointsCache;
  IntCache *fillPolyXRelCache[10];
  IntCache *fillPolyXAbsCache[10];
  IntCache *fillPolyYRelCache[10];
  IntCache *fillPolyYAbsCache[10];
  unsigned int fillPolyRecentX[8];
  unsigned int fillPolyRecentY[8];
  unsigned int fillPolyIndex;

  //
  // GetSelectionOwner request.
  //

  IntCache getSelectionOwnerSelectionCache;

  //
  // GrabButton request (also used for GrabPointer).
  //

  IntCache grabButtonEventMaskCache;
  IntCache grabButtonConfineCache;
  CharCache grabButtonButtonCache;
  IntCache grabButtonModifierCache;

  //
  // GrabKeyboard request.
  //

  unsigned int grabKeyboardLastTimestamp;

  //
  // ImageText8/16 request.
  //

  IntCache imageTextLengthCache;
  unsigned int imageTextLastX;
  unsigned int imageTextLastY;
  IntCache imageTextCacheX;
  IntCache imageTextCacheY;
  TextCompressor imageTextTextCompressor;

  //
  // InternAtom request. Used also for
  // GetAtomName in proto version < 3.
  //

  TextCompressor internAtomTextCompressor;

  //
  // OpenFont request.
  //

  TextCompressor openFontTextCompressor;

  //
  // PolyFillRectangle request.
  //

  IntCache *polyFillRectangleCacheX[4];
  IntCache *polyFillRectangleCacheY[4];
  IntCache *polyFillRectangleCacheWidth[4];
  IntCache *polyFillRectangleCacheHeight[4];

  //
  // PolyLine request.
  //

  IntCache *polyLineCacheX[2];
  IntCache *polyLineCacheY[2];

  //
  // PolyPoint request.
  //

  IntCache *polyPointCacheX[2];
  IntCache *polyPointCacheY[2];

  //
  // PolyRectangle request.
  //

  IntCache *polyRectangleGeomCache[4];

  //
  // PolySegment request.
  //

  IntCache polySegmentCacheX;
  IntCache polySegmentCacheY;
  unsigned int polySegmentLastX[2];
  unsigned int polySegmentLastY[2];
  unsigned int polySegmentCacheIndex;

  //
  // PolyText8/16 request.
  //

  unsigned int polyTextLastX;
  unsigned int polyTextLastY;
  IntCache polyTextCacheX;
  IntCache polyTextCacheY;
  IntCache polyTextFontCache;
  CharCache polyTextDeltaCache;
  TextCompressor polyTextTextCompressor;

  //
  // PutImage request.
  //

  IntCache putImageWidthCache;
  IntCache putImageHeightCache;
  unsigned int putImageLastX;
  unsigned int putImageLastY;
  IntCache putImageXCache;
  IntCache putImageYCache;
  CharCache putImageLeftPadCache;

  //
  // GetImage request.
  //

  IntCache getImagePlaneMaskCache;

  //
  // QueryColors request.
  //

  unsigned int queryColorsLastPixel;

  //
  // SetClipRectangles request.
  //

  IntCache setClipRectanglesXCache;
  IntCache setClipRectanglesYCache;
  IntCache *setClipRectanglesGeomCache[4];

  //
  // SetDashes request.
  //

  IntCache setDashesLengthCache;
  IntCache setDashesOffsetCache;
  CharCache setDashesDashCache_[2];

  //
  // SetSelectionOwner request.
  //

  IntCache setSelectionOwnerCache;
  IntCache setSelectionOwnerTimestampCache;

  //
  // TranslateCoords request.
  //

  IntCache translateCoordsSrcCache;
  IntCache translateCoordsDstCache;
  IntCache translateCoordsXCache;
  IntCache translateCoordsYCache;

  //
  // SendEvent request.
  //

  IntCache     sendEventMaskCache;
  CharCache    sendEventCodeCache;
  CharCache    sendEventByteDataCache;
  unsigned int sendEventLastSequence;
  IntCache     sendEventIntDataCache;
  CharCache    sendEventEventCache;

  //
  // PolyFillArc request.
  //

  IntCache *polyFillArcCacheX[2];
  IntCache *polyFillArcCacheY[2];
  IntCache *polyFillArcCacheWidth[2];
  IntCache *polyFillArcCacheHeight[2];
  IntCache *polyFillArcCacheAngle1[2];
  IntCache *polyFillArcCacheAngle2[2];

  //
  // PolyArc request.
  //

  IntCache *polyArcCacheX[2];
  IntCache *polyArcCacheY[2];
  IntCache *polyArcCacheWidth[2];
  IntCache *polyArcCacheHeight[2];
  IntCache *polyArcCacheAngle1[2];
  IntCache *polyArcCacheAngle2[2];

  //
  // PutPackedImage request.
  //

  //
  // TODO: Field method is encoded in differences
  // starting from protocol level 3, so cache can
  // be removed in future.
  //

  CharCache putPackedImageMethodCache;
  IntCache  putPackedImageSrcLengthCache;
  IntCache  putPackedImageDstLengthCache;

  //
  // Shape extension requests.
  //

  CharCache shapeExtensionCharCache;
  IntCache  *shapeExtensionIntCache[8];

  //
  // Generic requests.
  //

  CharCache genericRequestCharCache;
  IntCache  *genericRequestIntCache[8];

  //
  // Used only in protocol version >= 4.
  //

  CharCache resourceCache;

  //
  // Render extension requests.
  //

  OpcodeCache renderOpcodeCache;

  CharCache renderTypeCache;
  CharCache renderOpCache;

  IntCache renderIdCache;

  XidCache renderPictureCache;

  IntCache renderLengthCache;
  IntCache renderGlyphsetCache;
  IntCache renderFormatCache;
  IntCache renderMaskCache;
  IntCache renderNumGlyphsCache;

  IntCache renderXCache;
  IntCache renderYCache;

  unsigned int renderLastX;
  unsigned int renderLastY;

  IntCache renderDeltaXCache;
  IntCache renderDeltaYCache;

  unsigned int renderLastId;
  unsigned int renderLastGlyphset;

  IntCache *renderDataCache[16];
  unsigned int renderLastData;

  TextCompressor renderTextCompressor;

  IntCache *renderCompositeGlyphsDataCache[16];
  unsigned int renderLastCompositeGlyphsData;

  IntCache *renderCompositeDataCache[3];
};

#endif /* ClientCache_H */
