/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Compressor_H
#define Compressor_H

#include <zlib.h>

class EncodeBuffer;

class Compressor
{
  public:

  Compressor(int compressionLevel, int compressionThreshold);

  ~Compressor();

  int compressBuffer(const unsigned char *uncompressedBuffer, 
                         const unsigned int uncompressedSize, unsigned char *&compressedBuffer,
                             unsigned int &compressedSize, EncodeBuffer &encodeBuffer);

  int compressBuffer(const unsigned char *uncompressedBuffer, 
                         const unsigned int uncompressedSize, unsigned char *&compressedBuffer,
                             unsigned int &compressedSize);

  int fullReset()
  {
    return (deflateReset(&stream_) == Z_OK);
  }

  static int isCompressionLevel(int compressionLevel)
  {
    return (compressionLevel == Z_DEFAULT_COMPRESSION ||
                (compressionLevel >= Z_NO_COMPRESSION &&
                     compressionLevel <= Z_BEST_COMPRESSION));
  }

  private:

  int compress(Bytef *dest, uLongf *destLen, const Bytef *source, uLong sourceLen);

  z_stream stream_;

  unsigned char *buffer_;
  unsigned int  bufferSize_;

  int threshold_;
};

#endif
