/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef DecodeBuffer_H
#define DecodeBuffer_H

#include "OpcodeCache.h"
#include "StatusCache.h"

class IntCache;
class CharCache;
class XidCache;
class PositionCache;

#define DECODE_BUFFER_OVERFLOW_SIZE        4194304

class DecodeBuffer
{
  public:

  DecodeBuffer(const unsigned char *data, unsigned int length);

  ~DecodeBuffer()
  {
  }

  int decodeBool(unsigned int &value)
  {
    return decodeValue(value, 1);
  }

  int decodeValue(unsigned int &value, unsigned int numBits,
                      unsigned int blockSize = 0, int endOkay = 0);

  int decodeCachedValue(unsigned int &value, unsigned int numBits,
                            IntCache &cache, unsigned int blockSize = 0,
                                int endOkay = 0);

  int decodeCachedValue(unsigned char &value, unsigned int numBits,
                            CharCache &cache, unsigned int blockSize = 0,
                                int endOkay = 0);

  void decodeDiffCachedValue(unsigned int &value, unsigned int &previous,
                                 unsigned int bits, IntCache &cache,
                                     unsigned int block = 0)
  {
    decodeCachedValue(value, bits, cache, block);

    previous += (value + 1);
    previous &= (0xffffffff >> (32 - bits));

    value = previous;
  }

  int decodeOpcodeValue(unsigned char &value, OpcodeCache &cache, int endOkay = 0)
  {
    int result = decodeCachedValue(value, 8, cache.base_[cache.slot_], 8, endOkay);

    if (result == 1)
    {
      cache.slot_ = value;
    }

    return result;
  }

  int decodeStatusValue(unsigned char &value, StatusCache &cache)
  {
    decodeCachedValue(value, 2, cache.base_[cache.slot_]);

    cache.slot_ = value;

    return 1;
  }

  int decodePositionValue(short int &value, PositionCache &cache);

  int decodeXidValue(unsigned int &value, XidCache &cache);

  int decodeXidValue(unsigned int &value, unsigned int previous, XidCache &cache);

  const unsigned char *decodeMemory(unsigned int numBytes);

  private:

  const unsigned char *buffer_;
  const unsigned char *end_;
  const unsigned char *nextSrc_;

  unsigned char srcMask_;
};

#endif /* DecodeBuffer_H */
