/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Decompressor_H
#define Decompressor_H

#include <zlib.h>

class DecodeBuffer;

class Decompressor
{
  public:

  Decompressor();

  ~Decompressor();

  int decompressBuffer(unsigned char *decompressedBuffer, unsigned int decompressedSize,
                           const unsigned char *&compressedBuffer, unsigned int &compressedSize,
                               DecodeBuffer &decodeBuffer);

  int decompressBuffer(unsigned char *decompressedBuffer, const unsigned int decompressedSize,
                           const unsigned char *compressedBuffer, const unsigned compressedSize);

  int fullReset()
  {
    return (inflateReset(&stream_) == Z_OK);
  }

  private:

  int decompress(Bytef *dest, uLongf *destLen, const Bytef *source, uLong sourceLen);

  z_stream stream_;
};

#endif

