/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "OpcodeStore.h"

OpcodeStore::OpcodeStore()
{
  //
  // Assign opcodes according to NX protocol.
  //

  getControlParameters = X_NXGetControlParameters;
  getCleanupParameters = X_NXGetCleanupParameters;
  getImageParameters   = X_NXGetImageParameters;
  getUnpackParameters  = X_NXGetUnpackParameters;
  getShmemParameters   = X_NXGetShmemParameters;

  startSplit  = X_NXStartSplit;
  endSplit    = X_NXEndSplit;
  split       = X_NXSplit;
  commitSplit = X_NXCommitSplit;
  abortSplit  = X_NXAbortSplit;

  setExposeEvents = X_NXSetExposeEvents;

  setUnpackGeometry = X_NXSetUnpackGeometry;
  setUnpackColormap = X_NXSetUnpackColormap;
  setUnpackAlpha    = X_NXSetUnpackAlpha;

  putPackedImage = X_NXPutPackedImage;

  freeUnpack = X_NXFreeUnpack;

  //
  // These values must be fetched from X server.
  //

  shapeExtension  = 0;
  renderExtension = 0;

  //
  // Events sent as ClientMessage.
  //

  resetNotify      = NXResetNotify;
  congestionNotify = NXCongestionNotify;

  noSplitNotify     = NXNoSplitNotify;
  startSplitNotify  = NXStartSplitNotify;
  commitSplitNotify = NXCommitSplitNotify;
  endSplitNotify    = NXEndSplitNotify;
  emptySplitNotify  = NXEmptySplitNotify;
}

OpcodeStore::~OpcodeStore()
{
}
