/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#undef  TEST
#undef  DEBUG

#ifdef __cplusplus
extern "C" {
#endif

#include "NXpack.h"

#if defined(TEST) || defined(DEBUG)

#include <stdio.h>

#endif

const ColorMask Mask8TrueColor    = { 128, 63, 240, 7 };
const ColorMask Mask64TrueColor   = { 192, 7,  240, 4 };
const ColorMask Mask256TrueColor  = { 255, 0,  255, 0 };
const ColorMask Mask512TrueColor  = { 224, 5,  240, 4 };
const ColorMask Mask4KTrueColor   = { 240, 4,  240, 2 };
const ColorMask Mask32KTrueColor  = { 248, 3,  248, 2 };
const ColorMask Mask64KTrueColor  = { 255, 0,  255, 0 };
const ColorMask Mask256KTrueColor = { 252, 1,  252, 1 };
const ColorMask Mask2MTrueColor   = { 255, 0,  254, 1 };
const ColorMask Mask16MTrueColor  = { 255, 0,  255, 0 };

const SplitGeometry GeometrySmall  = { 32,    32,    32,    32 };
const SplitGeometry GeometryMedium = { 80,    80,    80,    80 };
const SplitGeometry GeometryBig    = { 128,   128,   128,   128 };
const SplitGeometry GeometryHuge   = { 16384, 16384, 16384, 16384 };

const SplitGeometry *GetSplitGeometry(unsigned int method)
{
  switch (method)
  {
    case SPLIT_GEOMETRY_SMALL:
    {
      return &GeometrySmall;
    }
    case SPLIT_GEOMETRY_MEDIUM:
    {
      return &GeometryMedium;
    }
    case SPLIT_GEOMETRY_BIG:
    {
      return &GeometryBig;
    }
    case SPLIT_GEOMETRY_HUGE:
    {
      return &GeometryHuge;
    }
    default:
    {
      return 0;
    }
  }
}

const ColorMask *GetColorMask(unsigned int method)
{
  switch (method)
  {
    case MASK_8_COLORS:
    {
      return &Mask8TrueColor;
    }
    case MASK_64_COLORS:
    {
      return &Mask64TrueColor;
    }
    case MASK_256_COLORS:
    {
      return &Mask256TrueColor;
    }
    case MASK_512_COLORS:
    {
      return &Mask512TrueColor;
    }
    case MASK_4K_COLORS:
    {
      return &Mask4KTrueColor;
    }
    case MASK_32K_COLORS:
    {
      return &Mask32KTrueColor;
    }
    case MASK_64K_COLORS:
    {
      return &Mask64KTrueColor;
    }
    case MASK_256K_COLORS:
    {
      return &Mask256KTrueColor;
    }
    case MASK_2M_COLORS:
    {
      return &Mask2MTrueColor;
    }
    case MASK_16M_COLORS:
    {
      return &Mask16MTrueColor;
    }
    default:
    {
      return NULL;
    }
  }
}

int GetBitsPerPixel(unsigned int method)
{
  switch (method)
  {
    case PACK_MASKED_8_COLORS:
    case PACK_TIGHT_8_COLORS:
    case PACK_JPEG_8_COLORS:
    case PACK_PNG_8_COLORS:
    case PACK_PNG_JPEG_8_COLORS:
    {
      return 8;
    }
    case PACK_MASKED_64_COLORS:
    case PACK_TIGHT_64_COLORS:
    case PACK_JPEG_64_COLORS:
    case PACK_PNG_64_COLORS:
    case PACK_PNG_JPEG_64_COLORS:
    {
      return 8;
    }
    case PACK_MASKED_256_COLORS:
    case PACK_TIGHT_256_COLORS:
    case PACK_JPEG_256_COLORS:
    case PACK_PNG_256_COLORS:
    case PACK_PNG_JPEG_256_COLORS:
    {
      return 8;
    }
    case PACK_MASKED_512_COLORS:
    case PACK_TIGHT_512_COLORS:
    case PACK_JPEG_512_COLORS:
    case PACK_PNG_512_COLORS:
    case PACK_PNG_JPEG_512_COLORS:
    {
      return 16;
    }
    case PACK_MASKED_4K_COLORS:
    case PACK_TIGHT_4K_COLORS:
    case PACK_JPEG_4K_COLORS:
    case PACK_PNG_4K_COLORS:
    case PACK_PNG_JPEG_4K_COLORS:
    {
      return 16;
    }
    case PACK_MASKED_32K_COLORS:
    case PACK_TIGHT_32K_COLORS:
    case PACK_JPEG_32K_COLORS:
    case PACK_PNG_32K_COLORS:
    case PACK_PNG_JPEG_32K_COLORS:
    {
      return 16;
    }
    case PACK_MASKED_64K_COLORS:
    case PACK_TIGHT_64K_COLORS:
    case PACK_JPEG_64K_COLORS:
    case PACK_PNG_64K_COLORS:
    case PACK_PNG_JPEG_64K_COLORS:
    {
      return 16;
    }
    case PACK_MASKED_256K_COLORS:
    case PACK_TIGHT_256K_COLORS:
    case PACK_JPEG_256K_COLORS:
    case PACK_PNG_256K_COLORS:
    case PACK_PNG_JPEG_256K_COLORS:
    {
      return 24;
    }
    case PACK_MASKED_2M_COLORS:
    case PACK_TIGHT_2M_COLORS:
    case PACK_JPEG_2M_COLORS:
    case PACK_PNG_2M_COLORS:
    case PACK_PNG_JPEG_2M_COLORS:
    {
      return 24;
    }
    case PACK_MASKED_16M_COLORS:
    case PACK_TIGHT_16M_COLORS:
    case PACK_JPEG_16M_COLORS:
    case PACK_PNG_16M_COLORS:
    case PACK_PNG_JPEG_16M_COLORS:
    {
      return 24;
    }
    case PACK_RDP_PLAIN_256_COLORS:
    case PACK_RDP_COMPRESSED_256_COLORS:
    {
      return 8;
    }
    case PACK_RDP_PLAIN_32K_COLORS:
    case PACK_RDP_COMPRESSED_32K_COLORS:
    {
      return 16;
    }
    case PACK_RDP_PLAIN_64K_COLORS:
    case PACK_RDP_COMPRESSED_64K_COLORS:
    {
      return 16;
    }
    case PACK_RDP_PLAIN_16M_COLORS:
    case PACK_RDP_COMPRESSED_16M_COLORS:
    {
      return 24;
    }
    case PACK_RFB_TIGHT_PLAIN:
    {
      return 32;
    }
    case PACK_RFB_TIGHT_COMPRESSED:
    {
      return 32;
    }
    case PACK_RFB_HEXTILE:
    {
      return 32;
    }
    default:
    {
      return 0;
    }
  }
}

unsigned int SelectPackMethod(unsigned int method, int src_bits_per_pixel,
                                  int dst_bits_per_pixel)
{
  #ifdef TEST
  fprintf(stderr, "SelectPackMethod: Called with method [%u] source bits [%d] destination bits [%d].\n",
              method, src_bits_per_pixel, dst_bits_per_pixel);
  #endif

  if (GetBitsPerPixel(method) > dst_bits_per_pixel)
  {
    switch(dst_bits_per_pixel)
    {
      case 16:
      {
        if (method >= PACK_JPEG_8_COLORS && method <= PACK_JPEG_16M_COLORS)
        {
          method = PACK_JPEG_64K_COLORS;
        }
        else if (method >= PACK_PNG_8_COLORS && method <= PACK_PNG_16M_COLORS)
        {
          method = PACK_PNG_64K_COLORS;
        }
        else if (method >= PACK_PNG_JPEG_8_COLORS && method <= PACK_PNG_JPEG_16M_COLORS)
        {
          method = PACK_PNG_JPEG_64K_COLORS;
        }
        else if (method >= PACK_TIGHT_8_COLORS && method <= PACK_TIGHT_16M_COLORS)
        {
          method = PACK_TIGHT_64K_COLORS;
        }
        else
        {
          method = PACK_MASKED_64K_COLORS;
        }

        break;
      }
      case 8:
      {
        if (method >= PACK_JPEG_8_COLORS && method <= PACK_JPEG_16M_COLORS)
        {
          method = PACK_JPEG_256_COLORS;
        }
        else if (method >= PACK_PNG_8_COLORS && method <= PACK_PNG_16M_COLORS)
        {
          method = PACK_PNG_256_COLORS;
        }
        else if (method >= PACK_PNG_JPEG_8_COLORS && method <= PACK_PNG_JPEG_16M_COLORS)
        {
          method = PACK_PNG_JPEG_256_COLORS;
        }
        else if (method >= PACK_TIGHT_8_COLORS && method <= PACK_TIGHT_16M_COLORS)
        {
          method = PACK_TIGHT_256_COLORS;
        }
        else
        {
          method = PACK_MASKED_256_COLORS;
        }

        break;
      }
      default:
      {
        method = -1;

        break;
      }
    }
  }

  #ifdef TEST
  fprintf(stderr, "SelectPackMethod: Selected method [%u].\n",
              method);
  #endif

  return method;
}

#ifdef __cplusplus
}
#endif
