/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2005 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "QueryFontReply.h"

#include "ServerCache.h"

#include "EncodeBuffer.h"
#include "DecodeBuffer.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  DUMP

//
// Here are the methods to handle messages' content.
//

int QueryFontReplyStore::parseBegin(Message *message, unsigned char *buffer,
                                        unsigned int size, int bigEndian) const
{
  //
  // Clear the padding bytes.
  //

  unsigned char *pad = (unsigned char *) buffer;

  if (size >= 24)
  {
    PutULONG(0, pad + 20, bigEndian);
  }

  if (size >= 40)
  {
    PutULONG(0, pad + 36, bigEndian);
  }

  //
  // TODO: This doesn't work. Probably these
  // padding bytes are not padding anymore.
  // This is to be investigated.
  //
  // pad += 60;
  //
  // while (pad + 16 <= (buffer + size))
  // {
  //   PutULONG(0, pad + 12, bigEndian);
  //
  //   pad += 16;
  // }
  //

  #ifdef DEBUG
  *logofs << name() << ": Cleaned padding bytes of "
          << "message at " << message << ".\n"
          << logofs_flush;
  #endif

  return true;
}

int QueryFontReplyStore::parseIdentity(Message *message, const unsigned char *buffer,
                                          unsigned int size, int bigEndian) const
{
  return true;
}

int QueryFontReplyStore::unparseIdentity(const Message *message, unsigned char *buffer,
                                            unsigned int size, int bigEndian) const
{
  return true;
}

void QueryFontReplyStore::dumpIdentity(const Message *message) const
{
  #ifdef DUMP

  QueryFontReplyMessage *queryFontReply = (QueryFontReplyMessage *) message;

  *logofs << name() << ": Identity size " << queryFontReply -> size_ << ".\n";

  #endif
}

void QueryFontReplyStore::identityChecksum(const Message *message, const unsigned char *buffer,
                                               unsigned int size, int bigEndian) const
{
}
