/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2005 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXVIEWER, NX protocol compression and NX extensions to this software   */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*
 * vncviewer.c - the Xt-based VNC viewer.
 */

#include "vncviewer.h"
#include "NXalert.h"
#include "NX.h"

char *programName;
char *displaymName;
char *captionName;
Bool nxviewerUseNXTrans = False;

XtAppContext appContext;
Display* dpy;

void nxviewerExit(int reason);

Widget toplevel;

int
main(int argc, char **argv)
{
  int i;
  programName = argv[0];

  /* The -listen option is used to make us a daemon process which listens for
     incoming connections from servers, rather than actively connecting to a
     given server. The -tunnel and -via options are useful to create
     connections tunneled via SSH port forwarding. We must test for the
     -listen option before invoking any Xt functions - this is because we use
     forking, and Xt doesn't seem to cope with forking very well. For -listen
     option, when a successful incoming connection has been accepted,
     listenForIncomingConnections() returns, setting the listenSpecified
     flag. */


  for (i = 1; i < argc; i++) {
    if (strcmp(argv[i], "-listen") == 0) {
      listenForIncomingConnections(&argc, argv, i);
      break;
    }
    if (strcmp(argv[i], "-tunnel") == 0 || strcmp(argv[i], "-via") == 0) {
      if (!createTunnel(&argc, argv, i))
	nxviewerExit(1);
      break;
    }
  }
  for (i = 1; i < argc; i++) {
    /*fprintf(stderr,"nxviever: %s\n",argv[i]);*/
    if (strcmp(argv[i], "-display") == 0) {
      displaymName=argv[i+1];
    }
    if (strcmp(argv[i], "-name") == 0) {
      captionName=argv[i+1];
    }
  }

  /* Interpret resource specs and process any remaining command-line arguments
     (i.e. the VNC server name).  If the server name isn't specified on the
     command line, getArgsAndResources() will pop up a dialog box and wait
     for one to be entered. */

  GetArgs(argc, argv);
  if ((displaymName != NULL) && (strcmp(displaymName,"nx")))
    nxviewerUseNXTrans = True;
  
  /* Call the main Xt initialisation function.  It parses command-line options,
     generating appropriate resource specs, and makes a connection to the X
     display. */
     
  /* It used to check the RFB connection first before initialize the application
     but this had to be changed to allow the use of NXTransAlert */
     
  toplevel = XtVaAppInitialize(&appContext, "NXVncviewer",
			       cmdLineOptions, numCmdLineOptions,
			       &argc, argv, (nxviewerUseNXTrans ? fallback_resources_nx : fallback_resources),
			       XtNborderWidth, 0, NULL);

  dpy = XtDisplay(toplevel);
  
  /* Unless we accepted an incoming connection, make a TCP connection to the
     given VNC server */

  fprintf(stderr,"Info: Connecting to RFB server '%s'.\n",vncServerHost);

  if (!listenSpecified) {
    if (!ConnectToRFBServer(vncServerHost, vncServerPort)) {
	nxviewerDialog(REMOTE_SERVER_RFB_CONNECT_ALERT);
        nxviewerExit(1);
    }
  }

  fprintf(stderr,"Info: Connected to RFB server '%s'.\n",vncServerHost);

  /* Initialise the VNC connection, including reading the password */

  if (!InitialiseRFBConnection()) {
     nxviewerExit(1);
  }
  /*fprintf(stderr,"nxviever: authentication successful.\n");*/

  GetResources();

  /* Create the "popup" widget - this won't actually appear on the screen until
     some user-defined event causes the "ShowPopup" action to be invoked */

  CreatePopup();

  /* Find the best pixel format and X visual/colormap to use */

  SetVisualAndCmap();

  /* Create the "desktop" widget, and perform initialisation which needs doing
     before the widgets are realized */

  ToplevelInitBeforeRealization();

  DesktopInitBeforeRealization();

  /* "Realize" all the widgets, i.e. actually create and map their X windows */

  XtRealizeWidget(toplevel);

  /* Perform initialisation that needs doing after realization, now that the X
     windows exist */

  InitialiseSelection(); 

  ToplevelInitAfterRealization();

  DesktopInitAfterRealization();

  /* Tell the VNC server which pixel format and encodings we want to use */

  SetFormatAndEncodings();

  /* Now enter the main loop, processing VNC messages.  X events will
     automatically be processed whenever the VNC connection is idle. */

  while (1) {
    if (!HandleRFBServerMessage())
      break;
  }

  Cleanup();
  
  nxviewerExit(0);

  return 0;
}

void nxviewerExit(int reason)
{
    if (nxviewerUseNXTrans)
	NXTransDestroy();
    exit(reason);
}

int
nxviewerDialog(int code)
{
    char *error_msg = 0;
    char error_caption[512];
    
    #ifdef NXDESKTOP_DIALOG_DEBUG
    fprintf(stderr, "nxviewerDialog: Message code = %d\n", code);
    #endif
    
    if ((displaymName != NULL) && (strcmp(displaymName,"nx")))
    {
	if (NXTransRunning())
	{
	    return (NXTransAlert(code, NX_ALERT_REMOTE));
	} else 
	{
	    if (error_caption[0])
		snprintf(error_caption,511,"Error");
	    NXTransDialog(error_caption, error_msg, (char *)desktopWin, "ok", 0, (char *)dpy );
	    wait(NULL);
	    return 0;
	}
    }
    return 0;
}
