#!/bin/sh

DEBUG=0

if [ $DEBUG -gt 0 ]; then
  set -x
  echo "Debug mode."
fi

version=10.0.8.805-20060718

if [ -e /usr/lib/RealPlayer10/version ] && [ "`cat /usr/lib/RealPlayer10/version 2>/dev/null`" = "$version" ]; then
  echo "RealPlayer Version $version is already installed."
  exit 0
fi

archive_url=https://helixcommunity.org/download.php/2152/RealPlayer-10.0.8.805-20060718.i586.rpm
archive=`basename $archive_url`
http_proxy=`apt-config dump | grep '^Acquire::http::Proxy' | sed "s/Acquire::http::Proxy \"http:\/\/\(.*\)\";/\1/"`
if [ -n "$http_proxy" ]; then
  export $http_proxy
fi

############################################################################

# Minimalist rpm2cpio in perl.
# Code taken from http://www.eleves.ens.fr:8080/home/espel/rpm2cpio
rpm2cpio() {
	perl -e '
		undef $/;
		$|=1;
		$rpm = <>;

		($magic, $major, $minor, undef) = unpack("NCC C90", $rpm);
		exit "Not an RPM\n" if $magic != 0xedabeedb;
		exit "Not a version 3 RPM\n" if $major != 3;
		
		$rpm = substr($rpm, 96);
		
		while ($rpm ne "") {
			$rpm =~ s/^\c@*//s;
			($magic, undef, $sections, $bytes) = unpack("N4", $rpm);
			$smagic = unpack("n", $rpm);
			last if $smagic eq 0x1f8b;
			die "Error: header not recognized\n" if $magic != 0x8eade801;
			$rpm = substr($rpm, 16*(1+$sections) + $bytes);
		}
		
		exit "bogus RPM\n" if $rpm eq "";
		
		open(ZCAT, "|gzip -cd") || die "cannot pipe to gzip\n";
		print ZCAT $rpm;
		close ZCAT;
	' $1
}

abort() {
	rm -rf ${rvtmpdir} || true
	rm -rf /var/lib/realplayer/$archive || true
	exit 1
}

rvtmpdir="${TMPDIR:-/var/tmp}/realplayer-unpacked.$$"

# Remove old files.
# (Note that this section is duplicated in the prerm.)
# Also note that I should never remove any of the files from
# this list; they were all present in some old version or
# other.
rm -rf	/usr/lib/libdecdnet.so /usr/lib/libra14_4.so \
	/usr/lib/libra28_8.so /usr/lib/libradnet.so \
	/usr/lib/libradnet.so /usr/lib/librarv10.so \
	/usr/lib/librasipr.so /usr/lib/librv10dec.so \
	/usr/lib/librvplayer.so \
	/usr/doc/rvplayer/README.FIRST \
	/usr/doc/rvplayer/License.txt \
	/usr/doc/rvplayer/examples/welcome.rm \
	/usr/doc/rvplayer/examples/Mailcap \
	/usr/doc/rvplayer/examples/rvplayer.ad \
	/usr/X11R6/lib/X11/rvplayer/rvplayer \
	/usr/X11R6/lib/X11/rvplayer/version \
	/usr/lib/librvcore.so \
	/usr/lib/netscape/plugins/librvplayer.so \
	/usr/lib/netscape/plugins/RAObserver.class \
	/usr/lib/netscape/plugins/RAPlayer.class \
	/usr/doc/rvplayer/README \
	/usr/doc/rvplayer/index.htm \
	/usr/doc/rvplayer/doc \
	/usr/doc/realplayer/LICENSE \
	/usr/doc/realplayer/README \
	/usr/doc/realplayer/RealHelp \
	/usr/doc/realplayer/RealHelp.htm \
	/usr/lib/RealPlayerG2 \
	/usr/lib/RealPlayer7 \
	/usr/lib/RealPlayer8 \
	/usr/share/doc/realplayer/Mailcap \
	/usr/share/doc/realplayer/Mime.types \
	/usr/share/doc/realplayer/README.RealHelp \
	/usr/share/doc/realplayer/RealHelp.html \
	/usr/share/doc/realplayer/README \
	/usr/share/doc/realplayer/RealHelp.htm \
	/usr/share/doc/realplayer/RealHelp \
	/usr/lib/netscape/plugins/rpnp.so \
	/usr/lib/netscape/plugins/raclass.zip \
	/usr/X11R6/lib/X11/realplayer/

if ! mkdir -p /var/lib/realplayer/ ; then
    exit 1
fi

if [ $DEBUG -gt 0 ]; then
    if ! cp -a /home/kbys/$archive /var/lib/realplayer/ ; then
        abort
    fi
else
    if ! wget -P /var/lib/realplayer $archive_url ; then
        abort
    fi
fi

rm -rf "${TMPDIR:-/var/tmp}/realplayer-unpacked.*" || true
if ! mkdir $rvtmpdir ; then
    abort
fi

if ! cd $rvtmpdir ; then
    abort
fi

if ! rpm2cpio /var/lib/realplayer/$archive | cpio --quiet --extract --make-directories >/dev/null ; then
    abort
fi

# Actually install the files, but first, fix permissions.
chown -R root.root usr
chmod -R go=rX usr
chmod -R u+rw usr

rm -rf /usr/lib/RealPlayer10/ || true
mv usr/local/RealPlayer /usr/lib/RealPlayer10

rm -f /usr/bin/realplayer || true
cat <<EOF > /usr/bin/realplayer
#!/bin/sh

GTK_IM_MODULE=xim exec /usr/lib/RealPlayer10/realplay "\$@"
EOF
if ! chmod +x /usr/bin/realplayer; then
  abort
fi

echo $version > /usr/lib/RealPlayer10/version

rm -rf $rvtmpdir || true
rm -rf /var/lib/realplayer/ || true
