/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.ws.client.ContextMap;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentUnmarshaller;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayloadSerializer;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.internal.SOAP12NotUnderstoodHeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.pept.encoding.Encoder;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.spi.runtime.InternalSoapEncoder;
import com.sun.xml.internal.ws.spi.runtime.MtomCallback;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import org.w3c.dom.Document;

public abstract class SOAPEncoder
implements Encoder,
InternalSoapEncoder {
    public void encodeAndSend(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer encode(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    public InternalMessage toInternalMessage(MessageInfo messageInfo) {
        return null;
    }

    public DOMSource toDOMSource(JAXBBridgeInfo jAXBBridgeInfo, MessageInfo messageInfo) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        Document document = DOMUtil.createDom();
        jAXBBridgeInfo.serialize(bridgeContext, document);
        return new DOMSource(document);
    }

    public DOMSource toDOMSource(RpcLitPayload rpcLitPayload, MessageInfo messageInfo) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(byteArrayBuffer);
            this.writeRpcLitPayload(rpcLitPayload, messageInfo, xMLStreamWriter);
            xMLStreamWriter.close();
            byteArrayBuffer.close();
            Transformer transformer = XmlUtil.newTransformer();
            StreamSource streamSource = new StreamSource(byteArrayBuffer.newInputStream());
            DOMResult dOMResult = new DOMResult();
            transformer.transform(streamSource, dOMResult);
            return new DOMSource(dOMResult.getNode());
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    public DOMSource toDOMSource(SOAPFaultInfo sOAPFaultInfo, MessageInfo messageInfo) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(byteArrayBuffer);
            this.writeFault(sOAPFaultInfo, messageInfo, xMLStreamWriter);
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.close();
            byteArrayBuffer.close();
            Transformer transformer = XmlUtil.newTransformer();
            StreamSource streamSource = new StreamSource(byteArrayBuffer.newInputStream());
            DOMResult dOMResult = new DOMResult();
            transformer.transform(streamSource, dOMResult);
            return new DOMSource(dOMResult.getNode());
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void writeRpcLitPayload(RpcLitPayload rpcLitPayload, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        RpcLitPayloadSerializer.serialize(rpcLitPayload, bridgeContext, messageInfo, xMLStreamWriter);
    }

    protected void writeRpcLitPayload(RpcLitPayload rpcLitPayload, MessageInfo messageInfo, OutputStream outputStream) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        RpcLitPayloadSerializer.serialize(rpcLitPayload, bridgeContext, outputStream);
    }

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jAXBContext = null;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        if (requestContext != null) {
            jAXBContext = (JAXBContext)requestContext.get("com.sun.xml.internal.ws.jaxbcontext");
        }
        return jAXBContext;
    }

    private void writeJAXBBeanInfo(JAXBBeanInfo jAXBBeanInfo, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        OutputStream outputStream = (OutputStream)messageInfo.getMetaData("com.sun.xml.internal.bind.api.Bridge.outputStream");
        Marshaller marshaller = (Marshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.marshaller");
        Unmarshaller unmarshaller = (Unmarshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.unmarshaller");
        jAXBBeanInfo.setMarshallers(marshaller, unmarshaller);
        if (outputStream != null) {
            try {
                xMLStreamWriter.writeCharacters("");
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
            jAXBBeanInfo.writeTo(outputStream);
        } else {
            jAXBBeanInfo.writeTo(xMLStreamWriter);
        }
    }

    private void writeJAXBBeanInfo(JAXBBeanInfo jAXBBeanInfo, OutputStream outputStream) {
        jAXBBeanInfo.writeTo(outputStream);
    }

    protected void writeJAXBBridgeInfo(JAXBBridgeInfo jAXBBridgeInfo, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        OutputStream outputStream = (OutputStream)messageInfo.getMetaData("com.sun.xml.internal.bind.api.Bridge.outputStream");
        if (outputStream != null) {
            try {
                xMLStreamWriter.writeCharacters("");
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
            jAXBBridgeInfo.serialize(bridgeContext, outputStream, xMLStreamWriter.getNamespaceContext());
        } else {
            jAXBBridgeInfo.serialize(bridgeContext, xMLStreamWriter);
        }
    }

    protected void writeJAXBBridgeInfo(JAXBBridgeInfo jAXBBridgeInfo, MessageInfo messageInfo, OutputStream outputStream) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        jAXBBridgeInfo.serialize(bridgeContext, outputStream, null);
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, SOAPMessage sOAPMessage) {
        try {
            BodyBlock bodyBlock = internalMessage.getBody();
            if (bodyBlock == null) {
                return sOAPMessage;
            }
            Object object = bodyBlock.getValue();
            if (object == null) {
                return sOAPMessage;
            }
            if (!(object instanceof Source)) {
                throw new UnsupportedOperationException("Unknown object in BodyBlock:" + object.getClass());
            }
            Source source = (Source)object;
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            sOAPBody.removeContents();
            Transformer transformer = XmlUtil.newTransformer();
            transformer.transform(source, new DOMResult(sOAPBody));
            return sOAPMessage;
        }
        catch (Exception exception) {
            throw new ServerRtException("soapencoder.err", new Object[]{exception});
        }
    }

    public static void serializeReader(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) {
        try {
            int n;
            block7: do {
                n = xMLStreamReader.next();
                switch (n) {
                    case 1: {
                        String string;
                        String string2;
                        int n2;
                        String string3 = xMLStreamReader.getNamespaceURI();
                        String string4 = xMLStreamReader.getPrefix();
                        String string5 = xMLStreamReader.getLocalName();
                        if (string4 == null) {
                            if (string3 == null) {
                                xMLStreamWriter.writeStartElement(string5);
                            } else {
                                xMLStreamWriter.writeStartElement(string3, string5);
                            }
                        } else {
                            assert (string3 != null);
                            if (string4.length() > 0) {
                                String string6;
                                String string7 = null;
                                if (xMLStreamWriter.getNamespaceContext() != null) {
                                    string7 = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string4);
                                }
                                if (SOAPEncoder.declarePrefix(string4, string3, string6 = xMLStreamWriter.getPrefix(string3), string7)) {
                                    xMLStreamWriter.writeStartElement(string4, string5, string3);
                                    xMLStreamWriter.setPrefix(string4, string3 != null ? string3 : "");
                                    xMLStreamWriter.writeNamespace(string4, string3);
                                } else {
                                    xMLStreamWriter.writeStartElement(string4, string5, string3);
                                }
                            } else {
                                xMLStreamWriter.writeStartElement(string4, string5, string3);
                            }
                        }
                        int n3 = xMLStreamReader.getNamespaceCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string2 = xMLStreamReader.getNamespacePrefix(n2);
                            if (string2 == null) {
                                string2 = "";
                            }
                            string = null;
                            if (xMLStreamWriter.getNamespaceContext() != null) {
                                string = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string2);
                            }
                            String string8 = xMLStreamReader.getNamespaceURI(n2);
                            if (string != null && string2.length() != 0 && string4.length() != 0 && (string2.equals(string4) || string.equals(string8))) continue;
                            xMLStreamWriter.setPrefix(string2, string8 != null ? string8 : "");
                            xMLStreamWriter.writeNamespace(string2, string8 != null ? string8 : "");
                        }
                        n3 = xMLStreamReader.getAttributeCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string2 = xMLStreamReader.getAttributePrefix(n2);
                            string = xMLStreamReader.getAttributeNamespace(n2);
                            xMLStreamWriter.writeAttribute(string2 != null ? string2 : "", string != null ? string : "", xMLStreamReader.getAttributeLocalName(n2), xMLStreamReader.getAttributeValue(n2));
                            SOAPEncoder.setUndeclaredPrefix(string2, string, xMLStreamWriter);
                        }
                        continue block7;
                    }
                    case 2: {
                        xMLStreamWriter.writeEndElement();
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeCharacters(xMLStreamReader.getText());
                    }
                }
            } while (n != 8);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    private static void setUndeclaredPrefix(String string, String string2, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string3 = null;
        if (xMLStreamWriter.getNamespaceContext() != null) {
            string3 = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string);
        }
        if (string3 == null) {
            xMLStreamWriter.setPrefix(string, string2 != null ? string2 : "");
            xMLStreamWriter.writeNamespace(string, string2 != null ? string2 : "");
        }
    }

    private static boolean declarePrefix(String string, String string2, String string3, String string4) {
        return string4 == null || string3 != null && !string.equals(string3) || string2 != null && !string4.equals(string2);
    }

    protected void serializeSource(Source source, XMLStreamWriter xMLStreamWriter) {
        try {
            XMLStreamReader xMLStreamReader = SourceReaderFactory.createSourceReader(source, true);
            SOAPEncoder.serializeReader(xMLStreamReader, xMLStreamWriter);
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void serializeSource(Source source, OutputStream outputStream) {
        try {
            Transformer transformer = XmlUtil.newTransformer();
            transformer.transform(source, new StreamResult(outputStream));
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    protected void startEnvelope(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
            xMLStreamWriter.setPrefix("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            xMLStreamWriter.writeNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void writeEnvelopeNamespaces(XMLStreamWriter xMLStreamWriter, MessageInfo messageInfo) throws XMLStreamException {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (runtimeContext != null && runtimeContext.getModel() != null) {
            xMLStreamWriter.setPrefix("xsd", "http://www.w3.org/2001/XMLSchema");
            xMLStreamWriter.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            int n = 1;
            for (String string : runtimeContext.getModel().getKnownNamespaceURIs()) {
                String string2 = "ns" + n++;
                xMLStreamWriter.setPrefix(string2, string);
                xMLStreamWriter.writeNamespace(string2, string);
            }
            xMLStreamWriter.writeCharacters("");
        }
    }

    protected void startBody(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Body", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void startHeader(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Header", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void writeHeaders(XMLStreamWriter xMLStreamWriter, InternalMessage internalMessage, MessageInfo messageInfo) {
        try {
            List<HeaderBlock> list = internalMessage.getHeaders();
            if (list == null || list.isEmpty()) {
                return;
            }
            this.startHeader(xMLStreamWriter);
            for (HeaderBlock headerBlock : list) {
                Object object = headerBlock.getValue();
                if (object != null) {
                    if (object instanceof JAXBBridgeInfo) {
                        this.writeJAXBBridgeInfo((JAXBBridgeInfo)object, messageInfo, xMLStreamWriter);
                        continue;
                    }
                    throw new SerializationException("unknown.object", object.getClass().getName());
                }
                if (!(headerBlock instanceof SOAP12NotUnderstoodHeaderBlock)) continue;
                ((SOAP12NotUnderstoodHeaderBlock)headerBlock).write(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void writeBody(XMLStreamWriter xMLStreamWriter, InternalMessage internalMessage, MessageInfo messageInfo) {
        try {
            this.startBody(xMLStreamWriter);
            BodyBlock bodyBlock = internalMessage.getBody();
            if (bodyBlock != null) {
                Object object = bodyBlock.getValue();
                if (object instanceof JAXBBridgeInfo) {
                    this.writeJAXBBridgeInfo((JAXBBridgeInfo)object, messageInfo, xMLStreamWriter);
                } else if (object instanceof RpcLitPayload) {
                    this.writeRpcLitPayload((RpcLitPayload)object, messageInfo, xMLStreamWriter);
                } else if (object instanceof Source) {
                    this.serializeSource((Source)object, xMLStreamWriter);
                } else if (object instanceof SOAPFaultInfo) {
                    this.writeFault((SOAPFaultInfo)object, messageInfo, xMLStreamWriter);
                } else if (object instanceof JAXBBeanInfo) {
                    if (((JAXBBeanInfo)object).getBean() != null && (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context") != null) {
                        this.writeJAXBBeanInfo((JAXBBeanInfo)object, messageInfo, xMLStreamWriter);
                    }
                } else if (object != null || (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context") == null) {
                    throw new SerializationException("unknown.object", object.getClass().getName());
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    public void setAttachmentsMap(MessageInfo messageInfo, InternalMessage internalMessage) {
        Object object = messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object != null) {
            BridgeContext bridgeContext = ((RuntimeContext)object).getBridgeContext();
            if (bridgeContext == null) {
                return;
            }
            JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = (JAXWSAttachmentMarshaller)bridgeContext.getAttachmentMarshaller();
            jAXWSAttachmentMarshaller.setAttachments(internalMessage.getAttachments());
            jAXWSAttachmentMarshaller.setHandlerContaxt(((RuntimeContext)object).getHandlerContext());
            HandlerContext handlerContext = ((RuntimeContext)object).getHandlerContext();
            Object object2 = handlerContext == null ? messageInfo.getMetaData("com.sun.xml.internal.ws.common.MtomThresholdValue") : handlerContext.getMessageContext().get("com.sun.xml.internal.ws.common.MtomThresholdValue");
            if (object2 != null) {
                jAXWSAttachmentMarshaller.setMtomThresholdValue((Integer)object2);
            }
        } else if (messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context") != null) {
            ContextMap contextMap = (ContextMap)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
            BindingProvider bindingProvider = (BindingProvider)contextMap.get("com.sun.xml.internal.ws.client.handle");
            JAXBContext jAXBContext = (JAXBContext)contextMap.get("com.sun.xml.internal.ws.jaxbcontext");
            if (jAXBContext != null) {
                try {
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                    JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = new JAXWSAttachmentMarshaller(((SOAPBinding)bindingProvider.getBinding()).isMTOMEnabled());
                    JAXWSAttachmentUnmarshaller jAXWSAttachmentUnmarshaller = new JAXWSAttachmentUnmarshaller();
                    jAXWSAttachmentMarshaller.setAttachments(internalMessage.getAttachments());
                    marshaller.setAttachmentMarshaller(jAXWSAttachmentMarshaller);
                    unmarshaller.setAttachmentUnmarshaller(jAXWSAttachmentUnmarshaller);
                    messageInfo.setMetaData("com.sun.xml.internal.ws.client.dispatch.marshaller", marshaller);
                    messageInfo.setMetaData("com.sun.xml.internal.ws.client.dispatch.unmarshaller", unmarshaller);
                    jAXWSAttachmentMarshaller.setHandlerContaxt((SOAPHandlerContext)messageInfo.getMetaData("com.sun.xml.internal.ws.handler.context"));
                    HandlerContext handlerContext = (HandlerContext)messageInfo.getMetaData("com.sun.xml.internal.ws.handler.context");
                    jAXWSAttachmentMarshaller.setXOPPackage(((SOAPBinding)bindingProvider.getBinding()).isMTOMEnabled());
                    jAXWSAttachmentUnmarshaller.setXOPPackage(((SOAPBinding)bindingProvider.getBinding()).isMTOMEnabled());
                    Object object3 = handlerContext == null ? messageInfo.getMetaData("com.sun.xml.internal.ws.common.MtomThresholdValue") : handlerContext.getMessageContext().get("com.sun.xml.internal.ws.common.MtomThresholdValue");
                    if (object3 != null) {
                        jAXWSAttachmentMarshaller.setMtomThresholdValue((Integer)object3);
                    }
                }
                catch (Exception exception) {
                    throw new WebServiceException(exception);
                }
            }
        }
    }

    protected void processAttachments(InternalMessage internalMessage, SOAPMessage sOAPMessage) throws SOAPException {
        for (Map.Entry<String, AttachmentBlock> entry : internalMessage.getAttachments().entrySet()) {
            AttachmentBlock attachmentBlock = entry.getValue();
            attachmentBlock.addTo(sOAPMessage);
        }
    }

    protected void endEnvelope(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    protected void writeFault(SOAPFaultInfo sOAPFaultInfo, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        throw new UnsupportedOperationException();
    }

    protected void writeFault(SOAPFaultInfo sOAPFaultInfo, MessageInfo messageInfo, OutputStream outputStream) {
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(outputStream);
        this.writeFault(sOAPFaultInfo, messageInfo, xMLStreamWriter);
    }

    public void write(Object object, Object object2, OutputStream outputStream, MtomCallback mtomCallback) {
        if (!(object2 instanceof MessageInfo)) {
            throw new SerializationException("incorrect.messageinfo", object2.getClass().getName());
        }
        MessageInfo messageInfo = (MessageInfo)object2;
        Object object3 = messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object3 != null) {
            BridgeContext bridgeContext = ((RuntimeContext)object3).getBridgeContext();
            if (bridgeContext != null) {
                JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = (JAXWSAttachmentMarshaller)((RuntimeContext)object3).getBridgeContext().getAttachmentMarshaller();
                jAXWSAttachmentMarshaller.setMtomCallback(mtomCallback);
            }
        } else {
            Marshaller marshaller = (Marshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.marshaller");
            if (marshaller != null) {
                JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = (JAXWSAttachmentMarshaller)marshaller.getAttachmentMarshaller();
                jAXWSAttachmentMarshaller.setMtomCallback(mtomCallback);
            }
        }
        if (object instanceof JAXBBridgeInfo) {
            this.writeJAXBBridgeInfo((JAXBBridgeInfo)object, messageInfo, outputStream);
        } else if (object instanceof RpcLitPayload) {
            this.writeRpcLitPayload((RpcLitPayload)object, messageInfo, outputStream);
        } else if (object instanceof Source) {
            this.serializeSource((Source)object, outputStream);
        } else if (object instanceof SOAPFaultInfo) {
            this.writeFault((SOAPFaultInfo)object, messageInfo, outputStream);
        } else if (object instanceof JAXBBeanInfo) {
            this.writeJAXBBeanInfo((JAXBBeanInfo)object, outputStream);
        } else {
            throw new SerializationException("unknown.object", object.getClass().getName());
        }
    }

    public void write(Object object, Object object2, XMLStreamWriter xMLStreamWriter, MtomCallback mtomCallback) {
        if (!(object2 instanceof MessageInfo)) {
            throw new SerializationException("incorrect.messageinfo", object2.getClass().getName());
        }
        MessageInfo messageInfo = (MessageInfo)object2;
        Object object3 = messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object3 != null) {
            BridgeContext bridgeContext = ((RuntimeContext)object3).getBridgeContext();
            if (bridgeContext != null) {
                JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = (JAXWSAttachmentMarshaller)((RuntimeContext)object3).getBridgeContext().getAttachmentMarshaller();
                jAXWSAttachmentMarshaller.setMtomCallback(mtomCallback);
            }
        } else {
            Marshaller marshaller = (Marshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.marshaller");
            if (marshaller != null) {
                JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = (JAXWSAttachmentMarshaller)marshaller.getAttachmentMarshaller();
                jAXWSAttachmentMarshaller.setMtomCallback(mtomCallback);
            }
        }
        if (object instanceof JAXBBridgeInfo) {
            this.writeJAXBBridgeInfo((JAXBBridgeInfo)object, messageInfo, xMLStreamWriter);
        } else if (object instanceof RpcLitPayload) {
            this.writeRpcLitPayload((RpcLitPayload)object, messageInfo, xMLStreamWriter);
        } else if (object instanceof Source) {
            this.serializeSource((Source)object, xMLStreamWriter);
        } else if (object instanceof SOAPFaultInfo) {
            this.writeFault((SOAPFaultInfo)object, messageInfo, xMLStreamWriter);
        } else if (object instanceof JAXBBeanInfo) {
            this.writeJAXBBeanInfo((JAXBBeanInfo)object, messageInfo, xMLStreamWriter);
        } else {
            throw new SerializationException("unknown.object", object.getClass().getName());
        }
    }
}

