/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final PriorityQueue<E> q = new PriorityQueue();
    private Thread leader = null;
    private final Condition available = this.lock.newCondition();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.offer(e);
            if (this.q.peek() == e) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            Object var5_4 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock;
        block3: {
            E e;
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                Delayed delayed = (Delayed)this.q.peek();
                if (delayed != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block3;
                e = null;
                Object var5_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }
        Delayed delayed = (Delayed)this.q.poll();
        Object var5_6 = null;
        reentrantLock.unlock();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        while (true) {
            try {
                Object var7_5;
                Object object;
                long l;
                while (true) {
                    Delayed delayed;
                    if ((delayed = (Delayed)this.q.peek()) == null) {
                        this.available.await();
                        continue;
                    }
                    l = delayed.getDelay(TimeUnit.NANOSECONDS);
                    if (l <= 0L) {
                        object = (Delayed)this.q.poll();
                        Object var9_6 = null;
                        if (this.leader == null && this.q.peek() != null) {
                            this.available.signal();
                        }
                        reentrantLock.unlock();
                        return (E)object;
                    }
                    if (this.leader == null) break;
                    this.available.await();
                }
                this.leader = object = Thread.currentThread();
                try {
                    this.available.awaitNanos(l);
                    var7_5 = null;
                    if (this.leader != object) continue;
                    this.leader = null;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    if (this.leader == object) {
                        this.leader = null;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (this.leader == null && this.q.peek() != null) {
                    this.available.signal();
                }
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        var6_4.lockInterruptibly();
        while (true) lbl-1000:
        // 5 sources

        {
            var7_5 = (Delayed)this.q.peek();
            if (var7_5 != null) ** GOTO lbl28
            if (var4_3 > 0L) break block14;
            var8_7 = null;
            var16_11 = null;
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            var6_4.unlock();
            break;
        }
        catch (Throwable var15_16) {
            var16_14 = null;
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            var6_4.unlock();
            throw var15_16;
        }
        {
            block16: {
                block15: {
                    block14: {
                        return var8_7;
                    }
                    var4_3 = this.available.awaitNanos(var4_3);
                    continue;
lbl28:
                    // 1 sources

                    var8_6 = var7_5.getDelay(TimeUnit.NANOSECONDS);
                    if (var8_6 > 0L) break block15;
                    var10_8 = (Delayed)this.q.poll();
                    var16_12 = null;
                    if (this.leader == null && this.q.peek() != null) {
                        this.available.signal();
                    }
                    var6_4.unlock();
                    return (E)var10_8;
                }
                if (var4_3 > 0L) break block16;
                var10_8 = null;
                var16_13 = null;
                if (this.leader == null && this.q.peek() != null) {
                    this.available.signal();
                }
                var6_4.unlock();
                return (E)var10_8;
            }
            if (var4_3 < var8_6 || this.leader != null) {
                var4_3 = this.available.awaitNanos(var4_3);
                continue;
            }
            this.leader = var10_8 = Thread.currentThread();
            try {
                var11_9 = this.available.awaitNanos(var8_6);
                var4_3 -= var8_6 - var11_9;
                var14_10 = null;
                if (this.leader != var10_8) continue;
                this.leader = null;
                continue;
            }
            catch (Throwable var13_15) {
                var14_10 = null;
                if (this.leader == var10_8) {
                    this.leader = null;
                }
                throw var13_15;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Delayed delayed;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            delayed = (Delayed)this.q.peek();
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n = 0;
            while ((delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                collection.add(this.q.poll());
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n2;
            for (n2 = 0; n2 < n && (delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n2) {
                collection.add(this.q.poll());
            }
            int n3 = n2;
            Object var7_7 = null;
            reentrantLock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            reentrantLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            T[] TArray2 = this.q.toArray(TArray);
            Object var5_4 = null;
            reentrantLock.unlock();
            return TArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.remove(object);
            Object var5_4 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] objectArray) {
            this.array = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object object = this.array[this.lastRet];
            this.lastRet = -1;
            DelayQueue.this.lock.lock();
            try {
                Iterator iterator = DelayQueue.this.q.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    iterator.remove();
                    Object var4_3 = null;
                    DelayQueue.this.lock.unlock();
                    return;
                }
                Object var4_4 = null;
                DelayQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DelayQueue.this.lock.unlock();
                throw throwable;
            }
        }
    }
}

