/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ChangeListenerMap;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;

public class PropertyChangeSupport
implements Serializable {
    private PropertyChangeListenerMap map = new PropertyChangeListenerMap();
    private Object source;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("children", Hashtable.class), new ObjectStreamField("source", Object.class), new ObjectStreamField("propertyChangeSupportSerializedDataVersion", Integer.TYPE)};
    static final long serialVersionUID = 6401253773779951803L;

    public PropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            this.map.add(null, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            this.map.remove(null, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return (PropertyChangeListener[])this.map.getListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || string == null) {
            return;
        }
        if ((propertyChangeListener = this.map.extract(propertyChangeListener)) != null) {
            this.map.add(string, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || string == null) {
            return;
        }
        if ((propertyChangeListener = this.map.extract(propertyChangeListener)) != null) {
            this.map.remove(string, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return (PropertyChangeListener[])this.map.getListeners(string);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n != n2) {
            this.firePropertyChange(string, (Object)n, (Object)n2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == null || object2 == null || !object.equals(object2)) {
            String string = propertyChangeEvent.getPropertyName();
            PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.map.get(null);
            PropertyChangeListener[] propertyChangeListenerArray2 = string != null ? (PropertyChangeListener[])this.map.get(string) : null;
            PropertyChangeSupport.fire(propertyChangeListenerArray, propertyChangeEvent);
            PropertyChangeSupport.fire(propertyChangeListenerArray2, propertyChangeEvent);
        }
    }

    private static void fire(PropertyChangeListener[] propertyChangeListenerArray, PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeListenerArray != null) {
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public void fireIndexedPropertyChange(String string, int n, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.firePropertyChange(new IndexedPropertyChangeEvent(this.source, string, object, object2, n));
        }
    }

    public void fireIndexedPropertyChange(String string, int n, int n2, int n3) {
        if (n2 != n3) {
            this.fireIndexedPropertyChange(string, n, (Object)n2, (Object)n3);
        }
    }

    public void fireIndexedPropertyChange(String string, int n, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.fireIndexedPropertyChange(string, n, (Object)bl, (Object)bl2);
        }
    }

    public boolean hasListeners(String string) {
        return this.map.hasListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, PropertyChangeSupport> hashtable = null;
        PropertyChangeListener[] propertyChangeListenerArray = null;
        Object object = this.map;
        synchronized (object) {
            for (Map.Entry<String, L[]> entry : this.map.getEntries()) {
                String string = entry.getKey();
                if (string == null) {
                    propertyChangeListenerArray = (PropertyChangeListener[])entry.getValue();
                    continue;
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, PropertyChangeSupport>();
                }
                PropertyChangeSupport object2 = new PropertyChangeSupport(this.source);
                object2.map.set(null, (EventListener[])entry.getValue());
                hashtable.put(string, object2);
            }
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("children", hashtable);
        ((ObjectOutputStream.PutField)object).put("source", this.source);
        ((ObjectOutputStream.PutField)object).put("propertyChangeSupportSerializedDataVersion", 2);
        objectOutputStream.writeFields();
        if (propertyChangeListenerArray != null) {
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                if (!(propertyChangeListener instanceof Serializable)) continue;
                objectOutputStream.writeObject(propertyChangeListener);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.map = new PropertyChangeListenerMap();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("children", null);
        this.source = getField.get("source", null);
        getField.get("propertyChangeSupportSerializedDataVersion", 2);
        while (null != (object = objectInputStream.readObject())) {
            this.map.add(null, (PropertyChangeListener)object);
        }
        if (hashtable != null) {
            for (Map.Entry entry : hashtable.entrySet()) {
                for (PropertyChangeListener propertyChangeListener : ((PropertyChangeSupport)entry.getValue()).getPropertyChangeListeners()) {
                    this.map.add((String)entry.getKey(), propertyChangeListener);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyChangeListenerMap
    extends ChangeListenerMap<PropertyChangeListener> {
        private static final PropertyChangeListener[] EMPTY = new PropertyChangeListener[0];

        private PropertyChangeListenerMap() {
        }

        protected PropertyChangeListener[] newArray(int n) {
            return 0 < n ? new PropertyChangeListener[n] : EMPTY;
        }

        @Override
        protected PropertyChangeListener newProxy(String string, PropertyChangeListener propertyChangeListener) {
            return new PropertyChangeListenerProxy(string, propertyChangeListener);
        }
    }
}

