/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JArrayClass;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JType;

public final class JPrimitiveType
extends JType {
    private final String typeName;
    private final JCodeModel owner;
    private final JClass wrapperClass;
    private JClass arrayClass;

    JPrimitiveType(JCodeModel jCodeModel, String string, Class clazz) {
        this.owner = jCodeModel;
        this.typeName = string;
        this.wrapperClass = jCodeModel.ref(clazz);
    }

    public JCodeModel owner() {
        return this.owner;
    }

    public String fullName() {
        return this.typeName;
    }

    public String name() {
        return this.fullName();
    }

    public boolean isPrimitive() {
        return true;
    }

    public JClass array() {
        if (this.arrayClass == null) {
            this.arrayClass = new JArrayClass(this.owner, this);
        }
        return this.arrayClass;
    }

    public JClass boxify() {
        return this.wrapperClass;
    }

    public JType unboxify() {
        return this;
    }

    public JClass getWrapperClass() {
        return this.boxify();
    }

    public JExpression wrap(JExpression jExpression) {
        return JExpr._new(this.boxify()).arg(jExpression);
    }

    public JExpression unwrap(JExpression jExpression) {
        return jExpression.invoke(this.typeName + "Value");
    }

    public void generate(JFormatter jFormatter) {
        jFormatter.p(this.typeName);
    }
}

