/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JPrimitiveType;

public abstract class JType
implements JGenerable,
Comparable {
    public static JPrimitiveType parse(JCodeModel jCodeModel, String string) {
        if (string.equals("void")) {
            return jCodeModel.VOID;
        }
        if (string.equals("boolean")) {
            return jCodeModel.BOOLEAN;
        }
        if (string.equals("byte")) {
            return jCodeModel.BYTE;
        }
        if (string.equals("short")) {
            return jCodeModel.SHORT;
        }
        if (string.equals("char")) {
            return jCodeModel.CHAR;
        }
        if (string.equals("int")) {
            return jCodeModel.INT;
        }
        if (string.equals("float")) {
            return jCodeModel.FLOAT;
        }
        if (string.equals("long")) {
            return jCodeModel.LONG;
        }
        if (string.equals("double")) {
            return jCodeModel.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + string);
    }

    public abstract JCodeModel owner();

    public abstract String fullName();

    public String binaryName() {
        return this.fullName();
    }

    public abstract String name();

    public abstract JClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract JClass boxify();

    public abstract JType unboxify();

    public JType erasure() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    public JType elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }

    public int compareTo(Object object) {
        String string = ((JType)object).fullName();
        boolean bl = this.fullName().startsWith("java");
        boolean bl2 = string.startsWith("java");
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        return this.fullName().compareTo(string);
    }
}

